/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.cim.provider.rs6k.HscProviderUtils;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscProviderSocket;
import com.ibm.hsc.common.util.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.Adler32;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class NVRAM {
    static final short DLPAR_BIT = 16;
    static final short SIZE_OF_LONG = 8;
    static final short SIZE_OF_INT = 4;
    static final short SIZE_OF_SHORT = 2;
    static final short SIZE_OF_BYTE = 1;
    static final short NUM_BITS_PER_BYTE = 8;
    final short SIZE_OF_TIME_STAMP = (short)7;
    final short SIZE_OF_ENCODED_TIME_STAMP = (short)5;
    final short SIZE_OF_DRAWER_INFO = (short)10;
    final short LENGTH_OF_NAME = (short)32;
    final short LENGTH_OF_LPAR_NAME_GA4 = (short)31;
    final short LENGTH_OF_DRAWER_ID = (short)24;
    final short SIZE_OF_CORRUPTED_BYTE = 1;
    static final short SIZE_OF_CHECKSUM = 8;
    public static Vector CSP_VERSIONS = new Vector();
    public static Vector NVRAM_VERSIONS = new Vector();
    final short SIZE_OF_PACKAGE = (short)1000;
    static final short SIZE_OF_LPAR_PHYSICAL_LOC_CODE = 32;
    final short SIZE_OF_LPAR_CLUSTER_TYPE = 1;
    short SIZE_OF_LPAR_INFO = (short)32;
    short SIZE_OF_ALPAR_INFO = (short)33;
    int NUM_LPAR_INFO_STORED = 1;
    final short SYS_PROFILE = 1;
    short MAX_PROFILE = (short)130;
    public int NVRAM_SIZE;
    short NUM_PARTITION_SLOTS;
    short NUM_PARTITION_SLOTS_16 = (short)16;
    short NUM_PARTITION_SLOTS_32 = (short)32;
    final int MAX_NUM_ALPAR = 8;
    final int PROFILE_NAME_TABLE_CHANGE = 1;
    final int DEFAULT_LIST_CHANGE = 2;
    final int ACTIVATED_LIST_CHANGE = 4;
    final int DRAWER_PROFILE_INFO_CHANGE = 8;
    final int PARTITION_NAME_TABLE_CHANGE = 16;
    final int PARTITION_PHYSICAL_LOC_CODE_TABLE_CHANGE = 32;
    int CORRUPTED_BYTE_OFFSET = 0;
    int NUM_ALPAR_SLOTS_OFFSET;
    int NUM_PARTITION_SLOTS_OFFSET;
    int VALIDATION_CHECKSUM_OFFSET;
    int TIME_STAMPS_CHECKSUM_OFFSET;
    int NVRAM_TIME_STAMP_OFFSET;
    int PARTITION_NAME_TABLE_TIME_STAMP_OFFSET;
    int PROFILE_NAME_TABLE_TIME_STAMP_OFFSET;
    int DEFAULT_LIST_TIME_STAMP_OFFSET;
    int ACTIVATED_LIST_TIME_STAMP_OFFSET;
    int PHY_LOC_CODE_TIME_STAMP_OFFSET;
    int DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET;
    int PARTITION_NAME_TABLE_CHECKSUM_OFFSET;
    int PARTITION_NAME_TABLE_OFFSET;
    int LPAR_CLUSTER_TYPE_OFFSET = 32;
    int PROFILE_NAME_TABLE_CHECKSUM_OFFSET;
    int PROFILE_NAME_TABLE_OFFSET;
    int DEFAULT_LIST_CHECKSUM_OFFSET;
    int DEFAULT_LIST_OFFSET;
    int ACTIVATED_LIST_CHECKSUM_OFFSET;
    int ACTIVATED_LIST_OFFSET;
    int PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET;
    int PHY_LOC_CODE_TABLE_OFFSET;
    int ALPAR_ID_FOR_PHY_LOC_CODE_TABLE_OFFSET = 0;
    int ALPAR_PHY_LOC_CODE_OFFSET = this.ALPAR_ID_FOR_PHY_LOC_CODE_TABLE_OFFSET + 1;
    int ALPAR_OFFSET_INDEX = 0;
    int ALPAR_PHY_LOC_INDEX = 1;
    int DRAWER_PROFILE_INFO_CHECKSUM_OFFSET;
    int DRAWER_PROF_INFO_DATA_SIZE_OFFSET;
    int NUM_DRAWERS_OFFSET;
    int DRAWERS_OFFSET;
    int DRAWER_ID_OFFSET = 0;
    int DRAWER_INDEX_OFFSET = this.DRAWER_ID_OFFSET + 24;
    int PROFILE_LEN_OFFSET = 0;
    int TEMPLATE_VERSION_OFFSET = this.PROFILE_LEN_OFFSET + 1;
    int PROFILE_TIME_STAMP_OFFSET = this.TEMPLATE_VERSION_OFFSET + 1;
    int IS_SYSTEM_OFFSET = this.PROFILE_TIME_STAMP_OFFSET + 7;
    int NAME_INDEX_OFFSET = this.IS_SYSTEM_OFFSET + 1;
    int PARTITION_ID_OFFSET = this.NAME_INDEX_OFFSET + 2;
    int BOOT_MODE_OFFSET = this.PARTITION_ID_OFFSET + 1;
    int NUM_PARTITION_OFFSET = this.NAME_INDEX_OFFSET + 2;
    int PARTITION_PROFILE_LIST_OFFSET = this.NUM_PARTITION_OFFSET + 1;
    int SERVICE_AUTHORITY_OFFSET = this.BOOT_MODE_OFFSET + 1;
    int DESIRED_CPU_NUM_OFFSET = this.SERVICE_AUTHORITY_OFFSET + 1;
    int REQUIRED_CPU_NUM_OFFSET = this.DESIRED_CPU_NUM_OFFSET + 1;
    int DESIRED_MEM_SIZE_OFFSET = this.REQUIRED_CPU_NUM_OFFSET + 1;
    int REQUIRED_MEM_SIZE_OFFSET = this.DESIRED_MEM_SIZE_OFFSET + 4;
    int NUM_DRAWERS_IN_PROFILE_OFFSET = this.REQUIRED_MEM_SIZE_OFFSET + 4;
    int IO_DRAWERS_OFFSET = this.NUM_DRAWERS_IN_PROFILE_OFFSET + 1;
    int DRAWER_ID_INDEX_OFFSET = 0;
    int DESIRED_SLOTS_OFFSET = this.DRAWER_ID_INDEX_OFFSET + 2;
    int REQUIRED_SLOTS_OFFSET = this.DESIRED_SLOTS_OFFSET + 4;
    final short FIX_LPAR_PROFILE_LENGTH = (short)26;
    final short FIX_SYS_PROFILE_LENGTH = (short)13;
    final short FIX_SYS_PROFILE_LENGTH_R4 = (short)16;
    int DLPAR_PROFILE_LEN_OFFSET = 0;
    int DLPAR_TEMPLATE_VERSION_OFFSET = this.DLPAR_PROFILE_LEN_OFFSET + 1;
    int DLPAR_TEMPLATE_VERSION_OFFSET_R4 = this.DLPAR_PROFILE_LEN_OFFSET + 2;
    int DLPAR_PROFILE_TIME_STAMP_OFFSET = this.DLPAR_TEMPLATE_VERSION_OFFSET + 1;
    int DLPAR_PROFILE_TIME_STAMP_OFFSET_R4 = this.DLPAR_TEMPLATE_VERSION_OFFSET_R4 + 1;
    int DLPAR_IS_SYSTEM_OFFSET = this.DLPAR_PROFILE_TIME_STAMP_OFFSET + 7;
    int DLPAR_IS_SYSTEM_OFFSET_R4 = this.DLPAR_PROFILE_TIME_STAMP_OFFSET_R4 + 7;
    int DLPAR_NAME_INDEX_OFFSET = this.DLPAR_IS_SYSTEM_OFFSET + 1;
    int DLPAR_NAME_INDEX_OFFSET_R4 = this.DLPAR_IS_SYSTEM_OFFSET_R4 + 1;
    int DLPAR_PARTITION_ID_OFFSET = this.DLPAR_NAME_INDEX_OFFSET + 2;
    int DLPAR_PARTITION_ID_OFFSET_R4 = this.DLPAR_NAME_INDEX_OFFSET_R4 + 4;
    int DLPAR_BOOT_MODE_OFFSET = this.DLPAR_PARTITION_ID_OFFSET + 1;
    int DLPAR_BOOT_MODE_OFFSET_R4 = this.DLPAR_PARTITION_ID_OFFSET_R4 + 1;
    int DLPAR_SERVICE_AUTHORITY_OFFSET = this.DLPAR_BOOT_MODE_OFFSET + 1;
    int DLPAR_SERVICE_AUTHORITY_OFFSET_R4 = this.DLPAR_BOOT_MODE_OFFSET_R4 + 1;
    int DLPAR_RMO_OFFSET = this.DLPAR_SERVICE_AUTHORITY_OFFSET + 1;
    int DLPAR_RMO_OFFSET_R4 = this.DLPAR_SERVICE_AUTHORITY_OFFSET_R4 + 1;
    int DLPAR_SFP_SURVEIL_OFFSET = this.DLPAR_RMO_OFFSET + 1;
    int DLPAR_SFP_SURVEIL_OFFSET_R4 = this.DLPAR_RMO_OFFSET_R4 + 1;
    int DLPAR_DESIRED_CPU_NUM_OFFSET = this.DLPAR_SFP_SURVEIL_OFFSET + 1;
    int DLPAR_DESIRED_CPU_NUM_OFFSET_R4 = this.DLPAR_SFP_SURVEIL_OFFSET_R4 + 1;
    int DLPAR_REQUIRED_CPU_NUM_OFFSET = this.DLPAR_DESIRED_CPU_NUM_OFFSET + 1;
    int DLPAR_REQUIRED_CPU_NUM_OFFSET_R4 = this.DLPAR_DESIRED_CPU_NUM_OFFSET_R4 + 1;
    int DLPAR_MAX_CPU_NUM_OFFSET = this.DLPAR_REQUIRED_CPU_NUM_OFFSET + 1;
    int DLPAR_MAX_CPU_NUM_OFFSET_R4 = this.DLPAR_REQUIRED_CPU_NUM_OFFSET_R4 + 1;
    int DLPAR_DESIRED_MEM_SIZE_OFFSET = this.DLPAR_MAX_CPU_NUM_OFFSET + 1;
    int DLPAR_DESIRED_MEM_SIZE_OFFSET_R4 = this.DLPAR_MAX_CPU_NUM_OFFSET_R4 + 1;
    int DLPAR_REQUIRED_MEM_SIZE_OFFSET = this.DLPAR_DESIRED_MEM_SIZE_OFFSET + 4;
    int DLPAR_REQUIRED_MEM_SIZE_OFFSET_R4 = this.DLPAR_DESIRED_MEM_SIZE_OFFSET_R4 + 4;
    int DLPAR_MAX_MEM_SIZE_OFFSET = this.DLPAR_REQUIRED_MEM_SIZE_OFFSET + 4;
    int DLPAR_MAX_MEM_SIZE_OFFSET_R4 = this.DLPAR_REQUIRED_MEM_SIZE_OFFSET_R4 + 4;
    int DLPAR_NUM_DRAWERS_IN_PROFILE_OFFSET = this.DLPAR_MAX_MEM_SIZE_OFFSET + 1;
    int DLPAR_NUM_DRAWERS_IN_PROFILE_OFFSET_R4 = this.DLPAR_MAX_MEM_SIZE_OFFSET_R4 + 1;
    int DLPAR_IO_DRAWERS_OFFSET = this.DLPAR_NUM_DRAWERS_IN_PROFILE_OFFSET + 1;
    int DLPAR_IO_DRAWERS_OFFSET_R4 = this.DLPAR_NUM_DRAWERS_IN_PROFILE_OFFSET_R4 + 1;
    final short DLPAR_FIX_LPAR_PROFILE_LENGTH = (short)33;
    final short DLPAR_FIX_LPAR_PROFILE_LENGTH_R4 = (short)36;
    public static Hashtable NVRAM_TABLE = new Hashtable();
    static final byte[] CORRUPTED_ON = new byte[1];
    static final byte[] CORRUPTED_OFF = new byte[1];
    static final int LPAR_INFO_USER_DEF_NAME = 0;
    static final int LPAR_INFO_PHYSICAL_LOC_CODE = 1;
    static final int LPAR_INFO_CLUSTER_TYPE = 2;
    static final byte RELEASE_VERSION_1 = 0;
    static final byte RELEASE_VERSION_2 = 1;
    static final byte RELEASE_VERSION_3 = 2;
    static final byte RELEASE_VERSION_4 = 3;
    static final byte RELEASE_VERSION_5 = 4;
    static final byte FAST_ACTIVATION_OFF = 0;
    static final byte FAST_ACTIVATION_ON = 1;
    private int _nvramDataSize = 0;
    private short _numPhyLocCodeSlots = 0;
    private byte[] _nvramTimeStamp = new byte[7];
    private byte[] _partitionNameTableTimeStamp = new byte[7];
    private byte[] _profileNameTableTimeStamp = new byte[7];
    private byte[] _defaultListTimeStamp = new byte[7];
    private byte[] _activatedListTimeStamp = new byte[7];
    private byte[] _phyLocCodeTableTimeStamp = new byte[7];
    private byte[] _drawerProfileInfoTimeStamp = new byte[7];
    private short _numDrawers = 0;
    private String[] _defaultList;
    private String[] _activatedList;
    private String[] _partitionNameTable;
    private boolean[] _fastActivation;
    private Vector[] _partitionPhyLocCodeTable;
    private short[] _partitionClusterTypeTable;
    private Hashtable _drawerIDTable = new Hashtable();
    private Hashtable _drawerIndexTable = new Hashtable();
    private Hashtable _profileNameTable = new Hashtable();
    private Hashtable _profileNameOffsetTable = new Hashtable();
    private Hashtable _profileTable;
    private Vector[] _profilesAtPartitionTable;
    private Vector _pnameFreeList = new Vector();
    private Vector _dIDFreeList = new Vector();
    private int _drawerOffsetTail = 0;
    private short _dIDFreeListTail = 0;
    private Vector _phyLocFreeList = new Vector();
    private byte[] _nvramData;
    private String _zeroOutNameString = new String(new byte[32]);
    private String _zeroOutDIDString = new String(new byte[24]);
    private String _zeroOutTimeStamp = new String(new byte[7]);
    private ByteArrayInputStream _nvramBAInputStream;
    private ByteArrayOutputStream _nvramBAOutputStream;
    private DataInputStream _nvramDInputStream;
    private DataOutputStream _nvramDOutputStream;
    private File _backup;
    private FileInputStream _input;
    private FileOutputStream _output;
    private short _hscTemplateVersion;
    static boolean DEBUG_ON;
    private Adler32 _checksumCalc = new Adler32();
    private long _checksum = 0L;
    private String _cecName;
    private byte _releaseVersion = 0;
    private byte _versionMask = (byte)-2;
    private String _cspVersion = null;
    private int _cspCapability = 255;
    private int _runtimeCapability = 0;
    private int _releaseNumPartitionSlots = 0;
    private byte[] _timestamp = new byte[7];
    private int _restoreType = 2;
    private long _bufferedNVRAMSize = 0L;
    private int _drawerProfInfoDataSize = 0;
    private boolean _cannotMergeFromModel = false;
    private boolean _cannotMergeFromAddOn = false;
    private Hashtable nvramError = new Hashtable();
    private static Vector callingReg;
    private long lastCleanupTime = System.currentTimeMillis();

    public static boolean nvramCheckReg() {
        Thread thread = Thread.currentThread();
        if (callingReg.indexOf(thread) != -1) {
            return false;
        }
        callingReg.addElement(thread);
        return true;
    }

    private void handleBadNVRAMError() {
        Thread thread = Thread.currentThread();
        if (callingReg.indexOf(thread) == -1) {
            return;
        }
        long l = System.currentTimeMillis();
        this.nvramError.put(thread, new Long(l));
        new Exception("report bad nvram error.").printStackTrace();
    }

    public long getNvramErrorTime() {
        Thread thread = Thread.currentThread();
        Long l = (Long)this.nvramError.remove(thread);
        callingReg.remove(thread);
        if (l != null) {
            return l;
        }
        return 0L;
    }

    NVRAM(String string, HscProviderSocket hscProviderSocket, String string2) throws CIMException {
        if (DEBUG_ON) {
            System.out.println("RELEASE 3 NVRAM");
        }
        this._cspVersion = string2;
        if (DEBUG_ON) {
            System.out.println("cspVersion = " + this._cspVersion);
        }
        if (this._cspVersion == null || this._cspVersion.trim().length() == 0) {
            Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_CSP_INTERFACE_VERSION_NUMBER", null, hscProviderSocket);
            this._cspVersion = (String)hashtable.get("VERSION");
            if (DEBUG_ON) {
                System.out.println("cspVersion = " + this._cspVersion);
            }
        }
        Trace.trace("apnvhscF", "_cspVersion = " + this._cspVersion);
        this._init(string, hscProviderSocket);
    }

    NVRAM(String string, HscProviderSocket hscProviderSocket) throws CIMException {
        if (DEBUG_ON) {
            System.out.println("RELEASE 3 NVRAM");
        }
        this._init(string, hscProviderSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _init(String string, HscProviderSocket hscProviderSocket) throws CIMException {
        try {
            try {
                Trace.trace("apnvhscT", "-> NVRAM Constructor");
                Trace.trace("apnvhscF", "cecName = " + string);
                Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                this._cecName = string;
                if (DEBUG_ON) {
                    System.out.println("**********************************************");
                    System.out.println("In NVRAM constructor");
                    System.out.println("cecName = " + string);
                    System.out.println("socket = " + hscProviderSocket);
                }
                String[] stringArray = null;
                Hashtable hashtable = null;
                HSCCIMException hSCCIMException = null;
                try {
                    short s;
                    stringArray = null;
                    hashtable = HscProviderUtils.doCSPCommand("GET_SIZE_HSC_SAVE_AREA", stringArray, hscProviderSocket, this._cspVersion);
                    this.NVRAM_SIZE = ((Long)hashtable.get("NVRAM_SIZE")).intValue();
                    this._nvramData = new byte[this.NVRAM_SIZE];
                    Trace.trace("apnvhscF", "NVRAM_SIZE = " + String.valueOf(this.NVRAM_SIZE));
                    if (DEBUG_ON) {
                        System.out.println("NVRAM_SIZE = " + this.NVRAM_SIZE);
                    }
                    if (this._cspVersion == null || this._cspVersion.trim().length() == 0) {
                        hashtable = HscProviderUtils.doCSPCommand("GET_CSP_INTERFACE_VERSION_NUMBER", null, hscProviderSocket);
                        this._cspVersion = (String)hashtable.get("VERSION");
                        if (DEBUG_ON) {
                            System.out.println("cspVersion = " + this._cspVersion);
                        }
                    }
                    hashtable = HscProviderUtils.doCSPCommand("GET_CEC_CAPABILITY_MODE", null, hscProviderSocket, this._cspVersion);
                    this._hscTemplateVersion = s = ((Integer)hashtable.get("CAPABILITY")).shortValue();
                    this._cspCapability = this._hscTemplateVersion;
                    stringArray = null;
                    hashtable = HscProviderUtils.doCSPCommand("GET_NUM_LPAR_SLOTS", stringArray, hscProviderSocket, this._cspVersion);
                    this.NUM_PARTITION_SLOTS = ((Integer)hashtable.get("NUM_LPAR_SLOTS")).shortValue();
                    this._releaseNumPartitionSlots = this.NUM_PARTITION_SLOTS;
                    Trace.trace("apnvhscF", "NUM_PARTITION_SLOTS = " + String.valueOf(this.NUM_PARTITION_SLOTS));
                    if (DEBUG_ON) {
                        System.out.println("number of partition slots specified in csp = " + this.NUM_PARTITION_SLOTS);
                    }
                    byte[] byArray = this._readDataFromCSP(this.CORRUPTED_BYTE_OFFSET, 10, hscProviderSocket);
                    byte by = byArray[0];
                    if ((byArray[this.CORRUPTED_BYTE_OFFSET] & 1) == CORRUPTED_ON[0]) {
                        if (DEBUG_ON) {
                            System.out.println("corrupted");
                        }
                        this.handleBadNVRAMError();
                        hSCCIMException = new HSCCIMException("0006");
                    }
                    if (new String(byArray).equals(new String(new byte[byArray.length]))) {
                        this._initializeData(this._cspVersion, hscProviderSocket, true);
                        this._backupToLocalFile();
                    } else {
                        this._releaseVersion = (byte)((by & this._versionMask) >>> 1);
                        Trace.trace("apnvhscF", "_releaseVersion = " + this._releaseVersion);
                        if (DEBUG_ON) {
                            System.out.println("_releaseVersion = " + this._releaseVersion);
                        }
                        if (NVRAM_VERSIONS.indexOf(new Byte(this._releaseVersion)) == -1) {
                            hSCCIMException = new HSCCIMException("0037", new String[]{String.valueOf(this._releaseVersion)});
                        }
                        this._updateVariables(hscProviderSocket, true, true);
                        if (hSCCIMException != null) {
                            throw hSCCIMException;
                        }
                        int n = NVRAM_VERSIONS.indexOf(new Byte(this._releaseVersion));
                        int n2 = CSP_VERSIONS.indexOf(this._cspVersion);
                        Trace.trace("apnvhscF", "nvramVerIndex = " + n);
                        Trace.trace("apnvhscF", "cspVerIndex = " + n2);
                        if (DEBUG_ON) {
                            System.out.println("nvramVerIndex = " + n);
                            System.out.println("cspVerIndex = " + n2);
                        }
                        if (n2 == -1 || n2 != n) {
                            if (n2 == -1) {
                                throw new HSCCIMException("0033", new String[]{this._cspVersion});
                            }
                            if (n2 < n) {
                                throw new HSCCIMException("0034", new String[]{this._cspVersion, String.valueOf(this._releaseVersion)});
                            }
                        }
                        byArray = this._readDataFromCSP(this.CORRUPTED_BYTE_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.CORRUPTED_BYTE_OFFSET, hscProviderSocket);
                        this._checksumCalc.reset();
                        this._checksumCalc.update(byArray, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                        byte[] byArray2 = new byte[8];
                        int n3 = 0;
                        while (n3 < 8) {
                            byArray2[n3] = byArray[this.TIME_STAMPS_CHECKSUM_OFFSET + n3];
                            ++n3;
                        }
                        BigInteger bigInteger = new BigInteger(byArray2);
                        if (bigInteger.longValue() != this._checksumCalc.getValue()) {
                            this.handleBadNVRAMError();
                            throw new HSCCIMException("0006");
                        }
                        if (DEBUG_ON) {
                            System.out.println("In NVRAM constructor: timeStamp != 0");
                        }
                        this.buildNVRAM(hscProviderSocket, true, null, true, true);
                        this._backupToLocalFile();
                    }
                }
                finally {
                    NVRAM_TABLE.put(this._cecName, this);
                    if (DEBUG_ON) {
                        System.out.println("End of NVRAM construtor");
                        System.out.println("*******************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var16_16 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (NVRAM_TABLE.get(this._cecName) == null) {
                    NVRAM_TABLE.put(this._cecName, this);
                }
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (!(throwable instanceof HSCCIMException)) {
                    throw new HSCCIMException("0008");
                }
                throw new HSCCIMException(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            Trace.trace("apnvhscT", "<- NVRAM Constructor");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- NVRAM Constructor");
    }

    NVRAM(File file, int n, int n2, int n3, String string, HscProviderSocket hscProviderSocket) throws CIMException {
        try {
            block11: {
                try {
                    if (DEBUG_ON) {
                        System.out.println("RELEASE 3 NVRAM");
                    }
                    Trace.trace("apnvhscT", "-> NVRAM Constructor");
                    Trace.trace("apnvhscF", "restoreFile = " + file);
                    Trace.trace("apnvhscF", "dataSize = " + n);
                    Trace.trace("apnvhscF", "numParts = " + n2);
                    Trace.trace("apnvhscF", "templateVersion = " + n3);
                    Trace.trace("apnvhscF", "cecNameStr = " + string);
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("**********************************************");
                        System.out.println("In NVRAM constructor(SPECIAL)");
                    }
                    Hashtable hashtable = null;
                    if (this._cspVersion == null || this._cspVersion.trim().length() == 0) {
                        hashtable = HscProviderUtils.doCSPCommand("GET_CSP_INTERFACE_VERSION_NUMBER", null, hscProviderSocket);
                        this._cspVersion = (String)hashtable.get("VERSION");
                        if (DEBUG_ON) {
                            System.out.println("cspVersion = " + this._cspVersion);
                        }
                    }
                    this.NVRAM_SIZE = n;
                    this.NUM_PARTITION_SLOTS = (short)n2;
                    this._releaseNumPartitionSlots = this.NUM_PARTITION_SLOTS;
                    this._hscTemplateVersion = (short)n3;
                    this._cecName = string;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    if (DEBUG_ON) {
                        System.out.println("NVRAM special NVRAM_SIZE = " + this.NVRAM_SIZE);
                    }
                    this._releaseVersion = (byte)((fileInputStream.read() & this._versionMask) >>> 1);
                    this._numPhyLocCodeSlots = (short)fileInputStream.read();
                    Trace.trace("apnvhscF", "_releaseVersion = " + String.valueOf(this._releaseVersion));
                    if (DEBUG_ON) {
                        System.out.println("_releaseVersion = " + this._releaseVersion);
                    }
                    fileInputStream.close();
                    this._nvramData = new byte[this.NVRAM_SIZE];
                    fileInputStream = new FileInputStream(file);
                    fileInputStream.read(this._nvramData, 0, (int)file.length());
                    fileInputStream.close();
                    this._updateVariables(hscProviderSocket, true, false);
                    this.buildNVRAMFromLocalCopy(hscProviderSocket, file, false, false);
                    if (!DEBUG_ON) break block11;
                    System.out.println("End of NVRAM constructor(SPECIAL)");
                    System.out.println("**********************************************");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof HSCCIMException)) {
                        throw new HSCCIMException("0009", new String[]{file.getName()});
                    }
                    throw new HSCCIMException(throwable);
                }
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            Trace.trace("apnvhscT", "<- NVRAM Constructor");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- NVRAM Constructor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(HscProviderSocket hscProviderSocket) throws CIMException {
        try {
            try {
                Trace.trace("apnvhscT", "-> initialize");
                Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                if (DEBUG_ON) {
                    System.out.println("In initialize -- socket = " + hscProviderSocket);
                }
                Object var2_2 = null;
                Hashtable hashtable = null;
                try {
                    if (this._cspVersion == null || this._cspVersion.trim().length() == 0) {
                        hashtable = HscProviderUtils.doCSPCommand("GET_CSP_INTERFACE_VERSION_NUMBER", null, hscProviderSocket);
                        this._cspVersion = (String)hashtable.get("VERSION");
                        if (DEBUG_ON) {
                            System.out.println("cspVersion = " + this._cspVersion);
                        }
                    }
                    Trace.trace("apnvhscF", "cspVersion = " + this._cspVersion);
                    if (DEBUG_ON) {
                        System.out.println("cspVersion = " + this._cspVersion);
                    }
                    int n = CSP_VERSIONS.indexOf(this._cspVersion);
                    Trace.trace("apnvhscF", "cspVerIndex = " + String.valueOf(n));
                    if (DEBUG_ON) {
                        System.out.println("cspVerIndex = " + n);
                    }
                    if (n == -1) {
                        throw new HSCCIMException("0033", new String[]{this._cspVersion});
                    }
                    this._releaseVersion = (Byte)NVRAM_VERSIONS.elementAt(n);
                    Trace.trace("apnvhscF", "_releaseVersion = " + String.valueOf(this._releaseVersion));
                    if (DEBUG_ON) {
                        System.out.println("_releaseVersion = " + this._releaseVersion);
                    }
                    this._initializeData(this._cspVersion, hscProviderSocket, false);
                    this._backupToLocalFile();
                    if (DEBUG_ON) {
                        System.out.println("after initialize Data ");
                    }
                }
                finally {
                    NVRAM_TABLE.put(this._cecName, this);
                    if (DEBUG_ON) {
                        System.out.println("End of NVRAM construtor");
                        System.out.println("*******************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (NVRAM_TABLE.get(this._cecName) == null) {
                    NVRAM_TABLE.put(this._cecName, this);
                }
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (!(throwable instanceof HSCCIMException)) {
                    throw new HSCCIMException("0030");
                }
                throw new HSCCIMException(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Trace.trace("apnvhscT", "<- initialize");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- initialize");
    }

    public synchronized void buildNVRAM(HscProviderSocket hscProviderSocket, boolean bl, File file, boolean bl2, boolean bl3) throws CIMException {
        if (hscProviderSocket == null) {
            this.buildNVRAM(hscProviderSocket, bl, file, bl2, false, bl3);
        } else if (file == null) {
            this.buildNVRAM(hscProviderSocket, bl, file, bl2, true, bl3);
        } else {
            this.buildNVRAM(hscProviderSocket, bl, file, bl2, false, bl3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void buildNVRAM(HscProviderSocket var1_1, boolean var2_2, File var3_3, boolean var4_4, boolean var5_5, boolean var6_6) throws CIMException {
        try {
            try {
                Trace.trace("apnvhscT", "-> buildNVRAM");
                Trace.trace("apnvhscF", "socket = " + var1_1);
                Trace.trace("apnvhscF", "isConstruct = " + new Boolean(var2_2));
                Trace.trace("apnvhscF", "restoredFile = " + var3_3);
                Trace.trace("apnvhscF", "toBackupfile = " + var4_4);
                Trace.trace("apnvhscF", "readFromCsp = " + var5_5);
                if (NVRAM.DEBUG_ON) {
                    System.out.println("*****************************************");
                    System.out.println("In buildNVRAM");
                }
                var7_7 = null;
                var8_9 = null;
                var9_10 = 0;
                var10_11 = 0;
                var11_12 = 0;
                try {
                    block290: {
                        block299: {
                            block298: {
                                if (var5_5) break block298;
                                var9_10 = this.updateNVRAMCache(var1_1, var3_3, false);
                                this._releaseVersion = (byte)((this._nvramData[0] & this._versionMask) >>> 1);
                                if (var9_10 == -1) {
                                    this.initialize(var1_1);
                                }
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("_releaseVersion = " + this._releaseVersion);
                                }
                                Trace.trace("apnvhscF", "_releaseVersion = " + String.valueOf(this._releaseVersion));
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("_releaseVersion = " + this._releaseVersion);
                                }
                                var12_20 /* !! */  = (byte[])"";
                                if (var1_1 == null) {
                                    var12_20 /* !! */  = (byte[])this._cspVersion;
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("cspVersion = " + (String)var12_20 /* !! */ );
                                    }
                                } else if (this._cspVersion == null || this._cspVersion.trim().length() == 0) {
                                    var8_9 = HscProviderUtils.doCSPCommand("GET_CSP_INTERFACE_VERSION_NUMBER", null, var1_1);
                                    var12_20 /* !! */  = (byte[])((String)var8_9.get("VERSION"));
                                    this._cspVersion = var12_20 /* !! */ ;
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("cspVersion = " + this._cspVersion);
                                    }
                                } else {
                                    var12_20 /* !! */  = (byte[])this._cspVersion;
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("cspVersion = " + (String)var12_20 /* !! */ );
                                    }
                                }
                                var13_22 = HscProviderUtils.getCapabilities((String)var12_20 /* !! */ , var1_1);
                                var14_24 = (short)((Integer)var13_22.get("CecCapability")).intValue();
                                this._cspCapability = var14_24;
                                this._runtimeCapability = (Integer)var13_22.get("RuntimeCapability");
                                var10_11 = NVRAM.NVRAM_VERSIONS.indexOf(new Byte(this._releaseVersion));
                                Trace.trace("apnvhscF", "nvramVerIndex = " + String.valueOf(var10_11));
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("nvrmaVerIndex = " + var10_11);
                                }
                                if (var10_11 == -1) {
                                    throw new HSCCIMException("0037", new String[]{String.valueOf(this._releaseVersion)});
                                }
                                var11_12 = NVRAM.CSP_VERSIONS.indexOf(this._cspVersion);
                                Trace.trace("apnvhscF", "cspVerIndex = " + String.valueOf(var11_12));
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("cspVerIndex = " + var11_12);
                                }
                                if (var11_12 == -1 || var11_12 != var10_11) {
                                    if (var11_12 == -1) {
                                        throw new HSCCIMException("0033", new String[]{this._cspVersion});
                                    }
                                    if (var11_12 < var10_11) {
                                        throw new HSCCIMException("0034", new String[]{this._cspVersion, String.valueOf(this._releaseVersion)});
                                    }
                                    this._updateVariables(var1_1, false, false);
                                    break block290;
                                } else {
                                    this._updateVariables(var1_1, false, false);
                                }
                                break block290;
                            }
                            var12_20 /* !! */  = this._readDataFromCSP(this.CORRUPTED_BYTE_OFFSET, 1, var1_1);
                            if (var12_20 /* !! */  != null && (var12_20 /* !! */ [0] & 1) == NVRAM.CORRUPTED_ON[0]) {
                                this.handleBadNVRAMError();
                                throw new HSCCIMException("0006");
                            }
                            if (!var2_2 && new String((byte[])(var13_22 = this._readDataFromCSP(0, 10, var1_1))).equals(new String(new byte[10]))) {
                                this.handleBadNVRAMError();
                                throw new HSCCIMException("0031");
                            }
                            this._releaseVersion = (byte)((var12_20 /* !! */ [0] & this._versionMask) >>> 1);
                            Trace.trace("apnvhscF", "_releaseVersion = " + String.valueOf(this._releaseVersion));
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("_releaseVersion = " + this._releaseVersion);
                            }
                            this._updateVariables(var1_1, false, true);
                            if (this._cspVersion == null || this._cspVersion.trim().length() == 0) {
                                var8_9 = HscProviderUtils.doCSPCommand("GET_CSP_INTERFACE_VERSION_NUMBER", null, var1_1);
                                this._cspVersion = (String)var8_9.get("VERSION");
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("cspVersion = " + this._cspVersion);
                                }
                            }
                            var13_22 = HscProviderUtils.getCapabilities(this._cspVersion, var1_1);
                            var14_24 = (short)((Integer)var13_22.get("CecCapability")).intValue();
                            this._cspCapability = var14_24;
                            this._runtimeCapability = (Integer)var13_22.get("RuntimeCapability");
                            Trace.trace("apnvhscF", "cspVersion = " + this._cspVersion);
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("cspVersion = " + this._cspVersion);
                            }
                            var10_11 = NVRAM.NVRAM_VERSIONS.indexOf(new Byte(this._releaseVersion));
                            var11_12 = NVRAM.CSP_VERSIONS.indexOf(this._cspVersion);
                            Trace.trace("apnvhscF", "nvramVerIndex = " + String.valueOf(var10_11));
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("nvramVerIndex = " + var10_11);
                            }
                            Trace.trace("apnvhscF", "cspVerIndex = " + String.valueOf(var11_12));
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("cspVerIndex = " + var11_12);
                            }
                            if (var10_11 == -1) {
                                throw new HSCCIMException("0037", new String[]{String.valueOf(this._releaseVersion)});
                            }
                            if (var11_12 == -1 || var11_12 != var10_11) {
                                if (var11_12 == -1) {
                                    throw new HSCCIMException("0033", new String[]{this._cspVersion});
                                }
                                if (var11_12 < var10_11) {
                                    throw new HSCCIMException("0034", new String[]{this._cspVersion, String.valueOf(this._releaseVersion)});
                                }
                            }
                            if (var2_2) break block299;
                            var15_26 /* !! */  = this._readDataFromCSP(this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, var1_1);
                            if (new String(var15_26 /* !! */ , 8, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET - 8).equals(new String(new byte[this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET - 8]))) {
                                this.handleBadNVRAMError();
                                throw new HSCCIMException("0031");
                            }
                            var16_27 = new byte[8];
                            var17_29 = 0;
                            if (true) ** GOTO lbl547
                        }
                        Trace.trace("apnvhscD", "Constructor calls this method - Update everything");
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("NVRAM constructor call this method");
                        }
                        if ((var9_10 = this.updateNVRAMCache(var1_1, null, true)) == -1) {
                            this.initialize(var1_1);
                        }
                    }
                    while (true) {
                        this._nvramBAInputStream = new ByteArrayInputStream(this._nvramData);
                        this._nvramDInputStream = new DataInputStream(this._nvramBAInputStream);
                        var12_21 = 0;
                        var13_23 = 0;
                        var14_25 = null;
                        var15_26 /* !! */  = null;
                        var16_28 = 0;
                        var17_30 = null;
                        var18_31 = null;
                        var19_33 = false;
                        var20_34 = 0;
                        var21_36 = null;
                        var22_38 = 0;
                        var23_39 = null;
                        try {
                            block292: {
                                block291: {
                                    this._nvramDInputStream.skipBytes(this.NVRAM_TIME_STAMP_OFFSET);
                                    this._nvramDInputStream.read(this._nvramTimeStamp);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In buildNVRAM: _nvramTimeStamp = " + NVRAM.printableTimestamp(new String(this._nvramTimeStamp)));
                                    }
                                    if ((var9_10 & 16) != 0) {
                                        this._nvramDInputStream.read(this._partitionNameTableTimeStamp);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("partitionNameTable changed");
                                        }
                                    } else {
                                        this._nvramDInputStream.skipBytes(7);
                                    }
                                    if ((var9_10 & 1) != 0) {
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("update PROFILE_NAME_TABLE variables");
                                        }
                                        this._nvramDInputStream.read(this._profileNameTableTimeStamp);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In buildNVRAM:_profileNameTableTimeStamp = " + NVRAM.printableTimestamp(new String(this._profileNameTableTimeStamp)));
                                        }
                                    } else {
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("NOT update PROFILE_NAME_TABLE variables");
                                        }
                                        this._nvramDInputStream.skipBytes(7);
                                    }
                                    if ((var9_10 & 2) != 0) {
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("update DEFAULT_LIST variables");
                                        }
                                        this._nvramDInputStream.read(this._defaultListTimeStamp);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In buildNVRAM: _defaultListTimeStamp = " + NVRAM.printableTimestamp(new String(this._defaultListTimeStamp)));
                                        }
                                    } else {
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("NOT update DEFAULT_LIST variables");
                                        }
                                        this._nvramDInputStream.skipBytes(7);
                                    }
                                    if ((var9_10 & 4) != 0) {
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("update ACTIVATED_LIST variables");
                                        }
                                        this._nvramDInputStream.read(this._activatedListTimeStamp);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In buildNVRAM: _activatedListTimeStamp = " + NVRAM.printableTimestamp(new String(this._activatedListTimeStamp)));
                                        }
                                    } else {
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("NOT update ACTIVATED_LIST variables");
                                        }
                                        this._nvramDInputStream.skipBytes(7);
                                    }
                                    if (this._releaseVersion != 0) {
                                        if ((var9_10 & 32) != 0) {
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("update PARTITION_PHYSICAL_LOC_CODE_TABLE variables");
                                            }
                                            this._nvramDInputStream.read(this._phyLocCodeTableTimeStamp);
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In buildNVRAM: _phyLocCodeTableTimeStamp = " + NVRAM.printableTimestamp(new String(this._phyLocCodeTableTimeStamp)));
                                            }
                                        } else {
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("NOT update PARTITION_PHYSICAL_LOC_CODE_TABLE variables");
                                            }
                                            this._nvramDInputStream.skipBytes(7);
                                        }
                                    }
                                    if ((var9_10 & 8) != 0) {
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("update DRAWER_PROFILE_INFO_CHANGE variables");
                                        }
                                        this._nvramDInputStream.read(this._drawerProfileInfoTimeStamp);
                                        this._nvramDInputStream.skipBytes(8);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In buildNVRAM:_drawerProfileInfoTimeStamp = " + NVRAM.printableTimestamp(new String(this._drawerProfileInfoTimeStamp)));
                                        }
                                    } else {
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("NOT update DRAWER_PROFILE_INFO_CHANGE variables");
                                        }
                                        this._nvramDInputStream.skipBytes(this.PARTITION_NAME_TABLE_OFFSET - this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET);
                                    }
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println();
                                    }
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In buildNVRAM: _partitionNameTable");
                                    }
                                    if ((var9_10 & 16) != 0) {
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println(" in buildNVRAM: NUM_PARTITION_SLOTS = " + this.NUM_PARTITION_SLOTS);
                                            System.out.println(" in buildNVRAM: _releaseNumPartitionSlots = " + this._releaseNumPartitionSlots);
                                        }
                                        this._partitionNameTable = new String[this._releaseNumPartitionSlots];
                                        this._fastActivation = new boolean[this._releaseNumPartitionSlots];
                                        if (this._releaseVersion != 0) {
                                            this._partitionClusterTypeTable = new short[this._releaseNumPartitionSlots];
                                        }
                                        var24_40 = 0;
                                        while (true) {
                                            if (var24_40 >= this._releaseNumPartitionSlots) {
                                                this._nvramDInputStream.skipBytes(8);
                                                break block291;
                                            }
                                            var25_42 = new byte[32];
                                            this._nvramDInputStream.readFully(var25_42);
                                            var26_46 = null;
                                            var27_51 = false;
                                            var26_46 = new String(var25_42, 0, 31);
                                            if (var25_42[31] != 0) {
                                                var27_51 = true;
                                            }
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("lparName[" + (var24_40 + 1) + "] = " + var26_46);
                                            }
                                            if (new String(var25_42).equals(this._zeroOutNameString)) {
                                                this._partitionNameTable[var24_40] = null;
                                            } else {
                                                if (var3_3 != null && (this._cspCapability & 2) == 0 && (this._runtimeCapability & 2) == 0) {
                                                    throw new HSCCIMException("003e");
                                                }
                                                this._partitionNameTable[var24_40] = var26_46.trim();
                                                this._fastActivation[var24_40] = var27_51;
                                            }
                                            if (this._releaseVersion != 0) {
                                                var28_55 = (short)this._nvramDInputStream.readUnsignedByte();
                                                if (var28_55 == 0) {
                                                    this._partitionClusterTypeTable[var24_40] = 1;
                                                } else {
                                                    if (var3_3 == null || (this._cspCapability & 8) != 0 || var28_55 != 3 && var28_55 != 2 || (this._runtimeCapability & 8) == 0) {
                                                        // empty if block
                                                    }
                                                    this._partitionClusterTypeTable[var24_40] = var28_55;
                                                }
                                            }
                                            ++var24_40;
                                        }
                                    }
                                    this._nvramDInputStream.skipBytes(this.PROFILE_NAME_TABLE_OFFSET - this.PARTITION_NAME_TABLE_OFFSET);
                                }
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: _profileNameTable");
                                }
                                if ((var9_10 & 1) != 0) {
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("The profile name table needs to be updated");
                                    }
                                    this._profileNameTable = new Hashtable<K, V>();
                                    this._profileNameOffsetTable = new Hashtable<K, V>();
                                    this._pnameFreeList = new Vector<E>();
                                    var24_40 = 0;
                                    while (var24_40 < this.MAX_PROFILE) {
                                        var17_30 = new int[2];
                                        var12_21 = this.PROFILE_NAME_TABLE_OFFSET + var24_40 * 32;
                                        var14_25 = new String(this._nvramData, var12_21, 32);
                                        if (var14_25.equals(this._zeroOutNameString)) {
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In buildNVRAM: profileName is zeroed out");
                                            }
                                            if (!this._pnameFreeList.contains(new Integer(var12_21))) {
                                                this._pnameFreeList.add(new Integer(var12_21));
                                            }
                                        } else {
                                            Trace.trace("apnvhscF", "offset = " + String.valueOf(var12_21));
                                            Trace.trace("apnvhscF", "name = " + var14_25.trim());
                                            var17_30[0] = var12_21;
                                            var17_30[1] = 0;
                                            this._profileNameTable.put(var14_25.trim(), var17_30);
                                            this._profileNameOffsetTable.put(new Integer(var12_21), var14_25.trim());
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In buildNVRAM: profileName at " + var24_40 + " " + var14_25.trim() + " offset " + var12_21);
                                            }
                                        }
                                        ++var24_40;
                                    }
                                } else if (NVRAM.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: profile name table has not been changed");
                                }
                                this._nvramDInputStream.skipBytes(this.DEFAULT_LIST_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println();
                                }
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: _defaultList");
                                }
                                if ((var9_10 & 2) != 0) {
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In buildNVRAM: default list has been changed");
                                    }
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println(" in buildNVRAM: default list NUM_PARTITION_SLOTS = " + this.NUM_PARTITION_SLOTS);
                                        System.out.println(" in buildNVRAM: _releaseNumPartitionSlots = " + this._releaseNumPartitionSlots);
                                    }
                                    this._defaultList = new String[this._releaseNumPartitionSlots + 1];
                                    var24_40 = 0;
                                    while (var24_40 <= this._releaseNumPartitionSlots) {
                                        var12_21 = this.DEFAULT_LIST_OFFSET + var24_40 * 7;
                                        Trace.trace("apnvhscF", "offset = " + String.valueOf(var12_21));
                                        var23_39 = new String(this._nvramData, var12_21, 7);
                                        if (!var23_39.equals(this._zeroOutTimeStamp)) {
                                            this._defaultList[var24_40] = NVRAM.printableTimestamp(var23_39);
                                            Trace.trace("apnvhscF", "timeStamp is not equal to zero out string" + " - Has default profile at " + String.valueOf(var24_40));
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In buildNVRAM: defaultProfile(" + var24_40 + ") " + NVRAM.printableTimestamp(var23_39));
                                            }
                                        } else {
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In buildNVRAM: timeStamp = 0");
                                            }
                                            Trace.trace("apnvhscF", "timeStamp is equal to zero out string" + " - No default profile at " + String.valueOf(var24_40));
                                            this._defaultList[var24_40] = null;
                                        }
                                        ++var24_40;
                                    }
                                } else if (NVRAM.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: default list has not been changed");
                                }
                                this._nvramDInputStream.skipBytes(this.ACTIVATED_LIST_OFFSET - this.DEFAULT_LIST_OFFSET);
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println();
                                }
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: _activatedList");
                                }
                                if ((var9_10 & 4) != 0) {
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In buildNVRAM: activated list needs to be updated");
                                    }
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println(" in buildNVRAM: NUM_PARTITION_SLOTS = " + this.NUM_PARTITION_SLOTS);
                                        System.out.println(" in buildNVRAM: _releaseNumPartitionSlots = " + this._releaseNumPartitionSlots);
                                    }
                                    this._activatedList = new String[this._releaseNumPartitionSlots + 1];
                                    var24_40 = 0;
                                    while (var24_40 <= this._releaseNumPartitionSlots) {
                                        var12_21 = this.ACTIVATED_LIST_OFFSET + var24_40 * 7;
                                        Trace.trace("apnvhscF", "offset = " + String.valueOf(var12_21));
                                        var23_39 = new String(this._nvramData, var12_21, 7);
                                        if (!var23_39.equals(this._zeroOutTimeStamp)) {
                                            this._activatedList[var24_40] = NVRAM.printableTimestamp(var23_39);
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In buildNVRAM: activatedProfile(" + var24_40 + ") " + var13_23);
                                            }
                                            Trace.trace("apnvhscF", "timeStamp is not equal to zero out string" + " - Has activated profile at " + String.valueOf(var24_40));
                                        } else {
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In buildNVRAM: nameOffset = 0");
                                            }
                                            Trace.trace("apnvhscF", "timeStamp is equal to zero out string" + " - No activated profile at " + String.valueOf(var24_40));
                                            this._activatedList[var24_40] = null;
                                        }
                                        ++var24_40;
                                    }
                                } else if (NVRAM.DEBUG_ON) {
                                    System.out.println("activated list doesn't need to be updated");
                                }
                                if (this._releaseVersion == 0) {
                                    this._nvramDInputStream.skipBytes(this.NUM_DRAWERS_OFFSET - this.ACTIVATED_LIST_OFFSET);
                                } else {
                                    this._nvramDInputStream.skipBytes(this.PHY_LOC_CODE_TABLE_OFFSET - this.ACTIVATED_LIST_OFFSET);
                                    if ((var9_10 & 32) != 0) {
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println(" in buildNVRAM: NUM_PARTITION_SLOTS = " + this.NUM_PARTITION_SLOTS);
                                            System.out.println(" in buildNVRAM: _releaseNumPartitionSlots = " + this._releaseNumPartitionSlots);
                                        }
                                        this._partitionPhyLocCodeTable = new Vector[this._releaseNumPartitionSlots];
                                        this._phyLocFreeList = new Vector<E>();
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In buildNVRAM: physical location code table needs to be updated");
                                        }
                                        var24_40 = 0;
                                        while (true) {
                                            if (var24_40 >= this._numPhyLocCodeSlots) break;
                                            this._phyLocFreeList.add(new Integer(this.PHY_LOC_CODE_TABLE_OFFSET + var24_40 * this.SIZE_OF_ALPAR_INFO));
                                            ++var24_40;
                                        }
                                        var25_43 = 0;
                                        while (true) {
                                            if (var25_43 >= this._numPhyLocCodeSlots) {
                                                this._nvramDInputStream.skipBytes(this.NUM_DRAWERS_OFFSET - (this.PHY_LOC_CODE_TABLE_OFFSET + this._numPhyLocCodeSlots * this.SIZE_OF_ALPAR_INFO));
                                                break block292;
                                            }
                                            var26_48 = this._nvramDInputStream.readUnsignedByte();
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("lparID = " + var26_48);
                                            }
                                            Trace.trace("apnvhscF", "i = " + var25_43 + "; lparID = " + var26_48);
                                            var27_53 = new byte[32];
                                            this._nvramDInputStream.readFully(var27_53);
                                            var28_56 = new String(var27_53);
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("phyLocCode = " + var28_56);
                                            }
                                            Trace.trace("apnvhscF", "phyLocCode = " + var28_56);
                                            var29_57 = this.PHY_LOC_CODE_TABLE_OFFSET + var25_43 * this.SIZE_OF_ALPAR_INFO;
                                            if (var26_48 == 0) {
                                                if (!this._phyLocFreeList.contains(new Integer(var29_57))) {
                                                    this._phyLocFreeList.add(new Integer(var29_57));
                                                }
                                            } else if (var28_56.trim().length() == 0) {
                                                this._partitionPhyLocCodeTable[var26_48 - 1] = null;
                                                if (!this._phyLocFreeList.contains(new Integer(var29_57))) {
                                                    this._phyLocFreeList.add(new Integer(var29_57));
                                                }
                                            } else if (this._partitionNameTable[var26_48 - 1] == null || this._partitionNameTable[var26_48 - 1].trim().length() == 0) {
                                                this._partitionPhyLocCodeTable[var26_48 - 1] = null;
                                                if (!this._phyLocFreeList.contains(new Integer(var29_57))) {
                                                    this._phyLocFreeList.add(new Integer(var29_57));
                                                }
                                            } else if (this._partitionPhyLocCodeTable[var26_48 - 1] != null && this._partitionPhyLocCodeTable[var26_48 - 1].size() != 0) {
                                                if (!this._phyLocFreeList.contains(new Integer(var29_57))) {
                                                    this._phyLocFreeList.add(new Integer(var29_57));
                                                }
                                            } else {
                                                var30_58 = new Vector<Object>();
                                                var30_58.setSize(this.ALPAR_PHY_LOC_INDEX + 1);
                                                var30_58.setElementAt(new Integer(var29_57), this.ALPAR_OFFSET_INDEX);
                                                var30_58.setElementAt(var28_56.trim(), this.ALPAR_PHY_LOC_INDEX);
                                                this._partitionPhyLocCodeTable[var26_48 - 1] = var30_58;
                                                var31_60 = this._phyLocFreeList.indexOf(new Integer(var29_57));
                                                if (var31_60 != -1) {
                                                    this._phyLocFreeList.removeElementAt(var31_60);
                                                }
                                            }
                                            ++var25_43;
                                        }
                                    }
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("physical location code list doesn't need to be updated");
                                    }
                                    this._nvramDInputStream.skipBytes(this.NUM_DRAWERS_OFFSET - this.PHY_LOC_CODE_TABLE_OFFSET);
                                }
                            }
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("NUM_DRAWERS_OFFSET = " + this.NUM_DRAWERS_OFFSET);
                            }
                            if ((var9_10 & 8) == 0) ** GOTO lbl1081
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("In buildNVRAM: drawers and profile part need to be updated");
                            }
                            this._numDrawers = this._nvramDInputStream.readShort();
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("In buildNVRAM: _numDrawers = " + this._numDrawers);
                            }
                            Trace.trace("apnvhscF", "_numDrawers = " + String.valueOf(this._numDrawers));
                            if (NVRAM.DEBUG_ON) {
                                System.out.println();
                                System.out.println("In buildNVRAM: drawers");
                            }
                            this._drawerIDTable = new Hashtable<K, V>();
                            this._drawerIndexTable = new Hashtable<K, V>();
                            this._dIDFreeList = new Vector<E>();
                            this._dIDFreeListTail = 0;
                            this._drawerOffsetTail = 0;
                            var24_40 = 0;
                            if (this._numDrawers != 0) {
                                var25_44 = 0;
                                while (var25_44 < this._numDrawers) {
                                    block293: {
                                        var12_21 = this.DRAWERS_OFFSET + var24_40 * 26;
                                        Trace.trace("apnvhscF", "drawerOffset = " + String.valueOf(var12_21));
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In buildNVRAM: drawerOffset = " + var12_21);
                                        }
                                        var15_26 /* !! */  = (byte[])new String(this._nvramData, var12_21, 24);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In buildNVRAM: drawerID = " + var15_26 /* !! */ .trim() + " at " + var24_40);
                                        }
                                        Trace.trace("apnvhscF", "drawerID = " + (String)var15_26 /* !! */ );
                                        this._nvramDInputStream.skipBytes(24);
                                        var16_28 = this._nvramDInputStream.readShort();
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In buildNVRAM: drawerIndex = " + var16_28);
                                        }
                                        ++var24_40;
                                        if (var15_26 /* !! */ .trim().length() == 0) continue;
                                        ++var25_44;
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In buildNVRAM: existing drawer count = " + var25_44);
                                        }
                                        if (this._dIDFreeListTail == var16_28) {
                                            this._dIDFreeListTail = (short)(this._dIDFreeListTail + 1);
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In buildNVRAM: _dIDFreeListTail = " + this._dIDFreeListTail);
                                            }
                                        } else {
                                            if (this._dIDFreeListTail < var16_28) {
                                                var26_49 = 0;
                                                while (true) {
                                                    if (var26_49 >= var16_28 - this._dIDFreeListTail) {
                                                        this._dIDFreeListTail = (short)(var16_28 + 1);
                                                        if (NVRAM.DEBUG_ON) {
                                                            System.out.println("In buildNVRAM: _dIDFreeList = " + this._dIDFreeList);
                                                            System.out.println("In buildNVRAM: _dIDFreeListTail = " + this._dIDFreeListTail);
                                                        }
                                                        break block293;
                                                    }
                                                    this._dIDFreeList.add(new Short((short)(this._dIDFreeListTail + var26_49)));
                                                    ++var26_49;
                                                }
                                            }
                                            this._dIDFreeList.removeElement(new Short(var16_28));
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In buildNVRAM: _dIDFreeList = " + this._dIDFreeList);
                                            }
                                        }
                                    }
                                    var17_30 = new int[3];
                                    var17_30[0] = var12_21;
                                    var17_30[1] = var16_28;
                                    Trace.trace("apnvhscF", "drawerIndex = " + String.valueOf(var16_28));
                                    var17_30[2] = 0;
                                    this._drawerIDTable.put(var15_26 /* !! */ .trim(), var17_30);
                                    this._drawerIndexTable.put(new Short(var16_28), var15_26 /* !! */ .trim());
                                }
                            }
                            if (NVRAM.DEBUG_ON) {
                                System.out.println();
                            }
                            this._drawerOffsetTail = this.DRAWERS_OFFSET + var24_40 * 26;
                            Trace.trace("apnvhscF", "_drawerOffsetTail = " + String.valueOf(this._drawerOffsetTail));
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("In buildNVRAM: _drawerOffsetTail = " + this._drawerOffsetTail);
                            }
                            this._nvramDataSize = this._drawerOffsetTail;
                            if (NVRAM.DEBUG_ON) {
                                System.out.println();
                            }
                            this._profileTable = new Hashtable<K, V>();
                            if (NVRAM.DEBUG_ON) {
                                System.out.println(" in buildNVRAM: NUM_PARTITION_SLOTS = " + this.NUM_PARTITION_SLOTS);
                                System.out.println(" in buildNVRAM: _releaseNumPartitionSlots = " + this._releaseNumPartitionSlots);
                            }
                            this._profilesAtPartitionTable = new Vector[this._releaseNumPartitionSlots + 1];
                            var25_45 = 0;
                            while (true) {
                                if (var25_45 >= this._releaseNumPartitionSlots + 1) {
                                    var26_50 = false;
                                    var27_54 = 0;
                                    var27_54 = this._releaseVersion < 3 ? (short)this._nvramDInputStream.readUnsignedByte() : this._nvramDInputStream.readShort();
                                }
                                this._profilesAtPartitionTable[var25_45] = new Vector<E>();
                                ++var25_45;
                            }
                            Trace.trace("apnvhscF", "len = " + String.valueOf(var27_54));
                            ** GOTO lbl-1000
                        }
                        catch (Throwable var24_41) {
                            var24_41.printStackTrace();
                            HSCLogUtils.serverLog(var24_41, HSCLogUtils._NVRAMClassLogInfo);
                            if (var24_41 instanceof HSCCIMException != false) throw new HSCCIMException(var24_41);
                            throw new HSCCIMException("0007");
                        }
                        break;
                    }
                    while (true) {
                        var78_13 = null;
                        Trace.trace("apnvhscT", "<- buildNVRAM");
                        return;
                    }
                    do {
                        var16_27[var17_29] = var15_26 /* !! */ [var17_29];
                        ++var17_29;
lbl547:
                        // 2 sources

                    } while (var17_29 < 8);
                    var18_31 = new BigInteger(var16_27);
                    this._checksum = var18_31.longValue();
                    this._checksumCalc.reset();
                    this._checksumCalc.update(var15_26 /* !! */ , this.NVRAM_TIME_STAMP_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                    if (this._checksum != this._checksumCalc.getValue()) {
                        this.handleBadNVRAMError();
                        throw new HSCCIMException("0006");
                    }
                    var19_32 = new byte[7];
                    var20_34 = 0;
                    while (var20_34 < 7) {
                        var19_32[var20_34] = var15_26 /* !! */ [this.NVRAM_TIME_STAMP_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET + var20_34];
                        ++var20_34;
                    }
                    var21_35 = this.compareTime(this._nvramTimeStamp, var19_32);
                    if (var21_35 == 0) {
                        try {
                            if (!var6_6) {
                                Thread.sleep(1000L);
                            }
                        }
                        catch (Throwable var22_37) {
                            var22_37.printStackTrace();
                            HSCLogUtils.serverLog(var22_37, HSCLogUtils._NVRAMClassLogInfo);
                        }
                        Trace.trace("apnvhscF", "Time stamps in the cached and csp in the same - No need to update");
                        if (var11_12 <= var10_11 && this.NUM_PARTITION_SLOTS <= this._releaseNumPartitionSlots) {
                        }
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("in buildNVRAM: calling migration line 2424  - _releaseNumPartitionSlots = " + this._releaseNumPartitionSlots);
                        }
                        this.migration(var1_1, var5_5, var4_4);
                    }
                    if (NVRAM.DEBUG_ON) {
                        System.out.println("Need to update NVRAM cache");
                    }
                    Trace.trace("apnvhscF", "Time Stamps in the CSP is newer than the one in the cache - Need to update the NVRAM");
                    if ((var9_10 = this.updateNVRAMCache(var1_1, null, true)) != -1) ** continue;
                    this.initialize(var1_1);
lbl-1000:
                    // 1 sources

                    {
                        block301: {
                            while (true) {
                                block300: {
                                    if (var27_54 == 0) break block300;
                                    var20_34 = this._drawerOffsetTail;
                                    this._nvramDataSize = this._drawerOffsetTail;
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println();
                                        System.out.println("In buildNVRAM; _drawerOffsetTail = " + this._drawerOffsetTail);
                                    }
                                    var26_50 = true;
                                    var28_55 = 0;
                                    var29_57 = 0;
                                    var30_59 = false;
                                    var31_60 = 0;
                                    var32_61 = 0;
                                    var33_62 = false;
                                    if (true) ** GOTO lbl1079
                                }
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: still drawers");
                                }
                                if (this._drawerOffsetTail + 24 + 2 >= this.NVRAM_SIZE) break;
                                this._nvramDInputStream.skipBytes(25);
                                this._drawerOffsetTail += 26;
                                var27_54 = (short)this._nvramDInputStream.readUnsignedByte();
                                Trace.trace("apnvhscF", "len = " + String.valueOf(var27_54));
                            }
                            this._drawerOffsetTail = this._nvramDataSize;
                            if (var4_4) {
                                this._backupToLocalFile();
                            }
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("End of buildNVRAM");
                                System.out.println("****************************************");
                                System.out.println();
                                System.out.println();
                            }
                            if (var11_12 <= var10_11 && this.NUM_PARTITION_SLOTS <= this._releaseNumPartitionSlots) {
                            }
                            this.migration(var1_1, var5_5, var4_4);
                            do {
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: profile offset = " + var20_34);
                                }
                                var34_63 = new Vector<Object>();
                                var35_64 = null;
                                if (!var26_50) {
                                    var27_54 = this._releaseVersion < 3 ? (short)this._nvramDInputStream.readUnsignedByte() : this._nvramDInputStream.readShort();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("flag != 1");
                                    }
                                    Trace.trace("apnvhscF", "len = " + String.valueOf(var27_54));
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In buildNVRAM: profile len = " + var27_54);
                                    }
                                } else {
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In buildNVRAM: profile len = " + var27_54);
                                    }
                                    var26_50 = false;
                                }
                                var29_57 = this._nvramDInputStream.readByte();
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In buildNVRAM: templateVersion = " + var29_57);
                                }
                                Trace.trace("apnvhscD", "templateVersion = " + String.valueOf(var29_57));
                                if (var29_57 != -1 && var27_54 != 0) {
                                    var36_65 = new byte[7];
                                    this._nvramDInputStream.read(var36_65);
                                    var23_39 = new String(var36_65);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In buildNVRAM: profileTimeStamp = " + NVRAM.printableTimestamp(var23_39));
                                    }
                                    var28_55 = this._nvramDInputStream.readByte();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In buildNVRAM: isSystem = " + var28_55);
                                    }
                                    Trace.trace("apnvhscF", "isSystem = " + String.valueOf(var28_55));
                                    var31_60 = this._releaseVersion < 3 ? (int)this._nvramDInputStream.readShort() : this._nvramDInputStream.readInt();
                                    Trace.trace("apnvhscF", "nameIndex = " + String.valueOf(var31_60));
                                    var14_25 = (String)this._profileNameOffsetTable.get(new Integer(var31_60));
                                    Trace.trace("apnvhscF", "name = " + var14_25);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In buildNVRAM: nameIndex = " + var31_60);
                                    }
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In buildNVRAM:  name = " + var14_25);
                                        System.out.println("In buildNVRAM:  name = " + var14_25.trim());
                                    }
                                    var37_66 = new CIMProperty("UserDefinedName", new CIMValue((Object)var14_25));
                                    var17_30 = (int[])this._profileNameTable.get(var14_25);
                                    var17_30[1] = var17_30[1] + 1;
                                    if (var28_55 == 1) {
                                        block294: {
                                            var38_67 = new CIMProperty("Name", new CIMValue((Object)NVRAM.printableTimestamp(var23_39)));
                                            var34_63.setSize(4);
                                            var34_63.setElementAt(var38_67, 0);
                                            var34_63.setElementAt(var37_66, 1);
                                            Trace.trace("apnvhscD", "The profile is ", " - System Profile");
                                            var39_69 = 0;
                                            var39_69 = this._nvramDInputStream.readByte();
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In buildNVRAM: numPartitionsInSys = " + var39_69);
                                            }
                                            Trace.trace("apnvhscF", "numPartitionsInSys = " + new Short((short)var39_69));
                                            if (var39_69 != 0) {
                                                if (NVRAM.DEBUG_ON) {
                                                    System.out.println("numPartitionInSys != 0");
                                                }
                                                var40_71 = new Vector();
                                                var41_72 = new Vector();
                                                var40_71.setSize(var39_69);
                                                var41_72.setSize(var39_69);
                                                var42_74 = 0;
                                                while (true) {
                                                    if (var42_74 >= var39_69) {
                                                        var43_76 /* !! */  = (byte[])new CIMProperty("ProfileList", new CIMValue((Vector)var40_71, new CIMDataType(29)));
                                                        var44_78 = new CIMProperty("PartitionIDList", new CIMValue((Vector)var41_72, new CIMDataType(21)));
                                                        var34_63.setElementAt(var43_76 /* !! */ , 2);
                                                        var34_63.setElementAt(var44_78, 3);
                                                        break block294;
                                                    }
                                                    if (NVRAM.DEBUG_ON) {
                                                        System.out.println("IN for loop");
                                                    }
                                                    var43_76 /* !! */  = new byte[5];
                                                    var44_79 = this._nvramDInputStream.readUnsignedByte();
                                                    var41_72.setElementAt(new UnsignedInt8((short)var44_79), var42_74);
                                                    if (NVRAM.DEBUG_ON) {
                                                        System.out.println("pid = " + var44_79);
                                                    }
                                                    this._nvramDInputStream.read(var43_76 /* !! */ );
                                                    var45_80 = null;
                                                    var45_80 = this.decodeTime(var43_76 /* !! */ );
                                                    var40_71.setElementAt(NVRAM.printableTimestamp(var45_80), var42_74);
                                                    ++var42_74;
                                                }
                                            }
                                            var40_71 = new CIMProperty("ProfileList", new CIMValue(new Vector<E>(), new CIMDataType(29)));
                                            var41_72 = new CIMProperty("PartitionIDList", new CIMValue(new Vector<E>(), new CIMDataType(21)));
                                            var34_63.setElementAt(var40_71, 2);
                                            var34_63.setElementAt(var41_72, 3);
                                        }
                                        var35_64 = new Object[]{new Integer(var20_34), new Short(var27_54), var34_63};
                                        this._profileTable.put(NVRAM.printableTimestamp(var23_39), var35_64);
                                        this._profilesAtPartitionTable[0].add(NVRAM.printableTimestamp(var23_39));
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In buildNVRAM: timeStmap = " + NVRAM.printableTimestamp(var23_39) + " offset = " + var20_34 + " len = " + var27_54 + " properties = " + var34_63);
                                            System.out.println();
                                        }
                                    } else {
                                        block295: {
                                            var38_68 = 0;
                                            if (this._releaseVersion < 2) {
                                                var39_70 = new CIMProperty("SettingID", new CIMValue((Object)NVRAM.printableTimestamp(var23_39)));
                                                var34_63.setSize(11);
                                                var34_63.setElementAt(var39_70, 0);
                                                var34_63.setElementAt(var37_66, 1);
                                                var38_68 = this._nvramDInputStream.readByte();
                                                Trace.trace("apnvhscF", "partitionID = " + String.valueOf(var38_68));
                                                if (NVRAM.DEBUG_ON) {
                                                    System.out.println("In buildNVRAM: partitionID = " + var38_68);
                                                }
                                                var32_61 = this._nvramDInputStream.readByte();
                                                if (NVRAM.DEBUG_ON) {
                                                    System.out.println("In buildNVRAM: bootMode = " + var32_61);
                                                }
                                                Trace.trace("apnvhscF", "bootMode = " + String.valueOf(var32_61));
                                                var40_71 = new CIMProperty("BootMode", new CIMValue((Object)new UnsignedInt8(var32_61), new CIMDataType(1)));
                                                var34_63.setElementAt(var40_71, 2);
                                                var41_73 = this._nvramDInputStream.readByte();
                                                Trace.trace("apnvhscF", "serviceAuthority = " + String.valueOf(var41_73));
                                                if (NVRAM.DEBUG_ON) {
                                                    System.out.println("In buildNVRAM:serviceAuthority= " + var41_73);
                                                }
                                                var42_75 = new CIMProperty("ServiceAuthority", new CIMValue((Object)new UnsignedInt8(var41_73), new CIMDataType(1)));
                                                var34_63.setElementAt(var42_75, 3);
                                                var43_77 = (short)this._nvramDInputStream.readUnsignedByte();
                                                if (NVRAM.DEBUG_ON) {
                                                    System.out.println("In buildNVRAM: numCPU = " + var43_77);
                                                }
                                                Trace.trace("apnvhscF", "desiredCPUNum = " + String.valueOf(var43_77));
                                                var44_78 = new CIMProperty("DesireCPUCount", new CIMValue((Object)new UnsignedInt8(var43_77)));
                                                var34_63.setElementAt(var44_78, 4);
                                                var45_81 = (short)this._nvramDInputStream.readUnsignedByte();
                                                if (NVRAM.DEBUG_ON) {
                                                    System.out.println("In buildNVARM: minCPU = " + var45_81);
                                                }
                                                Trace.trace("apnvhscF", "requiredCPUNum = " + String.valueOf(var45_81));
                                                var46_82 = new CIMProperty("MinimumCPUCount", new CIMValue((Object)new UnsignedInt8(var45_81)));
                                                var34_63.setElementAt(var46_82, 5);
                                                var47_83 = this._nvramDInputStream.readInt();
                                                Trace.trace("apnvhscF", "desiredMemSize = " + String.valueOf(var47_83 &= -1L));
                                                if (NVRAM.DEBUG_ON) {
                                                    System.out.println("In buildNVRAM: memSize = " + var47_83);
                                                }
                                                var49_86 = new CIMProperty("DesireMemoryMB", new CIMValue((Object)new UnsignedInt32(var47_83)));
                                                var34_63.setElementAt(var49_86, 6);
                                                var50_88 = this._nvramDInputStream.readInt();
                                                Trace.trace("apnvhscF", "requiredMemSize = " + String.valueOf(var50_88 &= -1L));
                                                if (NVRAM.DEBUG_ON) {
                                                    System.out.println("In buildNVRAM: minMem = " + var50_88);
                                                }
                                                var52_91 = new CIMProperty("MinimumMemoryMB", new CIMValue((Object)new UnsignedInt32(var50_88)));
                                                var34_63.setElementAt(var52_91, 7);
                                                var22_38 = this._nvramDInputStream.readUnsignedByte();
                                                if (NVRAM.DEBUG_ON) {
                                                    System.out.println("In buildNVRAM: numDrawersInProfile = " + var22_38);
                                                }
                                                Trace.trace("apnvhscF", "numDrawersInProfile = " + String.valueOf(var22_38));
                                                if (var22_38 != 0) {
                                                    var53_92 = new Vector<Object>();
                                                    var54_95 = new Vector();
                                                    var55_96 = new Vector();
                                                    var56_97 = 0;
                                                    block33: while (true) {
                                                        if (var56_97 >= var22_38) {
                                                            if (NVRAM.DEBUG_ON) {
                                                                System.out.println(var53_92);
                                                                System.out.println(var54_95);
                                                                System.out.println(var55_96);
                                                            }
                                                            var57_99 = new CIMProperty("IODrawer", new CIMValue(var53_92, new CIMDataType(29)));
                                                            var34_63.setElementAt(var57_99, 8);
                                                            var58_101 = new CIMProperty("IOSlots", new CIMValue((Vector)var54_95, new CIMDataType(21)));
                                                            var34_63.setElementAt(var58_101, 9);
                                                            var59_103 = new CIMProperty("IORequirement", new CIMValue((Vector)var55_96, new CIMDataType(29)));
                                                            var34_63.setElementAt(var59_103, 10);
                                                            break block295;
                                                        }
                                                        var57_100 = this._nvramDInputStream.readShort();
                                                        Trace.trace("apnvhscF", "dIDIndex = " + String.valueOf(var57_100));
                                                        if (NVRAM.DEBUG_ON) {
                                                            System.out.println("In buildNVRAM:dIDIndex= " + var57_100);
                                                        }
                                                        var15_26 /* !! */  = (String)this._drawerIndexTable.get(new Short(var57_100));
                                                        Trace.trace("apnvhscF", "drawerID = " + (String)var15_26 /* !! */ );
                                                        if (NVRAM.DEBUG_ON) {
                                                            System.out.println("In buildNVRAM:drawerID= " + (String)var15_26 /* !! */ );
                                                        }
                                                        var17_30 = (int[])this._drawerIDTable.get(var15_26 /* !! */ );
                                                        var58_102 = this._nvramDInputStream.readInt();
                                                        if (NVRAM.DEBUG_ON) {
                                                            System.out.println("In buildNVRAM: slots = " + var58_102);
                                                        }
                                                        Trace.trace("apnvhscF", "desired = " + String.valueOf(var58_102));
                                                        var59_103 = Integer.toBinaryString(var58_102);
                                                        if (NVRAM.DEBUG_ON) {
                                                            System.out.println("In buildNVRAM: sltsRep= " + (String)var59_103);
                                                        }
                                                        Trace.trace("apnvhscF", "desiredRep = " + (String)var59_103);
                                                        var60_105 = this._nvramDInputStream.readInt();
                                                        if (NVRAM.DEBUG_ON) {
                                                            System.out.println("In buildNVRAM:require= " + var60_105);
                                                        }
                                                        Trace.trace("apnvhscF", "required = " + String.valueOf(var60_105));
                                                        var61_106 = Integer.toBinaryString(var60_105);
                                                        Trace.trace("apnvhscF", "requiredRep = " + var61_106);
                                                        if (NVRAM.DEBUG_ON) {
                                                            System.out.println("In buildNVRAM:reqRep = " + var61_106);
                                                        }
                                                        var62_107 = var59_103.length();
                                                        var63_109 = var61_106.length();
                                                        var64_111 = var62_107 - 1;
                                                        while (true) {
                                                            if (var64_111 < 0) break;
                                                            if (var59_103.charAt(var64_111) == '1') {
                                                                var53_92.add(var15_26 /* !! */ );
                                                                var17_30[2] = var17_30[2] + 1;
                                                                var65_115 = new UnsignedInt8((short)(var62_107 - var64_111 - 1));
                                                                var54_95.add(var65_115);
                                                                var55_96.add("D");
                                                            }
                                                            --var64_111;
                                                        }
                                                        var65_114 = var63_109 - 1;
                                                        while (true) {
                                                            if (var65_114 < 0) {
                                                                ++var56_97;
                                                                continue block33;
                                                            }
                                                            if (var61_106.charAt(var65_114) == '1') {
                                                                var53_92.add(var15_26 /* !! */ );
                                                                var17_30[2] = var17_30[2] + 1;
                                                                var66_116 = new UnsignedInt8((short)(var63_109 - var65_114 - 1));
                                                                var54_95.add(var66_116);
                                                                var55_96.add("R");
                                                            }
                                                            --var65_114;
                                                        }
                                                        break;
                                                    }
                                                }
                                                var53_93 = new CIMProperty("IODrawer", new CIMValue(new Vector<E>(), new CIMDataType(29)));
                                                var34_63.setElementAt(var53_93, 8);
                                                var54_95 = new CIMProperty("IOSlots", new CIMValue(new Vector<E>(), new CIMDataType(21)));
                                                var34_63.setElementAt(var54_95, 9);
                                                var55_96 = new CIMProperty("IORequirement", new CIMValue(new Vector<E>(), new CIMDataType(29)));
                                                var34_63.setElementAt(var55_96, 10);
                                            } else {
                                                block296: {
                                                    var39_70 = new CIMProperty("SettingID", new CIMValue((Object)NVRAM.printableTimestamp(var23_39)));
                                                    if (this._releaseVersion >= 3) {
                                                        var34_63.setSize(18);
                                                    } else {
                                                        var34_63.setSize(15);
                                                    }
                                                    var34_63.setElementAt(var39_70, 0);
                                                    var34_63.setElementAt(var37_66, 1);
                                                    var38_68 = this._nvramDInputStream.readByte();
                                                    Trace.trace("apnvhscF", "partitionID = " + String.valueOf(var38_68));
                                                    if (NVRAM.DEBUG_ON) {
                                                        System.out.println("In buildNVRAM: partitionID = " + var38_68);
                                                    }
                                                    var32_61 = this._nvramDInputStream.readByte();
                                                    if (NVRAM.DEBUG_ON) {
                                                        System.out.println("In buildNVRAM: bootMode = " + var32_61);
                                                    }
                                                    Trace.trace("apnvhscF", "bootMode = " + String.valueOf(var32_61));
                                                    var40_71 = new CIMProperty("BootMode", new CIMValue((Object)new UnsignedInt8(var32_61), new CIMDataType(1)));
                                                    var34_63.setElementAt(var40_71, 2);
                                                    var41_73 = this._nvramDInputStream.readByte();
                                                    Trace.trace("apnvhscF", "serviceAuthority = " + String.valueOf(var41_73));
                                                    if (NVRAM.DEBUG_ON) {
                                                        System.out.println("In buildNVRAM:serviceAuthority= " + var41_73);
                                                    }
                                                    var42_75 = new CIMProperty("ServiceAuthority", new CIMValue((Object)new UnsignedInt8(var41_73), new CIMDataType(1)));
                                                    var34_63.setElementAt(var42_75, 3);
                                                    var43_77 = this._nvramDInputStream.readByte();
                                                    Trace.trace("apnvhscF", "rmoSize = " + String.valueOf(var43_77));
                                                    if (NVRAM.DEBUG_ON) {
                                                        System.out.println("In buildNVRAM:rmoSize= " + var43_77);
                                                    }
                                                    var44_78 = new CIMProperty("RMOSize", new CIMValue((Object)new UnsignedInt8(var43_77), new CIMDataType(1)));
                                                    var34_63.setElementAt(var44_78, 4);
                                                    var45_81 = this._nvramDInputStream.readByte();
                                                    Trace.trace("apnvhscF", "sfpSurveil = " + String.valueOf(var45_81));
                                                    if (NVRAM.DEBUG_ON) {
                                                        System.out.println("In buildNVRAM:sfpSurveil= " + var45_81);
                                                    }
                                                    var46_82 = new CIMProperty("SFPSurveillance", new CIMValue((Object)new UnsignedInt8(var45_81), new CIMDataType(1)));
                                                    var34_63.setElementAt(var46_82, 5);
                                                    var47_84 = (short)this._nvramDInputStream.readUnsignedByte();
                                                    if (NVRAM.DEBUG_ON) {
                                                        System.out.println("In buildNVRAM: numCPU = " + var47_84);
                                                    }
                                                    Trace.trace("apnvhscF", "desiredCPUNum = " + String.valueOf(var47_84));
                                                    var48_85 = new CIMProperty("DesireCPUCount", new CIMValue((Object)new UnsignedInt8(var47_84)));
                                                    var34_63.setElementAt(var48_85, 6);
                                                    var49_87 = (short)this._nvramDInputStream.readUnsignedByte();
                                                    if (NVRAM.DEBUG_ON) {
                                                        System.out.println("In buildNVARM: minCPU = " + var49_87);
                                                    }
                                                    Trace.trace("apnvhscF", "requiredCPUNum = " + String.valueOf(var49_87));
                                                    var50_89 = new CIMProperty("MinimumCPUCount", new CIMValue((Object)new UnsignedInt8(var49_87)));
                                                    var34_63.setElementAt(var50_89, 7);
                                                    var51_90 = (short)this._nvramDInputStream.readUnsignedByte();
                                                    if (NVRAM.DEBUG_ON) {
                                                        System.out.println("In buildNVARM: maxCPU = " + var51_90);
                                                    }
                                                    Trace.trace("apnvhscF", "maxCPUNum = " + String.valueOf(var51_90));
                                                    var52_91 = new CIMProperty("MaximumCPUCount", new CIMValue((Object)new UnsignedInt8(var51_90)));
                                                    var34_63.setElementAt(var52_91, 8);
                                                    var53_94 = this._nvramDInputStream.readInt();
                                                    Trace.trace("apnvhscF", "desiredMemSize = " + String.valueOf(var53_94 &= -1L));
                                                    if (NVRAM.DEBUG_ON) {
                                                        System.out.println("In buildNVRAM: memSize = " + var53_94);
                                                    }
                                                    var55_96 = new CIMProperty("DesireMemoryMB", new CIMValue((Object)new UnsignedInt32(var53_94)));
                                                    var34_63.setElementAt(var55_96, 9);
                                                    var56_98 = this._nvramDInputStream.readInt();
                                                    Trace.trace("apnvhscF", "requiredMemSize = " + String.valueOf(var56_98 &= -1L));
                                                    if (NVRAM.DEBUG_ON) {
                                                        System.out.println("In buildNVRAM: minMem = " + var56_98);
                                                    }
                                                    var58_101 = new CIMProperty("MinimumMemoryMB", new CIMValue((Object)new UnsignedInt32(var56_98)));
                                                    var34_63.setElementAt(var58_101, 10);
                                                    var59_104 = this._nvramDInputStream.readInt();
                                                    Trace.trace("apnvhscF", "maxMemSize = " + String.valueOf(var59_104 &= -1L));
                                                    if (NVRAM.DEBUG_ON) {
                                                        System.out.println("In buildNVRAM: maxMem = " + var59_104);
                                                    }
                                                    var61_106 = new CIMProperty("MaximumMemoryMB", new CIMValue((Object)new UnsignedInt32(var59_104)));
                                                    var34_63.setElementAt(var61_106, 11);
                                                    var22_38 = (short)this._nvramDInputStream.readUnsignedByte();
                                                    if (NVRAM.DEBUG_ON) {
                                                        System.out.println("In buildNVRAM: numDrawersInProfile = " + var22_38);
                                                    }
                                                    Trace.trace("apnvhscF", "numDrawersInProfile = " + String.valueOf(var22_38));
                                                    if (var22_38 != 0) {
                                                        var62_108 = new Vector();
                                                        var63_110 = new Vector();
                                                        var64_112 = new Vector();
                                                        var65_114 = 0;
                                                        block36: while (true) {
                                                            if (var65_114 >= var22_38) {
                                                                if (NVRAM.DEBUG_ON) {
                                                                    System.out.println(var62_108);
                                                                    System.out.println(var63_110);
                                                                    System.out.println(var64_112);
                                                                }
                                                                var66_116 = new CIMProperty("IODrawer", new CIMValue((Vector)var62_108, new CIMDataType(29)));
                                                                var34_63.setElementAt(var66_116, 12);
                                                                var67_120 = new CIMProperty("IOSlots", new CIMValue((Vector)var63_110, new CIMDataType(21)));
                                                                var34_63.setElementAt(var67_120, 13);
                                                                var68_123 = new CIMProperty("IORequirement", new CIMValue((Vector)var64_112, new CIMDataType(29)));
                                                                var34_63.setElementAt(var68_123, 14);
                                                                break block296;
                                                            }
                                                            var66_118 = this._nvramDInputStream.readShort();
                                                            Trace.trace("apnvhscF", "dIDIndex = " + String.valueOf(var66_118));
                                                            if (NVRAM.DEBUG_ON) {
                                                                System.out.println("In buildNVRAM:dIDIndex= " + var66_118);
                                                            }
                                                            var15_26 /* !! */  = (String)this._drawerIndexTable.get(new Short(var66_118));
                                                            Trace.trace("apnvhscF", "drawerID = " + (String)var15_26 /* !! */ );
                                                            if (NVRAM.DEBUG_ON) {
                                                                System.out.println("In buildNVRAM:drawerID= " + (String)var15_26 /* !! */ );
                                                            }
                                                            var17_30 = (int[])this._drawerIDTable.get(var15_26 /* !! */ );
                                                            var67_119 = this._nvramDInputStream.readInt();
                                                            if (NVRAM.DEBUG_ON) {
                                                                System.out.println("In buildNVRAM: slots = " + var67_119);
                                                            }
                                                            Trace.trace("apnvhscF", "desired = " + String.valueOf(var67_119));
                                                            var68_123 = Integer.toBinaryString(var67_119);
                                                            if (NVRAM.DEBUG_ON) {
                                                                System.out.println("In buildNVRAM: sltsRep= " + (String)var68_123);
                                                            }
                                                            Trace.trace("apnvhscF", "desiredRep = " + (String)var68_123);
                                                            var69_126 = this._nvramDInputStream.readInt();
                                                            if (NVRAM.DEBUG_ON) {
                                                                System.out.println("In buildNVRAM:require= " + var69_126);
                                                            }
                                                            Trace.trace("apnvhscF", "required = " + String.valueOf(var69_126));
                                                            var70_128 = Integer.toBinaryString(var69_126);
                                                            Trace.trace("apnvhscF", "requiredRep = " + var70_128);
                                                            if (NVRAM.DEBUG_ON) {
                                                                System.out.println("In buildNVRAM:reqRep = " + var70_128);
                                                            }
                                                            var71_129 = var68_123.length();
                                                            var72_130 = var70_128.length();
                                                            var73_131 = var71_129 - 1;
                                                            while (true) {
                                                                if (var73_131 < 0) break;
                                                                if (var68_123.charAt(var73_131) == '1') {
                                                                    var62_108.add(var15_26 /* !! */ );
                                                                    var17_30[2] = var17_30[2] + 1;
                                                                    var74_133 = new UnsignedInt8((short)(var71_129 - var73_131 - 1));
                                                                    var63_110.add(var74_133);
                                                                    var64_112.add("D");
                                                                }
                                                                --var73_131;
                                                            }
                                                            var74_132 = var72_130 - 1;
                                                            while (true) {
                                                                if (var74_132 < 0) {
                                                                    ++var65_114;
                                                                    continue block36;
                                                                }
                                                                if (var70_128.charAt(var74_132) == '1') {
                                                                    var62_108.add(var15_26 /* !! */ );
                                                                    var17_30[2] = var17_30[2] + 1;
                                                                    var75_134 = new UnsignedInt8((short)(var72_130 - var74_132 - 1));
                                                                    var63_110.add(var75_134);
                                                                    var64_112.add("R");
                                                                }
                                                                --var74_132;
                                                            }
                                                            break;
                                                        }
                                                    }
                                                    var62_108 = new CIMProperty("IODrawer", new CIMValue(new Vector<E>(), new CIMDataType(29)));
                                                    var34_63.setElementAt(var62_108, 12);
                                                    var63_110 = new CIMProperty("IOSlots", new CIMValue(new Vector<E>(), new CIMDataType(21)));
                                                    var34_63.setElementAt(var63_110, 13);
                                                    var64_112 = new CIMProperty("IORequirement", new CIMValue(new Vector<E>(), new CIMDataType(29)));
                                                    var34_63.setElementAt(var64_112, 14);
                                                }
                                                if (this._releaseVersion >= 3) {
                                                    var62_108 = new Vector<E>();
                                                    var63_110 = new Vector<E>();
                                                    var64_113 = 0;
                                                    var65_114 = 0;
                                                    var65_114 = (short)this._nvramDInputStream.readUnsignedByte();
                                                    if (NVRAM.DEBUG_ON) {
                                                        System.out.println("In buildNVRAM: Number of SMA Adapters = " + var65_114);
                                                    }
                                                    Trace.trace("apnvhscF", "Number SMA Adapters = " + String.valueOf(var65_114));
                                                    if (var65_114 == 0) {
                                                        var66_116 = new CIMProperty("SNIConfigMode", new CIMValue((Object)new UnsignedInt8(var64_113), new CIMDataType(1)));
                                                        System.out.println("buildNVRAM - SMA MODE ==============================================");
                                                        System.out.println("SMA MODE = " + var66_116);
                                                        var34_63.setElementAt(var66_116, 15);
                                                        var67_121 = new CIMProperty("SNIDeviceID", new CIMValue((Vector)var62_108, new CIMDataType(29)));
                                                        var34_63.setElementAt(var67_121, 16);
                                                        var68_123 = new CIMProperty("SNIWindows", new CIMValue((Vector)var63_110, new CIMDataType(23)));
                                                        var34_63.setElementAt(var68_123, 17);
                                                    } else {
                                                        var64_113 = (short)this._nvramDInputStream.readUnsignedByte();
                                                        if (NVRAM.DEBUG_ON) {
                                                            System.out.println("In buildNVRAM: SMA Config Mode = " + var64_113);
                                                        }
                                                        Trace.trace("apnvhscF", "SMA Config Mode = " + String.valueOf(var64_113));
                                                        var66_116 = new CIMProperty("SNIConfigMode", new CIMValue((Object)new UnsignedInt8(var64_113), new CIMDataType(1)));
                                                        var34_63.setElementAt(var66_116, 15);
                                                        var67_122 = 0;
                                                        while (true) {
                                                            if (var67_122 >= var65_114) break;
                                                            var68_124 = this._nvramDInputStream.readInt();
                                                            var70_128 = String.valueOf(var68_124 &= -1L);
                                                            var62_108.add(var70_128);
                                                            ++var67_122;
                                                        }
                                                        var68_125 = 0;
                                                        while (true) {
                                                            if (var68_125 >= var65_114) {
                                                                var69_127 = new CIMProperty("SNIDeviceID", new CIMValue((Vector)var62_108, new CIMDataType(29)));
                                                                var34_63.setElementAt(var69_127, 16);
                                                                var70_128 = new CIMProperty("SNIWindows", new CIMValue((Vector)var63_110, new CIMDataType(23)));
                                                                var34_63.setElementAt(var70_128, 17);
                                                                break;
                                                            }
                                                            var69_126 = this._nvramDInputStream.readShort();
                                                            var70_128 = new UnsignedInt16(var69_126);
                                                            var63_110.add(var70_128);
                                                            ++var68_125;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        var35_64 = new Object[]{new Integer(var20_34), new Short(var27_54), var34_63};
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In buildNVRAM: timeStamp = " + NVRAM.printableTimestamp(var23_39) + " offset = " + var20_34 + " len = " + var27_54 + " properties = " + var34_63 + " partitionID = " + var38_68);
                                            System.out.println();
                                        }
                                        this._profileTable.put(NVRAM.printableTimestamp(var23_39), var35_64);
                                        this._profilesAtPartitionTable[var38_68].add(NVRAM.printableTimestamp(var23_39));
                                    }
                                    this._nvramDataSize = var20_34 += var27_54;
                                    continue;
                                }
                                if (var29_57 == -1) {
                                    Trace.trace("apnvhscD", "Invalid profile - Skip the profile");
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("Invalid profile");
                                        System.out.println();
                                    }
                                    if (this._releaseVersion < 3) {
                                        this._nvramDInputStream.skipBytes(var27_54 - 2);
                                    } else {
                                        this._nvramDInputStream.skipBytes(var27_54 - 3);
                                    }
                                    this._nvramDataSize = var20_34 += var27_54;
                                    continue;
                                }
                                var20_34 = this._nvramData.length;
                                Trace.trace("apnvhscD", "No more profile - EXIT");
                                if (!NVRAM.DEBUG_ON) continue;
                                System.out.println("In buildNVRAM: no more profile");
lbl1079:
                                // 5 sources

                            } while (var20_34 < this.NVRAM_SIZE);
                            break block301;
lbl1081:
                            // 1 sources

                            Trace.trace("apnvhscD", "DRAWER_PROFILE_INFO NOT change - drawer and profiles dont' need to be updated");
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("drawer and profiles don't need to be update");
                            }
                            if (this._drawerOffsetTail <= 0) {
                                this._drawerOffsetTail = this.DRAWERS_OFFSET;
                                this._nvramDataSize = this.DRAWERS_OFFSET;
                            }
                        }
                        if (var4_4) {
                            this._backupToLocalFile();
                        }
                        if (var11_12 > var10_11 || this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                            this.migration(var1_1, var5_5, var4_4);
                        }
                    }
                }
                finally {
                    if (!NVRAM.DEBUG_ON) ** continue;
                    System.out.println("End of buildNVRAM");
                    System.out.println("********************************************");
                    System.out.println();
                    System.out.println();
                }
            }
            catch (Throwable var7_8) {
                var7_8.printStackTrace();
                HSCLogUtils.serverLog(var7_8, HSCLogUtils._NVRAMClassLogInfo);
                if (var7_8 instanceof HSCCIMException != false) throw new HSCCIMException(var7_8);
                throw new HSCCIMException("000A");
            }
        }
        catch (Throwable var77_136) {
            var78_19 = null;
            Trace.trace("apnvhscT", "<- buildNVRAM");
            throw var77_136;
        }
        var78_18 = null;
        Trace.trace("apnvhscT", "<- buildNVRAM");
    }

    public synchronized Vector getActivatedLPARProfile(short s, HscProviderSocket hscProviderSocket) throws CIMException {
        return this._getActivatedLPARProfile(s, hscProviderSocket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector _getActivatedLPARProfile(short s, HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        Vector vector;
        try {
            try {
                block15: {
                    Trace.trace("apnvhscT", "getActivatedLPARProfile");
                    Trace.trace("apnvhscF", "partitionID = " + String.valueOf(s));
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("********************************************");
                    }
                    try {
                        Object[] objectArray;
                        String string;
                        if (DEBUG_ON) {
                            System.out.println("In getActivatedLPARProfile");
                        }
                        if (bl) {
                            this.buildNVRAM(hscProviderSocket, false, null, true, true);
                        }
                        if ((string = this._activatedList[s]) == null) {
                            vector = null;
                            return vector;
                        }
                        if (DEBUG_ON) {
                            System.out.println("In getActivatedLPARProfile: timeStamp = " + string);
                        }
                        if ((objectArray = (Object[])this._profileTable.get(string)) == null) {
                            Vector vector2 = null;
                            return vector2;
                        }
                        Vector vector3 = (Vector)((Vector)objectArray[2]).clone();
                        Trace.trace("apnvhscF", "ret = " + vector3);
                        Vector vector4 = vector3;
                        return vector4;
                    }
                    finally {
                        if (!DEBUG_ON) break block15;
                        System.out.println("End of getActivatedLPARProfile");
                        System.out.println("********************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("000B");
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            Trace.trace("apnvhscT", "<- getActivatedLPARProfile");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- getActivatedLPARProfile");
        return vector;
    }

    public synchronized Vector getActivatedSysProfile(HscProviderSocket hscProviderSocket) throws CIMException {
        return this._getActivatedSysProfile(hscProviderSocket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector _getActivatedSysProfile(HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        Vector vector;
        try {
            try {
                block8: {
                    Trace.trace("apnvhscT", "-> getActivatedSysProfile");
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In getActivatedSysProfile");
                    }
                    try {
                        vector = this._getActivatedLPARProfile((short)0, hscProviderSocket, true);
                        return vector;
                    }
                    finally {
                        if (!DEBUG_ON) break block8;
                        System.out.println("End of getActivatedSysProfile");
                        System.out.println("****************************************");
                        System.out.println();
                    }
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
                HSCLogUtils.serverLog(throwable2, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable2 instanceof HSCCIMException) throw new HSCCIMException(throwable2);
                throw new HSCCIMException("000C");
            }
        }
        catch (Throwable throwable3) {
            Object var6_6 = null;
            Trace.trace("apnvhscT", "<- getActivatedSysProfile");
            throw throwable3;
        }
        Trace.trace("apnvhscT", "<- getActivatedSysProfile");
        return vector;
    }

    public synchronized Vector getAllSysProfiles(HscProviderSocket hscProviderSocket) throws CIMException {
        return this._getAllSysProfiles(hscProviderSocket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector _getAllSysProfiles(HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        try {
            try {
                Vector vector;
                block8: {
                    Trace.trace("apnvhscT", "-> getAllSysProfile");
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("*******************************************");
                        System.out.println("In getAllSysProfile");
                    }
                    try {
                        Vector vector2 = this._getLPARProfilesAtPartition((short)0, hscProviderSocket, bl);
                        if (DEBUG_ON) {
                            System.out.println("End of getAllSysProfile");
                        }
                        vector = vector2;
                        Object var6_6 = null;
                        if (!DEBUG_ON) break block8;
                        System.out.println("*********************************************");
                        System.out.println();
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (!DEBUG_ON) throw throwable;
                        System.out.println("*********************************************");
                        System.out.println();
                        throw throwable;
                    }
                }
                Object var8_8 = null;
                Trace.trace("apnvhscT", "<- getAllSysProfile");
                return vector;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("000D");
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Trace.trace("apnvhscT", "<- getAllSysProfile");
            throw throwable;
        }
    }

    public synchronized Vector getDefaultLPARProfile(int n, HscProviderSocket hscProviderSocket) throws CIMException {
        return this._getDefaultLPARProfile(n, hscProviderSocket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector _getDefaultLPARProfile(int n, HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        Vector vector;
        try {
            try {
                block13: {
                    Trace.trace("apnvhscT", "<- getDefaultLPARProfile");
                    Trace.trace("apnvhscF", "partitionID = " + String.valueOf(n));
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("********************************************");
                        System.out.println("In getDefaultLPARProfile");
                    }
                    try {
                        if (bl) {
                            this.buildNVRAM(hscProviderSocket, false, null, true, true);
                        }
                        String string = this._defaultList[n];
                        Trace.trace("apnvhscF", "defaultProfileTimeStamp = " + string);
                        if (string == null) {
                            vector = null;
                            return vector;
                        }
                        Object[] objectArray = (Object[])this._profileTable.get(string);
                        if (objectArray == null) {
                            Vector vector2 = null;
                            return vector2;
                        }
                        Vector vector3 = (Vector)((Vector)objectArray[2]).clone();
                        Trace.trace("apnvhscF", "ret = " + vector3);
                        Vector vector4 = vector3;
                        return vector4;
                    }
                    finally {
                        if (!DEBUG_ON) break block13;
                        System.out.println("End of getDefaultLPARProfile");
                        System.out.println("*********************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("000E");
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            Trace.trace("apnvhscT", "<- getDefaultLPARProfile");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- getDefaultLPARProfile");
        return vector;
    }

    public synchronized Vector getDefaultSysProfile(HscProviderSocket hscProviderSocket) throws CIMException {
        return this._getDefaultSysProfile(hscProviderSocket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector _getDefaultSysProfile(HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        Vector vector;
        try {
            try {
                block8: {
                    Trace.trace("apnvhscT", "<- getDefaultSysProfile");
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("*********************************************");
                        System.out.println("In getDefaultSysProfile");
                    }
                    try {
                        vector = this._getDefaultLPARProfile(0, hscProviderSocket, bl);
                        return vector;
                    }
                    finally {
                        Trace.trace("apnvhscT", "<- getDefaultSysProfile");
                        if (!DEBUG_ON) break block8;
                        System.out.println("********************************************");
                        System.out.println();
                    }
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
                HSCLogUtils.serverLog(throwable2, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable2 instanceof HSCCIMException) throw new HSCCIMException(throwable2);
                throw new HSCCIMException("000F");
            }
        }
        catch (Throwable throwable3) {
            Object var6_6 = null;
            Trace.trace("apnvhscT", "<- getDefaultSysProfile");
            throw throwable3;
        }
        Trace.trace("apnvhscT", "<- getDefaultSysProfile");
        return vector;
    }

    public synchronized Vector getLPARProfile(String string, HscProviderSocket hscProviderSocket) throws CIMException {
        return this._getLPARProfile(string, hscProviderSocket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector _getLPARProfile(String string, HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        Vector vector;
        try {
            try {
                block23: {
                    Trace.trace("apnvhscT", "-> getLPARProfile");
                    Trace.trace("apnvhscF", "profiletTimeStamp = " + string);
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("***********************************************");
                        System.out.println("In getLPARProfile");
                    }
                    try {
                        if (bl) {
                            this.buildNVRAM(hscProviderSocket, false, null, true, true);
                        }
                        int n = 0;
                        int n2 = 0;
                        if (this._releaseVersion < 3) {
                            n = this.PARTITION_ID_OFFSET;
                            n2 = this.IS_SYSTEM_OFFSET;
                        } else {
                            n = this.DLPAR_PARTITION_ID_OFFSET_R4;
                            n2 = this.DLPAR_IS_SYSTEM_OFFSET_R4;
                        }
                        Object[] objectArray = (Object[])this._profileTable.get(string);
                        if (objectArray == null) {
                            vector = null;
                            return vector;
                        }
                        int n3 = (Integer)objectArray[0];
                        byte by = this._nvramData[n3 + n];
                        byte by2 = this._nvramData[n3 + n2];
                        Vector vector2 = (Vector)((Vector)objectArray[2]).clone();
                        Trace.trace("apnvhscF", "partitionID = " + by);
                        Trace.trace("apnvhscF", "ret = " + vector2);
                        if (vector2 != null) {
                            CIMProperty cIMProperty = null;
                            CIMProperty cIMProperty2 = null;
                            cIMProperty = string.equals(this._defaultList[by]) ? new CIMProperty("isDefault", new CIMValue((Object)new Boolean(true))) : new CIMProperty("isDefault", new CIMValue((Object)new Boolean(false)));
                            cIMProperty2 = string.equals(this._activatedList[by]) ? new CIMProperty("isActivated", new CIMValue((Object)new Boolean(true))) : new CIMProperty("isActivated", new CIMValue((Object)new Boolean(false)));
                            if (by2 != 0) {
                                vector2.setSize(6);
                                vector2.setElementAt(cIMProperty, 4);
                                vector2.setElementAt(cIMProperty2, 5);
                            } else if (this._releaseVersion < 2) {
                                vector2.setSize(13);
                                vector2.setElementAt(cIMProperty, 11);
                                vector2.setElementAt(cIMProperty2, 12);
                            } else if (this._releaseVersion == 2) {
                                vector2.setSize(17);
                                vector2.setElementAt(cIMProperty, 15);
                                vector2.setElementAt(cIMProperty2, 16);
                            } else if (((CIMProperty)vector2.elementAt(15)).getValue() != null) {
                                vector2.setSize(20);
                                vector2.setElementAt(cIMProperty, 18);
                                vector2.setElementAt(cIMProperty2, 19);
                            } else {
                                vector2.setSize(17);
                                vector2.setElementAt(cIMProperty, 15);
                                vector2.setElementAt(cIMProperty2, 16);
                            }
                            Trace.trace("apnvhscF", "ret = " + vector2);
                            Vector vector3 = vector2;
                            return vector3;
                        }
                        Vector vector4 = null;
                        return vector4;
                    }
                    finally {
                        if (!DEBUG_ON) break block23;
                        System.out.println("End of getLPARProfile");
                        System.out.println("******************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var16_10 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("0010");
            }
        }
        catch (Throwable throwable) {
            Object var16_13 = null;
            Trace.trace("apnvhscT", "<- getLPARProfile");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- getLPARProfile");
        return vector;
    }

    public synchronized Vector getLPARProfilesAtPartition(short s, HscProviderSocket hscProviderSocket) throws CIMException {
        return this._getLPARProfilesAtPartition(s, hscProviderSocket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector _getLPARProfilesAtPartition(short s, HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        Vector vector;
        try {
            try {
                block21: {
                    Trace.trace("apnvhscT", "<- getLPARProfileAtPartition");
                    Trace.trace("apnvhscF", "partitionID = " + String.valueOf(s));
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("*********************************************");
                        System.out.println("In getLPARProfileAtPartition");
                    }
                    try {
                        Enumeration enumeration;
                        if (bl) {
                            this.buildNVRAM(hscProviderSocket, false, null, true, true);
                        }
                        if ((enumeration = this._profilesAtPartitionTable[s].elements()) == null) {
                            Trace.trace("apnvhscF", "ret = null");
                            vector = null;
                            return vector;
                        }
                        Vector<Vector> vector2 = new Vector<Vector>();
                        while (true) {
                            Object object;
                            if (!enumeration.hasMoreElements()) {
                                object = vector2;
                                return object;
                            }
                            object = (String)enumeration.nextElement();
                            Trace.trace("apnvhscF", "profileTimeStamp = " + (String)object);
                            Object[] objectArray = (Object[])this._profileTable.get(object);
                            Vector vector3 = (Vector)((Vector)objectArray[2]).clone();
                            CIMProperty cIMProperty = null;
                            CIMProperty cIMProperty2 = null;
                            if (vector3 == null) continue;
                            cIMProperty = ((String)object).equals(this._defaultList[s]) ? new CIMProperty("isDefault", new CIMValue((Object)new Boolean(true))) : new CIMProperty("isDefault", new CIMValue((Object)new Boolean(false)));
                            cIMProperty2 = ((String)object).equals(this._activatedList[s]) ? new CIMProperty("isActivated", new CIMValue((Object)new Boolean(true))) : new CIMProperty("isActivated", new CIMValue((Object)new Boolean(false)));
                            if (s == 0) {
                                vector3.setSize(6);
                                vector3.setElementAt(cIMProperty, 4);
                                vector3.setElementAt(cIMProperty2, 5);
                            } else if (this._releaseVersion < 2) {
                                vector3.setSize(13);
                                vector3.setElementAt(cIMProperty, 11);
                                vector3.setElementAt(cIMProperty2, 12);
                            } else if (this._releaseVersion == 2) {
                                vector3.setSize(17);
                                vector3.setElementAt(cIMProperty, 15);
                                vector3.setElementAt(cIMProperty2, 16);
                            } else if (((CIMProperty)vector3.elementAt(15)).getValue() != null) {
                                vector3.setSize(20);
                                vector3.setElementAt(cIMProperty, 18);
                                vector3.setElementAt(cIMProperty2, 19);
                            } else {
                                vector3.setSize(17);
                                vector3.setElementAt(cIMProperty, 15);
                                vector3.setElementAt(cIMProperty2, 16);
                            }
                            Trace.trace("apnvhscF", "profileProperties = " + vector3);
                            vector2.add(vector3);
                        }
                    }
                    finally {
                        if (!DEBUG_ON) break block21;
                        System.out.println("End of getLPARProfileAtPartition");
                        System.out.println("********************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var13_8 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("0011");
            }
        }
        catch (Throwable throwable) {
            Object var13_10 = null;
            Trace.trace("apnvhscT", "<- getLPARProfileAtPartition");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- getLPARProfileAtPartition");
        return vector;
    }

    public synchronized Vector getSysProfile(String string, HscProviderSocket hscProviderSocket) throws CIMException {
        return this._getSysProfile(string, hscProviderSocket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector _getSysProfile(String string, HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        try {
            try {
                Vector vector;
                block7: {
                    Trace.trace("apnvhscT", "-> getSysProfile");
                    Trace.trace("apnvhscF", "profiletTimeStamp = " + string);
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("***********************************************");
                        System.out.println("In getSysProfile");
                    }
                    try {
                        vector = this._getLPARProfile(string, hscProviderSocket, bl);
                        Object var6_6 = null;
                        if (!DEBUG_ON) break block7;
                        System.out.println("*********************************************");
                        System.out.println();
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (!DEBUG_ON) throw throwable;
                        System.out.println("*********************************************");
                        System.out.println();
                        throw throwable;
                    }
                }
                Object var8_8 = null;
                Trace.trace("apnvhscT", "<- getSysProfile");
                return vector;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("0012");
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Trace.trace("apnvhscT", "<- getSysProfile");
            throw throwable;
        }
    }

    public synchronized void removeLPARProfile(String string, HscProviderSocket hscProviderSocket) throws CIMException {
        if (this._releaseVersion < 2) {
            this._removeLPARProfile(string, hscProviderSocket, true);
        } else {
            this._removeDLPARProfile(string, hscProviderSocket, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] _removeLPARProfile(String string, HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        int[] nArray;
        try {
            try {
                block71: {
                    Trace.trace("apnvhscT", "-> removeLPARProfile");
                    Trace.trace("apnvhscF", "profiletTimeStamp = " + string);
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("*********************************************");
                        System.out.println("In removeLPARProfile");
                    }
                    Hashtable hashtable = (Hashtable)this._profileTable.clone();
                    byte[] byArray = (byte[])this._nvramData.clone();
                    short s = this._numDrawers;
                    Hashtable hashtable2 = (Hashtable)this._drawerIDTable.clone();
                    Hashtable hashtable3 = (Hashtable)this._drawerIndexTable.clone();
                    short s2 = this._dIDFreeListTail;
                    Vector vector = (Vector)this._dIDFreeList.clone();
                    Vector[] vectorArray = (Vector[])this._profilesAtPartitionTable.clone();
                    Hashtable hashtable4 = (Hashtable)this._profileNameTable.clone();
                    Vector vector2 = (Vector)this._pnameFreeList.clone();
                    Hashtable hashtable5 = (Hashtable)this._profileNameOffsetTable.clone();
                    boolean bl2 = false;
                    try {
                        int n;
                        int[] nArray2;
                        Object object;
                        int n2;
                        int n3;
                        CIMValue cIMValue;
                        CIMValue cIMValue2;
                        Object[] objectArray;
                        int[] nArray3 = null;
                        boolean bl3 = false;
                        int n4 = -1;
                        int n5 = -1;
                        int n6 = -1;
                        int n7 = -1;
                        if (bl) {
                            this.buildNVRAM(hscProviderSocket, false, null, true, false);
                        }
                        if ((objectArray = (Object[])this._profileTable.get(string)) == null) {
                            nArray = null;
                            return nArray;
                        }
                        int n8 = (Integer)objectArray[0];
                        Trace.trace("apnvhscF", "profileOffset  = " + String.valueOf(n8));
                        if (DEBUG_ON) {
                            System.out.println("In removeLPARProfile: profileOffset = " + n8);
                            System.out.println("In removeLPARProfile: templateVersion = " + this._nvramData[n8 + this.TEMPLATE_VERSION_OFFSET]);
                        }
                        this._nvramData[n8 + this.TEMPLATE_VERSION_OFFSET] = -1;
                        byte by = this._nvramData[n8 + this.PARTITION_ID_OFFSET];
                        Trace.trace("apnvhscF", "partitionID =  " + String.valueOf(by));
                        if (n6 == -1) {
                            n6 = n8 + this.TEMPLATE_VERSION_OFFSET;
                        } else if (n6 > n8 + this.TEMPLATE_VERSION_OFFSET) {
                            n6 = n8 + this.TEMPLATE_VERSION_OFFSET;
                        }
                        if (n7 == -1) {
                            n7 = n8 + this.TEMPLATE_VERSION_OFFSET + 1;
                        } else if (n7 < n8 + this.TEMPLATE_VERSION_OFFSET + 1) {
                            n7 = n8 + this.TEMPLATE_VERSION_OFFSET + 1;
                        }
                        String string2 = (String)((CIMProperty)((Vector)objectArray[2]).elementAt(1)).getValue().getValue();
                        Trace.trace("apnvhscF", "name = " + string2);
                        int n9 = 0;
                        short s3 = 0;
                        short s4 = (Short)objectArray[1];
                        Trace.trace("apnvhscF", "len = " + String.valueOf(s4));
                        Vector vector3 = null;
                        Vector vector4 = null;
                        Vector vector5 = null;
                        CIMValue cIMValue3 = ((CIMProperty)((Vector)objectArray[2]).elementAt(8)).getValue();
                        if (cIMValue3 != null) {
                            Trace.trace("apnvhscF", "drawersValue = " + cIMValue3.getValue());
                        }
                        if ((cIMValue2 = ((CIMProperty)((Vector)objectArray[2]).elementAt(9)).getValue()) != null) {
                            Trace.trace("apnvhscF", "slotsValue = " + cIMValue2.getValue());
                        }
                        if ((cIMValue = ((CIMProperty)((Vector)objectArray[2]).elementAt(10)).getValue()) != null) {
                            Trace.trace("apnvhscF", "reqValue = " + cIMValue.getValue());
                        }
                        if (cIMValue3 == null && cIMValue2 == null && cIMValue == null) {
                            vector3 = null;
                            vector4 = null;
                            vector5 = null;
                        } else {
                            if (cIMValue3 == null) throw new HSCCIMException("03EF");
                            if (cIMValue2 == null) throw new HSCCIMException("03EF");
                            if (cIMValue == null) {
                                throw new HSCCIMException("03EF");
                            }
                            vector3 = (Vector)cIMValue3.getValue();
                            vector4 = (Vector)cIMValue2.getValue();
                            vector5 = (Vector)cIMValue.getValue();
                        }
                        boolean bl4 = false;
                        boolean bl5 = false;
                        if (vector3 != null) {
                            if (vector3.size() != vector4.size()) throw new HSCCIMException("03EF");
                            if (vector3.size() != vector5.size()) {
                                throw new HSCCIMException("03EF");
                            }
                        }
                        if (vector3 != null && vector3.size() != 0) {
                            n3 = vector3.size();
                            Trace.trace("apnvhscF", "numSlots = " + String.valueOf(n3));
                            if (DEBUG_ON) {
                                System.out.println("In removeLPARProfile: numSlots = " + n3);
                            }
                            n2 = 0;
                            while (n2 < n3) {
                                object = (String)vector3.get(n2);
                                Trace.trace("apnvhscF", "drawerID = " + (String)object);
                                if (DEBUG_ON) {
                                    System.out.println("In removeLPARProfile: drawerID = " + ((String)object).trim());
                                }
                                if ((nArray2 = (int[])this._drawerIDTable.get(object))[2] == 1) {
                                    block67: {
                                        bl5 = true;
                                        n9 = nArray2[0];
                                        if (DEBUG_ON) {
                                            System.out.println("In removeLPARProfile: drawerOffset = " + n9);
                                        }
                                        n = 0;
                                        while (true) {
                                            if (n >= 26) {
                                                if (n6 != -1) break;
                                                n6 = n9;
                                                break block67;
                                            }
                                            this._nvramData[n9 + n] = 0;
                                            ++n;
                                        }
                                        if (n6 > n9) {
                                            n6 = n9;
                                        }
                                    }
                                    if (n7 == -1) {
                                        n7 = n9 + 24 + 2;
                                    } else if (n7 < n9 + 24 + 2) {
                                        n7 = n9 + 24 + 2;
                                    }
                                    this._numDrawers = (short)(this._numDrawers - 1);
                                    this._nvramData[this.NUM_DRAWERS_OFFSET] = (byte)(this._numDrawers >>> 8);
                                    this._nvramData[this.NUM_DRAWERS_OFFSET + 1] = (byte)this._numDrawers;
                                    s3 = (short)nArray2[1];
                                    if (DEBUG_ON) {
                                        System.out.println("In removeLPARProfile: drawerIndex = " + s3);
                                    }
                                    this._drawerIDTable.remove(object);
                                    this._drawerIndexTable.remove(new Short(s3));
                                    if (s3 == this._dIDFreeListTail - 1) {
                                        this._dIDFreeListTail = (short)(this._dIDFreeListTail - 1);
                                    } else {
                                        this._dIDFreeList.add(new Short(s3));
                                    }
                                } else {
                                    nArray2[2] = nArray2[2] - 1;
                                }
                                ++n2;
                            }
                        }
                        this._profileTable.remove(string);
                        this._profilesAtPartitionTable[by].remove(string);
                        nArray2 = (int[])this._profileNameTable.get(string2);
                        n3 = nArray2[1];
                        n9 = nArray2[0];
                        if (DEBUG_ON) {
                            System.out.println("In removeLPARProfile: nameoffset = " + n9);
                        }
                        if (n3 == 1) {
                            block69: {
                                bl4 = true;
                                n2 = 0;
                                while (true) {
                                    if (n2 >= 32) {
                                        if (n4 != -1) break;
                                        n4 = n9;
                                        break block69;
                                    }
                                    this._nvramData[n9 + n2] = 0;
                                    ++n2;
                                }
                                if (n4 > n9) {
                                    n4 = n9;
                                }
                            }
                            if (n5 == -1) {
                                n5 = n9 + 32;
                            } else if (n5 < n9 + 32) {
                                n5 = n9 + 32;
                            }
                            this._pnameFreeList.add(new Integer(n9));
                            this._profileNameTable.remove(string2);
                            this._profileNameOffsetTable.remove(new Integer(n9));
                        } else {
                            nArray2[1] = nArray2[1] - 1;
                        }
                        if (string.equals(this._defaultList[by]) && this._fastActivation[by - 1]) {
                            this._fastActivation[by - 1] = false;
                            this._nvramData[this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (by - 1) + 31] = 0;
                            bl2 = true;
                        }
                        if (bl) {
                            byte by2;
                            block70: {
                                Hashtable hashtable6 = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", null, hscProviderSocket, this._cspVersion);
                                object = this.getTime(hashtable6);
                                n = 0;
                                while (true) {
                                    if (n >= 7) {
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                                        if (bl2) {
                                            this._partitionNameTableTimeStamp = (byte[])object.clone();
                                            this._checksumCalc.reset();
                                            this._checksumCalc.update(this._nvramData, this.PARTITION_NAME_TABLE_OFFSET, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET - this.PARTITION_NAME_TABLE_OFFSET);
                                            this._checksum = this._checksumCalc.getValue();
                                            this.writeIntegralToNvramData(this._checksum, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                                        }
                                        if (bl4) {
                                            this._profileNameTableTimeStamp = (byte[])object.clone();
                                            this._checksumCalc.reset();
                                            this._checksumCalc.update(this._nvramData, this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
                                            this._checksum = this._checksumCalc.getValue();
                                            this.writeIntegralToNvramData(this._checksum, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                                        }
                                        this._drawerProfileInfoTimeStamp = (byte[])object.clone();
                                        this._nvramTimeStamp = (byte[])object.clone();
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, (short)8);
                                        if (this._releaseVersion != 0) {
                                            by2 = this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET;
                                            this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = (byte)(by2 >>> 8);
                                            this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = (byte)(by2 & 0xFF);
                                        }
                                        this._backupToLocalFile();
                                        by2 = (byte)(this._releaseVersion << 1 | CORRUPTED_ON[0]);
                                        this._writeDataToCSP(new byte[]{by2}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                                        this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, hscProviderSocket);
                                        if (bl2) {
                                            this._writeDataToCSP(new String(this._nvramData, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                            this._writeDataToCSP(new String(this._nvramData, this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (by - 1) + 31, 1).getBytes(), this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (by - 1) + 31, 1, hscProviderSocket);
                                        }
                                        if (bl4) {
                                            if (DEBUG_ON) {
                                                System.out.println("In removeLPARProfile: changeProfileNameTable");
                                            }
                                            this._writeDataToCSP(new String(this._nvramData, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                            this._writeDataToCSP(this._zeroOutNameString.getBytes(), n9, 32, hscProviderSocket);
                                        }
                                        if (this._releaseVersion != 0) break;
                                        this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                        break block70;
                                    }
                                    this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + n] = (byte)object[n];
                                    if (bl2) {
                                        this._nvramData[this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET + n] = (byte)object[n];
                                    }
                                    if (bl4) {
                                        this._nvramData[this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + n] = (byte)object[n];
                                    }
                                    this._nvramData[this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + n] = (byte)object[n];
                                    ++n;
                                }
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10, hscProviderSocket);
                            }
                            if (bl5) {
                                System.out.println("In removeLPARProfile: changeDrawer");
                                this._writeDataToCSP(new String(this._nvramData, this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET).getBytes(), this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET, hscProviderSocket);
                            }
                            this._writeDataToCSP(new String(this._nvramData, n8 + this.TEMPLATE_VERSION_OFFSET, 1).getBytes(), n8 + this.TEMPLATE_VERSION_OFFSET, 1, hscProviderSocket);
                            by2 = (byte)(this._releaseVersion << 1 | CORRUPTED_OFF[0]);
                            this._writeDataToCSP(new byte[]{by2}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                        }
                        if (DEBUG_ON) {
                            System.out.println("Successful");
                        }
                        int[] nArray4 = nArray3;
                        return nArray4;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        this._profileTable = hashtable;
                        this._nvramData = byArray;
                        this._numDrawers = s;
                        this._drawerIDTable = hashtable2;
                        this._drawerIndexTable = hashtable3;
                        this._dIDFreeListTail = s2;
                        this._dIDFreeList = vector;
                        this._profilesAtPartitionTable = vectorArray;
                        this._profileNameTable = hashtable4;
                        this._pnameFreeList = vector2;
                        this._profileNameOffsetTable = hashtable5;
                        throw throwable;
                    }
                    finally {
                        if (!DEBUG_ON) break block71;
                        System.out.println("End of removeLPARProfile");
                        System.out.println("********************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var45_27 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("0013");
            }
        }
        catch (Throwable throwable) {
            Object var45_29 = null;
            Trace.trace("apnvhscT", "<- removeLPARProfile");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- removeLPARProfile");
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] _removeDLPARProfile(String string, HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        int[] nArray;
        try {
            try {
                block77: {
                    Trace.trace("apnvhscT", "-> removeDLPARProfile");
                    Trace.trace("apnvhscF", "profiletTimeStamp = " + string);
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("*********************************************");
                        System.out.println("In removeDLPARProfile");
                    }
                    Hashtable hashtable = (Hashtable)this._profileTable.clone();
                    byte[] byArray = (byte[])this._nvramData.clone();
                    short s = this._numDrawers;
                    Hashtable hashtable2 = (Hashtable)this._drawerIDTable.clone();
                    Hashtable hashtable3 = (Hashtable)this._drawerIndexTable.clone();
                    short s2 = this._dIDFreeListTail;
                    Vector vector = (Vector)this._dIDFreeList.clone();
                    Vector[] vectorArray = (Vector[])this._profilesAtPartitionTable.clone();
                    Hashtable hashtable4 = (Hashtable)this._profileNameTable.clone();
                    Vector vector2 = (Vector)this._pnameFreeList.clone();
                    Hashtable hashtable5 = (Hashtable)this._profileNameOffsetTable.clone();
                    boolean bl2 = false;
                    try {
                        int n;
                        int[] nArray2;
                        Object object;
                        int n2;
                        int n3;
                        CIMValue cIMValue;
                        CIMValue cIMValue2;
                        Object[] objectArray;
                        int[] nArray3 = null;
                        boolean bl3 = false;
                        int n4 = -1;
                        int n5 = -1;
                        int n6 = -1;
                        int n7 = -1;
                        if (bl) {
                            this.buildNVRAM(hscProviderSocket, false, null, true, false);
                        }
                        if ((objectArray = (Object[])this._profileTable.get(string)) == null) {
                            nArray = null;
                            return nArray;
                        }
                        int n8 = 0;
                        int n9 = 0;
                        if (this._releaseVersion < 3) {
                            n8 = this.DLPAR_PARTITION_ID_OFFSET;
                            n9 = this.DLPAR_TEMPLATE_VERSION_OFFSET;
                        } else {
                            n8 = this.DLPAR_PARTITION_ID_OFFSET_R4;
                            n9 = this.DLPAR_TEMPLATE_VERSION_OFFSET_R4;
                        }
                        int n10 = (Integer)objectArray[0];
                        Trace.trace("apnvhscF", "profileOffset  = " + String.valueOf(n10));
                        if (DEBUG_ON) {
                            System.out.println("In removeDLPARProfile: profileOffset = " + n10);
                            System.out.println("In removeDLPARProfile: templateVersion = " + this._nvramData[n10 + n9]);
                        }
                        this._nvramData[n10 + n9] = -1;
                        byte by = this._nvramData[n10 + n8];
                        Trace.trace("apnvhscF", "partitionID =  " + String.valueOf(by));
                        if (n6 == -1) {
                            n6 = n10 + n9;
                        } else if (n6 > n10 + n9) {
                            n6 = n10 + n9;
                        }
                        if (n7 == -1) {
                            n7 = n10 + n9 + 1;
                        } else if (n7 < n10 + n9 + 1) {
                            n7 = n10 + n9 + 1;
                        }
                        String string2 = (String)((CIMProperty)((Vector)objectArray[2]).elementAt(1)).getValue().getValue();
                        Trace.trace("apnvhscF", "name = " + string2);
                        int n11 = 0;
                        short s3 = 0;
                        short s4 = (Short)objectArray[1];
                        Trace.trace("apnvhscF", "len = " + String.valueOf(s4));
                        Vector vector3 = null;
                        Vector vector4 = null;
                        Vector vector5 = null;
                        CIMValue cIMValue3 = ((CIMProperty)((Vector)objectArray[2]).elementAt(12)).getValue();
                        if (cIMValue3 != null) {
                            Trace.trace("apnvhscF", "drawersValue = " + cIMValue3.getValue());
                        }
                        if ((cIMValue2 = ((CIMProperty)((Vector)objectArray[2]).elementAt(13)).getValue()) != null) {
                            Trace.trace("apnvhscF", "slotsValue = " + cIMValue2.getValue());
                        }
                        if ((cIMValue = ((CIMProperty)((Vector)objectArray[2]).elementAt(14)).getValue()) != null) {
                            Trace.trace("apnvhscF", "reqValue = " + cIMValue.getValue());
                        }
                        if (cIMValue3 == null && cIMValue2 == null && cIMValue == null) {
                            vector3 = null;
                            vector4 = null;
                            vector5 = null;
                        } else {
                            if (cIMValue3 == null) throw new HSCCIMException("03EF");
                            if (cIMValue2 == null) throw new HSCCIMException("03EF");
                            if (cIMValue == null) {
                                throw new HSCCIMException("03EF");
                            }
                            vector3 = (Vector)cIMValue3.getValue();
                            vector4 = (Vector)cIMValue2.getValue();
                            vector5 = (Vector)cIMValue.getValue();
                        }
                        boolean bl4 = false;
                        boolean bl5 = false;
                        if (vector3 != null) {
                            if (vector3.size() != vector4.size()) throw new HSCCIMException("03EF");
                            if (vector3.size() != vector5.size()) {
                                throw new HSCCIMException("03EF");
                            }
                        }
                        if (vector3 != null && vector3.size() != 0) {
                            n3 = vector3.size();
                            Trace.trace("apnvhscF", "numSlots = " + String.valueOf(n3));
                            if (DEBUG_ON) {
                                System.out.println("In removeLPARProfile: numSlots = " + n3);
                            }
                            n2 = 0;
                            while (n2 < n3) {
                                object = (String)vector3.get(n2);
                                Trace.trace("apnvhscF", "drawerID = " + (String)object);
                                if (DEBUG_ON) {
                                    System.out.println("In removeLPARProfile: drawerID = " + ((String)object).trim());
                                }
                                if ((nArray2 = (int[])this._drawerIDTable.get(object))[2] == 1) {
                                    block73: {
                                        bl5 = true;
                                        n11 = nArray2[0];
                                        if (DEBUG_ON) {
                                            System.out.println("In removeLPARProfile: drawerOffset = " + n11);
                                        }
                                        n = 0;
                                        while (true) {
                                            if (n >= 26) {
                                                if (n6 != -1) break;
                                                n6 = n11;
                                                break block73;
                                            }
                                            this._nvramData[n11 + n] = 0;
                                            ++n;
                                        }
                                        if (n6 > n11) {
                                            n6 = n11;
                                        }
                                    }
                                    if (n7 == -1) {
                                        n7 = n11 + 24 + 2;
                                    } else if (n7 < n11 + 24 + 2) {
                                        n7 = n11 + 24 + 2;
                                    }
                                    this._numDrawers = (short)(this._numDrawers - 1);
                                    this._nvramData[this.NUM_DRAWERS_OFFSET] = (byte)(this._numDrawers >>> 8);
                                    this._nvramData[this.NUM_DRAWERS_OFFSET + 1] = (byte)this._numDrawers;
                                    s3 = (short)nArray2[1];
                                    if (DEBUG_ON) {
                                        System.out.println("In removeLPARProfile: drawerIndex = " + s3);
                                    }
                                    this._drawerIDTable.remove(object);
                                    this._drawerIndexTable.remove(new Short(s3));
                                    if (s3 == this._dIDFreeListTail - 1) {
                                        this._dIDFreeListTail = (short)(this._dIDFreeListTail - 1);
                                    } else {
                                        this._dIDFreeList.add(new Short(s3));
                                    }
                                } else {
                                    nArray2[2] = nArray2[2] - 1;
                                }
                                ++n2;
                            }
                        }
                        this._profileTable.remove(string);
                        this._profilesAtPartitionTable[by].remove(string);
                        nArray2 = (int[])this._profileNameTable.get(string2);
                        n3 = nArray2[1];
                        n11 = nArray2[0];
                        if (DEBUG_ON) {
                            System.out.println("In removeLPARProfile: nameoffset = " + n11);
                        }
                        if (n3 == 1) {
                            block75: {
                                bl4 = true;
                                n2 = 0;
                                while (true) {
                                    if (n2 >= 32) {
                                        if (n4 != -1) break;
                                        n4 = n11;
                                        break block75;
                                    }
                                    this._nvramData[n11 + n2] = 0;
                                    ++n2;
                                }
                                if (n4 > n11) {
                                    n4 = n11;
                                }
                            }
                            if (n5 == -1) {
                                n5 = n11 + 32;
                            } else if (n5 < n11 + 32) {
                                n5 = n11 + 32;
                            }
                            this._pnameFreeList.add(new Integer(n11));
                            this._profileNameTable.remove(string2);
                            this._profileNameOffsetTable.remove(new Integer(n11));
                        } else {
                            nArray2[1] = nArray2[1] - 1;
                        }
                        if (string.equals(this._defaultList[by]) && this._fastActivation[by - 1]) {
                            this._fastActivation[by - 1] = false;
                            this._nvramData[this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (by - 1) + 31] = 0;
                            bl2 = true;
                        }
                        if (bl) {
                            byte by2;
                            block76: {
                                Hashtable hashtable6 = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", null, hscProviderSocket, this._cspVersion);
                                object = this.getTime(hashtable6);
                                n = 0;
                                while (true) {
                                    if (n >= 7) {
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                                        if (bl2) {
                                            this._partitionNameTableTimeStamp = (byte[])object.clone();
                                            this._checksumCalc.reset();
                                            this._checksumCalc.update(this._nvramData, this.PARTITION_NAME_TABLE_OFFSET, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET - this.PARTITION_NAME_TABLE_OFFSET);
                                            this._checksum = this._checksumCalc.getValue();
                                            this.writeIntegralToNvramData(this._checksum, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                                        }
                                        if (bl4) {
                                            this._profileNameTableTimeStamp = (byte[])object.clone();
                                            this._checksumCalc.reset();
                                            this._checksumCalc.update(this._nvramData, this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
                                            this._checksum = this._checksumCalc.getValue();
                                            this.writeIntegralToNvramData(this._checksum, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                                        }
                                        this._drawerProfileInfoTimeStamp = (byte[])object.clone();
                                        this._nvramTimeStamp = (byte[])object.clone();
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, (short)8);
                                        if (this._releaseVersion != 0) {
                                            by2 = this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET;
                                            if (this._releaseVersion >= 3) break;
                                            this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = (byte)(by2 >>> 8);
                                            this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = (byte)(by2 & 0xFF);
                                        }
                                        break block76;
                                    }
                                    this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + n] = (byte)object[n];
                                    if (bl2) {
                                        this._nvramData[this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET + n] = (byte)object[n];
                                    }
                                    if (bl4) {
                                        this._nvramData[this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + n] = (byte)object[n];
                                    }
                                    this._nvramData[this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + n] = (byte)object[n];
                                    ++n;
                                }
                                this.writeIntToNvramData(by2, this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET);
                            }
                            this._backupToLocalFile();
                            by2 = (byte)(this._releaseVersion << 1 | CORRUPTED_ON[0]);
                            this._writeDataToCSP(new byte[]{by2}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                            this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, hscProviderSocket);
                            if (bl2) {
                                this._writeDataToCSP(new String(this._nvramData, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                this._writeDataToCSP(new String(this._nvramData, this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (by - 1) + 31, 1).getBytes(), this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (by - 1) + 31, 1, hscProviderSocket);
                            }
                            if (bl4) {
                                if (DEBUG_ON) {
                                    System.out.println("In removeLPARProfile: changeProfileNameTable");
                                }
                                this._writeDataToCSP(new String(this._nvramData, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                this._writeDataToCSP(this._zeroOutNameString.getBytes(), n11, 32, hscProviderSocket);
                            }
                            if (this._releaseVersion == 0) {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8, hscProviderSocket);
                            } else if (this._releaseVersion < 3) {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10, hscProviderSocket);
                            } else {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12, hscProviderSocket);
                            }
                            if (bl5) {
                                System.out.println("In removeLPARProfile: changeDrawer");
                                this._writeDataToCSP(new String(this._nvramData, this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET).getBytes(), this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET, hscProviderSocket);
                            }
                            this._writeDataToCSP(new String(this._nvramData, n10 + n9, 1).getBytes(), n10 + n9, 1, hscProviderSocket);
                            by2 = (byte)(this._releaseVersion << 1 | CORRUPTED_OFF[0]);
                            this._writeDataToCSP(new byte[]{by2}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                        }
                        if (DEBUG_ON) {
                            System.out.println("Successful");
                        }
                        int[] nArray4 = nArray3;
                        return nArray4;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        this._profileTable = hashtable;
                        this._nvramData = byArray;
                        this._numDrawers = s;
                        this._drawerIDTable = hashtable2;
                        this._drawerIndexTable = hashtable3;
                        this._dIDFreeListTail = s2;
                        this._dIDFreeList = vector;
                        this._profilesAtPartitionTable = vectorArray;
                        this._profileNameTable = hashtable4;
                        this._pnameFreeList = vector2;
                        this._profileNameOffsetTable = hashtable5;
                        throw throwable;
                    }
                    finally {
                        if (!DEBUG_ON) break block77;
                        System.out.println("End of removeDLPARProfile");
                        System.out.println("********************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var47_27 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("0013");
            }
        }
        catch (Throwable throwable) {
            Object var47_29 = null;
            Trace.trace("apnvhscT", "<- removeDLPARProfile");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- removeDLPARProfile");
        return nArray;
    }

    public synchronized void removeSysProfile(String string, HscProviderSocket hscProviderSocket) throws CIMException {
        this._removeSysProfile(string, hscProviderSocket, true);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _removeSysProfile(String var1_1, HscProviderSocket var2_2, boolean var3_3) throws CIMException {
        try {
            try {
                block30: {
                    Trace.trace("apnvhscT", "-> removeSysProfile");
                    Trace.trace("apnvhscF", "profileTimeStamp = " + var1_1);
                    Trace.trace("apnvhscF", "socket = " + var2_2);
                    if (NVRAM.DEBUG_ON) {
                        System.out.println("************************************************");
                        System.out.println("In removeSysProfile");
                    }
                    var4_4 = (Hashtable)this._profileTable.clone();
                    var5_6 = (byte[])this._nvramData.clone();
                    var6_7 = (Vector[])this._profilesAtPartitionTable.clone();
                    var7_8 = (Vector)this._pnameFreeList.clone();
                    var8_9 = (Hashtable)this._profileNameTable.clone();
                    var9_10 = (Hashtable)this._profileNameOffsetTable.clone();
                    var10_11 = 0;
                    var10_11 = this._releaseVersion < 3 ? this.TEMPLATE_VERSION_OFFSET : this.DLPAR_TEMPLATE_VERSION_OFFSET_R4;
                    try {
                        if (var3_3) {
                            this.buildNVRAM(var2_2, false, null, true, false);
                        }
                        if ((var11_12 = (Object[])this._profileTable.get(var1_1)) == null) {
                        }
                        var12_17 = (Integer)var11_12[0];
                        Trace.trace("apnvhscF", "profileOffset  = " + String.valueOf(var12_17));
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("In removeSysProfile: profileOffset = " + var12_17);
                            System.out.println("In removeSysProfile: templateVersion = " + this._nvramData[var12_17 + var10_11]);
                        }
                        this._nvramData[var12_17 + var10_11] = -1;
                        var13_18 = (String)((CIMProperty)((Vector)var11_12[2]).elementAt(1)).getValue().getValue();
                        Trace.trace("apnvhscF", "name = " + var13_18);
                        var14_19 = 0;
                        var16_20 = (Short)var11_12[1];
                        Trace.trace("apnvhscF", "len = " + String.valueOf(var16_20));
                        var17_21 = false;
                        this._profileTable.remove(var1_1);
                        this._profilesAtPartitionTable[0].remove(var1_1);
                        var15_22 = (int[])this._profileNameTable.get(var13_18);
                        var18_23 = var15_22[1];
                        var14_19 = var15_22[0];
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("In removeSysProfile: nameoffset = " + var14_19);
                        }
                        if (var18_23 != 1) {
                            var15_22[1] = var15_22[1] - 1;
lbl45:
                            // 2 sources

                            while (true) {
                                if (var3_3) {
                                    block29: {
                                        var19_25 = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", null, var2_2, this._cspVersion);
                                        var20_26 = this.getTime(var19_25);
                                        var21_27 = 0;
                                        while (true) {
                                            if (var21_27 >= 7) {
                                                this._checksumCalc.reset();
                                                this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                                                this._checksum = this._checksumCalc.getValue();
                                                this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                                                if (var17_21) {
                                                    this._profileNameTableTimeStamp = (byte[])var20_26.clone();
                                                    this._checksumCalc.reset();
                                                    this._checksumCalc.update(this._nvramData, this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
                                                    this._checksum = this._checksumCalc.getValue();
                                                    this.writeIntegralToNvramData(this._checksum, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                                                }
                                                this._nvramTimeStamp = (byte[])var20_26.clone();
                                                this._drawerProfileInfoTimeStamp = (byte[])var20_26.clone();
                                                this._checksumCalc.reset();
                                                this._checksumCalc.update(this._nvramData, this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET);
                                                this._checksum = this._checksumCalc.getValue();
                                                this.writeIntegralToNvramData(this._checksum, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, (short)8);
                                                if (this._releaseVersion != 0) {
                                                    var22_28 = this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET;
                                                    if (this._releaseVersion >= 3) break;
                                                    this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = (byte)(var22_28 >>> 8);
                                                    this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = (byte)(var22_28 & 255);
                                                }
                                                break block29;
                                            }
                                            this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + var21_27] = var20_26[var21_27];
                                            if (var17_21) {
                                                this._nvramData[this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + var21_27] = var20_26[var21_27];
                                            }
                                            this._nvramData[this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + var21_27] = var20_26[var21_27];
                                            ++var21_27;
                                        }
                                        this.writeIntToNvramData(var22_28, this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET);
                                    }
                                    this._backupToLocalFile();
                                    var22_28 = (byte)(this._releaseVersion << 1 | NVRAM.CORRUPTED_ON[0]);
                                    this._writeDataToCSP(new byte[]{var22_28}, this.CORRUPTED_BYTE_OFFSET, 1, var2_2);
                                    this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, var2_2);
                                    if (var17_21) {
                                        this._writeDataToCSP(new String(this._nvramData, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8, var2_2);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In removeLPARProfile: changeProfileNameTable");
                                        }
                                        this._writeDataToCSP(this._zeroOutNameString.getBytes(), var14_19, 32, var2_2);
                                    }
                                    if (this._releaseVersion == 0) {
                                        this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8, var2_2);
                                    } else {
                                        this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10, var2_2);
                                    }
                                    this._writeDataToCSP(new String(this._nvramData, var12_17 + var10_11, 1).getBytes(), var12_17 + var10_11, 1, var2_2);
                                    var22_28 = (byte)(this._releaseVersion << 1 | NVRAM.CORRUPTED_OFF[0]);
                                    this._writeDataToCSP(new byte[]{var22_28}, this.CORRUPTED_BYTE_OFFSET, 1, var2_2);
                                }
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("Successful");
                                }
                                break;
                            }
                        }
                        var17_21 = true;
                        var19_24 = 0;
                        if (true) ** GOTO lbl139
                    }
                    catch (Throwable var11_13) {
                        var11_13.printStackTrace();
                        this._profileTable = var4_4;
                        this._nvramData = var5_6;
                        this._profilesAtPartitionTable = var6_7;
                        this._pnameFreeList = var7_8;
                        this._profileNameTable = var8_9;
                        this._profileNameOffsetTable = var9_10;
                        throw var11_13;
                    }
                    finally {
                        if (!NVRAM.DEBUG_ON) break block30;
                        System.out.println("End of removeSysProfile");
                        System.out.println("********************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                var25_14 = null;
            }
            catch (Throwable var4_5) {
                var4_5.printStackTrace();
                HSCLogUtils.serverLog(var4_5, HSCLogUtils._NVRAMClassLogInfo);
                if (var4_5 instanceof HSCCIMException != false) throw new HSCCIMException(var4_5);
                throw new HSCCIMException("0014");
            }
        }
        catch (Throwable var24_30) {
            var25_16 = null;
            Trace.trace("apnvhscT", "<- removeSysProfile");
            throw var24_30;
        }
        Trace.trace("apnvhscT", "<- removeSysProfile");
        return;
        do {
            this._nvramData[var14_19 + var19_24] = 0;
            ++var19_24;
lbl139:
            // 2 sources

        } while (var19_24 < 32);
        this._pnameFreeList.add(new Integer(var14_19));
        this._profileNameTable.remove(var13_18);
        this._profileNameOffsetTable.remove(new Integer(var14_19));
        ** while (true)
    }

    public synchronized void saveLPARProfile(String string, String string2, Vector vector, String string3, HscProviderSocket hscProviderSocket) throws CIMException {
        if (this._releaseVersion < 2) {
            this._saveLPARProfile(string, string2, vector, string3, hscProviderSocket, true);
        } else {
            this._saveDLPARProfile(string, string2, vector, string3, hscProviderSocket, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _saveLPARProfile(String var1_1, String var2_2, Vector var3_3, String var4_4, HscProviderSocket var5_5, boolean var6_6) throws CIMException {
        try {
            try {
                block104: {
                    block115: {
                        block109: {
                            block106: {
                                block108: {
                                    block107: {
                                        block105: {
                                            Trace.trace("apnvhscT", "-> saveLPARProfile");
                                            Trace.trace("apnvhscF", "oldName = " + var1_1);
                                            Trace.trace("apnvhscF", "profileTimeStamp = " + var2_2);
                                            Trace.trace("apnvhscF", "properties = " + var3_3);
                                            Trace.trace("apnvhscF", "newName = " + var4_4);
                                            Trace.trace("apnvhscF", "socket = " + var5_5);
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("************************************");
                                                System.out.println("In saveLPARProfile");
                                            }
                                            if (var6_6) {
                                                this.buildNVRAM(var5_5, false, null, true, false);
                                            }
                                            var7_7 = 0;
                                            var8_9 = 0;
                                            var9_10 = false;
                                            var10_11 = 0;
                                            var11_12 = false;
                                            var12_13 = 0;
                                            var13_14 = 0;
                                            var14_15 = 0;
                                            var15_16 = 0;
                                            var16_17 = 0;
                                            var17_18 = 0L;
                                            var19_19 = 0L;
                                            var21_20 = new String();
                                            var22_21 = 0;
                                            var8_9 = this._hscTemplateVersion;
                                            var9_10 = false;
                                            var28_22 = this._drawerOffsetTail;
                                            var29_23 = 0;
                                            var30_24 = 0;
                                            var31_25 = false;
                                            var32_26 = false;
                                            var33_27 = false;
                                            var34_28 = (byte[])this._nvramData.clone();
                                            var35_29 = this._nvramDataSize;
                                            var36_30 = this._numDrawers;
                                            var37_31 = (Hashtable)this._drawerIDTable.clone();
                                            var38_32 = (Hashtable)this._drawerIndexTable.clone();
                                            var39_33 = (Hashtable)this._profileNameTable.clone();
                                            var40_34 = (Hashtable)this._profileNameOffsetTable.clone();
                                            var41_35 = (Hashtable)this._profileTable.clone();
                                            var42_36 = (Vector)this._pnameFreeList.clone();
                                            var43_37 = (Vector)this._dIDFreeList.clone();
                                            var44_38 = this._drawerOffsetTail;
                                            var45_39 = this._dIDFreeListTail;
                                            var46_40 = (Integer)((Object[])this._profileTable.get(var2_2))[0];
                                            var47_41 = false;
                                            var48_42 = false;
                                            var49_43 = true;
                                            var50_44 = false;
                                            var51_45 = false;
                                            var52_46 = false;
                                            var53_47 = var1_1.length();
                                            if (var4_4 != null) break block105;
                                            Trace.trace("apnvhscF", "No new name - No need to change the profile name table");
                                            var25_48 = new String(var1_1);
                                            var10_11 = ((int[])this._profileNameTable.get(var25_48))[0];
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In saveLPARProfile: name = " + var25_48.trim());
                                                System.out.println("In saveLPARProfile: nameIndex = " + var10_11);
                                            }
                                            break block106;
                                        }
                                        Trace.trace("apnvhscF", "Has new name - May need to change the name table");
                                        var12_13 = var34_28[var46_40 + this.PARTITION_ID_OFFSET];
                                        Trace.trace("apnvhscF", "partitionIndex = " + String.valueOf(var12_13));
                                        if (this.isDuplicatedAtPartition(var12_13, var4_4, var5_5)) {
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In saveLPARProfile: name already exist");
                                            }
                                            Trace.trace("apnvhscF", "name already exist in same partition - throw CIMException");
                                            throw new HSCCIMException("0004", new String[]{var4_4, String.valueOf(var12_13)});
                                        }
                                        var53_47 = var4_4.length();
                                        var25_48 = new String(var4_4);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In saveLPARProfile: name = " + var25_48.trim());
                                        }
                                        var26_49 = (int[])var39_33.get(var1_1);
                                        var22_21 = var26_49[0];
                                        Trace.trace("apnvhscF", "oldNameOffset = " + String.valueOf(var22_21));
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In saveLPARProfile: oldNameOffset = " + var22_21);
                                        }
                                        var29_23 = var22_21;
                                        var24_50 = var26_49[1];
                                        if (var24_50 != 1) break block107;
                                        var47_41 = true;
                                        var31_25 = true;
                                        var54_51 = 0;
                                        if (true) ** GOTO lbl96
                                    }
                                    var26_49[1] = var26_49[1] - 1;
                                    break block108;
                                    do {
                                        var34_28[var22_21 + var54_51] = 0;
                                        ++var54_51;
lbl96:
                                        // 2 sources

                                    } while (var54_51 < 32);
                                    var39_33.remove(var1_1);
                                    var40_34.remove(new Integer(var22_21));
                                    var42_36.add(new Integer(var22_21));
                                }
                                if (var39_33.containsKey(var4_4)) {
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveLPARProfile: contained the new name already");
                                    }
                                    Trace.trace("apnvhscF", "profileNameTable already contains the new name - Just increment the reference count");
                                    var26_49 = (int[])var39_33.get(var25_48);
                                    var10_11 = var26_49[0];
                                    Trace.trace("apnvhscD", "nameIndex = " + String.valueOf(var10_11));
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveLPARProfile: nameIndex = " + var10_11);
                                    }
                                    var26_49[1] = var26_49[1] + 1;
                                } else {
                                    Trace.trace("apnvhscF", "profileNameTable doesn't contain the new name - Need to create one in the name table");
                                    var47_41 = true;
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveLPARProfile: the new name is not yet exist. Need to create one");
                                    }
                                    if (var42_36.isEmpty()) {
                                        if (NVRAM.DEBUG_ON == false) throw new HSCCIMException("0001");
                                        System.out.println("No more space for new name");
                                        throw new HSCCIMException("0001");
                                    }
                                    var32_26 = true;
                                    var26_49 = new int[2];
                                    var26_49[0] = (Integer)var42_36.elementAt(0);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveLPARProfile: new name offset = " + var26_49[0]);
                                    }
                                    var42_36.removeElementAt(0);
                                    var26_49[1] = 1;
                                    var30_24 = var10_11 = var26_49[0];
                                    var39_33.put(var25_48, var26_49);
                                    var40_34.put(new Integer(var10_11), var25_48);
                                    var54_52 = this.setLength(var25_48, 32).getBytes();
                                    var55_54 = 0;
                                    while (var55_54 < 32) {
                                        var34_28[var10_11 + var55_54] = var54_52[var55_54];
                                        ++var55_54;
                                    }
                                }
                            }
                            var54_53 = new Object[3];
                            var54_53 = (Object[])var41_35.get(var2_2);
                            var55_55 = (Vector)var54_53[2];
                            Trace.trace("apnvhscF", "cimproperties = " + var55_55);
                            var56_56 = null;
                            var57_57 = null;
                            var58_58 = null;
                            var59_59 = ((CIMProperty)var55_55.elementAt(8)).getValue();
                            var60_60 = ((CIMProperty)var55_55.elementAt(9)).getValue();
                            var61_61 = ((CIMProperty)var55_55.elementAt(10)).getValue();
                            if (var59_59 != null || var60_60 != null || var61_61 != null) {
                                if (var59_59 == null) throw new HSCCIMException("03EF");
                                if (var60_60 == null) throw new HSCCIMException("03EF");
                                if (var61_61 == null) {
                                    throw new HSCCIMException("03EF");
                                }
                                var56_56 = (Vector)var59_59.getValue();
                                Trace.trace("apnvhscF", "oldDrawers = " + var56_56);
                                var57_57 = (Vector)var60_60.getValue();
                                Trace.trace("apnvhscF", "oldSlots = " + var57_57);
                                var58_58 = (Vector)var61_61.getValue();
                                Trace.trace("apnvhscF", "oldRequire = " + var58_58);
                            }
                            var12_13 = var34_28[var46_40 + this.PARTITION_ID_OFFSET];
                            Trace.trace("apnvhscF", "partitionIndex = " + String.valueOf(var12_13));
                            var13_14 = ((UnsignedInt8)((CIMProperty)var3_3.elementAt(2)).getValue().getValue()).shortValue();
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("bootMode = " + var13_14);
                            }
                            var14_15 = ((UnsignedInt8)((CIMProperty)var3_3.elementAt(3)).getValue().getValue()).shortValue();
                            var15_16 = ((UnsignedInt8)((CIMProperty)var3_3.elementAt(4)).getValue().getValue()).shortValue();
                            var16_17 = ((UnsignedInt8)((CIMProperty)var3_3.elementAt(5)).getValue().getValue()).shortValue();
                            var17_18 = ((UnsignedInt32)((CIMProperty)var3_3.elementAt(6)).getValue().getValue()).longValue();
                            var19_19 = ((UnsignedInt32)((CIMProperty)var3_3.elementAt(7)).getValue().getValue()).longValue();
                            var62_62 = null;
                            var63_63 = null;
                            var64_64 = null;
                            var59_59 = ((CIMProperty)var3_3.elementAt(8)).getValue();
                            var60_60 = ((CIMProperty)var3_3.elementAt(9)).getValue();
                            var61_61 = ((CIMProperty)var3_3.elementAt(10)).getValue();
                            if (var59_59 != null || var60_60 != null || var61_61 != null) {
                                if (var59_59 == null) throw new HSCCIMException("03EF");
                                if (var60_60 == null) throw new HSCCIMException("03EF");
                                if (var61_61 == null) {
                                    throw new HSCCIMException("03EF");
                                }
                                var62_62 = (Vector)var59_59.getValue();
                                Trace.trace("apnvhscF", "drawers = " + var62_62);
                                var63_63 = (Vector)var60_60.getValue();
                                Trace.trace("apnvhscF", "slots = " + var63_63);
                                var64_64 = (Vector)var61_61.getValue();
                                Trace.trace("apnvhscF", "require = " + var64_64);
                            }
                            var65_65 = new Hashtable<String, Object[]>();
                            var66_66 = new char[32];
                            var67_67 = new char[32];
                            var68_68 = var35_29;
                            var69_69 = 0;
                            while (var69_69 < 32) {
                                var66_66[var69_69] = 48;
                                var67_67[var69_69] = 48;
                                ++var69_69;
                            }
                            if (var62_62 != null) {
                                if (var62_62.size() != var63_63.size()) throw new HSCCIMException("03EF");
                                if (var62_62.size() != var64_64.size()) {
                                    throw new HSCCIMException("03EF");
                                }
                            }
                            if (var62_62 != null && var62_62.size() != 0) {
                                var23_70 = var62_62.size();
                                Trace.trace("apnvhscF", "numSlots = " + String.valueOf(var23_70));
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In saveLPARProfile: numSlots = " + var23_70);
                                }
                                var70_71 = var44_38;
                                var71_73 = 0;
                                while (var71_73 < var23_70) {
                                    var21_20 = (String)var62_62.get(var71_73);
                                    Trace.trace("apnvhscF", "drawerID = " + var21_20);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveLPARProfile: drawerID = " + var21_20);
                                    }
                                    if (var37_31.containsKey(var21_20)) {
                                        Trace.trace("apnvhscF", "drawerIDTable already contains the drawerID  - no need to update drawerIDTable");
                                        var26_49 = (int[])var37_31.get(var21_20);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In saveLPARProfile: drawerID already exist");
                                            System.out.println("In saveLPARProfile: drawerIndex = " + var26_49[1]);
                                        }
                                        var26_49[2] = var26_49[2] + 1;
                                    } else {
                                        Trace.trace("apnvhscF", "drawerIDTable doesn't contains the drawerID - Need to update the drawerIDTable");
                                        var49_43 = true;
                                        var33_27 = true;
                                        var26_49 = new int[3];
                                        var73_80 = this.NVRAM_SIZE;
                                        if (this._releaseVersion != 0) {
                                            var73_80 = this._bufferedNVRAMSize;
                                        }
                                        if ((long)var44_38 >= var73_80 || (long)(var35_29 + 24 + 2) > var73_80) {
                                            Trace.trace("apnvhscF", "Not enough space in NVRAM - cleanup the NVRAM");
                                            var75_87 = (byte[])this._nvramData.clone();
                                            var76_92 = this._nvramDataSize;
                                            var77_97 = this._numDrawers;
                                            var78_103 = (Hashtable)this._drawerIDTable.clone();
                                            var79_108 = (Hashtable)this._drawerIndexTable.clone();
                                            var80_111 = (Object[])this._profileNameTable.clone();
                                            var81_114 = (Hashtable)this._profileNameOffsetTable.clone();
                                            var82_115 = (Hashtable)this._profileTable.clone();
                                            var83_116 = (Vector)this._pnameFreeList.clone();
                                            var84_117 = (Vector)this._dIDFreeList.clone();
                                            var85_118 = this._drawerOffsetTail;
                                            var86_119 = this._dIDFreeListTail;
                                            this._nvramData = (byte[])var34_28.clone();
                                            this._nvramDataSize = var35_29;
                                            this._numDrawers = var36_30;
                                            this._drawerIDTable = (Hashtable)var37_31.clone();
                                            this._drawerIndexTable = (Hashtable)var38_32.clone();
                                            this._profileNameTable = (Hashtable)var39_33.clone();
                                            this._profileNameOffsetTable = (Hashtable)var40_34.clone();
                                            this._profileTable = (Hashtable)var41_35.clone();
                                            this._pnameFreeList = (Vector)var42_36.clone();
                                            this._dIDFreeList = (Vector)var43_37.clone();
                                            this._drawerOffsetTail = var44_38;
                                            this._dIDFreeListTail = var45_39;
                                            try {
                                                this.cleanUp(null);
                                            }
                                            catch (Throwable var87_120) {
                                                var87_120.printStackTrace();
                                                this._nvramData = (byte[])var75_87.clone();
                                                this._nvramDataSize = var76_92;
                                                this._numDrawers = (short)var77_97;
                                                this._drawerIDTable = (Hashtable)var78_103.clone();
                                                this._drawerIndexTable = (Hashtable)var79_108.clone();
                                                this._profileNameTable = (Hashtable)var80_111.clone();
                                                this._profileNameOffsetTable = (Hashtable)var81_114.clone();
                                                this._profileTable = (Hashtable)var82_115.clone();
                                                this._pnameFreeList = (Vector)var83_116.clone();
                                                this._dIDFreeList = (Vector)var84_117.clone();
                                                this._drawerOffsetTail = var85_118;
                                                throw var87_120;
                                            }
                                            var50_44 = true;
                                            var51_45 = true;
                                            if ((long)this._drawerOffsetTail >= var73_80) throw new HSCCIMException("0001");
                                            if ((long)(this._nvramDataSize + 24 + 2) > var73_80) {
                                                throw new HSCCIMException("0001");
                                            }
                                            var34_28 = (byte[])this._nvramData.clone();
                                            var35_29 = this._nvramDataSize;
                                            var36_30 = this._numDrawers;
                                            var37_31 = (Hashtable)this._drawerIDTable.clone();
                                            var38_32 = (Hashtable)this._drawerIndexTable.clone();
                                            var39_33 = (Hashtable)this._profileNameTable.clone();
                                            var40_34 = (Hashtable)this._profileNameOffsetTable.clone();
                                            var41_35 = (Hashtable)this._profileTable.clone();
                                            var42_36 = (Vector)this._pnameFreeList.clone();
                                            var43_37 = (Vector)this._dIDFreeList.clone();
                                            var44_38 = this._drawerOffsetTail;
                                            var45_39 = this._dIDFreeListTail;
                                            var28_22 = this._drawerOffsetTail;
                                        }
                                        var48_42 = true;
                                        var26_49[0] = var44_38;
                                        if (!var43_37.isEmpty()) {
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In saveLPARProfile: _dIDFreeList = " + var43_37);
                                            }
                                            var27_74 = (Short)var43_37.elementAt(0);
                                            var43_37.removeElementAt(0);
                                            var26_49[1] = var27_74;
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In saveLPARProfile: _dIDFreeList != empty");
                                                System.out.println("In saveLPARProfile: drawerIndex = " + var27_74);
                                            }
                                        } else {
                                            if (var45_39 > 255) {
                                                if (NVRAM.DEBUG_ON == false) throw new HSCCIMException("0002");
                                                System.out.println("no more index for drawer");
                                                throw new HSCCIMException("0002");
                                            }
                                            var26_49[1] = var45_39;
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In saveLPARPrfoile: _dIDFreeListTail <= 255");
                                                System.out.println("In saveLPARProfile: drawerIndex = " + var26_49[1]);
                                            }
                                            var45_39 = (short)(var45_39 + 1);
                                        }
                                        var75_88 = (byte[])var34_28.clone();
                                        var76_91 = this.setLength(var21_20, 24).getBytes();
                                        var77_97 = 0;
                                        while (var77_97 < 24) {
                                            var34_28[var44_38 + var77_97] = var76_91[var77_97];
                                            ++var77_97;
                                        }
                                        var34_28[var44_38 + 24 + 0] = (byte)(var26_49[1] >>> 8);
                                        var34_28[var44_38 + 24 + 1] = (byte)var26_49[1];
                                        var78_102 = var44_38;
                                        while (var78_102 < this.NVRAM_SIZE - 24 - 2) {
                                            var34_28[var78_102 + 24 + 2] = var75_88[var78_102];
                                            ++var78_102;
                                        }
                                        var36_30 = (short)(var36_30 + 1);
                                        var34_28[this.NUM_DRAWERS_OFFSET + 0] = (byte)(var36_30 >>> 8);
                                        var34_28[this.NUM_DRAWERS_OFFSET + 1] = (byte)var36_30;
                                        var79_108 = var41_35.elements();
                                        while (var79_108.hasMoreElements()) {
                                            var80_111 = (Object[])var79_108.nextElement();
                                            var80_111[0] = new Integer((Integer)var80_111[0] + 24 + 2);
                                        }
                                        var50_44 = false;
                                        var44_38 += 26;
                                        var35_29 += 26;
                                        var26_49[2] = 1;
                                        var37_31.put(var21_20, var26_49);
                                        var38_32.put(new Short((short)var26_49[1]), var21_20);
                                    }
                                    var72_75 = var65_65.containsKey(var21_20) != false ? (Object[])var65_65.get(var21_20) : new Object[]{new Short((short)var26_49[1]), new Integer(0), new Integer(0)};
                                    var73_79 = ((UnsignedInt8)var63_63.get(var71_73)).shortValue();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveLPARProfile: slotNum = " + var73_79);
                                    }
                                    if (((String)var64_64.get(var71_73)).equals("R")) {
                                        var67_67[32 - var73_79 - 1] = 49;
                                        var74_85 = new String(var67_67);
                                        var67_67[32 - var73_79 - 1] = 48;
                                        var75_86 = Integer.parseInt((String)var74_85, 2);
                                        var72_75[2] = new Integer((Integer)var72_75[2] | var75_86);
                                    } else {
                                        var66_66[32 - var73_79 - 1] = 49;
                                        var74_85 = new String(var66_66);
                                        var66_66[32 - var73_79 - 1] = 48;
                                        var75_86 = Integer.parseInt((String)var74_85, 2);
                                        var72_75[1] = new Integer((Integer)var72_75[1] | var75_86);
                                    }
                                    var65_65.put(var21_20, var72_75);
                                    ++var71_73;
                                }
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In saveLPARProfile: newDrawerOffsetTail = " + var44_38);
                                }
                            }
                            if (var56_56 == null || var56_56.size() == 0) break block109;
                            var70_71 = 0;
                            while (var70_71 < var56_56.size()) {
                                block111: {
                                    block110: {
                                        var21_20 = (String)var56_56.get(var70_71);
                                        Trace.trace("apnvhscF", "drawerID = " + var21_20);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In saveLPARProfile: old drawerID = " + var21_20);
                                        }
                                        if ((var26_49 = (int[])var37_31.get(var21_20))[2] != 1) break block110;
                                        var48_42 = true;
                                        var71_73 = (short)var26_49[1];
                                        var22_21 = var26_49[0];
                                        var72_77 = 0;
                                        if (true) ** GOTO lbl384
                                    }
                                    var26_49[2] = var26_49[2] - 1;
                                    break block111;
                                    do {
                                        var34_28[var22_21 + var72_77] = 0;
                                        ++var72_77;
lbl384:
                                        // 2 sources

                                    } while (var72_77 < 26);
                                    var37_31.remove(var21_20);
                                    var38_32.remove(new Short((short)var71_73));
                                    if (var45_39 == var71_73 + 1) {
                                        var45_39 = (short)(var45_39 - 1);
                                    } else {
                                        var43_37.addElement(new Short((short)var71_73));
                                    }
                                    var36_30 = (short)(var36_30 - 1);
                                    var34_28[this.NUM_DRAWERS_OFFSET + 0] = (byte)(var36_30 >> 8);
                                    var34_28[this.NUM_DRAWERS_OFFSET + 1] = (byte)var36_30;
                                }
                                ++var70_71;
                            }
                        }
                        var7_7 = (short)(26 + var65_65.size() * 10);
                        var54_53 = new Object[3];
                        var54_53[1] = new Short(var7_7);
                        var54_53[2] = var3_3;
                        var70_72 = (Object[])var41_35.get(var2_2);
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("In saveLPARProfile: new len = " + var7_7);
                        }
                        Trace.trace("apnvhscF", "len = " + String.valueOf(var7_7));
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("In saveLPARProfile: old Len = " + (Short)var70_72[1]);
                        }
                        Trace.trace("apnvhscF", "oldLen = " + var70_72[1]);
                        var71_73 = 0;
                        var72_78 = false;
                        try {
                            block114: {
                                block113: {
                                    block112: {
                                        if (var7_7 != (Short)var70_72[1]) break block112;
                                        Trace.trace("apnvhscF", "old and new profiles have the same length - No need to move the profile");
                                        var54_53[0] = var70_72[0];
                                        var71_73 = (Integer)var54_53[0];
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("profileOffset = " + var71_73);
                                        }
                                        v0 = var72_78 = var33_27 == false;
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("nameIndex = " + var10_11);
                                        }
                                        var41_35.put(var2_2, var54_53);
                                        this._nvramBAOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
                                        this._nvramDOutputStream = new DataOutputStream(this._nvramBAOutputStream);
                                        this._nvramDOutputStream.write(var34_28, 0, (Integer)var54_53[0]);
                                        this._nvramDOutputStream.writeByte((byte)var7_7);
                                        this._nvramDOutputStream.writeByte((byte)var8_9);
                                        this._nvramDOutputStream.writeBytes(NVRAM.cryptedTimestamp(var2_2));
                                        this._nvramDOutputStream.writeByte((byte)var9_10);
                                        this._nvramDOutputStream.writeShort(var10_11);
                                        this._nvramDOutputStream.writeByte(var12_13);
                                        this._nvramDOutputStream.writeByte((byte)var13_14);
                                        this._nvramDOutputStream.writeByte((byte)var14_15);
                                        this._nvramDOutputStream.writeByte((byte)var15_16);
                                        this._nvramDOutputStream.writeByte((byte)var16_17);
                                        this._nvramDOutputStream.writeInt((int)var17_18);
                                        this._nvramDOutputStream.writeInt((int)var19_19);
                                        this._nvramDOutputStream.writeByte((byte)var65_65.size());
                                        if (var65_65.size() == 0) break block113;
                                        var73_81 = var65_65.keys();
                                        if (true) ** GOTO lbl552
                                    }
                                    var73_82 = this.NVRAM_SIZE;
                                    if (this._releaseVersion != 0) {
                                        var73_82 = this._bufferedNVRAMSize;
                                    }
                                    if ((long)(var35_29 + var7_7) > var73_82) {
                                        var75_89 = (byte[])this._nvramData.clone();
                                        var76_94 = this._nvramDataSize;
                                        var77_97 = this._numDrawers;
                                        var78_104 = (Hashtable)this._drawerIDTable.clone();
                                        var79_108 = (Hashtable)this._drawerIndexTable.clone();
                                        var80_111 = (Hashtable)this._profileNameTable.clone();
                                        var81_114 = (Hashtable)this._profileNameOffsetTable.clone();
                                        var82_115 = (Hashtable)this._profileTable.clone();
                                        var83_116 = (Vector)this._pnameFreeList.clone();
                                        var84_117 = (Vector)this._dIDFreeList.clone();
                                        var85_118 = this._drawerOffsetTail;
                                        var86_119 = this._dIDFreeListTail;
                                        this._nvramData = (byte[])var34_28.clone();
                                        this._nvramDataSize = var35_29;
                                        this._numDrawers = var36_30;
                                        this._drawerIDTable = (Hashtable)var37_31.clone();
                                        this._drawerIndexTable = (Hashtable)var38_32.clone();
                                        this._profileNameTable = (Hashtable)var39_33.clone();
                                        this._profileNameOffsetTable = (Hashtable)var40_34.clone();
                                        this._profileTable = (Hashtable)var41_35.clone();
                                        this._pnameFreeList = (Vector)var42_36.clone();
                                        this._dIDFreeList = (Vector)var43_37.clone();
                                        this._drawerOffsetTail = var44_38;
                                        this._dIDFreeListTail = var45_39;
                                        try {
                                            this.cleanUp(null);
                                        }
                                        catch (Throwable var87_121) {
                                            var87_121.printStackTrace();
                                            this._nvramData = (byte[])var75_89.clone();
                                            this._nvramDataSize = var76_94;
                                            this._numDrawers = (short)var77_97;
                                            this._drawerIDTable = (Hashtable)var78_104.clone();
                                            this._drawerIndexTable = (Hashtable)var79_108.clone();
                                            this._profileNameTable = (Hashtable)var80_111.clone();
                                            this._profileNameOffsetTable = (Hashtable)var81_114.clone();
                                            this._profileTable = (Hashtable)var82_115.clone();
                                            this._pnameFreeList = (Vector)var83_116.clone();
                                            this._dIDFreeList = (Vector)var84_117.clone();
                                            this._drawerOffsetTail = var85_118;
                                            throw var87_121;
                                        }
                                        var50_44 = true;
                                        if ((long)(this._nvramDataSize + var7_7) > var73_82) {
                                            throw new HSCCIMException("0003");
                                        }
                                        var34_28 = (byte[])this._nvramData.clone();
                                        var35_29 = this._nvramDataSize;
                                        var36_30 = this._numDrawers;
                                        var37_31 = (Hashtable)this._drawerIDTable.clone();
                                        var38_32 = (Hashtable)this._drawerIndexTable.clone();
                                        var39_33 = (Hashtable)this._profileNameTable.clone();
                                        var40_34 = (Hashtable)this._profileNameOffsetTable.clone();
                                        var41_35 = (Hashtable)this._profileTable.clone();
                                        var42_36 = (Vector)this._pnameFreeList.clone();
                                        var43_37 = (Vector)this._dIDFreeList.clone();
                                        if (var44_38 != this._drawerOffsetTail) {
                                            var48_42 = true;
                                        }
                                        var44_38 = this._drawerOffsetTail;
                                        var45_39 = this._dIDFreeListTail;
                                        var28_22 = this._drawerOffsetTail;
                                    }
                                    var46_40 = var75_86 = ((Integer)var70_72[0]).intValue();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveLPARProfile: oldOffset = " + var75_86);
                                    }
                                    var34_28[var75_86 + this.TEMPLATE_VERSION_OFFSET] = -1;
                                    var54_53 = new Object[]{new Integer(var35_29), new Short(var7_7), var3_3};
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveLPARProfile: newNvramDataSize = " + var35_29);
                                    }
                                    var71_73 = (Integer)var54_53[0];
                                    var41_35.put(var2_2, var54_53);
                                    this._nvramBAOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
                                    this._nvramDOutputStream = new DataOutputStream(this._nvramBAOutputStream);
                                    this._nvramDOutputStream.write(var34_28, 0, var35_29);
                                    this._nvramDOutputStream.writeByte((byte)var7_7);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveLPARProfile: len = " + var7_7);
                                    }
                                    this._nvramDOutputStream.writeByte((byte)var8_9);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveLPARProfile: templateVersion = " + var8_9);
                                    }
                                    this._nvramDOutputStream.writeBytes(NVRAM.cryptedTimestamp(var2_2));
                                    this._nvramDOutputStream.writeByte((byte)var9_10);
                                    this._nvramDOutputStream.writeShort(var10_11);
                                    this._nvramDOutputStream.writeByte(var12_13);
                                    this._nvramDOutputStream.writeByte((byte)var13_14);
                                    this._nvramDOutputStream.writeByte((byte)var14_15);
                                    this._nvramDOutputStream.writeByte((byte)var15_16);
                                    this._nvramDOutputStream.writeByte((byte)var16_17);
                                    this._nvramDOutputStream.writeInt((int)var17_18);
                                    this._nvramDOutputStream.writeInt((int)var19_19);
                                    this._nvramDOutputStream.writeByte((byte)var65_65.size());
                                    var76_95 = var65_65.keys();
                                    if (true) ** GOTO lbl569
                                    do {
                                        var74_85 = (String)var73_81.nextElement();
                                        var75_86 = ((Short)((Object[])var65_65.get(var74_85))[0]).shortValue();
                                        var76_93 = (Integer)((Object[])var65_65.get(var74_85))[1];
                                        var77_97 = (Integer)((Object[])var65_65.get(var74_85))[2];
                                        this._nvramDOutputStream.writeShort(var75_86);
                                        this._nvramDOutputStream.writeInt(var76_93);
                                        this._nvramDOutputStream.writeInt(var77_97);
                                        if (!NVRAM.DEBUG_ON) continue;
                                        System.out.println("In saveLPARProfile: drawerIndex = " + var75_86);
                                        System.out.println("In saveLPARProfile: ioSlots = " + var76_93);
                                        System.out.println("In saveLPARProfile: require = " + var77_97);
lbl552:
                                        // 3 sources

                                    } while (var73_81.hasMoreElements());
                                }
                                var22_21 = (Integer)var54_53[0];
                                this._nvramDOutputStream.write(var34_28, var22_21 + var7_7, this.NVRAM_SIZE - (var22_21 + var7_7));
                                break block114;
                                do {
                                    var77_99 = (String)var76_95.nextElement();
                                    var78_105 = (Short)((Object[])var65_65.get(var77_99))[0];
                                    var79_110 = (Integer)((Object[])var65_65.get(var77_99))[1];
                                    var80_113 = (Integer)((Object[])var65_65.get(var77_99))[2];
                                    this._nvramDOutputStream.writeShort(var78_105);
                                    this._nvramDOutputStream.writeInt(var79_110);
                                    this._nvramDOutputStream.writeInt(var80_113);
                                    if (!NVRAM.DEBUG_ON) continue;
                                    System.out.println("In saveLPARProfile: drawerIndex = " + var78_105);
                                    System.out.println("In saveLPARProfile: ioSlots = " + var79_110);
                                    System.out.println("In saveLPARProfile: require = " + var80_113);
lbl569:
                                    // 3 sources

                                } while (var76_95.hasMoreElements());
                                this._nvramDOutputStream.write(var34_28, var35_29 += var7_7, this.NVRAM_SIZE - var35_29);
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In saveLPARProfile: new nvraDataSize = " + var35_29);
                                }
                            }
                            this._nvramDOutputStream.flush();
                            this._nvramData = this._nvramBAOutputStream.toByteArray();
                            this._nvramDOutputStream.close();
                        }
                        catch (Throwable var73_83) {
                            var73_83.printStackTrace();
                            HSCLogUtils.serverLog(var73_83, HSCLogUtils._NVRAMClassLogInfo);
                            throw new HSCCIMException("0007");
                        }
                        this._nvramDataSize = var35_29;
                        this._numDrawers = var36_30;
                        this._drawerIDTable = (Hashtable)var37_31.clone();
                        this._drawerIndexTable = (Hashtable)var38_32.clone();
                        this._profileNameTable = (Hashtable)var39_33.clone();
                        this._profileNameOffsetTable = (Hashtable)var40_34.clone();
                        this._profileTable = (Hashtable)var41_35.clone();
                        this._pnameFreeList = (Vector)var42_36.clone();
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("In saveLPARProfile: newDIDFreeList = " + var43_37);
                        }
                        this._dIDFreeList = (Vector)var43_37.clone();
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("In saveLPARProfile: _dIDFreeList = " + this._dIDFreeList);
                        }
                        this._drawerOffsetTail = var44_38;
                        this._dIDFreeListTail = var45_39;
                        if (var2_2.equals(this._defaultList[var12_13]) && this._fastActivation[var12_13 - 1]) {
                            this._fastActivation[var12_13 - 1] = false;
                            this._nvramData[this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (var12_13 - 1) + 31] = 0;
                            var52_46 = true;
                        }
                        if (!var6_6) break block115;
                        var73_84 = null;
                        var74_85 = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", var73_84, var5_5, this._cspVersion);
                        var75_90 = this.getTime((Hashtable)var74_85);
                        var76_96 = 0;
                        if (true) ** GOTO lbl628
                    }
                    finally {
                        if (!NVRAM.DEBUG_ON) break block104;
                        System.out.println("End of saveLPARProfile");
                        System.out.println("***********************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                var90_122 = null;
                Trace.trace("apnvhscT", "-> saveLPARProfile");
                return;
                do {
                    this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + var76_96] = var75_90[var76_96];
                    if (var52_46) {
                        this._nvramData[this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET + var76_96] = var75_90[var76_96];
                    }
                    if (var47_41) {
                        this._nvramData[this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + var76_96] = var75_90[var76_96];
                    }
                    this._nvramData[this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + var76_96] = var75_90[var76_96];
                    ++var76_96;
lbl628:
                    // 2 sources

                } while (var76_96 < 7);
                this._checksumCalc.reset();
                this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                this._checksum = this._checksumCalc.getValue();
                this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                this._nvramTimeStamp = (byte[])var75_90.clone();
                if (var52_46) {
                    this._partitionNameTableTimeStamp = (byte[])var75_90.clone();
                    this._checksumCalc.reset();
                    this._checksumCalc.update(this._nvramData, this.PARTITION_NAME_TABLE_OFFSET, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET - this.PARTITION_NAME_TABLE_OFFSET);
                    this._checksum = this._checksumCalc.getValue();
                    this.writeIntegralToNvramData(this._checksum, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                }
                if (var47_41) {
                    this._profileNameTableTimeStamp = (byte[])var75_90.clone();
                    this._checksumCalc.reset();
                    this._checksumCalc.update(this._nvramData, this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
                    this._checksum = this._checksumCalc.getValue();
                    this.writeIntegralToNvramData(this._checksum, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                }
                this._checksumCalc.reset();
                this._checksumCalc.update(this._nvramData, this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET);
                this._checksum = this._checksumCalc.getValue();
                this.writeIntegralToNvramData(this._checksum, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, (short)8);
                if (this._releaseVersion != 0) {
                    var77_100 = this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET;
                    this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = (byte)(var77_100 >>> 8);
                    this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = (byte)(var77_100 & 255);
                }
                this._drawerProfileInfoTimeStamp = (byte[])var75_90.clone();
                this._backupToLocalFile();
                var77_101 = (byte)(this._releaseVersion << 1 | NVRAM.CORRUPTED_ON[0]);
                this._writeDataToCSP(new byte[]{var77_101}, this.CORRUPTED_BYTE_OFFSET, 1, var5_5);
                this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, var5_5);
                if (var52_46) {
                    this._writeDataToCSP(new String(this._nvramData, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8, var5_5);
                    this._writeDataToCSP(new String(this._nvramData, this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (var12_13 - 1) + 31, 1).getBytes(), this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (var12_13 - 1) + 31, 1, var5_5);
                }
                if (var47_41) {
                    this._writeDataToCSP(new String(this._nvramData, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8, var5_5);
                    if (var31_25) {
                        this._writeDataToCSP(this._zeroOutNameString.getBytes(), var29_23, 32, var5_5);
                    }
                    if (var32_26) {
                        this._writeDataToCSP(this.setLength(var25_48, 32).getBytes(), var30_24, 32, var5_5);
                    }
                }
                if (this._releaseVersion == 0) {
                    this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8, var5_5);
                } else {
                    this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10, var5_5);
                }
                if (var48_42) {
                    if (NVRAM.DEBUG_ON) {
                        System.out.println("in change drawer");
                    }
                    this._writeDataToCSP(new String(this._nvramData, this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET).getBytes(), this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET, var5_5);
                }
                if (var72_78) {
                    if (NVRAM.DEBUG_ON) {
                        System.out.println("In sameOffset");
                    }
                    this._writeDataToCSP(new String(this._nvramData, var71_73, (int)var7_7).getBytes(), var71_73, var7_7, var5_5);
                } else if (!(var33_27 || var50_44 || var51_45)) {
                    if (NVRAM.DEBUG_ON) {
                        System.out.println("in !adding");
                    }
                    var78_106 = new byte[]{-1};
                    this._writeDataToCSP(var78_106, var46_40 + this.TEMPLATE_VERSION_OFFSET, 1, var5_5);
                    this._writeDataToCSP(new String(this._nvramData, var71_73, (int)var7_7).getBytes(), var71_73, var7_7, var5_5);
                } else {
                    if (NVRAM.DEBUG_ON) {
                        System.out.println("in else");
                    }
                    var78_107 = 0;
                    var78_107 = var50_44 != false || var51_45 != false ? this.NVRAM_SIZE - this._drawerOffsetTail : this._nvramDataSize - this._drawerOffsetTail;
                    this._writeDataToCSP(new String(this._nvramData, this._drawerOffsetTail, var78_107).getBytes(), this._drawerOffsetTail, var78_107, var5_5);
                }
                var77_101 = (byte)(this._releaseVersion << 1 | NVRAM.CORRUPTED_OFF[0]);
                this._writeDataToCSP(new byte[]{var77_101}, this.CORRUPTED_BYTE_OFFSET, 1, var5_5);
            }
            catch (Throwable var7_8) {
                var7_8.printStackTrace();
                HSCLogUtils.serverLog(var7_8, HSCLogUtils._NVRAMClassLogInfo);
                if (var7_8 instanceof HSCCIMException != false) throw new HSCCIMException(var7_8);
                throw new HSCCIMException("0015");
            }
        }
        catch (Throwable var89_125) {
            var90_123 = null;
            Trace.trace("apnvhscT", "-> saveLPARProfile");
            throw var89_125;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _saveDLPARProfile(String var1_1, String var2_2, Vector var3_3, String var4_4, HscProviderSocket var5_5, boolean var6_6) throws CIMException {
        try {
            try {
                block135: {
                    block146: {
                        block140: {
                            block137: {
                                block139: {
                                    block138: {
                                        block136: {
                                            Trace.trace("apnvhscT", "-> saveDLPARProfile");
                                            Trace.trace("apnvhscF", "oldName = " + var1_1);
                                            Trace.trace("apnvhscF", "profileTimeStamp = " + var2_2);
                                            Trace.trace("apnvhscF", "properties = " + var3_3);
                                            Trace.trace("apnvhscF", "newName = " + var4_4);
                                            Trace.trace("apnvhscF", "socket = " + var5_5);
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("************************************");
                                                System.out.println("In saveLPARProfile");
                                            }
                                            if (var6_6) {
                                                this.buildNVRAM(var5_5, false, null, true, false);
                                            }
                                            var7_7 = 0;
                                            var8_9 = 0;
                                            var9_10 = false;
                                            var10_11 = 0;
                                            var11_12 = false;
                                            var12_13 = 0;
                                            var13_14 = 0;
                                            var14_15 = 0;
                                            var15_16 = 0;
                                            var16_17 = 1;
                                            var17_18 = 0;
                                            var18_19 = 0;
                                            var19_20 = 0;
                                            var20_21 = 0L;
                                            var22_22 = 0L;
                                            var24_23 = 0L;
                                            var26_24 = new String();
                                            var27_25 = 0;
                                            var8_9 = this._hscTemplateVersion;
                                            var9_10 = false;
                                            var33_26 = this._drawerOffsetTail;
                                            var34_27 = 0;
                                            var35_28 = 0;
                                            var36_29 = false;
                                            var37_30 = false;
                                            var38_31 = false;
                                            var39_32 = 0;
                                            var40_33 = null;
                                            var41_34 = null;
                                            var42_35 = 0;
                                            var43_36 = 0;
                                            var44_37 = 0;
                                            var45_38 = 0;
                                            var46_39 = 0;
                                            if (this._releaseVersion < 3) {
                                                var44_37 = this.DLPAR_PARTITION_ID_OFFSET;
                                                var45_38 = 33;
                                                var46_39 = this.DLPAR_TEMPLATE_VERSION_OFFSET;
                                            } else {
                                                var44_37 = this.DLPAR_PARTITION_ID_OFFSET_R4;
                                                var45_38 = 36;
                                                var46_39 = this.DLPAR_TEMPLATE_VERSION_OFFSET_R4;
                                            }
                                            var47_40 = (byte[])this._nvramData.clone();
                                            var48_41 = this._nvramDataSize;
                                            var49_42 = this._numDrawers;
                                            var50_43 = (Hashtable)this._drawerIDTable.clone();
                                            var51_44 = (Hashtable)this._drawerIndexTable.clone();
                                            var52_45 = (Hashtable)this._profileNameTable.clone();
                                            var53_46 = (Hashtable)this._profileNameOffsetTable.clone();
                                            var54_47 = (Hashtable)this._profileTable.clone();
                                            var55_48 = (Vector)this._pnameFreeList.clone();
                                            var56_49 = (Vector)this._dIDFreeList.clone();
                                            var57_50 = this._drawerOffsetTail;
                                            var58_51 = this._dIDFreeListTail;
                                            var59_52 = (Integer)((Object[])this._profileTable.get(var2_2))[0];
                                            var60_53 = false;
                                            var61_54 = false;
                                            var62_55 = true;
                                            var63_56 = false;
                                            var64_57 = false;
                                            var65_58 = false;
                                            var66_59 = var1_1.length();
                                            if (var4_4 != null) break block136;
                                            Trace.trace("apnvhscF", "No new name - No need to change the profile name table");
                                            var30_60 = new String(var1_1);
                                            var10_11 = ((int[])this._profileNameTable.get(var30_60))[0];
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In saveLPARProfile: name = " + var30_60.trim());
                                                System.out.println("In saveLPARProfile: nameIndex = " + var10_11);
                                            }
                                            break block137;
                                        }
                                        Trace.trace("apnvhscF", "Has new name - May need to change the name table");
                                        var12_13 = var47_40[var59_52 + var44_37];
                                        Trace.trace("apnvhscF", "partitionIndex = " + String.valueOf(var12_13));
                                        if (this.isDuplicatedAtPartition(var12_13, var4_4, var5_5)) {
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In saveLPARProfile: name already exist");
                                            }
                                            Trace.trace("apnvhscF", "name already exist in same partition - throw CIMException");
                                            throw new HSCCIMException("0004", new String[]{var4_4, String.valueOf(var12_13)});
                                        }
                                        var66_59 = var4_4.length();
                                        var30_60 = new String(var4_4);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In saveLPARProfile: name = " + var30_60.trim());
                                        }
                                        var31_61 = (int[])var52_45.get(var1_1);
                                        var27_25 = var31_61[0];
                                        Trace.trace("apnvhscF", "oldNameOffset = " + String.valueOf(var27_25));
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In saveLPARProfile: oldNameOffset = " + var27_25);
                                        }
                                        var34_27 = var27_25;
                                        var29_62 = var31_61[1];
                                        if (var29_62 != 1) break block138;
                                        var60_53 = true;
                                        var36_29 = true;
                                        var67_63 = 0;
                                        if (true) ** GOTO lbl116
                                    }
                                    var31_61[1] = var31_61[1] - 1;
                                    break block139;
                                    do {
                                        var47_40[var27_25 + var67_63] = 0;
                                        ++var67_63;
lbl116:
                                        // 2 sources

                                    } while (var67_63 < 32);
                                    var52_45.remove(var1_1);
                                    var53_46.remove(new Integer(var27_25));
                                    var55_48.add(new Integer(var27_25));
                                }
                                if (var52_45.containsKey(var4_4)) {
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveLPARProfile: contained the new name already");
                                    }
                                    Trace.trace("apnvhscF", "profileNameTable already contains the new name - Just increment the reference count");
                                    var31_61 = (int[])var52_45.get(var30_60);
                                    var10_11 = var31_61[0];
                                    Trace.trace("apnvhscD", "nameIndex = " + String.valueOf(var10_11));
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveLPARProfile: nameIndex = " + var10_11);
                                    }
                                    var31_61[1] = var31_61[1] + 1;
                                } else {
                                    Trace.trace("apnvhscF", "profileNameTable doesn't contain the new name - Need to create one in the name table");
                                    var60_53 = true;
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveLPARProfile: the new name is not yet exist. Need to create one");
                                    }
                                    if (var55_48.isEmpty()) {
                                        if (NVRAM.DEBUG_ON == false) throw new HSCCIMException("0001");
                                        System.out.println("No more space for new name");
                                        throw new HSCCIMException("0001");
                                    }
                                    var37_30 = true;
                                    var31_61 = new int[2];
                                    var31_61[0] = (Integer)var55_48.elementAt(0);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveLPARProfile: new name offset = " + var31_61[0]);
                                    }
                                    var55_48.removeElementAt(0);
                                    var31_61[1] = 1;
                                    var35_28 = var10_11 = var31_61[0];
                                    var52_45.put(var30_60, var31_61);
                                    var53_46.put(new Integer(var10_11), var30_60);
                                    var67_64 = this.setLength(var30_60, 32).getBytes();
                                    var68_66 = 0;
                                    while (var68_66 < 32) {
                                        var47_40[var10_11 + var68_66] = var67_64[var68_66];
                                        ++var68_66;
                                    }
                                }
                            }
                            var67_65 = new Object[3];
                            var67_65 = (Object[])var54_47.get(var2_2);
                            var68_67 = (Vector)var67_65[2];
                            Trace.trace("apnvhscF", "cimproperties = " + var68_67);
                            var69_68 = null;
                            var70_69 = null;
                            var71_70 = null;
                            var72_71 = ((CIMProperty)var68_67.elementAt(12)).getValue();
                            var73_72 = ((CIMProperty)var68_67.elementAt(13)).getValue();
                            var74_73 = ((CIMProperty)var68_67.elementAt(14)).getValue();
                            if (var72_71 != null || var73_72 != null || var74_73 != null) {
                                if (var72_71 == null) throw new HSCCIMException("03EF");
                                if (var73_72 == null) throw new HSCCIMException("03EF");
                                if (var74_73 == null) {
                                    throw new HSCCIMException("03EF");
                                }
                                var69_68 = (Vector)var72_71.getValue();
                                Trace.trace("apnvhscF", "oldDrawers = " + var69_68);
                                var70_69 = (Vector)var73_72.getValue();
                                Trace.trace("apnvhscF", "oldSlots = " + var70_69);
                                var71_70 = (Vector)var74_73.getValue();
                                Trace.trace("apnvhscF", "oldRequire = " + var71_70);
                            }
                            var12_13 = var47_40[var59_52 + var44_37];
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("partition index = " + var12_13);
                            }
                            Trace.trace("apnvhscF", "partitionIndex = " + String.valueOf(var12_13));
                            var13_14 = ((UnsignedInt8)((CIMProperty)var3_3.elementAt(2)).getValue().getValue()).shortValue();
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("bootMode = " + var13_14);
                            }
                            var14_15 = ((UnsignedInt8)((CIMProperty)var3_3.elementAt(3)).getValue().getValue()).shortValue();
                            var15_16 = ((UnsignedInt8)((CIMProperty)var3_3.elementAt(4)).getValue().getValue()).shortValue();
                            var16_17 = ((UnsignedInt8)((CIMProperty)var3_3.elementAt(5)).getValue().getValue()).shortValue();
                            var17_18 = ((UnsignedInt8)((CIMProperty)var3_3.elementAt(6)).getValue().getValue()).shortValue();
                            var18_19 = ((UnsignedInt8)((CIMProperty)var3_3.elementAt(7)).getValue().getValue()).shortValue();
                            var19_20 = ((UnsignedInt8)((CIMProperty)var3_3.elementAt(8)).getValue().getValue()).shortValue();
                            var20_21 = ((UnsignedInt32)((CIMProperty)var3_3.elementAt(9)).getValue().getValue()).longValue();
                            var22_22 = ((UnsignedInt32)((CIMProperty)var3_3.elementAt(10)).getValue().getValue()).longValue();
                            var24_23 = ((UnsignedInt32)((CIMProperty)var3_3.elementAt(11)).getValue().getValue()).longValue();
                            if (this._releaseVersion > 2) {
                                if (((CIMProperty)var3_3.elementAt(15)).getValue() != null) {
                                    var39_32 = ((UnsignedInt8)((CIMProperty)var3_3.elementAt(15)).getValue().getValue()).shortValue();
                                    var40_33 = (Vector)((CIMProperty)var3_3.elementAt(16)).getValue().getValue();
                                    var41_34 = (Vector)((CIMProperty)var3_3.elementAt(17)).getValue().getValue();
                                }
                                var42_35 = var40_33 == null ? 0 : (int)var40_33.size();
                                var43_36 = var42_35 == 0 ? 1 : (short)(2 + var42_35 * 4 * 1 + var42_35 * 2 * 1);
                            }
                            var75_74 = null;
                            var76_75 = null;
                            var77_76 = null;
                            var72_71 = ((CIMProperty)var3_3.elementAt(12)).getValue();
                            var73_72 = ((CIMProperty)var3_3.elementAt(13)).getValue();
                            var74_73 = ((CIMProperty)var3_3.elementAt(14)).getValue();
                            if (var72_71 != null || var73_72 != null || var74_73 != null) {
                                if (var72_71 == null) throw new HSCCIMException("03EF");
                                if (var73_72 == null) throw new HSCCIMException("03EF");
                                if (var74_73 == null) {
                                    throw new HSCCIMException("03EF");
                                }
                                var75_74 = (Vector)var72_71.getValue();
                                Trace.trace("apnvhscF", "drawers = " + var75_74);
                                var76_75 = (Vector)var73_72.getValue();
                                Trace.trace("apnvhscF", "slots = " + var76_75);
                                var77_76 = (Vector)var74_73.getValue();
                                Trace.trace("apnvhscF", "require = " + var77_76);
                            }
                            var78_77 = new Hashtable<String, Object[]>();
                            var79_78 = new char[32];
                            var80_79 = new char[32];
                            var81_80 = var48_41;
                            var82_81 = 0;
                            while (var82_81 < 32) {
                                var79_78[var82_81] = 48;
                                var80_79[var82_81] = 48;
                                ++var82_81;
                            }
                            if (var75_74 != null) {
                                if (var75_74.size() != var76_75.size()) throw new HSCCIMException("03EF");
                                if (var75_74.size() != var77_76.size()) {
                                    throw new HSCCIMException("03EF");
                                }
                            }
                            if (var75_74 != null && var75_74.size() != 0) {
                                var28_82 = var75_74.size();
                                Trace.trace("apnvhscF", "numSlots = " + String.valueOf(var28_82));
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In saveLPARProfile: numSlots = " + var28_82);
                                }
                                var83_83 = var57_50;
                                var84_85 = 0;
                                while (var84_85 < var28_82) {
                                    var26_24 = (String)var75_74.get(var84_85);
                                    Trace.trace("apnvhscF", "drawerID = " + var26_24);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveLPARProfile: drawerID = " + var26_24);
                                    }
                                    if (var50_43.containsKey(var26_24)) {
                                        Trace.trace("apnvhscF", "drawerIDTable already contains the drawerID  - no need to update drawerIDTable");
                                        var31_61 = (int[])var50_43.get(var26_24);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In saveLPARProfile: drawerID already exist");
                                            System.out.println("In saveLPARProfile: drawerIndex = " + var31_61[1]);
                                        }
                                        var31_61[2] = var31_61[2] + 1;
                                    } else {
                                        Trace.trace("apnvhscF", "drawerIDTable doesn't contains the drawerID - Need to update the drawerIDTable");
                                        var62_55 = true;
                                        var38_31 = true;
                                        var31_61 = new int[3];
                                        var86_92 = this.NVRAM_SIZE;
                                        if (this._releaseVersion != 0) {
                                            var86_92 = this._bufferedNVRAMSize;
                                        }
                                        if ((long)var57_50 >= var86_92 || (long)(var48_41 + 24 + 2) > var86_92) {
                                            Trace.trace("apnvhscF", "Not enough space in NVRAM - cleanup the NVRAM");
                                            var88_104 = (byte[])this._nvramData.clone();
                                            var89_109 = this._nvramDataSize;
                                            var90_114 = this._numDrawers;
                                            var91_121 = (Hashtable)this._drawerIDTable.clone();
                                            var92_128 = (Hashtable)this._drawerIndexTable.clone();
                                            var93_132 = (Object[])this._profileNameTable.clone();
                                            var94_135 = (Hashtable)this._profileNameOffsetTable.clone();
                                            var95_136 = (Hashtable)this._profileTable.clone();
                                            var96_137 = (Vector)this._pnameFreeList.clone();
                                            var97_138 = (Vector)this._dIDFreeList.clone();
                                            var98_139 = this._drawerOffsetTail;
                                            var99_140 = this._dIDFreeListTail;
                                            this._nvramData = (byte[])var47_40.clone();
                                            this._nvramDataSize = var48_41;
                                            this._numDrawers = var49_42;
                                            this._drawerIDTable = (Hashtable)var50_43.clone();
                                            this._drawerIndexTable = (Hashtable)var51_44.clone();
                                            this._profileNameTable = (Hashtable)var52_45.clone();
                                            this._profileNameOffsetTable = (Hashtable)var53_46.clone();
                                            this._profileTable = (Hashtable)var54_47.clone();
                                            this._pnameFreeList = (Vector)var55_48.clone();
                                            this._dIDFreeList = (Vector)var56_49.clone();
                                            this._drawerOffsetTail = var57_50;
                                            this._dIDFreeListTail = var58_51;
                                            try {
                                                this.cleanUp(null);
                                            }
                                            catch (Throwable var100_141) {
                                                var100_141.printStackTrace();
                                                this._nvramData = (byte[])var88_104.clone();
                                                this._nvramDataSize = var89_109;
                                                this._numDrawers = (short)var90_114;
                                                this._drawerIDTable = (Hashtable)var91_121.clone();
                                                this._drawerIndexTable = (Hashtable)var92_128.clone();
                                                this._profileNameTable = (Hashtable)var93_132.clone();
                                                this._profileNameOffsetTable = (Hashtable)var94_135.clone();
                                                this._profileTable = (Hashtable)var95_136.clone();
                                                this._pnameFreeList = (Vector)var96_137.clone();
                                                this._dIDFreeList = (Vector)var97_138.clone();
                                                this._drawerOffsetTail = var98_139;
                                                throw var100_141;
                                            }
                                            var63_56 = true;
                                            var64_57 = true;
                                            if ((long)this._drawerOffsetTail >= var86_92) throw new HSCCIMException("0001");
                                            if ((long)(this._nvramDataSize + 24 + 2) > var86_92) {
                                                throw new HSCCIMException("0001");
                                            }
                                            var47_40 = (byte[])this._nvramData.clone();
                                            var48_41 = this._nvramDataSize;
                                            var49_42 = this._numDrawers;
                                            var50_43 = (Hashtable)this._drawerIDTable.clone();
                                            var51_44 = (Hashtable)this._drawerIndexTable.clone();
                                            var52_45 = (Hashtable)this._profileNameTable.clone();
                                            var53_46 = (Hashtable)this._profileNameOffsetTable.clone();
                                            var54_47 = (Hashtable)this._profileTable.clone();
                                            var55_48 = (Vector)this._pnameFreeList.clone();
                                            var56_49 = (Vector)this._dIDFreeList.clone();
                                            var57_50 = this._drawerOffsetTail;
                                            var58_51 = this._dIDFreeListTail;
                                            var33_26 = this._drawerOffsetTail;
                                        }
                                        var61_54 = true;
                                        var31_61[0] = var57_50;
                                        if (!var56_49.isEmpty()) {
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In saveLPARProfile: _dIDFreeList = " + var56_49);
                                            }
                                            var32_86 = (Short)var56_49.elementAt(0);
                                            var56_49.removeElementAt(0);
                                            var31_61[1] = var32_86;
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In saveLPARProfile: _dIDFreeList != empty");
                                                System.out.println("In saveLPARProfile: drawerIndex = " + var32_86);
                                            }
                                        } else {
                                            if (var58_51 > 255) {
                                                if (NVRAM.DEBUG_ON == false) throw new HSCCIMException("0002");
                                                System.out.println("no more index for drawer");
                                                throw new HSCCIMException("0002");
                                            }
                                            var31_61[1] = var58_51;
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In saveLPARPrfoile: _dIDFreeListTail <= 255");
                                                System.out.println("In saveLPARProfile: drawerIndex = " + var31_61[1]);
                                            }
                                            var58_51 = (short)(var58_51 + 1);
                                        }
                                        var88_105 = (byte[])var47_40.clone();
                                        var89_108 = this.setLength(var26_24, 24).getBytes();
                                        var90_114 = 0;
                                        while (var90_114 < 24) {
                                            var47_40[var57_50 + var90_114] = var89_108[var90_114];
                                            ++var90_114;
                                        }
                                        var47_40[var57_50 + 24 + 0] = (byte)(var31_61[1] >>> 8);
                                        var47_40[var57_50 + 24 + 1] = (byte)var31_61[1];
                                        var91_120 = var57_50;
                                        while (var91_120 < this.NVRAM_SIZE - 24 - 2) {
                                            var47_40[var91_120 + 24 + 2] = var88_105[var91_120];
                                            ++var91_120;
                                        }
                                        var49_42 = (short)(var49_42 + 1);
                                        var47_40[this.NUM_DRAWERS_OFFSET + 0] = (byte)(var49_42 >>> 8);
                                        var47_40[this.NUM_DRAWERS_OFFSET + 1] = (byte)var49_42;
                                        var92_128 = var54_47.elements();
                                        while (var92_128.hasMoreElements()) {
                                            var93_132 = (Object[])var92_128.nextElement();
                                            var93_132[0] = new Integer((Integer)var93_132[0] + 24 + 2);
                                        }
                                        var63_56 = false;
                                        var57_50 += 26;
                                        var48_41 += 26;
                                        var31_61[2] = 1;
                                        var50_43.put(var26_24, var31_61);
                                        var51_44.put(new Short((short)var31_61[1]), var26_24);
                                    }
                                    var85_87 = var78_77.containsKey(var26_24) != false ? (Object[])var78_77.get(var26_24) : new Object[]{new Short((short)var31_61[1]), new Integer(0), new Integer(0)};
                                    var86_91 = ((UnsignedInt8)var76_75.get(var84_85)).shortValue();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveLPARProfile: slotNum = " + var86_91);
                                    }
                                    if (((String)var77_76.get(var84_85)).equals("R")) {
                                        var80_79[32 - var86_91 - 1] = 49;
                                        var87_98 = new String(var80_79);
                                        var80_79[32 - var86_91 - 1] = 48;
                                        var88_103 = Integer.parseInt(var87_98, 2);
                                        var85_87[2] = new Integer((Integer)var85_87[2] | var88_103);
                                    } else {
                                        var79_78[32 - var86_91 - 1] = 49;
                                        var87_98 = new String(var79_78);
                                        var79_78[32 - var86_91 - 1] = 48;
                                        var88_103 = Integer.parseInt(var87_98, 2);
                                        var85_87[1] = new Integer((Integer)var85_87[1] | var88_103);
                                    }
                                    var78_77.put(var26_24, var85_87);
                                    ++var84_85;
                                }
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In saveLPARProfile: newDrawerOffsetTail = " + var57_50);
                                }
                            }
                            if (var69_68 == null || var69_68.size() == 0) break block140;
                            var83_83 = 0;
                            while (var83_83 < var69_68.size()) {
                                block142: {
                                    block141: {
                                        var26_24 = (String)var69_68.get(var83_83);
                                        Trace.trace("apnvhscF", "drawerID = " + var26_24);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In saveLPARProfile: old drawerID = " + var26_24);
                                        }
                                        if ((var31_61 = (int[])var50_43.get(var26_24))[2] != 1) break block141;
                                        var61_54 = true;
                                        var84_85 = (short)var31_61[1];
                                        var27_25 = var31_61[0];
                                        var85_89 = 0;
                                        if (true) ** GOTO lbl417
                                    }
                                    var31_61[2] = var31_61[2] - 1;
                                    break block142;
                                    do {
                                        var47_40[var27_25 + var85_89] = 0;
                                        ++var85_89;
lbl417:
                                        // 2 sources

                                    } while (var85_89 < 26);
                                    var50_43.remove(var26_24);
                                    var51_44.remove(new Short((short)var84_85));
                                    if (var58_51 == var84_85 + 1) {
                                        var58_51 = (short)(var58_51 - 1);
                                    } else {
                                        var56_49.addElement(new Short((short)var84_85));
                                    }
                                    var49_42 = (short)(var49_42 - 1);
                                    var47_40[this.NUM_DRAWERS_OFFSET + 0] = (byte)(var49_42 >> 8);
                                    var47_40[this.NUM_DRAWERS_OFFSET + 1] = (byte)var49_42;
                                }
                                ++var83_83;
                            }
                        }
                        var7_7 = (short)(var45_38 + var43_36 + var78_77.size() * 10);
                        var67_65 = new Object[3];
                        var67_65[1] = new Short(var7_7);
                        var67_65[2] = var3_3;
                        var83_84 = (Object[])var54_47.get(var2_2);
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("In _saveDLPARProfile: new len = " + var7_7);
                        }
                        Trace.trace("apnvhscF", "len = " + String.valueOf(var7_7));
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("In _saveDLPARProfile: old Len = " + (Short)var83_84[1]);
                        }
                        Trace.trace("apnvhscF", "oldLen = " + var83_84[1]);
                        var84_85 = 0;
                        var85_90 = false;
                        try {
                            block145: {
                                block144: {
                                    block143: {
                                        if (var7_7 != (Short)var83_84[1]) break block143;
                                        Trace.trace("apnvhscF", "old and new profiles have the same length - No need to move the profile");
                                        var67_65[0] = var83_84[0];
                                        var84_85 = (Integer)var67_65[0];
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In _saveDLPARProfile: profileOffset = " + var84_85);
                                        }
                                        v0 = var85_90 = var38_31 == false;
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In _saveDLPARProfile: nameIndex = " + var10_11);
                                        }
                                        var54_47.put(var2_2, var67_65);
                                        this._nvramBAOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
                                        this._nvramDOutputStream = new DataOutputStream(this._nvramBAOutputStream);
                                        this._nvramDOutputStream.write(var47_40, 0, (Integer)var67_65[0]);
                                        if (this._releaseVersion < 3) {
                                            this._nvramDOutputStream.writeByte((byte)var7_7);
                                        } else {
                                            this._nvramDOutputStream.writeShort(var7_7);
                                        }
                                        this._nvramDOutputStream.writeByte((byte)var8_9);
                                        this._nvramDOutputStream.writeBytes(NVRAM.cryptedTimestamp(var2_2));
                                        this._nvramDOutputStream.writeByte((byte)var9_10);
                                        if (this._releaseVersion < 3) {
                                            this._nvramDOutputStream.writeShort((short)var10_11);
                                        } else {
                                            this._nvramDOutputStream.writeInt(var10_11);
                                        }
                                        this._nvramDOutputStream.writeByte(var12_13);
                                        this._nvramDOutputStream.writeByte((byte)var13_14);
                                        this._nvramDOutputStream.writeByte((byte)var14_15);
                                        this._nvramDOutputStream.writeByte((byte)var15_16);
                                        this._nvramDOutputStream.writeByte((byte)var16_17);
                                        this._nvramDOutputStream.writeByte((byte)var17_18);
                                        this._nvramDOutputStream.writeByte((byte)var18_19);
                                        this._nvramDOutputStream.writeByte((byte)var19_20);
                                        this._nvramDOutputStream.writeInt((int)var20_21);
                                        this._nvramDOutputStream.writeInt((int)var22_22);
                                        this._nvramDOutputStream.writeInt((int)var24_23);
                                        this._nvramDOutputStream.writeByte((byte)var78_77.size());
                                        if (var78_77.size() == 0) break block144;
                                        var86_93 = var78_77.keys();
                                        if (true) ** GOTO lbl605
                                    }
                                    var86_95 = this.NVRAM_SIZE;
                                    if (this._releaseVersion != 0) {
                                        var86_95 = this._bufferedNVRAMSize;
                                    }
                                    if ((long)(var48_41 + var7_7) > var86_95) {
                                        var88_106 = (byte[])this._nvramData.clone();
                                        var89_111 = this._nvramDataSize;
                                        var90_114 = this._numDrawers;
                                        var91_122 = (Hashtable)this._drawerIDTable.clone();
                                        var92_128 = (Hashtable)this._drawerIndexTable.clone();
                                        var93_132 = (Hashtable)this._profileNameTable.clone();
                                        var94_135 = (Hashtable)this._profileNameOffsetTable.clone();
                                        var95_136 = (Hashtable)this._profileTable.clone();
                                        var96_137 = (Vector)this._pnameFreeList.clone();
                                        var97_138 = (Vector)this._dIDFreeList.clone();
                                        var98_139 = this._drawerOffsetTail;
                                        var99_140 = this._dIDFreeListTail;
                                        this._nvramData = (byte[])var47_40.clone();
                                        this._nvramDataSize = var48_41;
                                        this._numDrawers = var49_42;
                                        this._drawerIDTable = (Hashtable)var50_43.clone();
                                        this._drawerIndexTable = (Hashtable)var51_44.clone();
                                        this._profileNameTable = (Hashtable)var52_45.clone();
                                        this._profileNameOffsetTable = (Hashtable)var53_46.clone();
                                        this._profileTable = (Hashtable)var54_47.clone();
                                        this._pnameFreeList = (Vector)var55_48.clone();
                                        this._dIDFreeList = (Vector)var56_49.clone();
                                        this._drawerOffsetTail = var57_50;
                                        this._dIDFreeListTail = var58_51;
                                        try {
                                            this.cleanUp(null);
                                        }
                                        catch (Throwable var100_142) {
                                            var100_142.printStackTrace();
                                            this._nvramData = (byte[])var88_106.clone();
                                            this._nvramDataSize = var89_111;
                                            this._numDrawers = (short)var90_114;
                                            this._drawerIDTable = (Hashtable)var91_122.clone();
                                            this._drawerIndexTable = (Hashtable)var92_128.clone();
                                            this._profileNameTable = (Hashtable)var93_132.clone();
                                            this._profileNameOffsetTable = (Hashtable)var94_135.clone();
                                            this._profileTable = (Hashtable)var95_136.clone();
                                            this._pnameFreeList = (Vector)var96_137.clone();
                                            this._dIDFreeList = (Vector)var97_138.clone();
                                            this._drawerOffsetTail = var98_139;
                                            throw var100_142;
                                        }
                                        var63_56 = true;
                                        if ((long)(this._nvramDataSize + var7_7) > var86_95) {
                                            throw new HSCCIMException("0003");
                                        }
                                        var47_40 = (byte[])this._nvramData.clone();
                                        var48_41 = this._nvramDataSize;
                                        var49_42 = this._numDrawers;
                                        var50_43 = (Hashtable)this._drawerIDTable.clone();
                                        var51_44 = (Hashtable)this._drawerIndexTable.clone();
                                        var52_45 = (Hashtable)this._profileNameTable.clone();
                                        var53_46 = (Hashtable)this._profileNameOffsetTable.clone();
                                        var54_47 = (Hashtable)this._profileTable.clone();
                                        var55_48 = (Vector)this._pnameFreeList.clone();
                                        var56_49 = (Vector)this._dIDFreeList.clone();
                                        if (var57_50 != this._drawerOffsetTail) {
                                            var61_54 = true;
                                        }
                                        var57_50 = this._drawerOffsetTail;
                                        var58_51 = this._dIDFreeListTail;
                                        var33_26 = this._drawerOffsetTail;
                                    }
                                    var59_52 = var88_103 = ((Integer)var83_84[0]).intValue();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In _saveDLPARProfile: oldOffset = " + var88_103);
                                    }
                                    var47_40[var88_103 + var46_39] = -1;
                                    var67_65 = new Object[]{new Integer(var48_41), new Short(var7_7), var3_3};
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In _saveDLPARProfile: newNvramDataSize = " + var48_41);
                                    }
                                    var84_85 = (Integer)var67_65[0];
                                    var54_47.put(var2_2, var67_65);
                                    this._nvramBAOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
                                    this._nvramDOutputStream = new DataOutputStream(this._nvramBAOutputStream);
                                    this._nvramDOutputStream.write(var47_40, 0, var48_41);
                                    if (this._releaseVersion < 3) {
                                        this._nvramDOutputStream.writeByte((byte)var7_7);
                                    } else {
                                        this._nvramDOutputStream.writeShort(var7_7);
                                    }
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In _saveDLPARProfile: len = " + var7_7);
                                    }
                                    this._nvramDOutputStream.writeByte((byte)var8_9);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In _saveDLPARProfile: templateVersion = " + var8_9);
                                    }
                                    this._nvramDOutputStream.writeBytes(NVRAM.cryptedTimestamp(var2_2));
                                    this._nvramDOutputStream.writeByte((byte)var9_10);
                                    if (this._releaseVersion < 3) {
                                        this._nvramDOutputStream.writeShort(var10_11);
                                    } else {
                                        this._nvramDOutputStream.writeInt(var10_11);
                                    }
                                    this._nvramDOutputStream.writeByte(var12_13);
                                    this._nvramDOutputStream.writeByte((byte)var13_14);
                                    this._nvramDOutputStream.writeByte((byte)var14_15);
                                    this._nvramDOutputStream.writeByte((byte)var15_16);
                                    this._nvramDOutputStream.writeByte((byte)var16_17);
                                    this._nvramDOutputStream.writeByte((byte)var17_18);
                                    this._nvramDOutputStream.writeByte((byte)var18_19);
                                    this._nvramDOutputStream.writeByte((byte)var19_20);
                                    this._nvramDOutputStream.writeInt((int)var20_21);
                                    this._nvramDOutputStream.writeInt((int)var22_22);
                                    this._nvramDOutputStream.writeInt((int)var24_23);
                                    this._nvramDOutputStream.writeByte((byte)var78_77.size());
                                    var89_112 = var78_77.keys();
                                    if (true) ** GOTO lbl644
                                    do {
                                        var87_98 = (String)var86_93.nextElement();
                                        var88_103 = ((Short)((Object[])var78_77.get(var87_98))[0]).shortValue();
                                        var89_110 = (Integer)((Object[])var78_77.get(var87_98))[1];
                                        var90_114 = (Integer)((Object[])var78_77.get(var87_98))[2];
                                        this._nvramDOutputStream.writeShort(var88_103);
                                        this._nvramDOutputStream.writeInt(var89_110);
                                        this._nvramDOutputStream.writeInt(var90_114);
                                        if (!NVRAM.DEBUG_ON) continue;
                                        System.out.println("In saveLPARProfile: drawerIndex = " + var88_103);
                                        System.out.println("In saveLPARProfile: ioSlots = " + var89_110);
                                        System.out.println("In saveLPARProfile: require = " + var90_114);
lbl605:
                                        // 3 sources

                                    } while (var86_93.hasMoreElements());
                                }
                                if (this._releaseVersion > 2) {
                                    this._nvramDOutputStream.writeByte((byte)var42_35);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In _saveDLPARProfile: Number SMA Adapters = " + var42_35);
                                    }
                                    if (var42_35 > 0) {
                                        this._nvramDOutputStream.writeByte((byte)var39_32);
                                        var86_94 = 0;
                                        while (var86_94 < var42_35) {
                                            var87_100 = Long.parseLong((String)var40_33.elementAt(var86_94));
                                            this._nvramDOutputStream.writeInt((int)var87_100);
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In _saveDLPARProfile: SMA Adapter ID = " + var87_100);
                                            }
                                            ++var86_94;
                                        }
                                        var87_101 = 0;
                                        while (var87_101 < var42_35) {
                                            var88_103 = ((UnsignedInt16)var41_34.elementAt(var87_101)).shortValue();
                                            this._nvramDOutputStream.writeShort(var88_103);
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In _saveDLPARProfile: SMA Adapter Number of Windows = " + var88_103);
                                            }
                                            ++var87_101;
                                        }
                                    }
                                }
                                var27_25 = (Integer)var67_65[0];
                                this._nvramDOutputStream.write(var47_40, var27_25 + var7_7, this.NVRAM_SIZE - (var27_25 + var7_7));
                                break block145;
                                do {
                                    var90_116 = (String)var89_112.nextElement();
                                    var91_123 = (Short)((Object[])var78_77.get(var90_116))[0];
                                    var92_130 = (Integer)((Object[])var78_77.get(var90_116))[1];
                                    var93_134 = (Integer)((Object[])var78_77.get(var90_116))[2];
                                    this._nvramDOutputStream.writeShort(var91_123);
                                    this._nvramDOutputStream.writeInt(var92_130);
                                    this._nvramDOutputStream.writeInt(var93_134);
                                    if (!NVRAM.DEBUG_ON) continue;
                                    System.out.println("In saveLPARProfile: drawerIndex = " + var91_123);
                                    System.out.println("In saveLPARProfile: ioSlots = " + var92_130);
                                    System.out.println("In saveLPARProfile: require = " + var93_134);
lbl644:
                                    // 3 sources

                                } while (var89_112.hasMoreElements());
                                if (this._releaseVersion > 2) {
                                    this._nvramDOutputStream.writeByte((byte)var42_35);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In _saveDLPARProfile: Number SMA Adapters = " + var42_35);
                                    }
                                    if (var42_35 > 0) {
                                        this._nvramDOutputStream.writeByte((byte)var39_32);
                                        var90_117 = 0;
                                        while (var90_117 < var42_35) {
                                            var91_124 = Long.parseLong((String)var40_33.elementAt(var90_117));
                                            this._nvramDOutputStream.writeInt((int)var91_124);
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In _saveDLPARProfile: SMA Adapter ID = " + var91_124);
                                            }
                                            ++var90_117;
                                        }
                                        var91_125 = 0;
                                        while (var91_125 < var42_35) {
                                            var92_131 = ((UnsignedInt16)var41_34.elementAt(var91_125)).shortValue();
                                            this._nvramDOutputStream.writeShort(var92_131);
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("In _saveDLPARProfile: SMA Adapter Number of Windows = " + var92_131);
                                            }
                                            ++var91_125;
                                        }
                                    }
                                }
                                this._nvramDOutputStream.write(var47_40, var48_41 += var7_7, this.NVRAM_SIZE - var48_41);
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In saveLPARProfile: new nvraDataSize = " + var48_41);
                                }
                            }
                            this._nvramDOutputStream.flush();
                            this._nvramData = this._nvramBAOutputStream.toByteArray();
                            this._nvramDOutputStream.close();
                        }
                        catch (Throwable var86_96) {
                            var86_96.printStackTrace();
                            HSCLogUtils.serverLog(var86_96, HSCLogUtils._NVRAMClassLogInfo);
                            throw new HSCCIMException("0007");
                        }
                        this._nvramDataSize = var48_41;
                        this._numDrawers = var49_42;
                        this._drawerIDTable = (Hashtable)var50_43.clone();
                        this._drawerIndexTable = (Hashtable)var51_44.clone();
                        this._profileNameTable = (Hashtable)var52_45.clone();
                        this._profileNameOffsetTable = (Hashtable)var53_46.clone();
                        this._profileTable = (Hashtable)var54_47.clone();
                        this._pnameFreeList = (Vector)var55_48.clone();
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("In _saveDLPARProfile: newDIDFreeList = " + var56_49);
                        }
                        this._dIDFreeList = (Vector)var56_49.clone();
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("In _saveDLPARProfile: _dIDFreeList = " + this._dIDFreeList);
                        }
                        this._drawerOffsetTail = var57_50;
                        this._dIDFreeListTail = var58_51;
                        if (var2_2.equals(this._defaultList[var12_13]) && this._fastActivation[var12_13 - 1]) {
                            this._fastActivation[var12_13 - 1] = false;
                            this._nvramData[this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (var12_13 - 1) + 31] = 0;
                            var65_58 = true;
                        }
                        if (!var6_6) break block146;
                        var86_97 = null;
                        var87_102 = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", var86_97, var5_5, this._cspVersion);
                        var88_107 = this.getTime(var87_102);
                        var89_113 = 0;
                        if (true) ** GOTO lbl725
                    }
                    finally {
                        if (!NVRAM.DEBUG_ON) break block135;
                        System.out.println("End of saveLPARProfile");
                        System.out.println("***********************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                var103_143 = null;
                Trace.trace("apnvhscT", "-> saveDLPARProfile");
                return;
                do {
                    this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + var89_113] = var88_107[var89_113];
                    if (var65_58) {
                        this._nvramData[this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET + var89_113] = var88_107[var89_113];
                    }
                    if (var60_53) {
                        this._nvramData[this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + var89_113] = var88_107[var89_113];
                    }
                    this._nvramData[this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + var89_113] = var88_107[var89_113];
                    ++var89_113;
lbl725:
                    // 2 sources

                } while (var89_113 < 7);
                this._checksumCalc.reset();
                this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                this._checksum = this._checksumCalc.getValue();
                this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                this._nvramTimeStamp = (byte[])var88_107.clone();
                if (var65_58) {
                    this._partitionNameTableTimeStamp = (byte[])var88_107.clone();
                    this._checksumCalc.reset();
                    this._checksumCalc.update(this._nvramData, this.PARTITION_NAME_TABLE_OFFSET, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET - this.PARTITION_NAME_TABLE_OFFSET);
                    this._checksum = this._checksumCalc.getValue();
                    this.writeIntegralToNvramData(this._checksum, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                }
                if (var60_53) {
                    this._profileNameTableTimeStamp = (byte[])var88_107.clone();
                    this._checksumCalc.reset();
                    this._checksumCalc.update(this._nvramData, this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
                    this._checksum = this._checksumCalc.getValue();
                    this.writeIntegralToNvramData(this._checksum, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                }
                this._checksumCalc.reset();
                this._checksumCalc.update(this._nvramData, this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET);
                this._checksum = this._checksumCalc.getValue();
                this.writeIntegralToNvramData(this._checksum, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, (short)8);
                if (this._releaseVersion != 0) {
                    var90_118 = this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET;
                    if (this._releaseVersion < 3) {
                        this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = (byte)(var90_118 >>> 8);
                        this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = (byte)(var90_118 & 255);
                    } else {
                        this.writeIntToNvramData(var90_118, this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET);
                    }
                }
                this._drawerProfileInfoTimeStamp = (byte[])var88_107.clone();
                this._backupToLocalFile();
                var90_119 = (byte)(this._releaseVersion << 1 | NVRAM.CORRUPTED_ON[0]);
                this._writeDataToCSP(new byte[]{var90_119}, this.CORRUPTED_BYTE_OFFSET, 1, var5_5);
                this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, var5_5);
                if (var65_58) {
                    this._writeDataToCSP(new String(this._nvramData, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8, var5_5);
                    this._writeDataToCSP(new String(this._nvramData, this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (var12_13 - 1) + 31, 1).getBytes(), this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (var12_13 - 1) + 31, 1, var5_5);
                }
                if (var60_53) {
                    this._writeDataToCSP(new String(this._nvramData, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8, var5_5);
                    if (var36_29) {
                        this._writeDataToCSP(this._zeroOutNameString.getBytes(), var34_27, 32, var5_5);
                    }
                    if (var37_30) {
                        this._writeDataToCSP(this.setLength(var30_60, 32).getBytes(), var35_28, 32, var5_5);
                    }
                }
                if (this._releaseVersion == 0) {
                    this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8, var5_5);
                } else if (this._releaseVersion < 3) {
                    this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10, var5_5);
                } else {
                    this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12, var5_5);
                }
                if (var61_54) {
                    if (NVRAM.DEBUG_ON) {
                        System.out.println("in change drawer");
                    }
                    this._writeDataToCSP(new String(this._nvramData, this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET).getBytes(), this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET, var5_5);
                }
                if (var85_90) {
                    if (NVRAM.DEBUG_ON) {
                        System.out.println("In sameOffset");
                    }
                    this._writeDataToCSP(new String(this._nvramData, var84_85, (int)var7_7).getBytes(), var84_85, var7_7, var5_5);
                } else if (!(var38_31 || var63_56 || var64_57)) {
                    if (NVRAM.DEBUG_ON) {
                        System.out.println("in !adding");
                    }
                    var91_126 = new byte[]{-1};
                    this._writeDataToCSP(var91_126, var59_52 + var46_39, 1, var5_5);
                    this._writeDataToCSP(new String(this._nvramData, var84_85, (int)var7_7).getBytes(), var84_85, var7_7, var5_5);
                } else {
                    if (NVRAM.DEBUG_ON) {
                        System.out.println("in else");
                    }
                    var91_127 = 0;
                    var91_127 = var63_56 != false || var64_57 != false ? this.NVRAM_SIZE - this._drawerOffsetTail : this._nvramDataSize - this._drawerOffsetTail;
                    this._writeDataToCSP(new String(this._nvramData, this._drawerOffsetTail, var91_127).getBytes(), this._drawerOffsetTail, var91_127, var5_5);
                }
                var90_119 = (byte)(this._releaseVersion << 1 | NVRAM.CORRUPTED_OFF[0]);
                this._writeDataToCSP(new byte[]{var90_119}, this.CORRUPTED_BYTE_OFFSET, 1, var5_5);
            }
            catch (Throwable var7_8) {
                var7_8.printStackTrace();
                HSCLogUtils.serverLog(var7_8, HSCLogUtils._NVRAMClassLogInfo);
                if (var7_8 instanceof HSCCIMException != false) throw new HSCCIMException(var7_8);
                throw new HSCCIMException("0015");
            }
        }
        catch (Throwable var102_146) {
            var103_144 = null;
            Trace.trace("apnvhscT", "-> saveDLPARProfile");
            throw var102_146;
        }
    }

    public synchronized void saveSysProfile(String string, String string2, Vector vector, String string3, HscProviderSocket hscProviderSocket) throws CIMException {
        this._saveSysProfile(string, string2, vector, string3, hscProviderSocket, true);
    }

    public synchronized void saveSysProfile(String string, Vector vector, String string2, HscProviderSocket hscProviderSocket) throws CIMException {
        this._saveSysProfile(string, vector, string2, hscProviderSocket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _saveSysProfile(String string, Vector vector, String string2, HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        block12: {
            try {
                try {
                    block13: {
                        Trace.trace("apnvhscT", "-> saveSysProfile");
                        Trace.trace("apnvhscF", "profileTimeStamp = " + string);
                        Trace.trace("apnvhscF", "properties = " + vector);
                        Trace.trace("apnvhscF", "newName = " + string2);
                        Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                        if (DEBUG_ON) {
                            System.out.println("********************************************");
                            System.out.println("In saveSysProfile");
                        }
                        try {
                            if (bl) {
                                this.buildNVRAM(hscProviderSocket, false, null, true, false);
                            }
                            Object[] objectArray = new Object[3];
                            objectArray = (Object[])this._profileTable.get(string);
                            Vector vector2 = (Vector)objectArray[2];
                            if (vector2 == null) {
                            }
                            String string3 = (String)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                            this._saveSysProfile(string3, string, vector, string2, hscProviderSocket, true);
                            break block12;
                        }
                        finally {
                            if (!DEBUG_ON) break block13;
                            System.out.println("End of saveSysProfile");
                            System.out.println("***********************************************");
                            System.out.println();
                            System.out.println();
                        }
                    }
                    Object var11_9 = null;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                    throw new HSCCIMException("0016");
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                Trace.trace("apnvhscT", "<- saveSysProfile");
                throw throwable;
            }
            Trace.trace("apnvhscT", "<- saveSysProfile");
            return;
        }
        Object var11_10 = null;
        Trace.trace("apnvhscT", "<- saveSysProfile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _saveSysProfile(String var1_1, String var2_2, Vector var3_3, String var4_4, HscProviderSocket var5_5, boolean var6_6) throws CIMException {
        try {
            try {
                block74: {
                    block81: {
                        block76: {
                            block78: {
                                block77: {
                                    block75: {
                                        Trace.trace("apnvhscT", "-> saveSysProfile");
                                        Trace.trace("apnvhscF", "oldName = " + var1_1);
                                        Trace.trace("apnvhscF", "profileTimeStamp = " + var2_2);
                                        Trace.trace("apnvhscF", "properties = " + var3_3);
                                        Trace.trace("apnvhscF", "newName = " + var4_4);
                                        Trace.trace("apnvhscF", "socket = " + var5_5);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("********************************************");
                                            System.out.println("In saveSysProfile");
                                        }
                                        if (var6_6) {
                                            this.buildNVRAM(var5_5, false, null, true, false);
                                        }
                                        var7_7 = 0;
                                        var8_9 = 0;
                                        var9_10 = false;
                                        var10_11 = 0;
                                        var11_12 = 0;
                                        var8_9 = this._hscTemplateVersion;
                                        var9_10 = true;
                                        var17_13 = this._drawerOffsetTail;
                                        var18_14 = 0;
                                        var19_15 = 0;
                                        var20_16 = false;
                                        var21_17 = false;
                                        var22_18 = false;
                                        var23_19 = (byte[])this._nvramData.clone();
                                        var24_20 = this._nvramDataSize;
                                        var25_21 = this._numDrawers;
                                        var26_22 = (Hashtable)this._drawerIDTable.clone();
                                        var27_23 = (Hashtable)this._drawerIndexTable.clone();
                                        var28_24 = (Hashtable)this._profileNameTable.clone();
                                        var29_25 = (Hashtable)this._profileNameOffsetTable.clone();
                                        var30_26 = (Hashtable)this._profileTable.clone();
                                        var31_27 = (Vector)this._pnameFreeList.clone();
                                        var32_28 = (Vector)this._dIDFreeList.clone();
                                        var33_29 = this._drawerOffsetTail;
                                        var34_30 = this._dIDFreeListTail;
                                        var35_31 = (Integer)((Object[])this._profileTable.get(var2_2))[0];
                                        var36_32 = false;
                                        var37_33 = false;
                                        var38_34 = true;
                                        var39_35 = false;
                                        var40_36 = false;
                                        var41_37 = 0;
                                        var41_37 = this._releaseVersion < 3 ? this.TEMPLATE_VERSION_OFFSET : this.DLPAR_TEMPLATE_VERSION_OFFSET_R4;
                                        var42_38 = var1_1.length();
                                        if (var4_4 != null && !var4_4.equals(var1_1)) break block75;
                                        Trace.trace("apnvhscF", "No new name - No need to change the profile name table");
                                        var14_39 = new String(var1_1);
                                        var10_11 = ((int[])this._profileNameTable.get(var14_39))[0];
                                        Trace.trace("apnvhscF", "nameIndex = " + var10_11);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In saveSysProfile: name = " + var14_39.trim());
                                            System.out.println("In saveSysProfile: nameIndex = " + var10_11);
                                        }
                                        break block76;
                                    }
                                    Trace.trace("apnvhscF", "Has new name - May need to change the name table");
                                    if (this.isDuplicatedAtPartition(0, var4_4, var5_5)) {
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In saveSysProfile: name already exist");
                                        }
                                        throw new HSCCIMException("0004", new String[]{var4_4, String.valueOf(0)});
                                    }
                                    var42_38 = var4_4.length();
                                    var14_39 = new String(var4_4);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveSysProfile: name = " + var14_39.trim());
                                    }
                                    var15_40 = (int[])var28_24.get(var1_1);
                                    var11_12 = var15_40[0];
                                    Trace.trace("apnvhscF", "oldNameOffset = " + String.valueOf(var11_12));
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In saveSysProfile: oldNameOffset = " + var11_12);
                                    }
                                    var18_14 = var11_12;
                                    var13_41 = (short)var15_40[1];
                                    if (var13_41 != 1) break block77;
                                    var36_32 = true;
                                    var20_16 = true;
                                    var43_42 = 0;
                                    if (true) ** GOTO lbl86
                                }
                                var15_40[1] = var15_40[1] - 1;
                                break block78;
                                do {
                                    var23_19[var11_12 + var43_42] = 0;
                                    ++var43_42;
lbl86:
                                    // 2 sources

                                } while (var43_42 < 32);
                                var28_24.remove(var1_1);
                                var29_25.remove(new Integer(var11_12));
                                var31_27.add(new Integer(var11_12));
                            }
                            if (var28_24.containsKey(var4_4)) {
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In saveSysProfile: contained the new name already");
                                }
                                Trace.trace("apnvhscF", "profileNameTable already contains the new name - Just increment the reference count");
                                var15_40 = (int[])var28_24.get(var14_39);
                                var10_11 = var15_40[0];
                                Trace.trace("apnvhscF", "nameIndex = " + String.valueOf(var10_11));
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In saveSysProfile: nameIndex = " + var10_11);
                                }
                                var15_40[1] = var15_40[1] + 1;
                            } else {
                                Trace.trace("apnvhscF", "profileNameTable doesn't contain the new name - Need to create one in the name table");
                                var36_32 = true;
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In saveSysProfile: the new name is not yet exist. Need to create one");
                                }
                                if (var31_27.isEmpty()) {
                                    if (NVRAM.DEBUG_ON == false) throw new HSCCIMException("0001");
                                    System.out.println("No more space for new name");
                                    throw new HSCCIMException("0001");
                                }
                                var21_17 = true;
                                var15_40 = new int[2];
                                var15_40[0] = (Integer)var31_27.elementAt(0);
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In saveSysProfile: new name offset = " + var15_40[0]);
                                }
                                var31_27.removeElementAt(0);
                                var15_40[1] = 1;
                                var19_15 = var10_11 = var15_40[0];
                                var28_24.put(var14_39, var15_40);
                                var29_25.put(new Integer(var10_11), var14_39);
                                var43_43 = this.setLength(var14_39, 32).getBytes();
                                var44_45 = 0;
                                while (var44_45 < 32) {
                                    var23_19[var10_11 + var44_45] = var43_43[var44_45];
                                    ++var44_45;
                                }
                            }
                        }
                        var43_44 = null;
                        var44_46 = null;
                        if (var3_3.size() == 4) {
                            var43_44 = (CIMProperty)var3_3.elementAt(2);
                            var44_46 = (CIMProperty)var3_3.elementAt(3);
                        }
                        var45_47 = null;
                        var46_48 = null;
                        var47_49 = 0;
                        if (var43_44 != null && var43_44.getValue() != null) {
                            var45_47 = (Vector)var43_44.getValue().getValue();
                            var46_48 = (Vector)var44_46.getValue().getValue();
                            if (var45_47 != null) {
                                var47_49 = var45_47.size();
                            }
                        }
                        var48_50 = new Object[3];
                        var48_50 = (Object[])var30_26.get(var2_2);
                        var49_51 = (Vector)var48_50[2];
                        Trace.trace("apnvhscF", "cimproperties = " + var49_51);
                        var7_7 = this._releaseVersion < 3 ? (short)(13 + var47_49 * 6) : (short)(16 + var47_49 * 6);
                        Trace.trace("apnvhscF", "len = " + var7_7);
                        var50_52 = new Object[3];
                        var50_52[1] = new Short(var7_7);
                        var50_52[2] = var3_3;
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("In saveSysProfile: new len = " + var7_7);
                        }
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("In saveSysProfile: old Len = " + (Short)var48_50[1]);
                        }
                        Trace.trace("apnvhscF", "oldLen = " + var48_50[1]);
                        var51_53 = 0;
                        var52_54 = false;
                        try {
                            block80: {
                                block79: {
                                    if (var7_7 != (Short)var48_50[1]) break block79;
                                    Trace.trace("apnvhscF", "old and new profiles have the same length - No need to move the profile");
                                    var50_52[0] = var48_50[0];
                                    var51_53 = (Integer)var50_52[0];
                                    var52_54 = var22_18 == false;
                                    var30_26.put(var2_2, var50_52);
                                    this._nvramBAOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
                                    this._nvramDOutputStream = new DataOutputStream(this._nvramBAOutputStream);
                                    this._nvramDOutputStream.write(var23_19, 0, (Integer)var50_52[0]);
                                    if (this._releaseVersion < 3) {
                                        this._nvramDOutputStream.writeByte((byte)var7_7);
                                    } else {
                                        this._nvramDOutputStream.writeShort(var7_7);
                                    }
                                    this._nvramDOutputStream.writeByte((byte)var8_9);
                                    this._nvramDOutputStream.writeBytes(NVRAM.cryptedTimestamp(var2_2));
                                    this._nvramDOutputStream.writeByte((byte)var9_10);
                                    if (this._releaseVersion < 3) {
                                        this._nvramDOutputStream.writeShort((short)var10_11);
                                    } else {
                                        this._nvramDOutputStream.writeInt(var10_11);
                                    }
                                    this._nvramDOutputStream.writeByte((byte)var47_49);
                                    var53_55 = 0;
                                    if (true) ** GOTO lbl292
                                }
                                var53_56 = this.NVRAM_SIZE;
                                if (this._releaseVersion != 0) {
                                    var53_56 = this._bufferedNVRAMSize;
                                }
                                if ((long)(var24_20 + var7_7) > var53_56) {
                                    var55_61 = (byte[])this._nvramData.clone();
                                    var56_64 = this._nvramDataSize;
                                    var57_66 = this._numDrawers;
                                    var58_70 = (Hashtable)this._drawerIDTable.clone();
                                    var59_72 = (Hashtable)this._drawerIndexTable.clone();
                                    var60_73 = (Hashtable)this._profileNameTable.clone();
                                    var61_74 = (Hashtable)this._profileNameOffsetTable.clone();
                                    var62_75 = (Hashtable)this._profileTable.clone();
                                    var63_76 = (Vector)this._pnameFreeList.clone();
                                    var64_77 = (Vector)this._dIDFreeList.clone();
                                    var65_78 = this._drawerOffsetTail;
                                    var66_79 = this._dIDFreeListTail;
                                    this._nvramData = (byte[])var23_19.clone();
                                    this._nvramDataSize = var24_20;
                                    this._numDrawers = var25_21;
                                    this._drawerIDTable = (Hashtable)var26_22.clone();
                                    this._drawerIndexTable = (Hashtable)var27_23.clone();
                                    this._profileNameTable = (Hashtable)var28_24.clone();
                                    this._profileNameOffsetTable = (Hashtable)var29_25.clone();
                                    this._profileTable = (Hashtable)var30_26.clone();
                                    this._pnameFreeList = (Vector)var31_27.clone();
                                    this._dIDFreeList = (Vector)var32_28.clone();
                                    this._drawerOffsetTail = var33_29;
                                    this._dIDFreeListTail = var34_30;
                                    try {
                                        this.cleanUp(null);
                                    }
                                    catch (Throwable var67_80) {
                                        var67_80.printStackTrace();
                                        this._nvramData = (byte[])var55_61.clone();
                                        this._nvramDataSize = var56_64;
                                        this._numDrawers = var57_66;
                                        this._drawerIDTable = (Hashtable)var58_70.clone();
                                        this._drawerIndexTable = (Hashtable)var59_72.clone();
                                        this._profileNameTable = (Hashtable)var60_73.clone();
                                        this._profileNameOffsetTable = (Hashtable)var61_74.clone();
                                        this._profileTable = (Hashtable)var62_75.clone();
                                        this._pnameFreeList = (Vector)var63_76.clone();
                                        this._dIDFreeList = (Vector)var64_77.clone();
                                        this._drawerOffsetTail = var65_78;
                                        throw var67_80;
                                    }
                                    var39_35 = true;
                                    if ((long)(this._nvramDataSize + var7_7) > var53_56) {
                                        throw new HSCCIMException("0003");
                                    }
                                    var23_19 = (byte[])this._nvramData.clone();
                                    var24_20 = this._nvramDataSize;
                                    var25_21 = this._numDrawers;
                                    var26_22 = (Hashtable)this._drawerIDTable.clone();
                                    var27_23 = (Hashtable)this._drawerIndexTable.clone();
                                    var28_24 = (Hashtable)this._profileNameTable.clone();
                                    var29_25 = (Hashtable)this._profileNameOffsetTable.clone();
                                    var30_26 = (Hashtable)this._profileTable.clone();
                                    var31_27 = (Vector)this._pnameFreeList.clone();
                                    var32_28 = (Vector)this._dIDFreeList.clone();
                                    if (var33_29 != this._drawerOffsetTail) {
                                        var37_33 = true;
                                    }
                                    var33_29 = this._drawerOffsetTail;
                                    var34_30 = this._dIDFreeListTail;
                                    var17_13 = this._drawerOffsetTail;
                                }
                                var35_31 = var55_62 = ((Integer)var48_50[0]).intValue();
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In saveSysProfile: oldOffset = " + var55_62);
                                }
                                var23_19[var55_62 + var41_37] = -1;
                                var50_52 = new Object[]{new Integer(var24_20), new Short(var7_7), var3_3};
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In saveSysProfile: newNvramDataSize = " + var24_20);
                                }
                                var51_53 = (Integer)var50_52[0];
                                var30_26.put(var2_2, var50_52);
                                this._nvramBAOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
                                this._nvramDOutputStream = new DataOutputStream(this._nvramBAOutputStream);
                                this._nvramDOutputStream.write(var23_19, 0, var24_20);
                                if (this._releaseVersion < 3) {
                                    this._nvramDOutputStream.writeByte((byte)var7_7);
                                } else {
                                    this._nvramDOutputStream.writeShort(var7_7);
                                }
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In saveSysProfile: len = " + var7_7);
                                }
                                this._nvramDOutputStream.writeByte((byte)var8_9);
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In saveSysProfile: templateVersion = " + var8_9);
                                }
                                this._nvramDOutputStream.writeBytes(NVRAM.cryptedTimestamp(var2_2));
                                this._nvramDOutputStream.writeByte((byte)var9_10);
                                if (this._releaseVersion < 3) {
                                    this._nvramDOutputStream.writeShort((short)var10_11);
                                } else {
                                    this._nvramDOutputStream.writeInt(var10_11);
                                }
                                this._nvramDOutputStream.writeByte((byte)var47_49);
                                var56_64 = 0;
                                if (true) ** GOTO lbl309
                                do {
                                    var54_59 = (String)var45_47.elementAt(var53_55);
                                    Trace.trace("apnvhscF", "timeStamp = " + (String)var54_59);
                                    var55_60 = NVRAM.encodeTime(NVRAM.cryptedTimestamp((String)var54_59));
                                    var56_63 = (UnsignedInt8)var46_48.elementAt(var53_55);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("pid = " + var56_63);
                                        System.out.println("encoded time stamp len = " + var55_60.length);
                                    }
                                    this._nvramDOutputStream.writeByte(var56_63.byteValue());
                                    this._nvramDOutputStream.writeBytes(new String(var55_60));
                                    ++var53_55;
lbl292:
                                    // 2 sources

                                } while (var53_55 < var47_49);
                                var11_12 = (Integer)var50_52[0];
                                this._nvramDOutputStream.write(var23_19, var11_12 + var7_7, this.NVRAM_SIZE - (var11_12 + var7_7));
                                break block80;
                                do {
                                    var57_67 = (String)var45_47.elementAt(var56_64);
                                    Trace.trace("apnvhscF", "timeStamp = " + var57_67);
                                    var58_70 = (UnsignedInt8)var46_48.elementAt(var56_64);
                                    Trace.trace("apnvhscF", "pid = " + var58_70);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("pid = " + var58_70);
                                    }
                                    var59_72 = NVRAM.encodeTime(NVRAM.cryptedTimestamp(var57_67));
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("encdedTimeStamp len = " + ((Object)var59_72).length);
                                    }
                                    this._nvramDOutputStream.writeByte(var58_70.byteValue());
                                    this._nvramDOutputStream.writeBytes(new String((byte[])var59_72));
                                    ++var56_64;
lbl309:
                                    // 2 sources

                                } while (var56_64 < var47_49);
                                this._nvramDOutputStream.write(var23_19, var24_20 += var7_7, this.NVRAM_SIZE - var24_20);
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In saveSysProfile: new nvraDataSize = " + var24_20);
                                }
                            }
                            this._nvramDOutputStream.flush();
                            this._nvramData = this._nvramBAOutputStream.toByteArray();
                            this._nvramDOutputStream.close();
                        }
                        catch (Throwable var53_57) {
                            var53_57.printStackTrace();
                            HSCLogUtils.serverLog(var53_57, HSCLogUtils._NVRAMClassLogInfo);
                            throw new HSCCIMException("0007");
                        }
                        this._nvramDataSize = var24_20;
                        this._numDrawers = var25_21;
                        this._drawerIDTable = (Hashtable)var26_22.clone();
                        this._drawerIndexTable = (Hashtable)var27_23.clone();
                        this._profileNameTable = (Hashtable)var28_24.clone();
                        this._profileNameOffsetTable = (Hashtable)var29_25.clone();
                        this._profileTable = (Hashtable)var30_26.clone();
                        this._pnameFreeList = (Vector)var31_27.clone();
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("In saveSysProfile: newDIDFreeList = " + var32_28);
                        }
                        this._dIDFreeList = (Vector)var32_28.clone();
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("In saveSysProfile: _dIDFreeList = " + this._dIDFreeList);
                        }
                        this._drawerOffsetTail = var33_29;
                        this._dIDFreeListTail = var34_30;
                        if (!var6_6) break block81;
                        var53_58 = null;
                        var54_59 = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", var53_58, var5_5, this._cspVersion);
                        var55_60 = this.getTime((Hashtable)var54_59);
                        var56_65 = 0;
                        if (true) ** GOTO lbl362
                    }
                    finally {
                        if (!NVRAM.DEBUG_ON) break block74;
                        System.out.println("End of saveSysProfile");
                        System.out.println("***********************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                var70_81 = null;
                Trace.trace("apnvhscT", "<- saveSysProfile");
                return;
                do {
                    this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + var56_65] = var55_60[var56_65];
                    if (var36_32) {
                        this._nvramData[this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + var56_65] = var55_60[var56_65];
                    }
                    this._nvramData[this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + var56_65] = var55_60[var56_65];
                    ++var56_65;
lbl362:
                    // 2 sources

                } while (var56_65 < 7);
                this._checksumCalc.reset();
                this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                this._checksum = this._checksumCalc.getValue();
                this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                this._nvramTimeStamp = (byte[])var55_60.clone();
                if (var36_32) {
                    this._profileNameTableTimeStamp = (byte[])var55_60.clone();
                    this._checksumCalc.reset();
                    this._checksumCalc.update(this._nvramData, this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
                    this._checksum = this._checksumCalc.getValue();
                    this.writeIntegralToNvramData(this._checksum, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                }
                this._drawerProfileInfoTimeStamp = (byte[])var55_60.clone();
                this._checksumCalc.reset();
                this._checksumCalc.update(this._nvramData, this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET);
                this._checksum = this._checksumCalc.getValue();
                this.writeIntegralToNvramData(this._checksum, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, (short)8);
                if (this._releaseVersion != 0) {
                    var57_68 = this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET;
                    if (this._releaseVersion < 3) {
                        this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = (byte)(var57_68 >>> 8);
                        this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = (byte)(var57_68 & 255);
                    } else {
                        this.writeIntToNvramData(var57_68, this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET);
                    }
                }
                this._backupToLocalFile();
                var57_69 = (byte)(this._releaseVersion << 1 | NVRAM.CORRUPTED_ON[0]);
                this._writeDataToCSP(new byte[]{var57_69}, this.CORRUPTED_BYTE_OFFSET, 1, var5_5);
                this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, var5_5);
                if (var36_32) {
                    this._writeDataToCSP(new String(this._nvramData, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8, var5_5);
                    if (var20_16) {
                        this._writeDataToCSP(this._zeroOutNameString.getBytes(), var18_14, 32, var5_5);
                    }
                    if (var21_17) {
                        this._writeDataToCSP(this.setLength(var14_39, 32).getBytes(), var19_15, 32, var5_5);
                    }
                }
                if (this._releaseVersion == 0) {
                    this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8, var5_5);
                } else if (this._releaseVersion < 3) {
                    this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10, var5_5);
                } else {
                    this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12, var5_5);
                }
                if (var52_54) {
                    this._writeDataToCSP(new String(this._nvramData, var51_53, (int)var7_7).getBytes(), var51_53, var7_7, var5_5);
                } else {
                    if (var37_33) {
                        this._writeDataToCSP(new String(this._nvramData, this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET).getBytes(), this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET, var5_5);
                    }
                    var58_71 = 0;
                    if (var39_35 || var40_36) {
                        var58_71 = this.NVRAM_SIZE - this._drawerOffsetTail;
                        this._writeDataToCSP(new String(this._nvramData, this._drawerOffsetTail, var58_71).getBytes(), this._drawerOffsetTail, var58_71, var5_5);
                    } else {
                        this._writeDataToCSP(new String(this._nvramData, var35_31 + var41_37, 1).getBytes(), var35_31 + var41_37, 1, var5_5);
                        var58_71 = this._nvramDataSize - var51_53;
                        this._writeDataToCSP(new String(this._nvramData, var51_53, var58_71).getBytes(), var51_53, var58_71, var5_5);
                    }
                }
                var57_69 = (byte)(this._releaseVersion << 1 | NVRAM.CORRUPTED_OFF[0]);
                this._writeDataToCSP(new byte[]{var57_69}, this.CORRUPTED_BYTE_OFFSET, 1, var5_5);
            }
            catch (Throwable var7_8) {
                var7_8.printStackTrace();
                HSCLogUtils.serverLog(var7_8, HSCLogUtils._NVRAMClassLogInfo);
                if (var7_8 instanceof HSCCIMException != false) throw new HSCCIMException(var7_8);
                throw new HSCCIMException("0016");
            }
        }
        catch (Throwable var69_84) {
            var70_82 = null;
            Trace.trace("apnvhscT", "<- saveSysProfile");
            throw var69_84;
        }
    }

    public synchronized void createLPARProfile(int n, String string, String string2, Vector vector, HscProviderSocket hscProviderSocket) throws CIMException {
        if (this._releaseVersion < 2) {
            this._createLPARProfile(n, string, string2, vector, hscProviderSocket, true);
        } else {
            this._createDLPARProfile(n, string, string2, vector, hscProviderSocket, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _createLPARProfile(int n, String string, String string2, Vector vector, HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        try {
            try {
                block80: {
                    Trace.trace("apnvhscT", "-> createLPARrofile");
                    Trace.trace("apnvhscF", "partitionID = " + String.valueOf(n));
                    Trace.trace("apnvhscF", "name = " + string);
                    Trace.trace("apnvhscF", "profileTimeStamp = " + string2);
                    Trace.trace("apnvhscF", "properties = " + vector);
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("********************************************");
                        System.out.println("In createLPARProfile");
                    }
                    try {
                        Object object;
                        int n2;
                        Object object2;
                        Cloneable cloneable;
                        Cloneable cloneable2;
                        Object[] objectArray;
                        Object object3;
                        Object object4;
                        int[] nArray;
                        if (bl) {
                            this.buildNVRAM(hscProviderSocket, false, null, true, false);
                        }
                        short s = 0;
                        short s2 = 0;
                        boolean bl2 = false;
                        int n3 = 0;
                        boolean bl3 = false;
                        short s3 = (short)n;
                        short s4 = 0;
                        short s5 = 0;
                        short s6 = 0;
                        short s7 = 0;
                        long l = 0L;
                        long l2 = 0L;
                        Object[] objectArray2 = new Object[3];
                        short s8 = 0;
                        String string3 = new String();
                        boolean bl4 = false;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        int n4 = 0;
                        int n5 = 0;
                        byte[] byArray = (byte[])this._nvramData.clone();
                        int n6 = this._nvramDataSize;
                        short s9 = this._numDrawers;
                        Hashtable hashtable = (Hashtable)this._drawerIDTable.clone();
                        Hashtable hashtable2 = (Hashtable)this._drawerIndexTable.clone();
                        Hashtable hashtable3 = (Hashtable)this._profileNameTable.clone();
                        Hashtable hashtable4 = (Hashtable)this._profileNameOffsetTable.clone();
                        Hashtable hashtable5 = (Hashtable)this._profileTable.clone();
                        Vector vector2 = (Vector)this._pnameFreeList.clone();
                        Vector vector3 = (Vector)this._dIDFreeList.clone();
                        if (DEBUG_ON) {
                            System.out.println("In createLPARProfile: _dIDFreeList = " + this._dIDFreeList);
                        }
                        int n7 = this._drawerOffsetTail;
                        short s10 = this._dIDFreeListTail;
                        s2 = this._hscTemplateVersion;
                        bl2 = false;
                        Hashtable<String, Object[]> hashtable6 = new Hashtable<String, Object[]>();
                        char[] cArray = new char[32];
                        char[] cArray2 = new char[32];
                        int n8 = this._nvramDataSize;
                        int n9 = 0;
                        while (true) {
                            if (n9 >= 32) {
                                if (!this.isDuplicatedAtPartition(n, string, hscProviderSocket)) break;
                                if (DEBUG_ON) {
                                    System.out.println("In createLPARProfile: name already exist");
                                }
                                throw new HSCCIMException("0004", new String[]{string, String.valueOf(n)});
                            }
                            cArray[n9] = 48;
                            cArray2[n9] = 48;
                            ++n9;
                        }
                        int n10 = string.length();
                        Trace.trace("apnvhscF", "name = " + string);
                        if (hashtable3.containsKey(string)) {
                            Trace.trace("apnvhscF", "profileNameTable already contain the name - Just increment the reference count");
                            nArray = (int[])hashtable3.get(string);
                            nArray[1] = nArray[1] + 1;
                            n3 = nArray[0];
                            if (DEBUG_ON) {
                                System.out.println("In createLPARProfile: nameIndex = " + n3);
                            }
                        } else {
                            bl4 = true;
                            nArray = new int[2];
                            if (vector2.isEmpty()) {
                                if (!DEBUG_ON) throw new HSCCIMException("0001");
                                System.out.println("no more space for name");
                                throw new HSCCIMException("0001");
                            }
                            nArray[0] = (Integer)vector2.elementAt(0);
                            vector2.removeElementAt(0);
                            nArray[1] = 1;
                            n4 = n3 = nArray[0];
                            Trace.trace("apnvhscF", "nameIndex and newNameOffset = " + n3);
                            if (DEBUG_ON) {
                                System.out.println("In createLPARProfile: nameIndex = " + n3);
                            }
                            hashtable3.put(string, nArray);
                            hashtable4.put(new Integer(n3), string);
                            object4 = this.setLength(string, 32).getBytes();
                            int n11 = 0;
                            while (n11 < 32) {
                                byArray[n4 + n11] = object4[n11];
                                ++n11;
                            }
                        }
                        s4 = ((UnsignedInt8)((CIMProperty)vector.elementAt(2)).getValue().getValue()).shortValue();
                        s5 = ((UnsignedInt8)((CIMProperty)vector.elementAt(3)).getValue().getValue()).shortValue();
                        s6 = ((UnsignedInt8)((CIMProperty)vector.elementAt(4)).getValue().getValue()).shortValue();
                        s7 = ((UnsignedInt8)((CIMProperty)vector.elementAt(5)).getValue().getValue()).shortValue();
                        l = ((UnsignedInt32)((CIMProperty)vector.elementAt(6)).getValue().getValue()).longValue();
                        l2 = ((UnsignedInt32)((CIMProperty)vector.elementAt(7)).getValue().getValue()).longValue();
                        object4 = null;
                        Vector vector4 = null;
                        Vector vector5 = null;
                        if (((CIMProperty)vector.elementAt(8)).getValue() != null) {
                            object4 = (Vector)((CIMProperty)vector.elementAt(8)).getValue().getValue();
                            vector4 = (Vector)((CIMProperty)vector.elementAt(9)).getValue().getValue();
                            vector5 = (Vector)((CIMProperty)vector.elementAt(10)).getValue().getValue();
                        }
                        int n12 = n7;
                        if (object4 != null && ((Vector)object4).size() != 0) {
                            Trace.trace("apnvhscF", "num of drawres = " + String.valueOf(((Vector)object4).size()));
                            int n13 = 0;
                            while (n13 < ((Vector)object4).size()) {
                                String string4;
                                string3 = (String)((Vector)object4).get(n13);
                                if (DEBUG_ON) {
                                    System.out.println("In createLPARProfile: slots = " + string3);
                                }
                                if (hashtable.containsKey(string3)) {
                                    nArray = (int[])hashtable.get(string3);
                                    if (DEBUG_ON) {
                                        System.out.println("In createLPARProfile: already contain this drawerID");
                                        System.out.println("In createLPARProfile: drawerID = " + string3.trim() + " drawerIndex = " + nArray[1]);
                                    }
                                    nArray[2] = nArray[2] + 1;
                                } else {
                                    int n14;
                                    nArray = new int[3];
                                    long l3 = this.NVRAM_SIZE;
                                    if (this._releaseVersion != 0) {
                                        l3 = this._bufferedNVRAMSize;
                                    }
                                    if ((long)n7 >= l3 || (long)(n6 + 24 + 2) > l3) {
                                        if (DEBUG_ON) {
                                            System.out.println("not enough space for drawers - need to clean up");
                                        }
                                        byte[] byArray2 = (byte[])this._nvramData.clone();
                                        int n15 = this._nvramDataSize;
                                        n14 = this._numDrawers;
                                        Hashtable hashtable7 = (Hashtable)this._drawerIDTable.clone();
                                        object3 = (Hashtable)this._drawerIndexTable.clone();
                                        objectArray = (Hashtable)this._profileNameTable.clone();
                                        cloneable2 = (Hashtable)this._profileNameOffsetTable.clone();
                                        cloneable = (Hashtable)this._profileTable.clone();
                                        Vector vector6 = (Vector)this._pnameFreeList.clone();
                                        Vector vector7 = (Vector)this._dIDFreeList.clone();
                                        int n16 = this._drawerOffsetTail;
                                        short s11 = this._dIDFreeListTail;
                                        this._nvramData = (byte[])byArray.clone();
                                        this._nvramDataSize = n6;
                                        this._numDrawers = s9;
                                        this._drawerIDTable = (Hashtable)hashtable.clone();
                                        this._drawerIndexTable = (Hashtable)hashtable2.clone();
                                        this._profileNameTable = (Hashtable)hashtable3.clone();
                                        this._profileNameOffsetTable = (Hashtable)hashtable4.clone();
                                        this._profileTable = (Hashtable)hashtable5.clone();
                                        this._pnameFreeList = (Vector)vector2.clone();
                                        this._dIDFreeList = (Vector)vector3.clone();
                                        this._drawerOffsetTail = n7;
                                        this._dIDFreeListTail = s10;
                                        try {
                                            this.cleanUp(null);
                                        }
                                        catch (Throwable throwable) {
                                            throwable.printStackTrace();
                                            this._nvramData = (byte[])byArray2.clone();
                                            this._nvramDataSize = n15;
                                            this._numDrawers = (short)n14;
                                            this._drawerIDTable = (Hashtable)hashtable7.clone();
                                            this._drawerIndexTable = (Hashtable)((Hashtable)object3).clone();
                                            this._profileNameTable = (Hashtable)objectArray.clone();
                                            this._profileNameOffsetTable = (Hashtable)((Hashtable)cloneable2).clone();
                                            this._profileTable = (Hashtable)((Hashtable)cloneable).clone();
                                            this._pnameFreeList = (Vector)vector6.clone();
                                            this._dIDFreeList = (Vector)vector7.clone();
                                            this._drawerOffsetTail = n16;
                                            throw throwable;
                                        }
                                        bl6 = true;
                                        bl7 = true;
                                        if ((long)this._drawerOffsetTail >= l3) throw new HSCCIMException("0003");
                                        if ((long)(this._nvramDataSize + 24 + 2) > l3) {
                                            throw new HSCCIMException("0003");
                                        }
                                        byArray = (byte[])this._nvramData.clone();
                                        n6 = this._nvramDataSize;
                                        s9 = this._numDrawers;
                                        hashtable = (Hashtable)this._drawerIDTable.clone();
                                        hashtable2 = (Hashtable)this._drawerIndexTable.clone();
                                        hashtable3 = (Hashtable)this._profileNameTable.clone();
                                        hashtable4 = (Hashtable)this._profileNameOffsetTable.clone();
                                        hashtable5 = (Hashtable)this._profileTable.clone();
                                        vector2 = (Vector)this._pnameFreeList.clone();
                                        vector3 = (Vector)this._dIDFreeList.clone();
                                        n7 = this._drawerOffsetTail;
                                        s10 = this._dIDFreeListTail;
                                        n12 = this._drawerOffsetTail;
                                    }
                                    bl5 = true;
                                    nArray[0] = n7;
                                    if (!vector3.isEmpty()) {
                                        if (DEBUG_ON) {
                                            System.out.println("In createLPARProfile: newDIDFreeList = " + vector3);
                                        }
                                        s8 = (Short)vector3.elementAt(0);
                                        vector3.removeElementAt(0);
                                        nArray[1] = s8;
                                        if (DEBUG_ON) {
                                            System.out.println("In createLPARProfile: (notempty) drawerIndex = " + s8);
                                        }
                                    } else {
                                        if (s10 > 255) {
                                            if (!DEBUG_ON) throw new HSCCIMException("0002");
                                            System.out.println("no more index for drawer");
                                            throw new HSCCIMException("0002");
                                        }
                                        nArray[1] = s10;
                                        if (DEBUG_ON) {
                                            System.out.println("In createLPARProfile: tail drawerIndex = " + s10);
                                        }
                                        s10 = (short)(s10 + 1);
                                    }
                                    byte[] byArray3 = (byte[])byArray.clone();
                                    object2 = this.setLength(string3, 24).getBytes();
                                    n14 = 0;
                                    while (true) {
                                        if (n14 >= 24) {
                                            byArray[n7 + 24 + 0] = (byte)(nArray[1] >>> 8);
                                            byArray[n7 + 24 + 1] = (byte)nArray[1];
                                            if (DEBUG_ON) {
                                                System.out.println("newDrawerOffsetTail = " + n7);
                                            }
                                            break;
                                        }
                                        byArray[n7 + n14] = (byte)object2[n14];
                                        ++n14;
                                    }
                                    int n17 = n7;
                                    while (true) {
                                        if (n17 >= n6) {
                                            s9 = (short)(s9 + 1);
                                            byArray[this.NUM_DRAWERS_OFFSET + 0] = (byte)(s9 >> 8);
                                            byArray[this.NUM_DRAWERS_OFFSET + 1] = (byte)s9;
                                            if (DEBUG_ON) {
                                                System.out.println("In createLPARProfile: newNumDrawer's first byte = " + byArray[this.NUM_DRAWERS_OFFSET]);
                                                System.out.println("In createLPARProfile: newNumDrawer's snd byte = " + byArray[this.NUM_DRAWERS_OFFSET + 1]);
                                                System.out.println("In createLPARProfile: num of drawers = " + s9);
                                                System.out.println("In createLPARProfile: drawerID = " + string3.trim());
                                                System.out.println("In createLPARProfile: drawerIndex = " + nArray[1]);
                                            }
                                            break;
                                        }
                                        byArray[n17 + 24 + 2] = byArray3[n17];
                                        ++n17;
                                    }
                                    object3 = hashtable5.elements();
                                    while (true) {
                                        if (!object3.hasMoreElements()) {
                                            bl6 = false;
                                            n6 += 26;
                                            n7 += 26;
                                            nArray[2] = 1;
                                            hashtable.put(string3, nArray);
                                            hashtable2.put(new Short((short)nArray[1]), string3);
                                            break;
                                        }
                                        objectArray = (Object[])object3.nextElement();
                                        objectArray[0] = new Integer((Integer)objectArray[0] + 24 + 2);
                                    }
                                }
                                if (DEBUG_ON) {
                                    System.out.println("before drawersInfo.containsKey");
                                }
                                Object[] objectArray3 = hashtable6.containsKey(string3) ? (Object[])hashtable6.get(string3) : new Object[]{new Short((short)nArray[1]), new Integer(0), new Integer(0)};
                                short s12 = ((UnsignedInt8)vector4.get(n13)).shortValue();
                                Trace.trace("apnvhscF", "slotNum = " + String.valueOf(s12));
                                if (((String)vector5.get(n13)).equalsIgnoreCase("r")) {
                                    if (DEBUG_ON) {
                                        System.out.println("required");
                                    }
                                    cArray2[32 - s12 - 1] = 49;
                                    string4 = new String(cArray2);
                                    cArray2[32 - s12 - 1] = 48;
                                    n2 = Integer.parseInt(string4, 2);
                                    objectArray3[2] = new Integer((Integer)objectArray3[2] | n2);
                                } else {
                                    if (DEBUG_ON) {
                                        System.out.println("desired");
                                    }
                                    cArray[32 - s12 - 1] = 49;
                                    string4 = new String(cArray);
                                    cArray[32 - s12 - 1] = 48;
                                    n2 = Integer.parseInt(string4, 2);
                                    objectArray3[1] = new Integer((Integer)objectArray3[1] | n2);
                                }
                                hashtable6.put(string3, objectArray3);
                                ++n13;
                            }
                        }
                        s = (short)(26 + hashtable6.size() * 10);
                        if (DEBUG_ON) {
                            System.out.println("In createLPARProfile: profile len = " + s);
                        }
                        long l4 = this.NVRAM_SIZE;
                        if (this._releaseVersion != 0) {
                            l4 = this._bufferedNVRAMSize;
                        }
                        if ((long)(n6 + s) > l4) {
                            byte[] byArray4 = (byte[])this._nvramData.clone();
                            int n18 = this._nvramDataSize;
                            n2 = this._numDrawers;
                            object2 = (Hashtable)this._drawerIDTable.clone();
                            Hashtable hashtable8 = (Hashtable)this._drawerIndexTable.clone();
                            Hashtable hashtable9 = (Hashtable)this._profileNameTable.clone();
                            object3 = (Hashtable)this._profileNameOffsetTable.clone();
                            objectArray = (Object[])this._profileTable.clone();
                            cloneable2 = (Vector)this._pnameFreeList.clone();
                            cloneable = (Vector)this._dIDFreeList.clone();
                            int n19 = this._drawerOffsetTail;
                            short s13 = this._dIDFreeListTail;
                            this._nvramData = (byte[])byArray.clone();
                            this._nvramDataSize = n6;
                            this._numDrawers = s9;
                            this._drawerIDTable = (Hashtable)hashtable.clone();
                            this._drawerIndexTable = (Hashtable)hashtable2.clone();
                            this._profileNameTable = (Hashtable)hashtable3.clone();
                            this._profileNameOffsetTable = (Hashtable)hashtable4.clone();
                            this._profileTable = (Hashtable)hashtable5.clone();
                            this._pnameFreeList = (Vector)vector2.clone();
                            this._dIDFreeList = (Vector)vector3.clone();
                            this._drawerOffsetTail = n7;
                            this._dIDFreeListTail = s10;
                            try {
                                this.cleanUp(null);
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                this._nvramData = (byte[])byArray4.clone();
                                this._nvramDataSize = n18;
                                this._numDrawers = (short)n2;
                                this._drawerIDTable = (Hashtable)((Hashtable)object2).clone();
                                this._drawerIndexTable = (Hashtable)hashtable8.clone();
                                this._profileNameTable = (Hashtable)hashtable9.clone();
                                this._profileNameOffsetTable = (Hashtable)((Hashtable)object3).clone();
                                this._profileTable = (Hashtable)objectArray.clone();
                                this._pnameFreeList = (Vector)((Vector)cloneable2).clone();
                                this._dIDFreeList = (Vector)((Vector)cloneable).clone();
                                this._drawerOffsetTail = n19;
                                throw throwable;
                            }
                            bl6 = true;
                            bl7 = true;
                            if ((long)(this._nvramDataSize + s) > l4) {
                                throw new HSCCIMException("0003");
                            }
                            byArray = (byte[])this._nvramData.clone();
                            n6 = this._nvramDataSize;
                            s9 = this._numDrawers;
                            hashtable = (Hashtable)this._drawerIDTable.clone();
                            hashtable2 = (Hashtable)this._drawerIndexTable.clone();
                            hashtable3 = (Hashtable)this._profileNameTable.clone();
                            hashtable4 = (Hashtable)this._profileNameOffsetTable.clone();
                            hashtable5 = (Hashtable)this._profileTable.clone();
                            vector2 = (Vector)this._pnameFreeList.clone();
                            vector3 = (Vector)this._dIDFreeList.clone();
                            if (n7 != this._drawerOffsetTail) {
                                bl5 = true;
                            }
                            n7 = this._drawerOffsetTail;
                            s10 = this._dIDFreeListTail;
                            n12 = this._drawerOffsetTail;
                        }
                        try {
                            objectArray2 = new Object[3];
                            objectArray2[0] = new Integer(n6);
                            n5 = n6;
                            objectArray2[1] = new Short(s);
                            objectArray2[2] = vector;
                            hashtable5.put(string2, objectArray2);
                            this._profilesAtPartitionTable[n].add(string2);
                            this._nvramBAOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
                            this._nvramDOutputStream = new DataOutputStream(this._nvramBAOutputStream);
                            this._nvramDOutputStream.write(byArray, 0, n6);
                            this._nvramDOutputStream.writeByte((byte)s);
                            this._nvramDOutputStream.writeByte((byte)s2);
                            this._nvramDOutputStream.writeBytes(NVRAM.cryptedTimestamp(string2));
                            this._nvramDOutputStream.writeByte((byte)(bl2 ? 1 : 0));
                            this._nvramDOutputStream.writeShort(n3);
                            this._nvramDOutputStream.writeByte((byte)s3);
                            this._nvramDOutputStream.writeByte((byte)s4);
                            this._nvramDOutputStream.writeByte((byte)s5);
                            this._nvramDOutputStream.writeByte((byte)s6);
                            this._nvramDOutputStream.writeByte((byte)s7);
                            this._nvramDOutputStream.writeInt((int)l);
                            this._nvramDOutputStream.writeInt((int)l2);
                            this._nvramDOutputStream.writeByte((byte)hashtable6.size());
                            if (DEBUG_ON) {
                                System.out.println("In createLPARProfile: num drawers = " + hashtable6.size());
                            }
                            if (hashtable6.size() != 0) {
                                if (DEBUG_ON) {
                                    System.out.println("has drawers!!!");
                                }
                                Enumeration enumeration = hashtable6.keys();
                                while (enumeration.hasMoreElements()) {
                                    if (DEBUG_ON) {
                                        System.out.println("has elements");
                                    }
                                    object = (String)enumeration.nextElement();
                                    n2 = ((Short)((Object[])hashtable6.get(object))[0]).shortValue();
                                    int n20 = (Integer)((Object[])hashtable6.get(object))[1];
                                    int n21 = (Integer)((Object[])hashtable6.get(object))[2];
                                    this._nvramDOutputStream.writeShort(n2);
                                    this._nvramDOutputStream.writeInt(n20);
                                    this._nvramDOutputStream.writeInt(n21);
                                    if (!DEBUG_ON) continue;
                                    System.out.println("In createLPARProfile: drawerID = " + n2);
                                    System.out.println("In createLPARProfile: ioSlots = " + n20);
                                    System.out.println("In createLPARProfile: require = " + n21);
                                }
                            }
                            this._nvramDOutputStream.write(byArray, n6, this.NVRAM_SIZE - (n6 + s));
                            n6 += s;
                            this._nvramDOutputStream.flush();
                            this._nvramData = this._nvramBAOutputStream.toByteArray();
                            if (DEBUG_ON) {
                                System.out.println("In createLPARProfile: _nvramData's length = " + this._nvramData.length);
                            }
                            this._nvramDOutputStream.close();
                            this._nvramBAOutputStream.close();
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                            throw new HSCCIMException("0007");
                        }
                        this._nvramDataSize = n6;
                        this._numDrawers = s9;
                        this._drawerIDTable = (Hashtable)hashtable.clone();
                        this._drawerIndexTable = (Hashtable)hashtable2.clone();
                        this._profileNameTable = (Hashtable)hashtable3.clone();
                        this._profileNameOffsetTable = (Hashtable)hashtable4.clone();
                        this._profileTable = (Hashtable)hashtable5.clone();
                        this._pnameFreeList = (Vector)vector2.clone();
                        this._dIDFreeList = (Vector)vector3.clone();
                        this._drawerOffsetTail = n7;
                        this._dIDFreeListTail = s10;
                        if (bl) {
                            byte by;
                            block79: {
                                Hashtable hashtable10 = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", null, hscProviderSocket, this._cspVersion);
                                object = this.getTime(hashtable10);
                                n2 = 0;
                                while (true) {
                                    if (n2 >= 7) {
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                                        this._nvramTimeStamp = (byte[])object.clone();
                                        if (bl4) {
                                            this._checksumCalc.reset();
                                            this._checksumCalc.update(this._nvramData, this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
                                            this._checksum = this._checksumCalc.getValue();
                                            this.writeIntegralToNvramData(this._checksum, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                                            this._profileNameTableTimeStamp = (byte[])object.clone();
                                        }
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, (short)8);
                                        if (this._releaseVersion != 0) {
                                            int n22 = this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET;
                                            this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = (byte)(n22 >>> 8);
                                            this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = (byte)(n22 & 0xFF);
                                        }
                                        this._drawerProfileInfoTimeStamp = (byte[])object.clone();
                                        this._backupToLocalFile();
                                        by = (byte)(this._releaseVersion << 1 | CORRUPTED_ON[0]);
                                        this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                                        this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, hscProviderSocket);
                                        if (bl4) {
                                            this._writeDataToCSP(new String(this._nvramData, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                            if (DEBUG_ON) {
                                                System.out.println("In createLPARProfile: writing to csp at ProfileNameTable portion");
                                            }
                                            this._writeDataToCSP(this.setLength(string, 32).getBytes(), n4, 32, hscProviderSocket);
                                            if (DEBUG_ON) {
                                                System.out.println("In createLPARProfile: newNameOffset = " + n4);
                                            }
                                            if (DEBUG_ON) {
                                                System.out.println("In createLPARProfile: name = " + string);
                                            }
                                        }
                                        if (this._releaseVersion != 0) break;
                                        this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                        break block79;
                                    }
                                    this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + n2] = (byte)object[n2];
                                    if (bl4) {
                                        this._nvramData[this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + n2] = (byte)object[n2];
                                    }
                                    this._nvramData[this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + n2] = (byte)object[n2];
                                    ++n2;
                                }
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10, hscProviderSocket);
                            }
                            if (bl5) {
                                this._writeDataToCSP(new String(this._nvramData, this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET).getBytes(), this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET, hscProviderSocket);
                            }
                            if (!(bl5 || bl6 || bl7)) {
                                this._writeDataToCSP(new String(this._nvramData, n5, (int)s).getBytes(), n5, s, hscProviderSocket);
                            } else {
                                int n23 = bl6 || bl7 ? this.NVRAM_SIZE - this._drawerOffsetTail : this._nvramDataSize - this._drawerOffsetTail;
                                this._writeDataToCSP(new String(this._nvramData, this._drawerOffsetTail, n23).getBytes(), this._drawerOffsetTail, n23, hscProviderSocket);
                            }
                            by = (byte)(this._releaseVersion << 1 | CORRUPTED_OFF[0]);
                            this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                        }
                    }
                    finally {
                        if (!DEBUG_ON) break block80;
                        System.out.println("End of createLPARProfile");
                        System.out.print("********************");
                        System.out.println("********************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var72_93 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("0017");
            }
        }
        catch (Throwable throwable) {
            Object var72_94 = null;
            Trace.trace("apnvhscT", "<- createLPARProfile");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- createLPARProfile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _createDLPARProfile(int var1_1, String var2_2, String var3_3, Vector var4_4, HscProviderSocket var5_5, boolean var6_6) throws CIMException {
        try {
            try {
                block93: {
                    block94: {
                        Trace.trace("apnvhscT", "-> createDLPARrofile");
                        Trace.trace("apnvhscF", "partitionID = " + String.valueOf(var1_1));
                        Trace.trace("apnvhscF", "name = " + var2_2);
                        Trace.trace("apnvhscF", "profileTimeStamp = " + var3_3);
                        Trace.trace("apnvhscF", "properties = " + var4_4);
                        Trace.trace("apnvhscF", "socket = " + var5_5);
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("********************************************");
                            System.out.println("In createDLPARProfile");
                        }
                        if (var6_6) {
                            this.buildNVRAM(var5_5, false, null, true, false);
                        }
                        var7_7 = 0;
                        var8_9 = 0;
                        var9_10 = false;
                        var10_11 = 0;
                        var11_12 = false;
                        var12_13 = (short)var1_1;
                        var13_14 = 0;
                        var14_15 = 0;
                        var15_16 = 0;
                        var16_17 = 0;
                        var17_18 = 0;
                        var18_19 = 0;
                        var19_20 = 0;
                        var20_21 = 0L;
                        var22_22 = 0L;
                        var24_23 = 0L;
                        var26_24 = new Object[3];
                        var27_25 = 0;
                        var28_26 = new String();
                        var29_27 = false;
                        var30_28 = false;
                        var31_29 = false;
                        var32_30 = false;
                        var33_31 = 0;
                        var34_32 = null;
                        var35_33 = null;
                        var36_34 = 0;
                        var37_35 = 0;
                        var38_36 = 0;
                        var39_37 = (byte[])this._nvramData.clone();
                        var40_38 = this._nvramDataSize;
                        var41_39 = this._numDrawers;
                        var42_40 = (Hashtable)this._drawerIDTable.clone();
                        var43_41 = (Hashtable)this._drawerIndexTable.clone();
                        var44_42 = (Hashtable)this._profileNameTable.clone();
                        var45_43 = (Hashtable)this._profileNameOffsetTable.clone();
                        var46_44 = (Hashtable)this._profileTable.clone();
                        var47_45 = (Vector)this._pnameFreeList.clone();
                        var48_46 = (Vector)this._dIDFreeList.clone();
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("In createLPARProfile: _dIDFreeList = " + this._dIDFreeList);
                        }
                        var49_47 = this._drawerOffsetTail;
                        var50_48 = this._dIDFreeListTail;
                        var8_9 = this._hscTemplateVersion;
                        var9_10 = false;
                        var52_49 = new Hashtable<String, Object[]>();
                        var53_50 = new char[32];
                        var54_51 = new char[32];
                        var55_52 = this._nvramDataSize;
                        var56_53 = 0;
                        while (var56_53 < 32) {
                            var53_50[var56_53] = 48;
                            var54_51[var56_53] = 48;
                            ++var56_53;
                        }
                        if (this.isDuplicatedAtPartition(var1_1, var2_2, var5_5)) {
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("In createLPARProfile: name already exist");
                            }
                            throw new HSCCIMException("0004", new String[]{var2_2, String.valueOf(var1_1)});
                        }
                        var57_54 = var2_2.length();
                        Trace.trace("apnvhscF", "name = " + var2_2);
                        if (var44_42.containsKey(var2_2)) {
                            Trace.trace("apnvhscF", "profileNameTable already contain the name - Just increment the reference count");
                            var51_55 = (int[])var44_42.get(var2_2);
                            var51_55[1] = var51_55[1] + 1;
                            var10_11 = var51_55[0];
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("In createLPARProfile: nameIndex = " + var10_11);
                            }
                        } else {
                            var29_27 = true;
                            var51_55 = new int[2];
                            if (var47_45.isEmpty()) {
                                if (NVRAM.DEBUG_ON == false) throw new HSCCIMException("0001");
                                System.out.println("no more space for name");
                                throw new HSCCIMException("0001");
                            }
                            var51_55[0] = (Integer)var47_45.elementAt(0);
                            var47_45.removeElementAt(0);
                            var51_55[1] = 1;
                            var37_35 = var10_11 = var51_55[0];
                            Trace.trace("apnvhscF", "nameIndex and newNameOffset = " + var10_11);
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("In createLPARProfile: nameIndex = " + var10_11);
                            }
                            var44_42.put(var2_2, var51_55);
                            var45_43.put(new Integer(var10_11), var2_2);
                            var58_56 = this.setLength(var2_2, 32).getBytes();
                            var59_57 = 0;
                            while (var59_57 < 32) {
                                var39_37[var37_35 + var59_57] = var58_56[var59_57];
                                ++var59_57;
                            }
                        }
                        var13_14 = ((UnsignedInt8)((CIMProperty)var4_4.elementAt(2)).getValue().getValue()).shortValue();
                        var14_15 = ((UnsignedInt8)((CIMProperty)var4_4.elementAt(3)).getValue().getValue()).shortValue();
                        var15_16 = ((UnsignedInt8)((CIMProperty)var4_4.elementAt(4)).getValue().getValue()).shortValue();
                        var16_17 = ((UnsignedInt8)((CIMProperty)var4_4.elementAt(5)).getValue().getValue()).shortValue();
                        var17_18 = ((UnsignedInt8)((CIMProperty)var4_4.elementAt(6)).getValue().getValue()).shortValue();
                        var18_19 = ((UnsignedInt8)((CIMProperty)var4_4.elementAt(7)).getValue().getValue()).shortValue();
                        var19_20 = ((UnsignedInt8)((CIMProperty)var4_4.elementAt(8)).getValue().getValue()).shortValue();
                        var20_21 = ((UnsignedInt32)((CIMProperty)var4_4.elementAt(9)).getValue().getValue()).longValue();
                        var22_22 = ((UnsignedInt32)((CIMProperty)var4_4.elementAt(10)).getValue().getValue()).longValue();
                        var24_23 = ((UnsignedInt32)((CIMProperty)var4_4.elementAt(11)).getValue().getValue()).longValue();
                        var58_56 = null;
                        var59_58 = null;
                        var60_59 = null;
                        if (((CIMProperty)var4_4.elementAt(12)).getValue() != null) {
                            var58_56 = (Vector)((CIMProperty)var4_4.elementAt(12)).getValue().getValue();
                            var59_58 = (Vector)((CIMProperty)var4_4.elementAt(13)).getValue().getValue();
                            var60_59 = (Vector)((CIMProperty)var4_4.elementAt(14)).getValue().getValue();
                        }
                        var61_60 = var49_47;
                        if (var58_56 != null && var58_56.size() != 0) {
                            Trace.trace("apnvhscF", "num of drawres = " + String.valueOf(var58_56.size()));
                            var62_61 = 0;
                            while (var62_61 < var58_56.size()) {
                                var28_26 = (String)var58_56.get(var62_61);
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In createLPARProfile: slots = " + var28_26);
                                }
                                if (var42_40.containsKey(var28_26)) {
                                    var51_55 = (int[])var42_40.get(var28_26);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In createLPARProfile: already contain this drawerID");
                                        System.out.println("In createLPARProfile: drawerID = " + var28_26.trim() + " drawerIndex = " + var51_55[1]);
                                    }
                                    var51_55[2] = var51_55[2] + 1;
                                } else {
                                    var51_55 = new int[3];
                                    var64_65 = this.NVRAM_SIZE;
                                    if (this._releaseVersion != 0) {
                                        var64_65 = this._bufferedNVRAMSize;
                                    }
                                    if ((long)var49_47 >= var64_65 || (long)(var40_38 + 24 + 2) > var64_65) {
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("not enough space for drawers - need to clean up");
                                        }
                                        var66_78 = (byte[])this._nvramData.clone();
                                        var67_81 = this._nvramDataSize;
                                        var68_83 = this._numDrawers;
                                        var69_90 = (Hashtable)this._drawerIDTable.clone();
                                        var70_93 = (Hashtable)this._drawerIndexTable.clone();
                                        var71_94 = (Hashtable)this._profileNameTable.clone();
                                        var72_95 = (Hashtable)this._profileNameOffsetTable.clone();
                                        var73_96 = (Hashtable)this._profileTable.clone();
                                        var74_97 = (Vector)this._pnameFreeList.clone();
                                        var75_99 = (Vector)this._dIDFreeList.clone();
                                        var76_101 = this._drawerOffsetTail;
                                        var77_103 = this._dIDFreeListTail;
                                        this._nvramData = (byte[])var39_37.clone();
                                        this._nvramDataSize = var40_38;
                                        this._numDrawers = var41_39;
                                        this._drawerIDTable = (Hashtable)var42_40.clone();
                                        this._drawerIndexTable = (Hashtable)var43_41.clone();
                                        this._profileNameTable = (Hashtable)var44_42.clone();
                                        this._profileNameOffsetTable = (Hashtable)var45_43.clone();
                                        this._profileTable = (Hashtable)var46_44.clone();
                                        this._pnameFreeList = (Vector)var47_45.clone();
                                        this._dIDFreeList = (Vector)var48_46.clone();
                                        this._drawerOffsetTail = var49_47;
                                        this._dIDFreeListTail = var50_48;
                                        try {
                                            this.cleanUp(null);
                                        }
                                        catch (Throwable var78_104) {
                                            var78_104.printStackTrace();
                                            this._nvramData = (byte[])var66_78.clone();
                                            this._nvramDataSize = var67_81;
                                            this._numDrawers = (short)var68_83;
                                            this._drawerIDTable = (Hashtable)var69_90.clone();
                                            this._drawerIndexTable = (Hashtable)var70_93.clone();
                                            this._profileNameTable = (Hashtable)var71_94.clone();
                                            this._profileNameOffsetTable = (Hashtable)var72_95.clone();
                                            this._profileTable = (Hashtable)var73_96.clone();
                                            this._pnameFreeList = (Vector)var74_97.clone();
                                            this._dIDFreeList = (Vector)var75_99.clone();
                                            this._drawerOffsetTail = var76_101;
                                            throw var78_104;
                                        }
                                        var31_29 = true;
                                        var32_30 = true;
                                        if ((long)this._drawerOffsetTail >= var64_65) throw new HSCCIMException("0003");
                                        if ((long)(this._nvramDataSize + 24 + 2) > var64_65) {
                                            throw new HSCCIMException("0003");
                                        }
                                        var39_37 = (byte[])this._nvramData.clone();
                                        var40_38 = this._nvramDataSize;
                                        var41_39 = this._numDrawers;
                                        var42_40 = (Hashtable)this._drawerIDTable.clone();
                                        var43_41 = (Hashtable)this._drawerIndexTable.clone();
                                        var44_42 = (Hashtable)this._profileNameTable.clone();
                                        var45_43 = (Hashtable)this._profileNameOffsetTable.clone();
                                        var46_44 = (Hashtable)this._profileTable.clone();
                                        var47_45 = (Vector)this._pnameFreeList.clone();
                                        var48_46 = (Vector)this._dIDFreeList.clone();
                                        var49_47 = this._drawerOffsetTail;
                                        var50_48 = this._dIDFreeListTail;
                                        var61_60 = this._drawerOffsetTail;
                                    }
                                    var30_28 = true;
                                    var51_55[0] = var49_47;
                                    if (!var48_46.isEmpty()) {
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In createLPARProfile: newDIDFreeList = " + var48_46);
                                        }
                                        var27_25 = (Short)var48_46.elementAt(0);
                                        var48_46.removeElementAt(0);
                                        var51_55[1] = var27_25;
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In createLPARProfile: (notempty) drawerIndex = " + var27_25);
                                        }
                                    } else {
                                        if (var50_48 > 255) {
                                            if (NVRAM.DEBUG_ON == false) throw new HSCCIMException("0002");
                                            System.out.println("no more index for drawer");
                                            throw new HSCCIMException("0002");
                                        }
                                        var51_55[1] = var50_48;
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In createLPARProfile: tail drawerIndex = " + var50_48);
                                        }
                                        var50_48 = (short)(var50_48 + 1);
                                    }
                                    var66_79 = (byte[])var39_37.clone();
                                    var67_80 = this.setLength(var28_26, 24).getBytes();
                                    var68_83 = 0;
                                    while (var68_83 < 24) {
                                        var39_37[var49_47 + var68_83] = (byte)var67_80[var68_83];
                                        ++var68_83;
                                    }
                                    var39_37[var49_47 + 24 + 0] = (byte)(var51_55[1] >>> 8);
                                    var39_37[var49_47 + 24 + 1] = (byte)var51_55[1];
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("newDrawerOffsetTail = " + var49_47);
                                    }
                                    var69_89 = var49_47;
                                    while (var69_89 < var40_38) {
                                        var39_37[var69_89 + 24 + 2] = var66_79[var69_89];
                                        ++var69_89;
                                    }
                                    var41_39 = (short)(var41_39 + 1);
                                    var39_37[this.NUM_DRAWERS_OFFSET + 0] = (byte)(var41_39 >> 8);
                                    var39_37[this.NUM_DRAWERS_OFFSET + 1] = (byte)var41_39;
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In createLPARProfile: newNumDrawer's first byte = " + var39_37[this.NUM_DRAWERS_OFFSET]);
                                        System.out.println("In createLPARProfile: newNumDrawer's snd byte = " + var39_37[this.NUM_DRAWERS_OFFSET + 1]);
                                        System.out.println("In createLPARProfile: num of drawers = " + var41_39);
                                        System.out.println("In createLPARProfile: drawerID = " + var28_26.trim());
                                        System.out.println("In createLPARProfile: drawerIndex = " + var51_55[1]);
                                    }
                                    var70_93 = var46_44.elements();
                                    while (var70_93.hasMoreElements()) {
                                        var71_94 = (Object[])var70_93.nextElement();
                                        var71_94[0] = new Integer((Integer)var71_94[0] + 24 + 2);
                                    }
                                    var31_29 = false;
                                    var40_38 += 26;
                                    var49_47 += 26;
                                    var51_55[2] = 1;
                                    var42_40.put(var28_26, var51_55);
                                    var43_41.put(new Short((short)var51_55[1]), var28_26);
                                }
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("before drawersInfo.containsKey");
                                }
                                var63_63 = var52_49.containsKey(var28_26) != false ? (Object[])var52_49.get(var28_26) : new Object[]{new Short((short)var51_55[1]), new Integer(0), new Integer(0)};
                                var64_64 = ((UnsignedInt8)var59_58.get(var62_61)).shortValue();
                                Trace.trace("apnvhscF", "slotNum = " + String.valueOf(var64_64));
                                if (((String)var60_59.get(var62_61)).equalsIgnoreCase("r")) {
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("required");
                                    }
                                    var54_51[32 - var64_64 - 1] = 49;
                                    var65_71 = new String(var54_51);
                                    var54_51[32 - var64_64 - 1] = 48;
                                    var66_77 = Integer.parseInt(var65_71, 2);
                                    var63_63[2] = new Integer((Integer)var63_63[2] | var66_77);
                                } else {
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("desired");
                                    }
                                    var53_50[32 - var64_64 - 1] = 49;
                                    var65_71 = new String(var53_50);
                                    var53_50[32 - var64_64 - 1] = 48;
                                    var66_77 = Integer.parseInt(var65_71, 2);
                                    var63_63[1] = new Integer((Integer)var63_63[1] | var66_77);
                                }
                                var52_49.put(var28_26, var63_63);
                                ++var62_61;
                            }
                        }
                        var7_7 = this._releaseVersion < 3 ? (short)(33 + var52_49.size() * 10) : (short)(36 + var52_49.size() * 10);
                        if (this._releaseVersion > 2) {
                            if (((CIMProperty)var4_4.elementAt(15)).getValue() != null) {
                                var33_31 = ((UnsignedInt8)((CIMProperty)var4_4.elementAt(15)).getValue().getValue()).shortValue();
                                var34_32 = (Vector)((CIMProperty)var4_4.elementAt(16)).getValue().getValue();
                                var35_33 = (Vector)((CIMProperty)var4_4.elementAt(17)).getValue().getValue();
                            }
                            var36_34 = var34_32 == null ? 0 : (int)var34_32.size();
                            var7_7 = var36_34 == 0 ? (short)(var7_7 + 1) : (short)(var7_7 + 2 + var36_34 * 4 * 1 + var36_34 * 2 * 1);
                        }
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("In createLPARProfile: profile len = " + var7_7);
                        }
                        var62_62 = this.NVRAM_SIZE;
                        if (this._releaseVersion != 0) {
                            var62_62 = this._bufferedNVRAMSize;
                        }
                        if ((long)(var40_38 + var7_7) > var62_62) {
                            var64_66 = (byte[])this._nvramData.clone();
                            var65_72 = this._nvramDataSize;
                            var66_77 = this._numDrawers;
                            var67_80 = (Hashtable)this._drawerIDTable.clone();
                            var68_84 = (Hashtable)this._drawerIndexTable.clone();
                            var69_91 = (Hashtable)this._profileNameTable.clone();
                            var70_93 = (Hashtable)this._profileNameOffsetTable.clone();
                            var71_94 = (Object[])this._profileTable.clone();
                            var72_95 = (Vector)this._pnameFreeList.clone();
                            var73_96 = (Vector)this._dIDFreeList.clone();
                            var74_98 = this._drawerOffsetTail;
                            var75_100 = this._dIDFreeListTail;
                            this._nvramData = (byte[])var39_37.clone();
                            this._nvramDataSize = var40_38;
                            this._numDrawers = var41_39;
                            this._drawerIDTable = (Hashtable)var42_40.clone();
                            this._drawerIndexTable = (Hashtable)var43_41.clone();
                            this._profileNameTable = (Hashtable)var44_42.clone();
                            this._profileNameOffsetTable = (Hashtable)var45_43.clone();
                            this._profileTable = (Hashtable)var46_44.clone();
                            this._pnameFreeList = (Vector)var47_45.clone();
                            this._dIDFreeList = (Vector)var48_46.clone();
                            this._drawerOffsetTail = var49_47;
                            this._dIDFreeListTail = var50_48;
                            try {
                                this.cleanUp(null);
                            }
                            catch (Throwable var76_102) {
                                var76_102.printStackTrace();
                                this._nvramData = (byte[])var64_66.clone();
                                this._nvramDataSize = var65_72;
                                this._numDrawers = (short)var66_77;
                                this._drawerIDTable = (Hashtable)var67_80.clone();
                                this._drawerIndexTable = (Hashtable)var68_84.clone();
                                this._profileNameTable = (Hashtable)var69_91.clone();
                                this._profileNameOffsetTable = (Hashtable)var70_93.clone();
                                this._profileTable = (Hashtable)var71_94.clone();
                                this._pnameFreeList = (Vector)var72_95.clone();
                                this._dIDFreeList = (Vector)var73_96.clone();
                                this._drawerOffsetTail = var74_98;
                                throw var76_102;
                            }
                            var31_29 = true;
                            var32_30 = true;
                            if ((long)(this._nvramDataSize + var7_7) > var62_62) {
                                throw new HSCCIMException("0003");
                            }
                            var39_37 = (byte[])this._nvramData.clone();
                            var40_38 = this._nvramDataSize;
                            var41_39 = this._numDrawers;
                            var42_40 = (Hashtable)this._drawerIDTable.clone();
                            var43_41 = (Hashtable)this._drawerIndexTable.clone();
                            var44_42 = (Hashtable)this._profileNameTable.clone();
                            var45_43 = (Hashtable)this._profileNameOffsetTable.clone();
                            var46_44 = (Hashtable)this._profileTable.clone();
                            var47_45 = (Vector)this._pnameFreeList.clone();
                            var48_46 = (Vector)this._dIDFreeList.clone();
                            if (var49_47 != this._drawerOffsetTail) {
                                var30_28 = true;
                            }
                            var49_47 = this._drawerOffsetTail;
                            var50_48 = this._dIDFreeListTail;
                            var61_60 = this._drawerOffsetTail;
                        }
                        try {
                            var26_24 = new Object[3];
                            var26_24[0] = new Integer(var40_38);
                            var38_36 = var40_38;
                            var26_24[1] = new Short(var7_7);
                            var26_24[2] = var4_4;
                            var46_44.put(var3_3, var26_24);
                            this._profilesAtPartitionTable[var1_1].add(var3_3);
                            this._nvramBAOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
                            this._nvramDOutputStream = new DataOutputStream(this._nvramBAOutputStream);
                            this._nvramDOutputStream.write(var39_37, 0, var40_38);
                            if (this._releaseVersion < 3) {
                                this._nvramDOutputStream.writeByte((byte)var7_7);
                            } else {
                                this._nvramDOutputStream.writeShort(var7_7);
                            }
                            this._nvramDOutputStream.writeByte((byte)var8_9);
                            this._nvramDOutputStream.writeBytes(NVRAM.cryptedTimestamp(var3_3));
                            this._nvramDOutputStream.writeByte((byte)var9_10);
                            if (this._releaseVersion < 3) {
                                this._nvramDOutputStream.writeShort((short)var10_11);
                            } else {
                                this._nvramDOutputStream.writeInt(var10_11);
                            }
                            this._nvramDOutputStream.writeByte((byte)var12_13);
                            this._nvramDOutputStream.writeByte((byte)var13_14);
                            this._nvramDOutputStream.writeByte((byte)var14_15);
                            this._nvramDOutputStream.writeByte((byte)var15_16);
                            this._nvramDOutputStream.writeByte((byte)var16_17);
                            this._nvramDOutputStream.writeByte((byte)var17_18);
                            this._nvramDOutputStream.writeByte((byte)var18_19);
                            this._nvramDOutputStream.writeByte((byte)var19_20);
                            this._nvramDOutputStream.writeInt((int)var20_21);
                            this._nvramDOutputStream.writeInt((int)var22_22);
                            this._nvramDOutputStream.writeInt((int)var24_23);
                            this._nvramDOutputStream.writeByte((byte)var52_49.size());
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("In createLPARProfile: num drawers = " + var52_49.size());
                            }
                            if (var52_49.size() != 0) {
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("has drawers!!!");
                                }
                                var64_67 = var52_49.keys();
                                while (var64_67.hasMoreElements()) {
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("has elements");
                                    }
                                    var65_73 = (String)var64_67.nextElement();
                                    var66_77 = ((Short)((Object[])var52_49.get(var65_73))[0]).shortValue();
                                    var67_82 = (Integer)((Object[])var52_49.get(var65_73))[1];
                                    var68_86 = (Integer)((Object[])var52_49.get(var65_73))[2];
                                    this._nvramDOutputStream.writeShort(var66_77);
                                    this._nvramDOutputStream.writeInt(var67_82);
                                    this._nvramDOutputStream.writeInt(var68_86);
                                    if (!NVRAM.DEBUG_ON) continue;
                                    System.out.println("In createLPARProfile: drawerID = " + var66_77);
                                    System.out.println("In createLPARProfile: ioSlots = " + var67_82);
                                    System.out.println("In createLPARProfile: require = " + var68_86);
                                }
                            }
                            if (this._releaseVersion > 2) {
                                this._nvramDOutputStream.writeByte((byte)var36_34);
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In _createDLPARProfile: Number SMA Adapters = " + var36_34);
                                }
                                if (var36_34 > 0) {
                                    this._nvramDOutputStream.writeByte((byte)var33_31);
                                    System.out.println("SMA Mode = " + var33_31);
                                    var64_68 = 0;
                                    while (var64_68 < var36_34) {
                                        var65_74 = Long.parseLong((String)var34_32.elementAt(var64_68));
                                        this._nvramDOutputStream.writeInt((int)var65_74);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In _createDLPARProfile: SMA Adapter ID = " + var65_74);
                                        }
                                        ++var64_68;
                                    }
                                    var65_75 = 0;
                                    while (var65_75 < var36_34) {
                                        var66_77 = ((UnsignedInt16)var35_33.elementAt(var65_75)).shortValue();
                                        this._nvramDOutputStream.writeShort(var66_77);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("In _createDLPARProfile: SMA Adapter Number of Windows = " + var66_77);
                                        }
                                        ++var65_75;
                                    }
                                }
                            }
                            this._nvramDOutputStream.write(var39_37, var40_38, this.NVRAM_SIZE - (var40_38 + var7_7));
                            var40_38 += var7_7;
                            this._nvramDOutputStream.flush();
                            this._nvramData = this._nvramBAOutputStream.toByteArray();
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("In createLPARProfile: _nvramData's length = " + this._nvramData.length);
                            }
                            this._nvramDOutputStream.close();
                            this._nvramBAOutputStream.close();
                        }
                        catch (Throwable var64_69) {
                            var64_69.printStackTrace();
                            HSCLogUtils.serverLog(var64_69, HSCLogUtils._NVRAMClassLogInfo);
                            throw new HSCCIMException("0007");
                        }
                        this._nvramDataSize = var40_38;
                        this._numDrawers = var41_39;
                        this._drawerIDTable = (Hashtable)var42_40.clone();
                        this._drawerIndexTable = (Hashtable)var43_41.clone();
                        this._profileNameTable = (Hashtable)var44_42.clone();
                        this._profileNameOffsetTable = (Hashtable)var45_43.clone();
                        this._profileTable = (Hashtable)var46_44.clone();
                        this._pnameFreeList = (Vector)var47_45.clone();
                        this._dIDFreeList = (Vector)var48_46.clone();
                        this._drawerOffsetTail = var49_47;
                        this._dIDFreeListTail = var50_48;
                        if (!var6_6) break block94;
                        var64_70 = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", null, var5_5, this._cspVersion);
                        var65_76 = this.getTime(var64_70);
                        var66_77 = 0;
                        if (true) ** GOTO lbl490
                    }
                    finally {
                        if (!NVRAM.DEBUG_ON) break block93;
                        System.out.println("End of createLPARProfile");
                        System.out.print("********************");
                        System.out.println("********************");
                        System.out.println();
                        System.out.println();
                    }
                }
                var81_105 = null;
                Trace.trace("apnvhscT", "<- createDLPARProfile");
                return;
                do {
                    this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + var66_77] = var65_76[var66_77];
                    if (var29_27) {
                        this._nvramData[this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + var66_77] = var65_76[var66_77];
                    }
                    this._nvramData[this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + var66_77] = var65_76[var66_77];
                    ++var66_77;
lbl490:
                    // 2 sources

                } while (var66_77 < 7);
                this._checksumCalc.reset();
                this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                this._checksum = this._checksumCalc.getValue();
                this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                this._nvramTimeStamp = (byte[])var65_76.clone();
                if (var29_27) {
                    this._checksumCalc.reset();
                    this._checksumCalc.update(this._nvramData, this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
                    this._checksum = this._checksumCalc.getValue();
                    this.writeIntegralToNvramData(this._checksum, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                    this._profileNameTableTimeStamp = (byte[])var65_76.clone();
                }
                this._checksumCalc.reset();
                this._checksumCalc.update(this._nvramData, this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET);
                this._checksum = this._checksumCalc.getValue();
                this.writeIntegralToNvramData(this._checksum, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, (short)8);
                if (this._releaseVersion != 0) {
                    var68_87 = this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET;
                    if (this._releaseVersion < 3) {
                        this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = (byte)(var68_87 >>> 8);
                        this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = (byte)(var68_87 & 255);
                    } else {
                        this.writeIntToNvramData(var68_87, this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET);
                    }
                }
                this._drawerProfileInfoTimeStamp = (byte[])var65_76.clone();
                this._backupToLocalFile();
                var68_88 = (byte)(this._releaseVersion << 1 | NVRAM.CORRUPTED_ON[0]);
                this._writeDataToCSP(new byte[]{var68_88}, this.CORRUPTED_BYTE_OFFSET, 1, var5_5);
                this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, var5_5);
                if (var29_27) {
                    this._writeDataToCSP(new String(this._nvramData, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8, var5_5);
                    if (NVRAM.DEBUG_ON) {
                        System.out.println("In createLPARProfile: writing to csp at ProfileNameTable portion");
                    }
                    this._writeDataToCSP(this.setLength(var2_2, 32).getBytes(), var37_35, 32, var5_5);
                    if (NVRAM.DEBUG_ON) {
                        System.out.println("In createLPARProfile: newNameOffset = " + var37_35);
                    }
                    if (NVRAM.DEBUG_ON) {
                        System.out.println("In createLPARProfile: name = " + var2_2);
                    }
                }
                if (this._releaseVersion == 0) {
                    this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8, var5_5);
                } else if (this._releaseVersion < 3) {
                    this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10, var5_5);
                } else {
                    this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12, var5_5);
                }
                if (var30_28) {
                    this._writeDataToCSP(new String(this._nvramData, this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET).getBytes(), this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET, var5_5);
                }
                if (!(var30_28 || var31_29 || var32_30)) {
                    this._writeDataToCSP(new String(this._nvramData, var38_36, (int)var7_7).getBytes(), var38_36, var7_7, var5_5);
                } else {
                    var69_92 = var31_29 != false || var32_30 != false ? this.NVRAM_SIZE - this._drawerOffsetTail : this._nvramDataSize - this._drawerOffsetTail;
                    this._writeDataToCSP(new String(this._nvramData, this._drawerOffsetTail, var69_92).getBytes(), this._drawerOffsetTail, var69_92, var5_5);
                }
                var68_88 = (byte)(this._releaseVersion << 1 | NVRAM.CORRUPTED_OFF[0]);
                this._writeDataToCSP(new byte[]{var68_88}, this.CORRUPTED_BYTE_OFFSET, 1, var5_5);
            }
            catch (Throwable var7_8) {
                var7_8.printStackTrace();
                HSCLogUtils.serverLog(var7_8, HSCLogUtils._NVRAMClassLogInfo);
                if (var7_8 instanceof HSCCIMException != false) throw new HSCCIMException(var7_8);
                throw new HSCCIMException("0017");
            }
        }
        catch (Throwable var80_108) {
            var81_106 = null;
            Trace.trace("apnvhscT", "<- createDLPARProfile");
            throw var80_108;
        }
    }

    public synchronized void createSysProfile(String string, String string2, Vector vector, HscProviderSocket hscProviderSocket) throws CIMException {
        this._createSysProfile(string, string2, vector, hscProviderSocket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _createSysProfile(String string, String string2, Vector vector, HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        try {
            try {
                block53: {
                    Trace.trace("apnvhscT", "-> createSysProfile");
                    Trace.trace("apnvhscF", "name = " + string);
                    Trace.trace("apnvhscF", "profileTimeStamp = " + string2);
                    Trace.trace("apnvhscF", "properties = " + vector);
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("********************************************");
                        System.out.println("In createSysProfile");
                    }
                    try {
                        byte[] byArray;
                        boolean bl2;
                        int n;
                        int n2;
                        boolean bl3;
                        boolean bl4;
                        boolean bl5;
                        short s;
                        block52: {
                            int n3;
                            Object object;
                            Object object2;
                            int[] nArray;
                            if (bl) {
                                this.buildNVRAM(hscProviderSocket, false, null, true, false);
                            }
                            s = 0;
                            short s2 = 0;
                            boolean bl6 = true;
                            int n4 = 0;
                            Object[] objectArray = new Object[3];
                            boolean bl7 = false;
                            bl5 = false;
                            bl4 = false;
                            bl3 = false;
                            n2 = 0;
                            n = 0;
                            byte[] byArray2 = (byte[])this._nvramData.clone();
                            int n5 = this._nvramDataSize;
                            short s3 = this._numDrawers;
                            Hashtable hashtable = (Hashtable)this._drawerIDTable.clone();
                            Hashtable hashtable2 = (Hashtable)this._drawerIndexTable.clone();
                            Hashtable hashtable3 = (Hashtable)this._profileNameTable.clone();
                            Hashtable hashtable4 = (Hashtable)this._profileNameOffsetTable.clone();
                            Hashtable hashtable5 = (Hashtable)this._profileTable.clone();
                            Vector vector2 = (Vector)this._pnameFreeList.clone();
                            Vector vector3 = (Vector)this._dIDFreeList.clone();
                            if (DEBUG_ON) {
                                System.out.println("In createSysProfile: _dIDFreeList = " + this._dIDFreeList);
                            }
                            int n6 = this._drawerOffsetTail;
                            short s4 = this._dIDFreeListTail;
                            s2 = this._hscTemplateVersion;
                            bl6 = true;
                            int n7 = this._nvramDataSize;
                            int n8 = 0;
                            bl2 = false;
                            int n9 = n6;
                            if (this.isDuplicatedAtPartition(0, string, hscProviderSocket)) {
                                if (DEBUG_ON) {
                                    System.out.println("In createSysProfile: name already exist");
                                }
                                throw new HSCCIMException("0004", new String[]{string, String.valueOf(0)});
                            }
                            int n10 = string.length();
                            Trace.trace("apnvhscF", "name = " + string);
                            if (hashtable3.containsKey(string)) {
                                Trace.trace("apnvhscF", "profileNameTable already contain the name - Just increment the reference count");
                                nArray = (int[])hashtable3.get(string);
                                nArray[1] = nArray[1] + 1;
                                n4 = nArray[0];
                                if (DEBUG_ON) {
                                    System.out.println("In createSysProfile: nameIndex = " + n4);
                                }
                            } else {
                                bl5 = true;
                                nArray = new int[2];
                                if (vector2.isEmpty()) {
                                    if (!DEBUG_ON) throw new HSCCIMException("0001");
                                    System.out.println("no more space for name");
                                    throw new HSCCIMException("0001");
                                }
                                nArray[0] = (Integer)vector2.elementAt(0);
                                vector2.removeElementAt(0);
                                nArray[1] = 1;
                                n2 = n4 = nArray[0];
                                if (DEBUG_ON) {
                                    System.out.println("In createSysProfile: nameIndex = " + n4);
                                }
                                hashtable3.put(string, nArray);
                                hashtable4.put(new Integer(n4), string);
                                object2 = this.setLength(string, 32).getBytes();
                                int n11 = 0;
                                while (n11 < 32) {
                                    byArray2[n2 + n11] = (byte)object2[n11];
                                    ++n11;
                                }
                            }
                            object2 = null;
                            Vector vector4 = null;
                            if (vector.size() == 4 && (vector.elementAt(3) != null || ((CIMProperty)vector.elementAt(3)).getValue() != null)) {
                                object2 = (Vector)((CIMProperty)vector.elementAt(3)).getValue().getValue();
                                Trace.trace("apnvhscF", "partitionIDList = " + object2);
                                vector4 = (Vector)((CIMProperty)vector.elementAt(2)).getValue().getValue();
                                Trace.trace("apnvhscF", "profileList = " + vector4);
                                n8 = object2 == null ? 0 : (int)((byte)((Vector)object2).size());
                            }
                            s = this._releaseVersion < 3 ? (short)(13 + n8 * 6) : (short)(16 + n8 * 6);
                            if (DEBUG_ON) {
                                System.out.println("In createSysProfile: profile len = " + s);
                            }
                            long l = this.NVRAM_SIZE;
                            if (this._releaseVersion != 0) {
                                l = this._bufferedNVRAMSize;
                            }
                            if ((long)(n5 + s) > l) {
                                byte[] byArray3 = (byte[])this._nvramData.clone();
                                int n12 = this._nvramDataSize;
                                short s5 = this._numDrawers;
                                object = (Hashtable)this._drawerIDTable.clone();
                                Hashtable hashtable6 = (Hashtable)this._drawerIndexTable.clone();
                                Hashtable hashtable7 = (Hashtable)this._profileNameTable.clone();
                                Hashtable hashtable8 = (Hashtable)this._profileNameOffsetTable.clone();
                                Hashtable hashtable9 = (Hashtable)this._profileTable.clone();
                                Vector vector5 = (Vector)this._pnameFreeList.clone();
                                Vector vector6 = (Vector)this._dIDFreeList.clone();
                                int n13 = this._drawerOffsetTail;
                                short s6 = this._dIDFreeListTail;
                                this._nvramData = (byte[])byArray2.clone();
                                this._nvramDataSize = n5;
                                this._numDrawers = s3;
                                this._drawerIDTable = (Hashtable)hashtable.clone();
                                this._drawerIndexTable = (Hashtable)hashtable2.clone();
                                this._profileNameTable = (Hashtable)hashtable3.clone();
                                this._profileNameOffsetTable = (Hashtable)hashtable4.clone();
                                this._profileTable = (Hashtable)hashtable5.clone();
                                this._pnameFreeList = (Vector)vector2.clone();
                                this._dIDFreeList = (Vector)vector3.clone();
                                this._drawerOffsetTail = n6;
                                this._dIDFreeListTail = s4;
                                try {
                                    this.cleanUp(null);
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                    this._nvramData = (byte[])byArray3.clone();
                                    this._nvramDataSize = n12;
                                    this._numDrawers = s5;
                                    this._drawerIDTable = (Hashtable)((Hashtable)object).clone();
                                    this._drawerIndexTable = (Hashtable)hashtable6.clone();
                                    this._profileNameTable = (Hashtable)hashtable7.clone();
                                    this._profileNameOffsetTable = (Hashtable)hashtable8.clone();
                                    this._profileTable = (Hashtable)hashtable9.clone();
                                    this._pnameFreeList = (Vector)vector5.clone();
                                    this._dIDFreeList = (Vector)vector6.clone();
                                    this._drawerOffsetTail = n13;
                                    throw throwable;
                                }
                                bl4 = true;
                                bl3 = true;
                                if ((long)(this._nvramDataSize + s) > l) {
                                    throw new HSCCIMException("0003");
                                }
                                byArray2 = (byte[])this._nvramData.clone();
                                n5 = this._nvramDataSize;
                                s3 = this._numDrawers;
                                hashtable = (Hashtable)this._drawerIDTable.clone();
                                hashtable2 = (Hashtable)this._drawerIndexTable.clone();
                                hashtable3 = (Hashtable)this._profileNameTable.clone();
                                hashtable4 = (Hashtable)this._profileNameOffsetTable.clone();
                                hashtable5 = (Hashtable)this._profileTable.clone();
                                vector2 = (Vector)this._pnameFreeList.clone();
                                vector3 = (Vector)this._dIDFreeList.clone();
                                if (n6 != this._drawerOffsetTail) {
                                    bl2 = true;
                                }
                                n6 = this._drawerOffsetTail;
                                s4 = this._dIDFreeListTail;
                                n9 = this._drawerOffsetTail;
                            }
                            try {
                                objectArray = new Object[3];
                                objectArray[0] = new Integer(n5);
                                n = n5;
                                objectArray[1] = new Short(s);
                                objectArray[2] = vector;
                                hashtable5.put(string2, objectArray);
                                this._profilesAtPartitionTable[0].add(string2);
                                this._nvramBAOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
                                this._nvramDOutputStream = new DataOutputStream(this._nvramBAOutputStream);
                                this._nvramDOutputStream.write(byArray2, 0, n5);
                                if (this._releaseVersion < 3) {
                                    this._nvramDOutputStream.writeByte((byte)s);
                                } else {
                                    this._nvramDOutputStream.writeShort(s);
                                }
                                this._nvramDOutputStream.writeByte((byte)s2);
                                this._nvramDOutputStream.writeBytes(NVRAM.cryptedTimestamp(string2));
                                this._nvramDOutputStream.writeByte((byte)(bl6 ? 1 : 0));
                                if (this._releaseVersion < 3) {
                                    this._nvramDOutputStream.writeShort((short)n4);
                                } else {
                                    this._nvramDOutputStream.writeInt(n4);
                                }
                                this._nvramDOutputStream.writeByte(n8);
                                if (n8 != 0) {
                                    int n14 = 0;
                                    while (n14 < ((Vector)object2).size()) {
                                        UnsignedInt8 unsignedInt8 = (UnsignedInt8)((Vector)object2).elementAt(n14);
                                        String string3 = (String)vector4.elementAt(n14);
                                        object = NVRAM.encodeTime(NVRAM.cryptedTimestamp(string3));
                                        this._nvramDOutputStream.writeByte(unsignedInt8.byteValue());
                                        this._nvramDOutputStream.writeBytes(new String((byte[])object));
                                        ++n14;
                                    }
                                }
                                this._nvramDOutputStream.write(byArray2, n5, this.NVRAM_SIZE - (n5 + s));
                                n5 += s;
                                this._nvramDOutputStream.flush();
                                this._nvramData = this._nvramBAOutputStream.toByteArray();
                                if (DEBUG_ON) {
                                    System.out.println("In createSysProfile: _nvramData's length = " + this._nvramData.length);
                                }
                                this._nvramDOutputStream.close();
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                                throw new HSCCIMException("0007");
                            }
                            this._nvramDataSize = n5;
                            this._numDrawers = s3;
                            this._drawerIDTable = (Hashtable)hashtable.clone();
                            this._drawerIndexTable = (Hashtable)hashtable2.clone();
                            this._profileNameTable = (Hashtable)hashtable3.clone();
                            this._profileNameOffsetTable = (Hashtable)hashtable4.clone();
                            this._profileTable = (Hashtable)hashtable5.clone();
                            this._pnameFreeList = (Vector)vector2.clone();
                            this._dIDFreeList = (Vector)vector3.clone();
                            this._drawerOffsetTail = n6;
                            this._dIDFreeListTail = s4;
                            Hashtable hashtable10 = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", null, hscProviderSocket, this._cspVersion);
                            byArray = this.getTime(hashtable10);
                            int n15 = 0;
                            while (true) {
                                if (n15 >= 7) {
                                    this._checksumCalc.reset();
                                    this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                                    this._checksum = this._checksumCalc.getValue();
                                    this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                                    this._nvramTimeStamp = (byte[])byArray.clone();
                                    if (bl5) {
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                                        this._profileNameTableTimeStamp = (byte[])byArray.clone();
                                    }
                                    this._checksumCalc.reset();
                                    this._checksumCalc.update(this._nvramData, this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET);
                                    this._checksum = this._checksumCalc.getValue();
                                    this.writeIntegralToNvramData(this._checksum, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, (short)8);
                                    if (this._releaseVersion != 0) {
                                        n3 = this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET;
                                        if (this._releaseVersion >= 3) break;
                                        this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = (byte)(n3 >>> 8);
                                        this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = (byte)(n3 & 0xFF);
                                    }
                                    break block52;
                                }
                                this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + n15] = byArray[n15];
                                if (bl5) {
                                    this._nvramData[this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + n15] = byArray[n15];
                                }
                                this._nvramData[this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + n15] = byArray[n15];
                                ++n15;
                            }
                            this.writeIntToNvramData(n3, this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET);
                        }
                        this._drawerProfileInfoTimeStamp = (byte[])byArray.clone();
                        this._backupToLocalFile();
                        if (bl) {
                            byte by = (byte)(this._releaseVersion << 1 | CORRUPTED_ON[0]);
                            this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                            this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, hscProviderSocket);
                            if (bl5) {
                                this._writeDataToCSP(new String(this._nvramData, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                if (DEBUG_ON) {
                                    System.out.println("In createSysProfile: writing to csp at ProfileNameTable portion");
                                }
                                this._writeDataToCSP(this.setLength(string, 32).getBytes(), n2, 32, hscProviderSocket);
                                if (DEBUG_ON) {
                                    System.out.println("In createSysProfile: newNameOffset = " + n2);
                                }
                                if (DEBUG_ON) {
                                    System.out.println("In createSysProfile: name = " + string);
                                }
                            }
                            if (this._releaseVersion == 0) {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8, hscProviderSocket);
                            } else if (this._releaseVersion < 3) {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10, hscProviderSocket);
                            } else {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12, hscProviderSocket);
                            }
                            if (bl2) {
                                this._writeDataToCSP(new String(this._nvramData, this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET).getBytes(), this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET, hscProviderSocket);
                            }
                            if (!(bl2 || bl4 || bl3)) {
                                this._writeDataToCSP(new String(this._nvramData, n, (int)s).getBytes(), n, s, hscProviderSocket);
                            } else {
                                int n16 = bl4 || bl3 ? this.NVRAM_SIZE - this._drawerOffsetTail : this._nvramDataSize - this._drawerOffsetTail;
                                this._writeDataToCSP(new String(this._nvramData, this._drawerOffsetTail, n16).getBytes(), this._drawerOffsetTail, n16, hscProviderSocket);
                            }
                            by = (byte)(this._releaseVersion << 1 | CORRUPTED_OFF[0]);
                            this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                        }
                    }
                    finally {
                        if (!DEBUG_ON) break block53;
                        System.out.println("End of createSysProfile");
                        System.out.print("********************");
                        System.out.println("********************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var54_63 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("0018");
            }
        }
        catch (Throwable throwable) {
            Object var54_64 = null;
            Trace.trace("apnvhscT", "<- createSysProfile");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- createSysProfile");
    }

    public synchronized void setActivatedLPARProfile(short s, String string, HscProviderSocket hscProviderSocket) throws CIMException {
        this._setActivatedLPARProfile(s, string, hscProviderSocket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _setActivatedLPARProfile(short s, String string, HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        try {
            try {
                block23: {
                    Trace.trace("apnvhscT", "-> setActivatedLPARProfile");
                    Trace.trace("apnvhscF", "partitionID = " + String.valueOf(s));
                    Trace.trace("apnvhscF", "profileTimeStamp = " + string);
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("******************************************");
                        System.out.println("In setActivatedLPARProfile");
                    }
                    boolean bl2 = false;
                    try {
                        block21: {
                            String string2;
                            if (bl) {
                                this.buildNVRAM(hscProviderSocket, false, null, true, false);
                            }
                            byte[] byArray = null;
                            byArray = string == null ? new byte[7] : NVRAM.cryptedTimestamp(string).getBytes();
                            int n = 0;
                            while (true) {
                                if (n >= 7) {
                                    String string3 = "";
                                    if (this._activatedList[s] != null) {
                                        string3 = this._activatedList[s];
                                    }
                                    this._activatedList[s] = string;
                                    string2 = "";
                                    if (this._defaultList[s] != null) {
                                        string2 = this._defaultList[s];
                                    }
                                    if (!string3.equals(string2) || string.equals(string2)) break;
                                    if (this._fastActivation[s - 1]) {
                                        System.out.println("$$$$$$$$$$$$ TURNING FAST ACTIVATOION BIT OFF $$$$$$$$$$$$$");
                                        this._fastActivation[s - 1] = false;
                                        this._nvramData[this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (s - 1) + 31] = 0;
                                        bl2 = true;
                                    }
                                    break block21;
                                }
                                this._nvramData[this.ACTIVATED_LIST_OFFSET + s * 7 + n] = byArray[n];
                                ++n;
                            }
                            if (string.equals(string2) && !this._fastActivation[s - 1]) {
                                System.out.println("$$$$$$$$$$$$$$$$$$$$ TURNING FAST ACTIATIVATION BIT ON $$$$$$$$$$$");
                                this._fastActivation[s - 1] = true;
                                this._nvramData[this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (s - 1) + 31] = 1;
                                bl2 = true;
                            }
                        }
                        if (bl) {
                            block22: {
                                String[] stringArray = new String[3];
                                Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", null, hscProviderSocket);
                                byte[] byArray = this.getTime(hashtable);
                                this._nvramTimeStamp = (byte[])byArray.clone();
                                this._activatedListTimeStamp = (byte[])byArray.clone();
                                int n = 0;
                                while (true) {
                                    if (n >= 7) {
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                                        if (bl2) {
                                            this._partitionNameTableTimeStamp = (byte[])byArray.clone();
                                            this._checksumCalc.reset();
                                            this._checksumCalc.update(this._nvramData, this.PARTITION_NAME_TABLE_OFFSET, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET - this.PARTITION_NAME_TABLE_OFFSET);
                                            this._checksum = this._checksumCalc.getValue();
                                            this.writeIntegralToNvramData(this._checksum, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                                        }
                                        if (this._releaseVersion != 0) break;
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.ACTIVATED_LIST_OFFSET, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET - this.ACTIVATED_LIST_OFFSET);
                                        break block22;
                                    }
                                    this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + n] = this._nvramTimeStamp[n];
                                    this._nvramData[this.ACTIVATED_LIST_TIME_STAMP_OFFSET + n] = this._activatedListTimeStamp[n];
                                    if (bl2) {
                                        this._nvramData[this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET + n] = byArray[n];
                                    }
                                    ++n;
                                }
                                this._checksumCalc.reset();
                                this._checksumCalc.update(this._nvramData, this.ACTIVATED_LIST_OFFSET, this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET - this.ACTIVATED_LIST_OFFSET);
                            }
                            this._checksum = this._checksumCalc.getValue();
                            this.writeIntegralToNvramData(this._checksum, this.ACTIVATED_LIST_CHECKSUM_OFFSET, (short)8);
                            this._backupToLocalFile();
                            byte by = (byte)(this._releaseVersion << 1 | CORRUPTED_ON[0]);
                            this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                            this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, hscProviderSocket);
                            if (bl2) {
                                this._writeDataToCSP(new String(this._nvramData, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                this._writeDataToCSP(new String(this._nvramData, this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (s - 1) + 31, 1).getBytes(), this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (s - 1) + 31, 1, hscProviderSocket);
                            }
                            this._writeDataToCSP(new String(this._nvramData, this.ACTIVATED_LIST_CHECKSUM_OFFSET, 8).getBytes(), this.ACTIVATED_LIST_CHECKSUM_OFFSET, 8, hscProviderSocket);
                            this._writeDataToCSP(new String(this._nvramData, this.ACTIVATED_LIST_OFFSET + s * 7, 7).getBytes(), this.ACTIVATED_LIST_OFFSET + s * 7, 7, hscProviderSocket);
                            by = (byte)(this._releaseVersion << 1 | CORRUPTED_OFF[0]);
                            this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                        }
                    }
                    finally {
                        if (!DEBUG_ON) break block23;
                        System.out.println("End of setActivatedLPARProfile");
                        System.out.print("********************");
                        System.out.println("*********************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var17_16 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("0019");
            }
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            Trace.trace("apnvhscT", "<- setActivatedLPARProfile");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- setActivatedLPARProfile");
    }

    public synchronized void setActivatedSysProfile(String string, HscProviderSocket hscProviderSocket) throws CIMException {
        this._setActivatedLPARProfile((short)0, string, hscProviderSocket, true);
    }

    public synchronized void setDefaultLPARProfile(short s, String string, HscProviderSocket hscProviderSocket) throws CIMException {
        this._setDefaultLPARProfile(s, string, hscProviderSocket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _setDefaultLPARProfile(short s, String string, HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        try {
            try {
                block20: {
                    boolean bl2 = false;
                    Trace.trace("apnvhscT", "-> setDefaultLPARProfile");
                    Trace.trace("apnvhscF", "partitionID = " + String.valueOf(s));
                    Trace.trace("apnvhscF", "profileTimeStamp = " + string);
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("**************************************");
                        System.out.println("In setDefaultLPARProfile");
                    }
                    try {
                        block19: {
                            if (bl) {
                                this.buildNVRAM(hscProviderSocket, false, null, true, false);
                            }
                            byte[] byArray = null;
                            byArray = string == null ? new byte[7] : NVRAM.cryptedTimestamp(string).getBytes();
                            int n = 0;
                            while (true) {
                                if (n >= 7) {
                                    String string2 = "";
                                    if (this._defaultList[s] != null) {
                                        string2 = this._defaultList[s];
                                    }
                                    this._defaultList[s] = string;
                                    if ((string == null || !string2.equals(string)) && this._fastActivation[s - 1]) {
                                        this._fastActivation[s - 1] = false;
                                        this._nvramData[this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (s - 1) + 31] = 0;
                                        bl2 = true;
                                    }
                                    if (bl) {
                                        break;
                                    }
                                    break block19;
                                }
                                this._nvramData[this.DEFAULT_LIST_OFFSET + s * 7 + n] = byArray[n];
                                ++n;
                            }
                            String[] stringArray = new String[3];
                            Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", null, hscProviderSocket, this._cspVersion);
                            byte[] byArray2 = this.getTime(hashtable);
                            int n2 = 0;
                            while (true) {
                                if (n2 >= 7) {
                                    this._checksumCalc.reset();
                                    this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                                    this._checksum = this._checksumCalc.getValue();
                                    this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                                    if (bl2) {
                                        this._partitionNameTableTimeStamp = (byte[])byArray2.clone();
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.PARTITION_NAME_TABLE_OFFSET, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET - this.PARTITION_NAME_TABLE_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                                    }
                                    this._checksumCalc.reset();
                                    this._checksumCalc.update(this._nvramData, this.DEFAULT_LIST_OFFSET, this.ACTIVATED_LIST_CHECKSUM_OFFSET - this.DEFAULT_LIST_OFFSET);
                                    this._checksum = this._checksumCalc.getValue();
                                    this.writeIntegralToNvramData(this._checksum, this.DEFAULT_LIST_CHECKSUM_OFFSET, (short)8);
                                    this._nvramTimeStamp = (byte[])byArray2.clone();
                                    this._defaultListTimeStamp = (byte[])byArray2.clone();
                                    this._backupToLocalFile();
                                    byte by = (byte)(this._releaseVersion << 1 | CORRUPTED_ON[0]);
                                    this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                                    this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, hscProviderSocket);
                                    if (bl2) {
                                        this._writeDataToCSP(new String(this._nvramData, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                        this._writeDataToCSP(new String(this._nvramData, this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (s - 1) + 31, 1).getBytes(), this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * (s - 1) + 31, 1, hscProviderSocket);
                                    }
                                    this._writeDataToCSP(new String(this._nvramData, this.DEFAULT_LIST_CHECKSUM_OFFSET, 8).getBytes(), this.DEFAULT_LIST_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                    this._writeDataToCSP(new String(this._nvramData, this.DEFAULT_LIST_OFFSET + s * 7, 7).getBytes(), this.DEFAULT_LIST_OFFSET + s * 7, 7, hscProviderSocket);
                                    by = (byte)(this._releaseVersion << 1 | CORRUPTED_OFF[0]);
                                    this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                                }
                                this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + n2] = byArray2[n2];
                                this._nvramData[this.DEFAULT_LIST_TIME_STAMP_OFFSET + n2] = byArray2[n2];
                                if (bl2) {
                                    this._nvramData[this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET + n2] = byArray2[n2];
                                }
                                ++n2;
                            }
                        }
                    }
                    finally {
                        if (!DEBUG_ON) break block20;
                        System.out.println("End of setDefaultLPARProfile");
                        System.out.println("****************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var16_15 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("001B");
            }
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            Trace.trace("apnvhscT", "<- setDefaultLPARProfile");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- setDefaultLPARProfile");
    }

    public synchronized void setDefaultSysProfile(String string, HscProviderSocket hscProviderSocket) throws CIMException {
        try {
            try {
                this._setDefaultLPARProfile((short)0, string, hscProviderSocket, true);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (!(throwable instanceof HSCCIMException)) {
                    throw new HSCCIMException("001C");
                }
                throw new HSCCIMException(throwable);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            Trace.trace("apnvhscT", "<- setDefaultSysProfile");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- setDefaultSysProfile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void cleanUp(HscProviderSocket var1_1) throws CIMException {
        try {
            try {
                block28: {
                    block31: {
                        Trace.trace("apnvhscT", "-> cleanup");
                        Trace.trace("apnvhscF", "socket = " + var1_1);
                        if (NVRAM.DEBUG_ON) {
                            System.out.print("********************");
                            System.out.println("********************");
                            System.out.println("In cleanUp");
                        }
                        if (var1_1 != null) {
                            this.buildNVRAM(var1_1, false, null, true, false);
                        }
                        var2_2 = new byte[this.NVRAM_SIZE];
                        var3_4 = 0;
                        while (var3_4 < this.DRAWERS_OFFSET) {
                            var2_2[var3_4] = this._nvramData[var3_4];
                            ++var3_4;
                        }
                        var4_5 = 0;
                        var5_6 = this.DRAWERS_OFFSET;
                        var6_7 = this.DRAWERS_OFFSET;
                        var10_8 = 0;
                        var10_8 = this._releaseVersion < 3 ? this.TEMPLATE_VERSION_OFFSET : this.DLPAR_TEMPLATE_VERSION_OFFSET_R4;
                        while (var4_5 < this._numDrawers) {
                            block29: {
                                var7_9 = new String(this._nvramData, var6_7, 24);
                                Trace.trace("apnvhscF", "drawerID = " + var7_9);
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("drawreID = " + var7_9);
                                }
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In cleanUp: drawerID = " + var7_9.trim());
                                }
                                if (var7_9.trim().length() == 0) break block29;
                                var7_9 = var7_9.trim();
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In cleanUp: currentPosition = " + var6_7);
                                }
                                ++var4_5;
                                var11_11 = 0;
                                if (true) ** GOTO lbl45
                            }
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("skip ");
                            }
                            Trace.trace("apnvhscF", "currentPosition = " + String.valueOf(var6_7 += 26));
                            continue;
                            do {
                                var2_2[var5_6 + var11_11] = this._nvramData[var6_7 + var11_11];
                                ++var11_11;
lbl45:
                                // 2 sources

                            } while (var11_11 < 26);
                            var8_10 = (int[])this._drawerIDTable.get(var7_9);
                            var8_10[0] = var5_6;
                            var5_6 += 26;
                            Trace.trace("apnvhscF", "currentPosition = " + String.valueOf(var6_7 += 26));
                        }
                        this._drawerOffsetTail = var5_6;
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("_drawerOffsetTail = " + this._drawerOffsetTail);
                        }
                        Trace.trace("apnvhscF", "_drawerOffsetTail" + String.valueOf(this._drawerOffsetTail));
                        var14_12 = false;
                        var15_13 = new String();
                        var16_14 = new Object[3];
                        while (var6_7 < this.NVRAM_SIZE) {
                            block30: {
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In cleanUp: currentPosition!!! " + var6_7);
                                }
                                var13_16 = this._releaseVersion < 3 ? (int)(255 & this._nvramData[var6_7]) : (short)(this._nvramData[var6_7] << 8 | this._nvramData[var6_7 + 1] & 255);
                                Trace.trace("apnvhscF", "len = " + String.valueOf(var13_16));
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In cleanUp: len = " + var13_16);
                                }
                                if (var13_16 == 0 && !var14_12) {
                                    var6_7 += 26;
                                    continue;
                                }
                                if (var14_12 && var13_16 == 0) break;
                                var14_12 = true;
                                var9_15 = this._nvramData[var6_7 + var10_8];
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In cleanUp: templateVersion = " + var9_15);
                                }
                                if (var9_15 == -1) break block30;
                                var17_17 = 0;
                                if (true) ** GOTO lbl85
                            }
                            if (NVRAM.DEBUG_ON) {
                                System.out.println("In cleanUp: not valid template");
                                System.out.println("In cleanUp: len!!!" + var13_16);
                            }
                            var6_7 += var13_16;
                            continue;
                            do {
                                var2_2[var5_6 + var17_17] = this._nvramData[var6_7 + var17_17];
                                ++var17_17;
lbl85:
                                // 2 sources

                            } while (var17_17 < var13_16);
                            var18_19 = new String(this._nvramData, var6_7 + this.PROFILE_TIME_STAMP_OFFSET, 7);
                            var16_14 = (Object[])this._profileTable.get(NVRAM.printableTimestamp((String)var18_19));
                            var16_14[0] = new Integer(var5_6);
                            var5_6 += var13_16;
                            var6_7 += var13_16;
                        }
                        this._nvramDataSize = var5_6;
                        this._nvramData = (byte[])var2_2.clone();
                        if (var1_1 == null) break block31;
                        var17_18 = new String[3];
                        var18_19 = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", null, var1_1, this._cspVersion);
                        var19_20 = this.getTime((Hashtable)var18_19);
                        var20_21 = 0;
                        if (true) ** GOTO lbl118
                    }
                    finally {
                        if (!NVRAM.DEBUG_ON) break block28;
                        System.out.println("End of cleanUp");
                        System.out.print("********************");
                        System.out.println("********************");
                        System.out.println();
                        System.out.println();
                    }
                }
                var24_23 = null;
                Trace.trace("apnvhscT", "<- cleanUp");
                return;
                do {
                    this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + var20_21] = var19_20[var20_21];
                    this._nvramData[this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + var20_21] = var19_20[var20_21];
                    ++var20_21;
lbl118:
                    // 2 sources

                } while (var20_21 < 7);
                this._checksumCalc.reset();
                this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                this._checksum = this._checksumCalc.getValue();
                this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                this._checksumCalc.reset();
                this._checksumCalc.update(this._nvramData, this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET);
                this._checksum = this._checksumCalc.getValue();
                this.writeIntegralToNvramData(this._checksum, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, (short)8);
                if (this._releaseVersion != 0) {
                    var21_22 = this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET;
                    if (this._releaseVersion < 3) {
                        this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = (byte)(var21_22 >>> 8);
                        this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = (byte)(var21_22 & 255);
                    } else {
                        this.writeIntToNvramData(var21_22, this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET);
                    }
                }
                this._nvramTimeStamp = (byte[])var19_20.clone();
                this._drawerProfileInfoTimeStamp = (byte[])var19_20.clone();
                this._backupToLocalFile();
                var21_22 = (byte)(this._releaseVersion << 1 | NVRAM.CORRUPTED_ON[0]);
                this._writeDataToCSP(new byte[]{var21_22}, this.CORRUPTED_BYTE_OFFSET, 1, var1_1);
                this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, var1_1);
                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, this.NVRAM_SIZE - this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, this.NVRAM_SIZE - this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, var1_1);
                var21_22 = (byte)(this._releaseVersion << 1 | NVRAM.CORRUPTED_OFF[0]);
                this._writeDataToCSP(new byte[]{var21_22}, this.CORRUPTED_BYTE_OFFSET, 1, var1_1);
            }
            catch (Throwable var2_3) {
                var2_3.printStackTrace();
                HSCLogUtils.serverLog(var2_3, HSCLogUtils._NVRAMClassLogInfo);
                if (var2_3 instanceof HSCCIMException != false) throw new HSCCIMException(var2_3);
                throw new HSCCIMException("001D");
            }
        }
        catch (Throwable var23_26) {
            var24_24 = null;
            Trace.trace("apnvhscT", "<- cleanUp");
            throw var23_26;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compareTime(byte[] byArray, byte[] byArray2) {
        Trace.trace("apnvhscT", "-> compareTime");
        Trace.trace("apnvhscF", "time1 = " + byArray);
        Trace.trace("apnvhscF", "time2 = " + byArray2);
        if (DEBUG_ON) {
            System.out.print("********************");
            System.out.println("*********************");
            System.out.println("In compareTime method");
        }
        try {
            if (byArray.length == 7 && byArray2.length == 7) {
                if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0 && byArray[4] == 0 && byArray[5] == 0 && byArray[6] == 0) {
                    int n = -1;
                    return n;
                }
                if (byArray2[0] == 0 && byArray2[1] == 0 && byArray2[2] == 0 && byArray2[3] == 0 && byArray2[4] == 0 && byArray2[5] == 0 && byArray2[6] == 0) {
                    int n = 1;
                    return n;
                }
                int n = byArray[0] << 8 | 0xFF & byArray[1];
                if (DEBUG_ON) {
                    System.out.println("In compareTime: year1 = " + n);
                }
                Trace.trace("apnvhscD", "year1 = " + String.valueOf(n));
                int n2 = byArray2[0] << 8 | 0xFF & byArray2[1];
                if (DEBUG_ON) {
                    System.out.println("In compareTime: year2 = " + n2);
                }
                Trace.trace("apnvhscD", "year2 = " + String.valueOf(n2));
                if (n > n2) {
                    int n3 = 1;
                    return n3;
                }
                if (n2 > n) {
                    int n4 = -1;
                    return n4;
                }
                byte by = byArray[2];
                Trace.trace("apnvhscD", "month1 = " + String.valueOf(byArray[2]));
                byte by2 = byArray2[2];
                Trace.trace("apnvhscD", "year2 = " + String.valueOf(byArray2[2]));
                if (by > by2) {
                    int n5 = 1;
                    return n5;
                }
                if (by2 > by) {
                    int n6 = -1;
                    return n6;
                }
                byte by3 = byArray[3];
                Trace.trace("apnvhscD", "day1 = " + String.valueOf(byArray[3]));
                byte by4 = byArray2[3];
                Trace.trace("apnvhscD", "day2 = " + String.valueOf(byArray2[3]));
                if (by3 > by4) {
                    if (DEBUG_ON) {
                        System.out.println("End of compareTime method");
                    }
                    int n7 = 1;
                    return n7;
                }
                if (by4 > by3) {
                    int n8 = -1;
                    return n8;
                }
                byte by5 = byArray[4];
                Trace.trace("apnvhscD", "hour1 = " + String.valueOf(byArray[4]));
                byte by6 = byArray2[4];
                Trace.trace("apnvhscD", "hour2 = " + String.valueOf(byArray2[4]));
                if (by5 > by6) {
                    int n9 = 1;
                    return n9;
                }
                if (by6 > by5) {
                    int n10 = -1;
                    return n10;
                }
                byte by7 = byArray[5];
                Trace.trace("apnvhscD", "minute1 = " + String.valueOf(byArray[5]));
                byte by8 = byArray2[5];
                Trace.trace("apnvhscD", "minute2 = " + String.valueOf(byArray2[5]));
                if (by7 > by8) {
                    int n11 = 1;
                    return n11;
                }
                if (by8 > by7) {
                    int n12 = -1;
                    return n12;
                }
                byte by9 = byArray[6];
                Trace.trace("apnvhscD", "second1 = " + String.valueOf(byArray[6]));
                byte by10 = byArray2[6];
                Trace.trace("apnvhscD", "second2 = " + String.valueOf(byArray2[6]));
                if (by9 > by10) {
                    int n13 = 1;
                    return n13;
                }
                if (by10 > by9) {
                    int n14 = -1;
                    return n14;
                }
                int n15 = 0;
                return n15;
            }
            if (DEBUG_ON) {
                System.out.println("problem with the time stamp passed: length not equal");
            }
            Trace.trace("apnvhscF", "compareTimeMethod returning - (-1) -- problem with the time stamp passed");
            int n = -1;
            return n;
        }
        finally {
            Trace.trace("apnvhscT", "<- compareTime");
            if (DEBUG_ON) {
                System.out.println("End of compareTime method");
                System.out.print("********************");
                System.out.println("********************");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized int updateNVRAMCache(HscProviderSocket hscProviderSocket, File file, boolean bl) throws CIMException {
        try {
            try {
                int n;
                block144: {
                    System.out.println("restoredFile = " + file);
                    Trace.trace("apnvhscT", "-> updateNVRAMCache");
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    Trace.trace("apnvhscF", "restoredFile = " + file);
                    if (DEBUG_ON) {
                        System.out.print("********************");
                        System.out.println("********************");
                        System.out.println("In updateNVRAMCache");
                    }
                    try {
                        int n2;
                        int n3;
                        int n4;
                        Object object;
                        Object object2;
                        int n5;
                        int n6;
                        int n7;
                        byte[] byArray;
                        byte[] byArray2;
                        byte[] byArray3;
                        byte[] byArray4;
                        byte[] byArray5;
                        BigInteger bigInteger;
                        byte[] byArray6;
                        byte[] byArray7;
                        int n8;
                        block145: {
                            byte[] byArray8;
                            block136: {
                                int n9;
                                n8 = 0;
                                byte[] byArray9 = null;
                                Object var6_7 = null;
                                Object var7_8 = null;
                                byArray7 = new byte[this.NVRAM_SIZE];
                                if (!bl) {
                                    block135: {
                                        try {
                                            int n10;
                                            FileInputStream fileInputStream = new FileInputStream(file);
                                            this._nvramData = new byte[this.NVRAM_SIZE];
                                            fileInputStream.read(this._nvramData, 0, (int)file.length());
                                            fileInputStream.close();
                                            if (DEBUG_ON) {
                                                System.out.println("_nvramData[1] = " + this._nvramData[1]);
                                                System.out.println("_nvramData[2] = " + this._nvramData[2]);
                                            }
                                            if ((n10 = this._nvramData[0] >>> 1 & 0xFF) != 1 && n10 != 2) break block135;
                                            Adler32 adler32 = new Adler32();
                                            byte[] byArray10 = new byte[528];
                                            adler32.update(byArray10);
                                            long l = adler32.getValue();
                                            int n11 = this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET;
                                            long l2 = (long)this._nvramData[n11] << 56 | (long)this._nvramData[n11 + 1] << 48 | (long)this._nvramData[n11 + 2] << 40 | (long)this._nvramData[n11 + 3] << 32 | (long)this._nvramData[n11 + 4] << 24 | (long)this._nvramData[n11 + 5] << 16 | (long)this._nvramData[n11 + 6] << 8 | (long)this._nvramData[n11 + 7];
                                            System.out.println("partChecksumVal = " + l2);
                                            System.out.println("emptyPartChecksumVal = " + l);
                                            if (l2 == l) {
                                                Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_NUM_LPAR_SLOTS", null, hscProviderSocket, this._cspVersion);
                                                int n12 = (Integer)hashtable.get("NUM_LPAR_SLOTS");
                                                System.out.println("numLpars = " + n12);
                                                if (n12 != 16) {
                                                    n = -1;
                                                    return n;
                                                }
                                            }
                                        }
                                        catch (FileNotFoundException fileNotFoundException) {
                                            fileNotFoundException.printStackTrace();
                                            HSCLogUtils.serverLog(fileNotFoundException, HSCLogUtils._NVRAMClassLogInfo);
                                            throw new HSCCIMException("1198", new String[]{file.getName()});
                                        }
                                        catch (SecurityException securityException) {
                                            securityException.printStackTrace();
                                            HSCLogUtils.serverLog(securityException, HSCLogUtils._NVRAMClassLogInfo);
                                            throw new HSCCIMException("1196", new String[]{file.getName()});
                                        }
                                        catch (Throwable throwable) {
                                            throwable.printStackTrace();
                                            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                                            throw new HSCCIMException("1197", new String[]{file.getName()});
                                        }
                                    }
                                    int n13 = n8 = 63;
                                    return n13;
                                }
                                byArray6 = this._readDataFromCSP(this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                                byte by = byArray6[0];
                                this._releaseVersion = (byte)((by & this._versionMask) >>> 1);
                                this._updateVariables(hscProviderSocket, false, true);
                                byArray7[this.CORRUPTED_BYTE_OFFSET] = byArray6[0];
                                if (this._releaseVersion != 0) {
                                    byArray7[this.NUM_ALPAR_SLOTS_OFFSET] = (byte)this._numPhyLocCodeSlots;
                                }
                                if (this._releaseVersion >= 3) {
                                    byArray7[this.NUM_PARTITION_SLOTS_OFFSET] = (byte)this._releaseNumPartitionSlots;
                                    byArray9 = this._readDataFromCSP(this.VALIDATION_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                    bigInteger = new BigInteger(byArray9);
                                    this._checksum = bigInteger.longValue();
                                    n9 = this.VALIDATION_CHECKSUM_OFFSET;
                                    while (n9 < this.TIME_STAMPS_CHECKSUM_OFFSET) {
                                        byArray7[n9] = byArray9[n9 - this.VALIDATION_CHECKSUM_OFFSET];
                                        ++n9;
                                    }
                                }
                                if ((by & 1) == CORRUPTED_ON[0]) {
                                    this.handleBadNVRAMError();
                                    throw new HSCCIMException("0006");
                                }
                                byArray9 = this._readDataFromCSP(this.TIME_STAMPS_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                bigInteger = new BigInteger(byArray9);
                                this._checksum = bigInteger.longValue();
                                n9 = this.TIME_STAMPS_CHECKSUM_OFFSET;
                                while (true) {
                                    if (n9 >= this.NVRAM_TIME_STAMP_OFFSET) {
                                        byArray9 = this._readDataFromCSP(this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET, hscProviderSocket);
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(byArray9);
                                        if (this._checksum == this._checksumCalc.getValue()) break;
                                        if (DEBUG_ON) {
                                            System.out.println("timestamp corrupted");
                                        }
                                        this.handleBadNVRAMError();
                                        throw new HSCCIMException("0006");
                                    }
                                    byArray7[n9] = byArray9[n9 - this.TIME_STAMPS_CHECKSUM_OFFSET];
                                    ++n9;
                                }
                                byte[] byArray11 = new byte[7];
                                byArray8 = new byte[7];
                                byArray5 = new byte[7];
                                byArray4 = new byte[7];
                                byArray3 = new byte[7];
                                byArray2 = new byte[7];
                                byArray = new byte[7];
                                int n14 = 0;
                                while (true) {
                                    if (n14 >= 7) break;
                                    byArray11[n14] = byArray9[n14];
                                    byArray8[n14] = byArray9[this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET - this.NVRAM_TIME_STAMP_OFFSET + n14];
                                    byArray5[n14] = byArray9[this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET - this.NVRAM_TIME_STAMP_OFFSET + n14];
                                    byArray4[n14] = byArray9[this.DEFAULT_LIST_TIME_STAMP_OFFSET - this.NVRAM_TIME_STAMP_OFFSET + n14];
                                    byArray3[n14] = byArray9[this.ACTIVATED_LIST_TIME_STAMP_OFFSET - this.NVRAM_TIME_STAMP_OFFSET + n14];
                                    if (this._releaseVersion != 0) {
                                        byArray2[n14] = byArray9[this.PHY_LOC_CODE_TIME_STAMP_OFFSET - this.NVRAM_TIME_STAMP_OFFSET + n14];
                                    }
                                    byArray[n14] = byArray9[this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET - this.NVRAM_TIME_STAMP_OFFSET + n14];
                                    ++n14;
                                }
                                int n15 = this.NVRAM_TIME_STAMP_OFFSET;
                                while (true) {
                                    if (n15 >= this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET) {
                                        n7 = this.compareTime(this._partitionNameTableTimeStamp, byArray8);
                                        if (n7 == 0) {
                                            if (DEBUG_ON) {
                                                System.out.println("partitionNameTable no change");
                                            }
                                            n6 = this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET;
                                            break;
                                        }
                                        break block136;
                                    }
                                    byArray7[n15] = byArray9[n15 - this.NVRAM_TIME_STAMP_OFFSET];
                                    ++n15;
                                }
                                while (n6 < this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET) {
                                    byArray7[n6] = this._nvramData[n6];
                                    ++n6;
                                }
                                break block145;
                            }
                            byArray6 = this._readDataFromCSP(this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET - this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, hscProviderSocket);
                            byte[] byArray12 = new byte[8];
                            n5 = 0;
                            while (true) {
                                if (n5 >= 8) {
                                    bigInteger = new BigInteger(byArray12);
                                    this._checksum = bigInteger.longValue();
                                    this._checksumCalc.reset();
                                    this._checksumCalc.update(byArray6, this.PARTITION_NAME_TABLE_OFFSET - this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET - this.PARTITION_NAME_TABLE_OFFSET);
                                    System.out.println("PARTITION_NAME_TABLE_OFFSET = " + this.PARTITION_NAME_TABLE_OFFSET);
                                    if (this._releaseVersion != 1 && this._releaseVersion != 2) break;
                                    object2 = new Adler32();
                                    object = new byte[528];
                                    object2.update((byte[])object);
                                    long l = ((Adler32)object2).getValue();
                                    int n16 = this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET;
                                    long l3 = this._checksum;
                                    System.out.println("partChecksumVal = " + l3);
                                    System.out.println("emptyPartChecksumVal = " + l);
                                    System.out.println("checkumValue = " + bigInteger);
                                    if (l3 != l) break;
                                    Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_NUM_LPAR_SLOTS", null, hscProviderSocket, this._cspVersion);
                                    int n17 = (Integer)hashtable.get("NUM_LPAR_SLOTS");
                                    System.out.println("numLpars = " + n17);
                                    if (n17 == 16) break;
                                    int n18 = -1;
                                    return n18;
                                }
                                byArray12[n5] = byArray6[n5];
                                ++n5;
                            }
                            if (((String)(object2 = new String(byArray6))).equals(object = (Object)new String(new byte[byArray6.length]))) {
                                this._checksum = this._checksumCalc.getValue();
                                int n19 = 0;
                                while (true) {
                                    if (n19 >= 8) {
                                        this._writeDataToCSP(new String(byArray6, 0, 8).getBytes(), this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                        break;
                                    }
                                    byArray6[n19] = (byte)(this._checksum >> (8 - n19 - 1) * 8);
                                    ++n19;
                                }
                            }
                            if (this._checksum != this._checksumCalc.getValue()) {
                                if (DEBUG_ON) {
                                    System.out.println("exception should occur");
                                }
                                this.handleBadNVRAMError();
                                throw new HSCCIMException("0006");
                            }
                            n4 = this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET;
                            while (true) {
                                if (n4 >= this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET) break;
                                byArray7[n4] = byArray6[n4 - this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET];
                                ++n4;
                            }
                            n3 = 0;
                            while (true) {
                                if (n3 >= 7) {
                                    this._partitionNameTableTimeStamp = (byte[])byArray8.clone();
                                    n8 |= 0x10;
                                    break;
                                }
                                byArray7[this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET + n3] = byArray8[n3];
                                ++n3;
                            }
                        }
                        n7 = this.compareTime(this._profileNameTableTimeStamp, byArray5);
                        if (n7 == 0) {
                            Trace.trace("apnvhscD", "compareTime method returning - equal (0)");
                            n6 = this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET;
                            while (n6 < this.DEFAULT_LIST_CHECKSUM_OFFSET) {
                                byArray7[n6] = this._nvramData[n6];
                                ++n6;
                            }
                        } else {
                            block137: {
                                byArray6 = this._readDataFromCSP(this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                if (DEBUG_ON) {
                                    System.out.println("after read the checksum of the profile name table");
                                }
                                bigInteger = new BigInteger(byArray6);
                                this._checksum = bigInteger.longValue();
                                n6 = this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET;
                                while (true) {
                                    if (n6 >= this.PROFILE_NAME_TABLE_OFFSET) {
                                        if (DEBUG_ON) {
                                            System.out.println("ProfileNameTableTimeStamp is differnt - change");
                                        }
                                        break;
                                    }
                                    byArray7[n6] = byArray6[n6 - this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET];
                                    ++n6;
                                }
                                Trace.trace("apnvhscD", "compareTime method returning -1 - Need to update");
                                byArray6 = this._readDataFromCSP(this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET, hscProviderSocket);
                                n5 = this.PROFILE_NAME_TABLE_OFFSET;
                                while (true) {
                                    if (n5 >= this.DEFAULT_LIST_CHECKSUM_OFFSET) {
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(byArray7, this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
                                        object2 = new String(byArray7, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET);
                                        object = new String(new byte[this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET]);
                                        if (((String)object2).equals(object)) {
                                            break;
                                        }
                                        break block137;
                                    }
                                    byArray7[n5] = byArray6[n5 - this.PROFILE_NAME_TABLE_OFFSET];
                                    ++n5;
                                }
                                this._checksum = this._checksumCalc.getValue();
                                n4 = 0;
                                while (true) {
                                    if (n4 >= 8) {
                                        this._writeDataToCSP(new String(byArray7, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                        break;
                                    }
                                    byArray7[this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET + n4] = (byte)(this._checksum >> (8 - n4 - 1) * 8);
                                    ++n4;
                                }
                            }
                            if (this._checksum != this._checksumCalc.getValue()) {
                                if (DEBUG_ON) {
                                    System.out.println("profile name table corrupted");
                                }
                                this.handleBadNVRAMError();
                                throw new HSCCIMException("0006");
                            }
                            n4 = 0;
                            while (true) {
                                if (n4 >= 7) {
                                    this._profileNameTableTimeStamp = (byte[])byArray5.clone();
                                    n8 |= 1;
                                    break;
                                }
                                byArray7[this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + n4] = byArray5[n4];
                                ++n4;
                            }
                        }
                        n7 = this.compareTime(this._defaultListTimeStamp, byArray4);
                        if (n7 == 0) {
                            Trace.trace("apnvhscD", "compareTime method returning - equal (0)");
                            n6 = this.DEFAULT_LIST_CHECKSUM_OFFSET;
                            while (n6 < this.ACTIVATED_LIST_CHECKSUM_OFFSET) {
                                byArray7[n6] = this._nvramData[n6];
                                ++n6;
                            }
                        } else {
                            block138: {
                                byArray6 = this._readDataFromCSP(this.DEFAULT_LIST_CHECKSUM_OFFSET, this.ACTIVATED_LIST_CHECKSUM_OFFSET - this.DEFAULT_LIST_CHECKSUM_OFFSET, hscProviderSocket);
                                byte[] byArray13 = new byte[8];
                                n5 = 0;
                                while (true) {
                                    if (n5 >= 8) {
                                        bigInteger = new BigInteger(byArray13);
                                        this._checksum = bigInteger.longValue();
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(byArray6, this.DEFAULT_LIST_OFFSET - this.DEFAULT_LIST_CHECKSUM_OFFSET, this.ACTIVATED_LIST_CHECKSUM_OFFSET - this.DEFAULT_LIST_OFFSET);
                                        object2 = new String(byArray6);
                                        object = new String(new byte[byArray6.length]);
                                        if (((String)object2).equals(object)) {
                                            break;
                                        }
                                        break block138;
                                    }
                                    byArray13[n5] = byArray6[n5];
                                    ++n5;
                                }
                                this._checksum = this._checksumCalc.getValue();
                                n4 = 0;
                                while (true) {
                                    if (n4 >= 8) {
                                        this._writeDataToCSP(new String(byArray6, 0, 8).getBytes(), this.DEFAULT_LIST_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                        break;
                                    }
                                    byArray6[n4] = (byte)(this._checksum >> (8 - n4 - 1) * 8);
                                    ++n4;
                                }
                            }
                            if (this._checksum != this._checksumCalc.getValue()) {
                                if (DEBUG_ON) {
                                    System.out.println("default list corrupted");
                                    System.out.println("_checksum = " + this._checksum);
                                    System.out.println("_checksumCalc.getValue() = " + this._checksumCalc.getValue());
                                }
                                this.handleBadNVRAMError();
                                throw new HSCCIMException("0006");
                            }
                            n4 = this.DEFAULT_LIST_CHECKSUM_OFFSET;
                            while (true) {
                                if (n4 >= this.ACTIVATED_LIST_CHECKSUM_OFFSET) {
                                    if (DEBUG_ON) {
                                        System.out.println("TimeStamp is differnt - change");
                                    }
                                    break;
                                }
                                byArray7[n4] = byArray6[n4 - this.DEFAULT_LIST_CHECKSUM_OFFSET];
                                ++n4;
                            }
                            Trace.trace("apnvhscF", "compareTime method returning -1 - Need to update");
                            n3 = 0;
                            while (true) {
                                if (n3 >= 7) {
                                    this._defaultListTimeStamp = (byte[])byArray4.clone();
                                    n8 |= 2;
                                    break;
                                }
                                byArray7[this.DEFAULT_LIST_TIME_STAMP_OFFSET + n3] = byArray4[n3];
                                ++n3;
                            }
                        }
                        n7 = this.compareTime(this._activatedListTimeStamp, byArray3);
                        if (n7 == 0) {
                            Trace.trace("apnvhscD", "compareTime method returning - equal (0)");
                            if (this._releaseVersion == 0) {
                                int n20 = this.ACTIVATED_LIST_CHECKSUM_OFFSET;
                                while (n20 < this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET) {
                                    byArray7[n20] = this._nvramData[n20];
                                    ++n20;
                                }
                            } else {
                                int n21 = this.ACTIVATED_LIST_CHECKSUM_OFFSET;
                                while (n21 < this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET) {
                                    byArray7[n21] = this._nvramData[n21];
                                    ++n21;
                                }
                            }
                        } else {
                            block140: {
                                byArray6 = this._releaseVersion == 0 ? this._readDataFromCSP(this.ACTIVATED_LIST_CHECKSUM_OFFSET, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET - this.ACTIVATED_LIST_CHECKSUM_OFFSET, hscProviderSocket) : this._readDataFromCSP(this.ACTIVATED_LIST_CHECKSUM_OFFSET, this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET - this.ACTIVATED_LIST_CHECKSUM_OFFSET, hscProviderSocket);
                                byte[] byArray14 = new byte[8];
                                n5 = 0;
                                while (true) {
                                    if (n5 >= 8) {
                                        bigInteger = new BigInteger(byArray14);
                                        this._checksum = bigInteger.longValue();
                                        this._checksumCalc.reset();
                                        if (this._releaseVersion != 0) break;
                                        this._checksumCalc.update(byArray6, this.ACTIVATED_LIST_OFFSET - this.ACTIVATED_LIST_CHECKSUM_OFFSET, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET - this.ACTIVATED_LIST_OFFSET);
                                        break block140;
                                    }
                                    byArray14[n5] = byArray6[n5];
                                    ++n5;
                                }
                                this._checksumCalc.update(byArray6, this.ACTIVATED_LIST_OFFSET - this.ACTIVATED_LIST_CHECKSUM_OFFSET, this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET - this.ACTIVATED_LIST_OFFSET);
                            }
                            object2 = new String(byArray6);
                            object = new String(new byte[byArray6.length]);
                            if (((String)object2).equals(object)) {
                                this._checksum = this._checksumCalc.getValue();
                                n4 = 0;
                                while (true) {
                                    if (n4 >= 8) {
                                        this._writeDataToCSP(new String(byArray6, 0, 8).getBytes(), this.ACTIVATED_LIST_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                        break;
                                    }
                                    byArray6[n4] = (byte)(this._checksum >> (8 - n4 - 1) * 8);
                                    ++n4;
                                }
                            }
                            if (this._checksum != this._checksumCalc.getValue()) {
                                if (DEBUG_ON) {
                                    System.out.println("activated list corrupted");
                                }
                                this.handleBadNVRAMError();
                                throw new HSCCIMException("0006");
                            }
                            if (this._releaseVersion == 0) {
                                n4 = this.ACTIVATED_LIST_CHECKSUM_OFFSET;
                                while (n4 < this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET) {
                                    byArray7[n4] = byArray6[n4 - this.ACTIVATED_LIST_CHECKSUM_OFFSET];
                                    ++n4;
                                }
                            } else {
                                n4 = this.ACTIVATED_LIST_CHECKSUM_OFFSET;
                                while (n4 < this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET) {
                                    byArray7[n4] = byArray6[n4 - this.ACTIVATED_LIST_CHECKSUM_OFFSET];
                                    ++n4;
                                }
                            }
                            if (DEBUG_ON) {
                                System.out.println("TimeStamp is differnt - change");
                            }
                            Trace.trace("apnvhscD", "compareTime method returning -1 - Need to update");
                            n4 = 0;
                            while (true) {
                                if (n4 >= 7) {
                                    this._activatedListTimeStamp = (byte[])byArray3.clone();
                                    n8 |= 4;
                                    break;
                                }
                                byArray7[this.ACTIVATED_LIST_TIME_STAMP_OFFSET + n4] = byArray3[n4];
                                ++n4;
                            }
                        }
                        if (this._releaseVersion != 0) {
                            n7 = this.compareTime(this._phyLocCodeTableTimeStamp, byArray2);
                            if (n7 == 0) {
                                Trace.trace("apnvhscD", "compareTime method returning - equal (0)");
                                int n22 = this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET;
                                while (n22 < this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET) {
                                    byArray7[n22] = this._nvramData[n22];
                                    ++n22;
                                }
                            } else {
                                block141: {
                                    byArray6 = this._readDataFromCSP(this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET - this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET, hscProviderSocket);
                                    byte[] byArray15 = new byte[8];
                                    n5 = 0;
                                    while (true) {
                                        if (n5 >= 8) {
                                            bigInteger = new BigInteger(byArray15);
                                            this._checksum = bigInteger.longValue();
                                            this._checksumCalc.reset();
                                            this._checksumCalc.update(byArray6, this.PHY_LOC_CODE_TABLE_OFFSET - this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET - this.PHY_LOC_CODE_TABLE_OFFSET);
                                            object2 = new String(byArray6);
                                            object = new String(new byte[byArray6.length]);
                                            if (((String)object2).equals(object)) {
                                                break;
                                            }
                                            break block141;
                                        }
                                        byArray15[n5] = byArray6[n5];
                                        ++n5;
                                    }
                                    this._checksum = this._checksumCalc.getValue();
                                    n4 = 0;
                                    while (true) {
                                        if (n4 >= 8) {
                                            this._writeDataToCSP(new String(byArray6, 0, 8).getBytes(), this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                            break;
                                        }
                                        byArray6[n4] = (byte)(this._checksum >> (8 - n4 - 1) * 8);
                                        ++n4;
                                    }
                                }
                                if (this._checksum != this._checksumCalc.getValue()) {
                                    if (DEBUG_ON) {
                                        System.out.println("activated list corrupted");
                                    }
                                    this.handleBadNVRAMError();
                                    throw new HSCCIMException("0006");
                                }
                                n4 = this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET;
                                while (true) {
                                    if (n4 >= this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET) {
                                        if (DEBUG_ON) {
                                            System.out.println("TimeStamp is differnt - change");
                                        }
                                        break;
                                    }
                                    byArray7[n4] = byArray6[n4 - this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET];
                                    ++n4;
                                }
                                Trace.trace("apnvhscD", "compareTime method returning -1 - Need to update");
                                n3 = 0;
                                while (true) {
                                    if (n3 >= 7) {
                                        this._phyLocCodeTableTimeStamp = (byte[])byArray2.clone();
                                        n8 |= 0x20;
                                        break;
                                    }
                                    byArray7[this.PHY_LOC_CODE_TIME_STAMP_OFFSET + n3] = byArray2[n3];
                                    ++n3;
                                }
                            }
                        }
                        if ((n7 = this.compareTime(this._drawerProfileInfoTimeStamp, byArray)) == 0) {
                            Trace.trace("apnvhscD", "compareTime method returning - equal (0)");
                            n2 = this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET;
                            while (n2 < this.NVRAM_SIZE) {
                                byArray7[n2] = this._nvramData[n2];
                                ++n2;
                            }
                        } else {
                            block143: {
                                block142: {
                                    byArray6 = this._readDataFromCSP(this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                    bigInteger = new BigInteger(byArray6);
                                    this._checksum = bigInteger.longValue();
                                    n2 = this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET;
                                    while (true) {
                                        if (n2 >= this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET + 8) {
                                            if (DEBUG_ON) {
                                                System.out.println("TimeStamp is differnt - change");
                                            }
                                            Trace.trace("apnvhscD", "compareTime method returning -1 - Need to update");
                                            if (this._releaseVersion == 0) {
                                                break;
                                            }
                                            break block142;
                                        }
                                        byArray7[n2] = byArray6[n2 - this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET];
                                        ++n2;
                                    }
                                    byArray6 = this._readDataFromCSP(this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET, hscProviderSocket);
                                    n5 = this.NUM_DRAWERS_OFFSET;
                                    while (true) {
                                        if (n5 >= this.NVRAM_SIZE) {
                                            this._checksumCalc.reset();
                                            this._checksumCalc.update(byArray7, this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET);
                                            break block143;
                                        }
                                        byArray7[n5] = byArray6[n5 - this.NUM_DRAWERS_OFFSET];
                                        ++n5;
                                    }
                                }
                                if (DEBUG_ON) {
                                    System.out.println("DRAWER_PROF_INFO_DATA_SIZE_OFFSET = " + this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET);
                                    System.out.println("NUM_DRAWERS_OFFSET = " + this.NUM_DRAWERS_OFFSET);
                                }
                                byArray6 = this._readDataFromCSP(this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET, this.NUM_DRAWERS_OFFSET - this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET, hscProviderSocket);
                                n5 = 0;
                                if (this._releaseVersion < 3) {
                                    if (DEBUG_ON) {
                                        System.out.println("data[0] = " + byArray6[0]);
                                        System.out.println("data[1] = " + byArray6[1]);
                                    }
                                    byArray7[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = byArray6[0];
                                    byArray7[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = byArray6[1];
                                    n5 = (byArray6[0] << 8 | byArray6[1] & 0xFF) & 0xFFFF;
                                } else {
                                    object2 = new byte[4];
                                    int n23 = 0;
                                    while (true) {
                                        if (n23 >= 4) {
                                            BigInteger bigInteger2 = new BigInteger((byte[])object2);
                                            byArray7[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = byArray6[0];
                                            byArray7[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = byArray6[1];
                                            byArray7[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 2] = byArray6[2];
                                            byArray7[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 3] = byArray6[3];
                                            n5 = bigInteger2.intValue();
                                            break;
                                        }
                                        object2[n23] = byArray6[n23];
                                        ++n23;
                                    }
                                }
                                byArray6 = this._readDataFromCSP(this.NUM_DRAWERS_OFFSET, n5, hscProviderSocket);
                                int n24 = 0;
                                while (true) {
                                    if (n24 >= n5) {
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(byArray7, this.NUM_DRAWERS_OFFSET, n5);
                                        break;
                                    }
                                    byArray7[this.NUM_DRAWERS_OFFSET + n24] = byArray6[n24];
                                    ++n24;
                                }
                            }
                            String string = new String(byArray7, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, this.NVRAM_SIZE - this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET);
                            String string2 = new String(new byte[this.NVRAM_SIZE - this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET]);
                            if (string.equals(string2)) {
                                this._checksum = this._checksumCalc.getValue();
                                int n25 = 0;
                                while (true) {
                                    if (n25 >= 8) {
                                        if (DEBUG_ON) {
                                            System.out.println("0 checksum 0 data for drawer profile info -> " + this._checksum);
                                        }
                                        this._writeDataToCSP(new String(byArray7, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                        break;
                                    }
                                    byArray7[this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET + n25] = (byte)(this._checksum >> (8 - n25 - 1) * 8);
                                    ++n25;
                                }
                            }
                            if (this._checksum != this._checksumCalc.getValue()) {
                                if (DEBUG_ON) {
                                    System.out.println("drawer profile info corrupted");
                                    System.out.println("stored _checksum = " + this._checksum);
                                    System.out.println("calculated checksum value = " + this._checksumCalc.getValue());
                                }
                                this.handleBadNVRAMError();
                                throw new HSCCIMException("0006");
                            }
                            int n26 = 0;
                            while (true) {
                                if (n26 >= 7) {
                                    this._drawerProfileInfoTimeStamp = (byte[])byArray.clone();
                                    n8 |= 8;
                                    break;
                                }
                                byArray7[this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + n26] = byArray[n26];
                                ++n26;
                            }
                        }
                        this._nvramData = (byte[])byArray7.clone();
                        this._backupToLocalFile();
                        n2 = n8;
                        return n2;
                    }
                    finally {
                        if (!DEBUG_ON) break block144;
                        System.out.println("End of updateNVRAMCache");
                        System.out.print("********************");
                        System.out.println("********************");
                    }
                }
                Object var37_34 = null;
                Trace.trace("apnvhscT", "<- updateNVRAMCache");
                return n;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("001E");
            }
        }
        catch (Throwable throwable) {
            Object var37_38 = null;
            Trace.trace("apnvhscT", "<- updateNVRAMCache");
            throw throwable;
        }
    }

    private String setLength(String string, int n) {
        Trace.trace("apnvhscT", "-> setLength");
        Trace.trace("apnvhscF", "str = " + string);
        Trace.trace("apnvhscF", "length = " + n);
        if (DEBUG_ON) {
            System.out.print("********************");
            System.out.println("********************");
            System.out.println("In setLength");
        }
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setLength(n);
        Trace.trace("apnvhscT", "<- setLength");
        if (DEBUG_ON) {
            System.out.println("End of setLength");
            System.out.print("********************");
            System.out.println("********************");
        }
        return stringBuffer.toString();
    }

    byte[] getTime(Hashtable hashtable) {
        Trace.trace("apnvhscT", "-> getTime");
        Trace.trace("apnvhscF", "resp = " + hashtable);
        if (DEBUG_ON) {
            System.out.println("***************************In getTime method");
        }
        byte[] byArray = new byte[7];
        short s = ((Integer)hashtable.get("YEAR")).shortValue();
        if (DEBUG_ON) {
            System.out.println("Year = " + s);
        }
        Trace.trace("apnvhscF", "Year = " + String.valueOf(s));
        byArray[0] = (byte)((s & 0xFF00) >> 8);
        byArray[1] = (byte)s;
        byArray[2] = ((Integer)hashtable.get("MONTH")).byteValue();
        if (DEBUG_ON) {
            System.out.println("Month = " + byArray[2]);
        }
        Trace.trace("apnvhscF", "Month = " + String.valueOf(byArray[2]));
        byArray[3] = ((Integer)hashtable.get("DAY")).byteValue();
        if (DEBUG_ON) {
            System.out.println("Day = " + byArray[3]);
        }
        Trace.trace("apnvhscF", "Day = " + String.valueOf(byArray[3]));
        byArray[4] = ((Integer)hashtable.get("HOUR")).byteValue();
        if (DEBUG_ON) {
            System.out.println("Hour = " + byArray[4]);
        }
        Trace.trace("apnvhscF", "Hour = " + String.valueOf(byArray[4]));
        byArray[5] = ((Integer)hashtable.get("MINUTE")).byteValue();
        if (DEBUG_ON) {
            System.out.println("Minute = " + byArray[5]);
        }
        Trace.trace("apnvhscF", "Minute = " + String.valueOf(byArray[5]));
        byArray[6] = ((Integer)hashtable.get("SECONDS")).byteValue();
        if (DEBUG_ON) {
            System.out.println("Seconds = " + byArray[6]);
        }
        Trace.trace("apnvhscF", "Seconds = " + String.valueOf(byArray[6]));
        if (DEBUG_ON) {
            System.out.println("***************************End of getTime method");
            System.out.println();
            System.out.println();
        }
        Trace.trace("apnvhscT", "<- getTime");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean isDuplicatedAtPartition(int n, String string, HscProviderSocket hscProviderSocket) throws CIMException {
        boolean bl;
        try {
            try {
                block13: {
                    Trace.trace("apnvhscT", "-> isDuplidatedAtPartition");
                    Trace.trace("apnvhscF", "lparSlot = " + n);
                    Trace.trace("apnvhscF", "profileName = " + string);
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In isDuplicatedAtPartition method");
                    }
                    try {
                        Vector vector;
                        String string2;
                        this.buildNVRAM(hscProviderSocket, false, null, true, true);
                        Vector vector2 = this.getLPARProfilesAtPartition((short)n, hscProviderSocket);
                        if (vector2 == null) {
                            bl = false;
                            return bl;
                        }
                        Enumeration enumeration = vector2.elements();
                        do {
                            if (!enumeration.hasMoreElements()) {
                                Trace.trace("apnvhscF", "No duplicated name in same partition - return false");
                                boolean bl2 = false;
                                return bl2;
                            }
                            vector = (Vector)enumeration.nextElement();
                            Trace.trace("apnvhscF", "properties = " + vector);
                        } while (!(string2 = (String)((CIMProperty)vector.get(1)).getValue().getValue()).equals(string));
                        Trace.trace("apnvhscF", "Duplicated name in partition - return true");
                        boolean bl3 = true;
                        return bl3;
                    }
                    finally {
                        if (!DEBUG_ON) break block13;
                        System.out.println("End of isDuplicatedAtPartition");
                        System.out.print("********************");
                        System.out.println("********************");
                    }
                }
                Object var11_8 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("001F");
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            Trace.trace("apnvhscT", "<- isDuplicatedAtPartition");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- isDuplicatedAtPartition");
        return bl;
    }

    public String decodeTime(byte[] byArray) {
        Trace.trace("apnvhscT", "-> decodeTime");
        Trace.trace("apnvhscF", "time = " + byArray);
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        int n5 = 4;
        int n6 = 5;
        int n7 = 6;
        byte[] byArray2 = new byte[7];
        long l = new BigInteger(byArray).longValue();
        byArray2[n7] = (byte)(l & 0x3FL);
        byArray2[n6] = (byte)((l & 0xFC0L) >>> 6);
        byArray2[n5] = (byte)((l & 0x1F000L) >>> 12);
        byArray2[n4] = (byte)((l & 0x3E0000L) >>> 17);
        byArray2[n3] = (byte)((l & 0x3C00000L) >>> 22);
        byArray2[n2] = (byte)(l >>> 26 & 0x3FFFL);
        byArray2[n] = (byte)((l >>> 26 & 0x3FFFL) >>> 8);
        Trace.trace("apnvhscT", "<- decodeTime");
        return new String(byArray2);
    }

    public static byte[] encodeTime(String string) {
        Trace.trace("apnvhscT", "-> encodeTime");
        Trace.trace("apnvhscF", "time = " + string);
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        int n5 = 4;
        int n6 = 5;
        int n7 = 6;
        byte[] byArray = string.getBytes();
        long l = 0L;
        byte[] byArray2 = new byte[5];
        l |= (long)(byArray[n7] & 0x3F);
        l |= (long)((byArray[n6] & 0x3F) << 6);
        l |= (long)((byArray[n5] & 0x1F) << 12);
        l |= (long)((byArray[n4] & 0x1F) << 17);
        l |= (long)((byArray[n3] & 0xF) << 22);
        byArray2[4] = (byte)(l |= ((long)(0xFF & byArray[n2]) | (long)(byArray[n] << 8)) << 26);
        byArray2[3] = (byte)(l >>> 8);
        byArray2[2] = (byte)(l >>> 16);
        byArray2[1] = (byte)(l >>> 24);
        byArray2[0] = (byte)(l >>> 32);
        Trace.trace("apnvhscT", "<- encodeTime");
        return byArray2;
    }

    public synchronized void deleteLparProfileFromSysProfile(String string, String string2, HscProviderSocket hscProviderSocket) throws CIMException {
        this._deleteLparProfileFromSysProfile(string, string2, hscProviderSocket, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _deleteLparProfileFromSysProfile(String string, String string2, HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        block24: {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            try {
                                try {
                                    Object[] objectArray;
                                    Trace.trace("apnvhscT", "-> deleteLparProfileFromSysProfile");
                                    Trace.trace("apnvhscF", "sysProfTimeStamp = " + string);
                                    Trace.trace("apnvhscF", "lparProfTimeStamp = " + string2);
                                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                                    if (DEBUG_ON) {
                                        System.out.println("****************************************");
                                        System.out.println("In deleteLparProfileFromSysProfile");
                                        System.out.println("sysProfTimeStamp = " + string);
                                        System.out.println("lparProfTimeStamp = " + string2);
                                    }
                                    if (bl) {
                                        this.buildNVRAM(hscProviderSocket, false, null, true, false);
                                    }
                                    if ((objectArray = (Object[])this._profileTable.get(string)) == null) {
                                        if (DEBUG_ON) {
                                            System.out.println("info == null");
                                        }
                                        Object var14_7 = null;
                                        break block20;
                                    }
                                    if (DEBUG_ON) {
                                        System.out.println("info != null");
                                    }
                                    Vector vector = (Vector)objectArray[2];
                                    Trace.trace("apnvhscF", "properties = " + vector);
                                    String string3 = (String)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                                    CIMValue cIMValue = null;
                                    CIMValue cIMValue2 = null;
                                    if (vector.size() >= 4) {
                                        cIMValue = ((CIMProperty)vector.elementAt(2)).getValue();
                                        cIMValue2 = ((CIMProperty)vector.elementAt(3)).getValue();
                                    }
                                    if (cIMValue == null) {
                                        if (DEBUG_ON) {
                                            System.out.println("profLIstValue == null");
                                        }
                                        break block21;
                                    }
                                    Vector vector2 = (Vector)cIMValue.getValue();
                                    Trace.trace("apnvhscF", "profList = " + vector2);
                                    if (DEBUG_ON) {
                                        System.out.println("profList = " + vector2);
                                    }
                                    Vector vector3 = (Vector)cIMValue2.getValue();
                                    Trace.trace("apnvhscF", "partitionList = " + vector3);
                                    if (DEBUG_ON) {
                                        System.out.println("partitionList = " + vector3);
                                    }
                                    if (vector2 == null) {
                                        if (DEBUG_ON) {
                                            System.out.println("profList == null");
                                        }
                                        break block22;
                                    }
                                    int n = vector2.indexOf(string2);
                                    if (DEBUG_ON) {
                                        System.out.println("index = " + n);
                                    }
                                    if (n == -1) {
                                        break block23;
                                    }
                                    vector2.removeElementAt(n);
                                    vector3.removeElementAt(n);
                                    vector.setSize(4);
                                    vector.setElementAt(new CIMProperty("ProfileList", new CIMValue(vector2, new CIMDataType(29))), 2);
                                    vector.setElementAt(new CIMProperty("PartitionIDList", new CIMValue(vector3, new CIMDataType(21))), 3);
                                    this._saveSysProfile(string3, string, vector, null, hscProviderSocket, bl);
                                    if (DEBUG_ON) {
                                        System.out.println("End of deleteLparProfileFromSysProfile");
                                        System.out.println("****************************************");
                                    }
                                    break block24;
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                                    if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                                    throw new HSCCIMException("0020");
                                }
                            }
                            catch (Throwable throwable) {
                                Object var14_12 = null;
                                Trace.trace("apnvhscT", "<- deleteLparProfileFromSysProfile");
                                throw throwable;
                            }
                        }
                        Trace.trace("apnvhscT", "<- deleteLparProfileFromSysProfile");
                        return;
                    }
                    Object var14_8 = null;
                    Trace.trace("apnvhscT", "<- deleteLparProfileFromSysProfile");
                    return;
                }
                Object var14_9 = null;
                Trace.trace("apnvhscT", "<- deleteLparProfileFromSysProfile");
                return;
            }
            Object var14_10 = null;
            Trace.trace("apnvhscT", "<- deleteLparProfileFromSysProfile");
            return;
        }
        Object var14_11 = null;
        Trace.trace("apnvhscT", "<- deleteLparProfileFromSysProfile");
    }

    public synchronized void addLparProfileToSysProfile(String string, String string2, byte by, HscProviderSocket hscProviderSocket) throws CIMException {
        this._addLparProfileToSysProfile(string, string2, by, hscProviderSocket, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _addLparProfileToSysProfile(String string, String string2, byte by, HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        block15: {
            block14: {
                try {
                    try {
                        Object[] objectArray;
                        Trace.trace("apnvhscT", "-> addLparProfileToSysProfile");
                        Trace.trace("apnvhscF", "sysProfTimeStamp = " + string);
                        Trace.trace("apnvhscF", "lparProfTimeStamp = " + string2);
                        Trace.trace("apnvhscF", "partitionID = " + by);
                        Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                        if (DEBUG_ON) {
                            System.out.println("****************************************");
                            System.out.println("In addLparProfileToSysProfile");
                            System.out.println("sysProfTimeStamp = " + string);
                            System.out.println("lparProfTimeStamp = " + string2);
                            System.out.println("paritionID = " + by);
                        }
                        if (bl) {
                            this.buildNVRAM(hscProviderSocket, false, null, true, false);
                        }
                        if ((objectArray = (Object[])this._profileTable.get(string)) == null) {
                            Object var14_8 = null;
                            break block14;
                        }
                        Vector vector = (Vector)objectArray[2];
                        Trace.trace("apnvhscF", "properties = " + vector);
                        String string3 = (String)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                        CIMValue cIMValue = null;
                        CIMValue cIMValue2 = null;
                        if (vector.size() >= 4) {
                            cIMValue = ((CIMProperty)vector.elementAt(2)).getValue();
                            Trace.trace("apnvhscF", "profListValue = " + cIMValue);
                            cIMValue2 = ((CIMProperty)vector.elementAt(3)).getValue();
                            Trace.trace("apnvhscF", "partListValue = " + cIMValue2);
                        }
                        Vector<String> vector2 = new Vector<String>();
                        Vector<UnsignedInt8> vector3 = new Vector<UnsignedInt8>();
                        if (cIMValue != null) {
                            vector2 = (Vector<String>)cIMValue.getValue();
                            vector3 = (Vector<UnsignedInt8>)cIMValue2.getValue();
                            if (vector2 == null) {
                                vector2 = new Vector<String>();
                                vector3 = new Vector<UnsignedInt8>();
                            }
                        }
                        vector2.addElement(string2);
                        vector3.addElement(new UnsignedInt8((short)by));
                        vector.setSize(4);
                        if (vector2.size() == 0) {
                            vector.setElementAt(new CIMProperty("ProfileList", new CIMValue(new Vector(), new CIMDataType(29))), 2);
                            vector.setElementAt(new CIMProperty("PartitionIDList", new CIMValue(new Vector(), new CIMDataType(21))), 3);
                        } else {
                            vector.setElementAt(new CIMProperty("ProfileList", new CIMValue(vector2, new CIMDataType(29))), 2);
                            vector.setElementAt(new CIMProperty("PartitionIDList", new CIMValue(vector3, new CIMDataType(21))), 3);
                        }
                        this._saveSysProfile(string3, string, vector, null, hscProviderSocket, bl);
                        if (DEBUG_ON) {
                            System.out.println("End of addLparProfToSysProfile");
                            System.out.println("****************************************");
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                        if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                        throw new HSCCIMException("0021");
                    }
                }
                catch (Throwable throwable) {
                    Object var14_10 = null;
                    Trace.trace("apnvhscT", "<- addLparProfileToSysProfile");
                    throw throwable;
                }
            }
            Trace.trace("apnvhscT", "<- addLparProfileToSysProfile");
            return;
        }
        Object var14_9 = null;
        Trace.trace("apnvhscT", "<- addLparProfileToSysProfile");
    }

    public synchronized void setSysProfileUserDefName(String string, String string2, HscProviderSocket hscProviderSocket) throws CIMException {
        this._setSysProfileUserDefName(string, string2, hscProviderSocket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _setSysProfileUserDefName(String string, String string2, HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        try {
            try {
                block47: {
                    Trace.trace("apnvhscT", "-> setSysProfileUserDefName");
                    Trace.trace("apnvhscF", "profileTimeStamp = " + string);
                    Trace.trace("apnvhscF", "newName = " + string2);
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("********************************************");
                        System.out.println("In setSysProfileUserDefName");
                    }
                    try {
                        int[] nArray;
                        String string3;
                        boolean bl2;
                        Vector vector;
                        int n;
                        boolean bl3;
                        boolean bl4;
                        int n2;
                        int n3;
                        int n4;
                        short s;
                        block45: {
                            if (bl) {
                                this.buildNVRAM(hscProviderSocket, false, null, true, false);
                            }
                            s = 0;
                            short s2 = 0;
                            boolean bl5 = false;
                            n4 = 0;
                            int n5 = 0;
                            s2 = this._hscTemplateVersion;
                            bl5 = true;
                            n3 = 0;
                            n2 = 0;
                            bl4 = false;
                            bl3 = false;
                            n = (Integer)((Object[])this._profileTable.get(string))[0];
                            Trace.trace("apnvhscF", "oldProfileOffset = " + n);
                            Object[] objectArray = (Object[])this._profileTable.get(string);
                            s = (Short)objectArray[1];
                            vector = (Vector)objectArray[2];
                            Trace.trace("apnvhscF", "oldProperties = " + vector);
                            String string4 = (String)((CIMProperty)vector.elementAt(1)).getValue().getValue();
                            bl2 = false;
                            boolean bl6 = true;
                            if (string2 == null) {
                            }
                            if (string2.equals(string4)) {
                            }
                            Trace.trace("apnvhscF", "Has new name - May need to change the name table");
                            if (this.isDuplicatedAtPartition(0, string2, hscProviderSocket)) {
                                if (DEBUG_ON) {
                                    System.out.println("In saveSysProfile: name already exist");
                                }
                                Trace.trace("apnvhscF", "name already exist in same partition - throw CIMException");
                                throw new HSCCIMException("0004", new String[]{string2, String.valueOf(0)});
                            }
                            string3 = new String(string2);
                            if (DEBUG_ON) {
                                System.out.println("In saveSysProfile: name = " + string3.trim());
                            }
                            nArray = (int[])this._profileNameTable.get(string4);
                            n5 = nArray[0];
                            Trace.trace("apnvhscF", "oldNameOffset = " + String.valueOf(n5));
                            if (DEBUG_ON) {
                                System.out.println("In saveSysProfile: oldNameOffset = " + n5);
                            }
                            n3 = n5;
                            short s3 = (short)nArray[1];
                            if (s3 == 1) {
                                bl2 = true;
                                bl4 = true;
                                int n6 = 0;
                                while (true) {
                                    if (n6 >= 32) {
                                        this._profileNameTable.remove(string4);
                                        this._profileNameOffsetTable.remove(new Integer(n5));
                                        this._pnameFreeList.add(new Integer(n5));
                                        break block45;
                                    }
                                    this._nvramData[n5 + n6] = 0;
                                    ++n6;
                                }
                            }
                            nArray[1] = nArray[1] - 1;
                        }
                        if (this._profileNameTable.containsKey(string2)) {
                            if (DEBUG_ON) {
                                System.out.println("In saveSysProfile: contained the new name already");
                            }
                            Trace.trace("apnvhscF", "profileNameTable already contains the new name - Just increment the reference count");
                            nArray = (int[])this._profileNameTable.get(string3);
                            n4 = nArray[0];
                            Trace.trace("apnvhscF", "nameIndex = " + String.valueOf(n4));
                            if (DEBUG_ON) {
                                System.out.println("In saveSysProfile: nameIndex = " + n4);
                            }
                            nArray[1] = nArray[1] + 1;
                        } else {
                            Trace.trace("apnvhscF", "profileNameTable doesn't contain the new name - Need to create one in the name table");
                            bl2 = true;
                            if (DEBUG_ON) {
                                System.out.println("In saveSysProfile: the new name is not yet exist. Need to create one");
                            }
                            if (this._pnameFreeList.isEmpty()) {
                                if (!DEBUG_ON) throw new HSCCIMException("0001");
                                System.out.println("No more space for new name");
                                throw new HSCCIMException("0001");
                            }
                            bl3 = true;
                            nArray = new int[2];
                            nArray[0] = (Integer)this._pnameFreeList.elementAt(0);
                            if (DEBUG_ON) {
                                System.out.println("In saveSysProfile: new name offset = " + nArray[0]);
                            }
                            this._pnameFreeList.removeElementAt(0);
                            nArray[1] = 1;
                            n2 = n4 = nArray[0];
                            this._profileNameTable.put(string3, nArray);
                            this._profileNameOffsetTable.put(new Integer(n4), string3);
                            byte[] byArray = this.setLength(string3, 32).getBytes();
                            int n7 = 0;
                            while (n7 < 32) {
                                this._nvramData[n4 + n7] = byArray[n7];
                                ++n7;
                            }
                        }
                        try {
                            if (this._releaseVersion < 3) {
                                this._nvramData[n + this.NAME_INDEX_OFFSET] = (byte)(n4 >> 8);
                                this._nvramData[n + this.NAME_INDEX_OFFSET + 1] = (byte)n4;
                            } else {
                                this.writeIntToNvramData(n4, n + this.DLPAR_NAME_INDEX_OFFSET_R4);
                            }
                            vector.setElementAt(new CIMProperty("UserDefinedName", new CIMValue((Object)string3)), 1);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                            throw new HSCCIMException("0007");
                        }
                        if (bl) {
                            byte by;
                            block46: {
                                String[] stringArray = null;
                                Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", stringArray, hscProviderSocket, this._cspVersion);
                                byte[] byArray = this.getTime(hashtable);
                                int n8 = 0;
                                while (true) {
                                    if (n8 >= 7) {
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                                        this._nvramTimeStamp = (byte[])byArray.clone();
                                        if (bl2) {
                                            this._profileNameTableTimeStamp = (byte[])byArray.clone();
                                            this._checksumCalc.reset();
                                            this._checksumCalc.update(this._nvramData, this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
                                            this._checksum = this._checksumCalc.getValue();
                                            this.writeIntegralToNvramData(this._checksum, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                                        }
                                        this._drawerProfileInfoTimeStamp = (byte[])byArray.clone();
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, (short)8);
                                        if (this._releaseVersion != 0) {
                                            by = this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET;
                                            if (this._releaseVersion >= 3) break;
                                            this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = (byte)(by >>> 8);
                                            this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = (byte)(by & 0xFF);
                                        }
                                        break block46;
                                    }
                                    this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + n8] = byArray[n8];
                                    if (bl2) {
                                        this._nvramData[this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + n8] = byArray[n8];
                                    }
                                    this._nvramData[this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + n8] = byArray[n8];
                                    ++n8;
                                }
                                this.writeIntToNvramData(by, this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET);
                            }
                            this._backupToLocalFile();
                            by = (byte)(this._releaseVersion << 1 | CORRUPTED_ON[0]);
                            this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                            this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, hscProviderSocket);
                            if (bl2) {
                                this._writeDataToCSP(new String(this._nvramData, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                if (bl4) {
                                    this._writeDataToCSP(this._zeroOutNameString.getBytes(), n3, 32, hscProviderSocket);
                                }
                                if (bl3) {
                                    this._writeDataToCSP(this.setLength(string3, 32).getBytes(), n2, 32, hscProviderSocket);
                                }
                            }
                            if (this._releaseVersion == 0) {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8, hscProviderSocket);
                            } else if (this._releaseVersion < 3) {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10, hscProviderSocket);
                            } else {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12, hscProviderSocket);
                            }
                            this._writeDataToCSP(new String(this._nvramData, n, (int)s).getBytes(), n, s, hscProviderSocket);
                            by = (byte)(this._releaseVersion << 1 | CORRUPTED_OFF[0]);
                            this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                        }
                    }
                    finally {
                        if (!DEBUG_ON) break block47;
                        System.out.println("End of setSysProfileUserDefName");
                        System.out.println("***********************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var32_21 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("0032");
            }
        }
        catch (Throwable throwable) {
            Object var32_24 = null;
            Trace.trace("apnvhscT", "<- setSysProfileUserDefName");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- setSysProfileUserDefName");
    }

    public synchronized String getPartitionName(int n, HscProviderSocket hscProviderSocket) throws CIMException {
        String string;
        try {
            Trace.trace("apnvhscT", "-> getPartitionName");
            Trace.trace("apnvhscF", "lparID = " + n);
            Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println("In getPartitionName");
            }
            this.buildNVRAM(hscProviderSocket, false, null, true, true);
            if (DEBUG_ON) {
                System.out.println("return = " + this._partitionNameTable[n - 1]);
                System.out.println("End of getPartitionName");
                System.out.println("****************************************");
            }
            string = this._partitionNameTable[n - 1];
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (!(throwable instanceof HSCCIMException)) {
                    throw new HSCCIMException("0022");
                }
                throw new HSCCIMException(throwable);
            }
            catch (Throwable throwable2) {
                Object var5_6 = null;
                Trace.trace("apnvhscT", "<- getPartitionName");
                throw throwable2;
            }
        }
        Trace.trace("apnvhscT", "<- getPartitionName");
        return string;
    }

    public synchronized String[] getAllPartitionNames(HscProviderSocket hscProviderSocket) throws CIMException {
        String[] stringArray;
        try {
            Trace.trace("apnvhscT", "-> getAllPartitionNames");
            Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println("In getAllPartitionNames");
            }
            this.buildNVRAM(hscProviderSocket, false, null, true, true);
            String[] stringArray2 = new String[this.NUM_PARTITION_SLOTS];
            int n = 0;
            while (n < this.NUM_PARTITION_SLOTS) {
                stringArray2[n] = this._partitionNameTable[n] == null || this._partitionNameTable[n].trim().length() == 0 ? "" : this._partitionNameTable[n];
                if (DEBUG_ON) {
                    System.out.println("lparNames[" + (n + 1) + "] = " + stringArray2[n]);
                }
                Trace.trace("apnvhscF", "lparNames[" + n + "] = " + stringArray2[n]);
                ++n;
            }
            if (DEBUG_ON) {
                System.out.println("lparNames = " + stringArray2);
                System.out.println("End of getAllPartitionNames");
                System.out.println("****************************************");
            }
            stringArray = stringArray2;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (!(throwable instanceof HSCCIMException)) {
                    throw new HSCCIMException("0023");
                }
                throw new HSCCIMException(throwable);
            }
            catch (Throwable throwable2) {
                Object var6_7 = null;
                Trace.trace("apnvhscT", "<- getAllPartitionNames");
                throw throwable2;
            }
        }
        Trace.trace("apnvhscT", "<- getAllPartitionNames");
        return stringArray;
    }

    public synchronized void setPartitionName(int n, String string, HscProviderSocket hscProviderSocket) throws CIMException {
        try {
            block11: {
                try {
                    int n2;
                    Trace.trace("apnvhscT", "-> setPartitionName");
                    Trace.trace("apnvhscF", "lparID = " + n);
                    Trace.trace("apnvhscF", "lparName = " + string);
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In setPartitionName");
                        System.out.println("lparID = " + n);
                        System.out.println("lparName = " + string);
                    }
                    Object var4_4 = null;
                    Object var5_6 = null;
                    this.buildNVRAM(hscProviderSocket, false, null, true, false);
                    this._partitionNameTable[n - 1] = string;
                    byte[] byArray = null;
                    if (string == null) {
                        byArray = new byte[32];
                    } else {
                        n2 = string.length();
                        if (n2 != 31) {
                            string = this.setLength(string, 31);
                        }
                        byArray = string.getBytes();
                    }
                    n2 = 0;
                    while (n2 < 31) {
                        this._nvramData[n2 + (n - 1) * this.SIZE_OF_LPAR_INFO + this.PARTITION_NAME_TABLE_OFFSET] = byArray[n2];
                        ++n2;
                    }
                    Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", null, hscProviderSocket, this._cspVersion);
                    byte[] byArray2 = this.getTime(hashtable);
                    int n3 = 0;
                    while (n3 < 7) {
                        this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + n3] = byArray2[n3];
                        this._nvramData[this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET + n3] = byArray2[n3];
                        ++n3;
                    }
                    this._checksumCalc.reset();
                    this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                    this._checksum = this._checksumCalc.getValue();
                    this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                    this._checksumCalc.reset();
                    this._checksumCalc.update(this._nvramData, this.PARTITION_NAME_TABLE_OFFSET, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET - this.PARTITION_NAME_TABLE_OFFSET);
                    this._checksum = this._checksumCalc.getValue();
                    this.writeIntegralToNvramData(this._checksum, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                    this._nvramTimeStamp = (byte[])byArray2.clone();
                    this._partitionNameTableTimeStamp = (byte[])byArray2.clone();
                    this._backupToLocalFile();
                    byte by = (byte)(this._releaseVersion << 1 | CORRUPTED_ON[0]);
                    this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                    this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, hscProviderSocket);
                    this._writeDataToCSP(new String(this._nvramData, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                    this._writeDataToCSP(byArray, this.PARTITION_NAME_TABLE_OFFSET + (n - 1) * this.SIZE_OF_LPAR_INFO, 31, hscProviderSocket);
                    by = (byte)(this._releaseVersion << 1 | CORRUPTED_OFF[0]);
                    this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                    if (!DEBUG_ON) break block11;
                    System.out.println("End of setPartitionName");
                    System.out.println("****************************************");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof HSCCIMException)) {
                        throw new HSCCIMException("0024");
                    }
                    throw new HSCCIMException(throwable);
                }
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            Trace.trace("apnvhscT", "<- setPartitionName");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- setPartitionName");
    }

    private synchronized void writeIntegralToNvramData(long l, int n, short s) {
        int n2;
        Trace.trace("apnvhscT", "-> writeIntegralToNvramData");
        Trace.trace("apnvhscF", "integral = " + l);
        Trace.trace("apnvhscF", "offset = " + n);
        Trace.trace("apnvhscF", "length = " + s);
        if (DEBUG_ON) {
            System.out.println("****************************************");
            System.out.println("In writeIntegralToNvramData");
            System.out.println("integral = " + l);
            System.out.println("offset = " + n);
            System.out.println("length = " + s);
        }
        int n3 = 0;
        if (s == 8) {
            n2 = 0;
            while (n2 < 4) {
                this._nvramData[n + n3] = (byte)(l >>> (8 - n3 - 1) * 8);
                ++n2;
                ++n3;
            }
        }
        if (s >= 4) {
            n2 = 0;
            while (n2 < 2) {
                this._nvramData[n + n3] = (byte)(l >>> (8 - n3 - 1) * 8);
                ++n2;
                ++n3;
            }
        }
        if (s >= 2) {
            n2 = 0;
            while (n2 < 1) {
                this._nvramData[n + n3] = (byte)(l >>> (8 - n3 - 1) * 8);
                ++n2;
                ++n3;
            }
        }
        if (s >= 1) {
            this._nvramData[n + n3] = (byte)l;
        }
        if (DEBUG_ON) {
            System.out.println("End of writeIntegralToNvramData");
            System.out.println("****************************************");
        }
        Trace.trace("apnvhscT", "<- writeIntegralToNvramData");
    }

    private synchronized void writeIntToNvramData(int n, int n2) {
        Trace.trace("apnvhscT", "-> writeIntToNvramData");
        Trace.trace("apnvhscF", "int = " + n);
        Trace.trace("apnvhscF", "offset = " + n2);
        if (DEBUG_ON) {
            System.out.println("****************************************");
            System.out.println("In writeIntToNvramData");
            System.out.println("int = " + n);
            System.out.println("offset = " + n2);
        }
        this._nvramData[n2] = (byte)(n >>> 24);
        this._nvramData[n2 + 1] = (byte)(n >>> 16);
        this._nvramData[n2 + 2] = (byte)(n >>> 8);
        this._nvramData[n2 + 3] = (byte)(n & 0xFF);
        if (DEBUG_ON) {
            int n3 = 0;
            while (n3 < 4) {
                System.out.println("_nvramData[" + (n2 + n3) + "] = " + this._nvramData[n2 + n3]);
                ++n3;
            }
        }
        if (DEBUG_ON) {
            System.out.println("End of writeIntegralToNvramData");
            System.out.println("****************************************");
        }
        Trace.trace("apnvhscT", "<- writeIntegralToNvramData");
    }

    public synchronized NVRAM buildNVRAMFromLocalCopy(HscProviderSocket hscProviderSocket, File file, boolean bl, boolean bl2) throws CIMException {
        NVRAM nVRAM;
        try {
            Object object;
            Trace.trace("apnvhscT", " -> buildNVRAMFromLocalCopy");
            Trace.trace("apnvhscF", "HscProviderSocket socket = " + hscProviderSocket);
            Trace.trace("apnvhscF", "restoreFile = " + file);
            Trace.trace("apnvhscF", "writeToCSP = " + bl);
            Trace.trace("apnvhscF", "writeToBackup = " + bl2);
            Hashtable hashtable = null;
            if (this._cspVersion == null || this._cspVersion.trim().length() == 0) {
                hashtable = HscProviderUtils.doCSPCommand("GET_CSP_INTERFACE_VERSION_NUMBER", null, hscProviderSocket);
                this._cspVersion = (String)hashtable.get("VERSION");
                if (DEBUG_ON) {
                    System.out.println("cspVersion = " + this._cspVersion);
                }
                object = HscProviderUtils.getCapabilities(this._cspVersion, hscProviderSocket);
                short by = (short)((Integer)((Hashtable)object).get("CecCapability")).intValue();
                this._cspCapability = by;
                this._runtimeCapability = (Integer)((Hashtable)object).get("RuntimeCapability");
            }
            hashtable = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", null, hscProviderSocket, this._cspVersion);
            object = this.getTime(hashtable);
            if (DEBUG_ON) {
                System.out.println("in buildNVRAMFromLocalCopy ---- about to call buildNVRAM");
                System.out.println("in buildNVRAMFromLocalCopy -- NUM_PARTITION_SLOTS = " + this.NUM_PARTITION_SLOTS);
                System.out.println("in buildNVRAMFromLocalCopy -- _releaseNumPartitionSlots = " + this._releaseNumPartitionSlots);
            }
            this.buildNVRAM(hscProviderSocket, false, file, bl2, false);
            if (bl) {
                byte nVRAM2 = (byte)(this._releaseVersion << 1 | CORRUPTED_ON[0]);
                this._writeDataToCSP(new byte[]{nVRAM2}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                if (DEBUG_ON) {
                    System.out.println("buildNVRAMFromLocalCopy releaseVersion = " + this._releaseVersion);
                }
                if (this._releaseVersion == 0) {
                    this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.NVRAM_SIZE - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.NVRAM_SIZE - this.TIME_STAMPS_CHECKSUM_OFFSET, hscProviderSocket);
                } else {
                    this._writeDataToCSP(new String(this._nvramData, this.NUM_ALPAR_SLOTS_OFFSET, this.NVRAM_SIZE - this.NUM_ALPAR_SLOTS_OFFSET).getBytes(), this.NUM_ALPAR_SLOTS_OFFSET, this.NVRAM_SIZE - this.NUM_ALPAR_SLOTS_OFFSET, hscProviderSocket);
                }
                byte by = (byte)(this._releaseVersion << 1 | CORRUPTED_OFF[0]);
                this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
            }
            NVRAM_TABLE.put(this._cecName, this);
            nVRAM = this;
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (!(throwable instanceof HSCCIMException)) {
                    throw new HSCCIMException("0025", new String[]{file.getName()});
                }
                throw new HSCCIMException(throwable);
            }
            catch (Throwable throwable2) {
                Object var9_13 = null;
                Trace.trace("apnvhscT", " <- buildNVRAMFromLocalCopy");
                throw throwable2;
            }
        }
        Trace.trace("apnvhscT", " <- buildNVRAMFromLocalCopy");
        return nVRAM;
    }

    private synchronized void _writeDataToCSP(byte[] byArray, int n, int n2, HscProviderSocket hscProviderSocket) throws CIMException {
        try {
            block12: {
                try {
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In _writeDataToCSP");
                        System.out.println("offset = " + n);
                        System.out.println("length = " + n2);
                    }
                    Trace.trace("apnvhscT", " -> writeDataToCSP");
                    Trace.trace("apnvhscF", "byte[] data = " + byArray);
                    Trace.trace("apnvhscF", "offset = " + String.valueOf(n));
                    Trace.trace("apnvhscF", "length = " + String.valueOf(n2));
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    String[] stringArray = null;
                    Hashtable hashtable = null;
                    int n3 = n2;
                    int n4 = 1;
                    int n5 = n3 % 1000;
                    n4 = n3 > 1000 && n5 != 0 ? n3 / 1000 + 1 : (n5 == 0 ? n3 / 1000 : 1);
                    int n6 = 0;
                    while (n6 < n4) {
                        stringArray = new String[3];
                        stringArray[0] = String.valueOf(n + n6 * 1000);
                        if (DEBUG_ON) {
                            System.out.println("arg[0] = " + stringArray[0]);
                        }
                        if (n6 != n4 - 1 || n5 == 0) {
                            stringArray[1] = String.valueOf(1000);
                            if (DEBUG_ON) {
                                System.out.println("arg[1] = " + stringArray[1]);
                            }
                            stringArray[2] = new String(byArray, n6 * 1000, 1000);
                        } else {
                            stringArray[1] = String.valueOf(n5);
                            if (DEBUG_ON) {
                                System.out.println("arg[1] = " + stringArray[1]);
                            }
                            stringArray[2] = new String(byArray, n6 * 1000, n5);
                        }
                        hashtable = HscProviderUtils.doCSPCommand("SET_HSC_SAVE_AREA", stringArray, hscProviderSocket, this._cspVersion);
                        ++n6;
                    }
                    if (!DEBUG_ON) break block12;
                    System.out.println("End of _writeDataToCSP");
                    System.out.println("****************************************");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof HSCCIMException)) {
                        throw new HSCCIMException("0026");
                    }
                    throw new HSCCIMException(throwable);
                }
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            Trace.trace("apnvhscT", " <- _writeDataToCSP");
            throw throwable;
        }
        Trace.trace("apnvhscT", " <- _writeDataToCSP");
    }

    private synchronized void _backupToLocalFile() throws CIMException {
        try {
            try {
                Trace.trace("apnvhscT", " -> _backupToLocalFile");
                if (DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println("_backupToLocalFile");
                }
                try {
                    String string = "/var/hsc/profiles/";
                    string = string.concat(this._cecName) + "/";
                    File file = new File(string);
                    file.mkdirs();
                    string = string.concat("backupFile");
                    if (DEBUG_ON) {
                        System.out.println("dir = " + string);
                    }
                    RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
                    byte by = (byte)(this._releaseVersion << 1 | CORRUPTED_ON[0]);
                    randomAccessFile.write(new byte[]{by});
                    if (this._releaseVersion == 0) {
                        randomAccessFile.write(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.NVRAM_SIZE - 1);
                    } else {
                        randomAccessFile.write(this._nvramData, this.NUM_ALPAR_SLOTS_OFFSET, this.NVRAM_SIZE - 1);
                        if (DEBUG_ON) {
                            System.out.println("_nvramData[NUM_ALPAR_SLOTS_OFFSET] = " + this._nvramData[this.NUM_ALPAR_SLOTS_OFFSET]);
                            System.out.println("NUM_ALPAR_SLOTS_OFFSET = " + this.NUM_ALPAR_SLOTS_OFFSET);
                        }
                    }
                    randomAccessFile.seek(0L);
                    by = (byte)(this._releaseVersion << 1 | CORRUPTED_OFF[0]);
                    if (DEBUG_ON) {
                        System.out.println("backup to local --> _releaseVersion= " + this._releaseVersion);
                        System.out.println("verAndCorrupt = " + by);
                    }
                    randomAccessFile.write(new byte[]{by});
                    if (this._releaseVersion != 0 && DEBUG_ON) {
                        System.out.println("In backupToLocalFile _nvram[DRAWER_PROF_INFO_DATA_SIZE_OFFSET] =  " + this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET]);
                        System.out.println("In backupToLocalFile _nvram[DRAWER_PROF_INFO_DATA_SIZE_OFFSET+1] =  " + this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1]);
                        if (this._releaseVersion >= 3) {
                            System.out.println("In backupToLocalFile _nvram[DRAWER_PROF_INFO_DATA_SIZE_OFFSET+2] =  " + this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 2]);
                            System.out.println("In backupToLocalFile _nvram[DRAWER_PROF_INFO_DATA_SIZE_OFFSET+3] =  " + this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 3]);
                        }
                    }
                    randomAccessFile.close();
                    if (DEBUG_ON) {
                        System.out.println("End of _backupToLocalFile");
                        System.out.println("****************************************");
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    throw new HSCCIMException("1195");
                }
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (!(throwable instanceof HSCCIMException)) {
                    throw new HSCCIMException("0027");
                }
                throw new HSCCIMException(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            Trace.trace("apnvhscF", "<- _backupToLocalFile");
            throw throwable;
        }
        Trace.trace("apnvhscF", "<- _backupToLocalFile");
    }

    public synchronized boolean existInPartition(int n, String string) {
        Trace.trace("apnvhscT", " -> existInPartition");
        Trace.trace("apnvhscF", "lparID = " + String.valueOf(n));
        Trace.trace("apnvhscF", "profTimestamp = " + string);
        if (DEBUG_ON) {
            System.out.println("****************************************");
            System.out.println("existInPartition");
        }
        boolean bl = this._profilesAtPartitionTable[n].contains(string);
        Trace.trace("apnvhscF", "ret = " + bl);
        if (DEBUG_ON) {
            System.out.println("exist or not = " + bl);
            System.out.println("end of existInPartition");
            System.out.println("****************************************");
        }
        Trace.trace("apnvhscT", "<- existInPartition");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized byte[] _readDataFromCSP(int n, int n2, HscProviderSocket hscProviderSocket) throws CIMException {
        byte[] byArray;
        try {
            try {
                Trace.trace("apnvhscT", "-> _readDataFromCSP");
                Trace.trace("apnvhscF", "offset = " + String.valueOf(n));
                Trace.trace("apnvhscF", "length = " + String.valueOf(n2));
                Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                if (DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println(" In _readDataFromCSP");
                    System.out.println("offset = " + n);
                    System.out.println("len = " + n2);
                }
                int n3 = n2;
                int n4 = 1;
                int n5 = n3 % 1000;
                byte[] byArray2 = new byte[n2];
                String[] stringArray = null;
                Hashtable hashtable = null;
                byte[] byArray3 = null;
                try {
                    if (n3 > 1000) {
                        n4 = n5 != 0 ? n3 / 1000 + 1 : n3 / 1000;
                    }
                    if (DEBUG_ON) {
                        System.out.println("----------Data------------------");
                    }
                    int n6 = 0;
                    block6: while (true) {
                        if (n6 >= n4) {
                            if (DEBUG_ON) {
                                System.out.println("-------------------------------------");
                            }
                            byArray = byArray2;
                            Object var14_15 = null;
                            if (DEBUG_ON) {
                                System.out.println("End of _readDataFromCSP()");
                                System.out.println("****************************************");
                            }
                            break;
                        }
                        stringArray = new String[]{String.valueOf(n + n6 * 1000), n6 != n4 - 1 || n5 == 0 ? String.valueOf(1000) : String.valueOf(n5)};
                        hashtable = HscProviderUtils.doCSPCommand("GET_HSC_SAVE_AREA", stringArray, hscProviderSocket, this._cspVersion);
                        byArray3 = (byte[])hashtable.get("NVRAM_DATA");
                        int n7 = 0;
                        while (true) {
                            if (n7 >= byArray3.length) {
                                ++n6;
                                continue block6;
                            }
                            byArray2[n6 * 1000 + n7] = byArray3[n7];
                            ++n7;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    if (!DEBUG_ON) throw throwable;
                    System.out.println("End of _readDataFromCSP()");
                    System.out.println("****************************************");
                    throw throwable;
                }
                Object var16_17 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("0028");
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            Trace.trace("apnvhscT", " <- _readDataFromCSP()");
            throw throwable;
        }
        Trace.trace("apnvhscT", " <- _readDataFromCSP()");
        return byArray;
    }

    public synchronized void deleteProfilesAtPartition(int n, HscProviderSocket hscProviderSocket) throws CIMException {
        try {
            block7: {
                try {
                    Trace.trace("apnvhscT", " -> deleteProfilesAtPartition");
                    Trace.trace("apnvhscF", "lparID = " + String.valueOf(n));
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.print("********************");
                        System.out.println("********************");
                        System.out.println("In deleteProfilesAtPartition");
                    }
                    Vector vector = this.getLPARProfilesAtPartition((short)n, hscProviderSocket);
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Trace.trace("apnvhscF", "profTimestamp = " + string);
                        this.removeLPARProfile(string, hscProviderSocket);
                    }
                    this.modifySysProfilesUsingLparID(n, hscProviderSocket);
                    if (!DEBUG_ON) break block7;
                    System.out.println("End of deleteProfilesAtPartition");
                    System.out.print("********************");
                    System.out.println("********************");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof HSCCIMException)) {
                        throw new HSCCIMException("0029", new String[]{String.valueOf(n)});
                    }
                    throw new HSCCIMException(throwable);
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Trace.trace("apnvhscT", " <- deleteProfilesAtPartition");
            throw throwable;
        }
        Trace.trace("apnvhscT", " <- deleteProfilesAtPartition");
    }

    public synchronized void modifySysProfilesUsingLparID(int n, HscProviderSocket hscProviderSocket) throws CIMException {
        try {
            block8: {
                try {
                    Trace.trace("apnvhscT", " -> modifySysProfilesUsingLparID");
                    Trace.trace("apnvhscF", "lparID = " + String.valueOf(n));
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.print("********************");
                        System.out.println("********************");
                        System.out.println("In modifySysProfilesUsingLparID");
                    }
                    Vector vector = this.getLPARProfilesAtPartition((short)0, hscProviderSocket);
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        if (DEBUG_ON) {
                            System.out.println("sysProfTimestamp = " + string);
                        }
                        Trace.trace("apnvhscF", "sysProfTimestamp = " + string);
                        Vector vector2 = this.getSysProfile(string, hscProviderSocket);
                        Trace.trace("apnvhscF", "properties = " + vector2);
                        CIMProperty cIMProperty = (CIMProperty)vector2.get(3);
                        CIMProperty cIMProperty2 = (CIMProperty)vector2.get(2);
                        if (cIMProperty == null) continue;
                        CIMValue cIMValue = cIMProperty.getValue();
                        CIMValue cIMValue2 = cIMProperty2.getValue();
                        if (cIMValue == null) continue;
                        Vector vector3 = (Vector)cIMValue.getValue();
                        Trace.trace("apnvhscF", "lparIDs = " + vector3);
                        Vector vector4 = (Vector)cIMValue2.getValue();
                        Trace.trace("apnvhscF", "lparProfs = " + vector4);
                        if (vector3 == null) break;
                        int n2 = vector3.indexOf(new UnsignedInt8((short)n));
                        if (n2 == -1) continue;
                        vector3.removeElementAt(n2);
                        vector4.removeElementAt(n2);
                        vector2.setSize(4);
                        if (vector3.size() != 0) break;
                        vector2.setElementAt(new CIMProperty("ProfileList", new CIMValue(new Vector(), new CIMDataType(29))), 2);
                        vector2.setElementAt(new CIMProperty("PartitionIDList", new CIMValue(new Vector(), new CIMDataType(21))), 3);
                        String string2 = (String)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                        this.saveSysProfile(string2, string, vector2, null, hscProviderSocket);
                    }
                    if (!DEBUG_ON) break block8;
                    System.out.println("End of modifySysProfilesUsingLparID");
                    System.out.print("********************");
                    System.out.println("********************");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof HSCCIMException)) {
                        throw new HSCCIMException("002A", new String[]{String.valueOf(n)});
                    }
                    throw new HSCCIMException(throwable);
                }
            }
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            Trace.trace("apnvhscT", " <- modifySysProfilesUsingLparID");
            throw throwable;
        }
        Trace.trace("apnvhscT", " <- modifySysProfilesUsingLparID");
    }

    public static String printableTimestamp(String string) {
        Trace.trace("apnvhscT", " -> printableTimestamp");
        Trace.trace("apnvhscF", "timestamp = " + string);
        if (DEBUG_ON) {
            System.out.println("****************************************");
            System.out.println("In printableTimestamp");
        }
        byte[] byArray = string.getBytes();
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray[0] << 8 | byArray[1] & 0xFF;
        stringBuffer.append(n);
        stringBuffer.append('/');
        stringBuffer.append(byArray[2]);
        stringBuffer.append('/');
        stringBuffer.append(byArray[3]);
        stringBuffer.append('/');
        stringBuffer.append(byArray[4]);
        stringBuffer.append('/');
        stringBuffer.append(byArray[5]);
        stringBuffer.append('/');
        stringBuffer.append(byArray[6]);
        if (DEBUG_ON) {
            System.out.println("printableString = " + stringBuffer);
            System.out.println("End of printableTimestamp");
            System.out.println("****************************************");
        }
        Trace.trace("apnvhscF", "ret = " + stringBuffer);
        Trace.trace("apnvhscT", "<- printableTimestamp");
        return stringBuffer.toString();
    }

    public static String cryptedTimestamp(String string) {
        Trace.trace("apnvhscT", "-> cryptedTimestamp");
        Trace.trace("apnvhscF", "time = " + string);
        if (DEBUG_ON) {
            System.out.println("****************************************");
            System.out.println("In cryptedTimeStamp");
        }
        byte[] byArray = new byte[7];
        int n = 0;
        int n2 = string.indexOf(47);
        int n3 = Integer.parseInt(new String(string.getBytes(), n, n2 - n));
        n = n2;
        n2 = string.indexOf(47, n + 1);
        int n4 = Integer.parseInt(new String(string.getBytes(), n + 1, n2 - 1 - n));
        n = n2;
        n2 = string.indexOf(47, n + 1);
        int n5 = Integer.parseInt(new String(string.getBytes(), n + 1, n2 - 1 - n));
        n = n2;
        n2 = string.indexOf(47, n + 1);
        int n6 = Integer.parseInt(new String(string.getBytes(), n + 1, n2 - 1 - n));
        n = n2;
        n2 = string.indexOf(47, n + 1);
        int n7 = Integer.parseInt(new String(string.getBytes(), n + 1, n2 - 1 - n));
        n = n2;
        int n8 = Integer.parseInt(new String(string.getBytes(), n + 1, string.length() - n - 1));
        byArray[0] = (byte)(n3 >>> 8);
        byArray[1] = (byte)n3;
        byArray[2] = (byte)n4;
        byArray[3] = (byte)n5;
        byArray[4] = (byte)n6;
        byArray[5] = (byte)n7;
        byArray[6] = (byte)n8;
        if (DEBUG_ON) {
            System.out.println("End of cryptedTimestamp");
            System.out.println("****************************************");
        }
        Trace.trace("apnvhscT", "<- cryptedTimestamp");
        return new String(byArray);
    }

    public static Vector arrayToVec(Object[] objectArray) {
        Trace.trace("apnvhscT", "-> arrayToVec");
        Trace.trace("apnvhscF", "arr = " + objectArray);
        if (objectArray == null) {
            return new Vector();
        }
        int n = objectArray.length;
        Vector<Object> vector = new Vector<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            vector.setElementAt(object, n2);
            ++n2;
        }
        Trace.trace("apnvhscF", "retVec = " + vector);
        Trace.trace("apnvhscT", "<- arrayToVec");
        return vector;
    }

    public synchronized boolean isCorrupted(byte[] byArray) {
        Trace.trace("apnvhscT", "-> isCorrupted");
        Trace.trace("apnvhscF", "data = " + byArray);
        if ((byArray[0] & 1) == CORRUPTED_ON[0]) {
            Trace.trace("apnvhscT", "<- isCorrupted(true - corrupted bit)");
            return true;
        }
        int n = (byArray[0] & this._versionMask) >>> 1;
        BigInteger bigInteger = new BigInteger(new String(byArray, this.TIME_STAMPS_CHECKSUM_OFFSET, 8));
        long l = bigInteger.longValue();
        Adler32 adler32 = new Adler32();
        adler32.reset();
        adler32.update(byArray, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
        if (l != adler32.getValue()) {
            if (DEBUG_ON) {
                System.out.println("timestamp corrupted");
            }
            Trace.trace("apnvhscT", "<- isCorrupted(true - timestamps)");
            return true;
        }
        bigInteger = new BigInteger(new String(byArray, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8));
        l = bigInteger.longValue();
        adler32.reset();
        adler32.update(byArray, this.PARTITION_NAME_TABLE_OFFSET, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET - this.PARTITION_NAME_TABLE_OFFSET);
        if (l != adler32.getValue()) {
            if (DEBUG_ON) {
                System.out.println("partitionNameTable corrupted");
            }
            Trace.trace("apnvhscT", "<- isCorrupted(true - partitionNameTable)");
            return true;
        }
        bigInteger = new BigInteger(new String(byArray, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8));
        l = bigInteger.longValue();
        adler32.reset();
        adler32.update(byArray, this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
        if (l != adler32.getValue()) {
            if (DEBUG_ON) {
                System.out.println("profileNameTable corrupted");
            }
            Trace.trace("apnvhscT", "<- isCorrupted(true profileNameTable)");
            return true;
        }
        bigInteger = new BigInteger(new String(byArray, this.DEFAULT_LIST_CHECKSUM_OFFSET, 8));
        l = bigInteger.longValue();
        adler32.reset();
        adler32.update(byArray, this.DEFAULT_LIST_OFFSET, this.ACTIVATED_LIST_CHECKSUM_OFFSET - this.DEFAULT_LIST_OFFSET);
        if (l != adler32.getValue()) {
            if (DEBUG_ON) {
                System.out.println("defaultList corrupted");
            }
            Trace.trace("apnvhscT", "<- isCorrupted(true - defaultList)");
            return true;
        }
        bigInteger = new BigInteger(new String(byArray, this.ACTIVATED_LIST_CHECKSUM_OFFSET, 8));
        l = bigInteger.longValue();
        adler32.reset();
        if (n == 0) {
            adler32.update(byArray, this.ACTIVATED_LIST_OFFSET, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET - this.ACTIVATED_LIST_OFFSET);
        } else {
            adler32.update(byArray, this.ACTIVATED_LIST_OFFSET, this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET - this.ACTIVATED_LIST_OFFSET);
        }
        if (l != adler32.getValue()) {
            if (DEBUG_ON) {
                System.out.println("activatedList corrupted");
            }
            Trace.trace("apnvhscT", "<- isCorrupted(true - activatedList)");
            return true;
        }
        if (n != 0) {
            bigInteger = new BigInteger(new String(byArray, this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET, 8));
            l = bigInteger.longValue();
            adler32.reset();
            adler32.update(byArray, this.PHY_LOC_CODE_TABLE_OFFSET, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET - this.PHY_LOC_CODE_TABLE_OFFSET);
            if (l != adler32.getValue()) {
                if (DEBUG_ON) {
                    System.out.println("phyLocCodeTable corrupted");
                }
                Trace.trace("apnvhscT", "<- isCorrupted(true - phyLocCodeTable)");
                return true;
            }
        }
        bigInteger = new BigInteger(new String(byArray, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8));
        l = bigInteger.longValue();
        adler32.reset();
        if (n == 0) {
            adler32.update(byArray, this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET);
        } else {
            int n2 = new BigInteger(new String(byArray, this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET, 2)).intValue();
            adler32.update(byArray, this.NUM_DRAWERS_OFFSET, n2);
        }
        if (l != adler32.getValue()) {
            if (DEBUG_ON) {
                System.out.println("drawersProfileInfo corrupted");
            }
            Trace.trace("apnvhscT", "<- isCorrupted(true - drawers and profiles)");
            return true;
        }
        Trace.trace("apnvhscT", "<- isCorrupted(false)");
        return false;
    }

    public NVRAM priorityRestore(File file, File file2, int n, HscProviderSocket hscProviderSocket) throws CIMException {
        NVRAM nVRAM;
        try {
            Trace.trace("apnvhscT", "-> priorityRestore");
            Trace.trace("apnvhscF", "mirrorFile = " + file);
            Trace.trace("apnvhscF", "backupFile = " + file2);
            Trace.trace("apnvhscF", "priority = " + n);
            Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println("In priorityRestore");
                System.out.println("priority = " + n);
                System.out.println("HscConstants.RESTORE_TYPE_CEC_PRIORITY = 2");
                System.out.println("HscConstants.RESTORE_TYPE_BACKUP_PRIORITY = 3");
            }
            NVRAM nVRAM2 = null;
            NVRAM nVRAM3 = null;
            this._restoreType = n;
            if (!file.equals(file2)) {
                this.buildNVRAM(hscProviderSocket, false, null, true, false);
            }
            if (n == 2) {
                nVRAM3 = new NVRAM(file2, this.NVRAM_SIZE, this.NUM_PARTITION_SLOTS, this._hscTemplateVersion, this._cecName, hscProviderSocket);
                nVRAM2 = new NVRAM(file, this.NVRAM_SIZE, this.NUM_PARTITION_SLOTS, this._hscTemplateVersion, this._cecName, hscProviderSocket);
            } else if (n == 3) {
                nVRAM3 = new NVRAM(file, this.NVRAM_SIZE, this.NUM_PARTITION_SLOTS, this._hscTemplateVersion, this._cecName, hscProviderSocket);
                nVRAM2 = new NVRAM(file2, this.NVRAM_SIZE, this.NUM_PARTITION_SLOTS, this._hscTemplateVersion, this._cecName, hscProviderSocket);
            }
            if (nVRAM2._releaseVersion != nVRAM3._releaseVersion) {
                throw new HSCCIMException("0035");
            }
            this._mergeData(nVRAM2, nVRAM3, hscProviderSocket);
            NVRAM_TABLE.put(this._cecName, nVRAM2);
            if (DEBUG_ON) {
                System.out.println("End of priorityRestore");
                System.out.println("****************************************");
            }
            nVRAM = nVRAM2;
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (!(throwable instanceof HSCCIMException)) {
                    throw new HSCCIMException("002B");
                }
                throw new HSCCIMException(throwable);
            }
            catch (Throwable throwable2) {
                Object var9_10 = null;
                Trace.trace("apnvhscT", "<- priorityRestore");
                throw throwable2;
            }
        }
        Trace.trace("apnvhscT", "<- priorityRestore");
        return nVRAM;
    }

    private void _mergeData(NVRAM nVRAM, NVRAM nVRAM2, HscProviderSocket hscProviderSocket) throws CIMException {
        try {
            block7: {
                try {
                    Trace.trace("apnvhscT", "-> _mergeData");
                    Trace.trace("apnvhscF", "base = " + nVRAM);
                    Trace.trace("apnvhscF", "addedOn= " + nVRAM2);
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In mergeData");
                    }
                    this._numPhyLocCodeSlots = nVRAM._numPhyLocCodeSlots;
                    this._releaseVersion = nVRAM._releaseVersion;
                    this.SIZE_OF_LPAR_INFO = nVRAM.SIZE_OF_LPAR_INFO;
                    this.NUM_ALPAR_SLOTS_OFFSET = nVRAM.NUM_ALPAR_SLOTS_OFFSET;
                    this.TIME_STAMPS_CHECKSUM_OFFSET = nVRAM.TIME_STAMPS_CHECKSUM_OFFSET;
                    this.NVRAM_TIME_STAMP_OFFSET = nVRAM.NVRAM_TIME_STAMP_OFFSET;
                    this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET = nVRAM.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET;
                    this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET = nVRAM.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET;
                    this.DEFAULT_LIST_TIME_STAMP_OFFSET = nVRAM.DEFAULT_LIST_TIME_STAMP_OFFSET;
                    this.ACTIVATED_LIST_TIME_STAMP_OFFSET = nVRAM.ACTIVATED_LIST_TIME_STAMP_OFFSET;
                    this.PHY_LOC_CODE_TIME_STAMP_OFFSET = nVRAM.PHY_LOC_CODE_TIME_STAMP_OFFSET;
                    this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET = nVRAM.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET;
                    this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET = nVRAM.PARTITION_NAME_TABLE_CHECKSUM_OFFSET;
                    this.PARTITION_NAME_TABLE_OFFSET = nVRAM.PARTITION_NAME_TABLE_OFFSET;
                    this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET = nVRAM.PROFILE_NAME_TABLE_CHECKSUM_OFFSET;
                    this.PROFILE_NAME_TABLE_OFFSET = nVRAM.PROFILE_NAME_TABLE_OFFSET;
                    this.DEFAULT_LIST_CHECKSUM_OFFSET = nVRAM.DEFAULT_LIST_CHECKSUM_OFFSET;
                    this.DEFAULT_LIST_OFFSET = nVRAM.DEFAULT_LIST_OFFSET;
                    this.ACTIVATED_LIST_CHECKSUM_OFFSET = nVRAM.ACTIVATED_LIST_CHECKSUM_OFFSET;
                    this.ACTIVATED_LIST_OFFSET = nVRAM.ACTIVATED_LIST_OFFSET;
                    this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET = nVRAM.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET;
                    this.PHY_LOC_CODE_TABLE_OFFSET = nVRAM.PHY_LOC_CODE_TABLE_OFFSET;
                    this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET = nVRAM.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET;
                    this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET = nVRAM.DRAWER_PROF_INFO_DATA_SIZE_OFFSET;
                    this.NUM_DRAWERS_OFFSET = nVRAM.NUM_DRAWERS_OFFSET;
                    this.DRAWERS_OFFSET = nVRAM.DRAWERS_OFFSET;
                    Vector[] vectorArray = this._mergePartitionNames(nVRAM, nVRAM2, hscProviderSocket);
                    this._mergeDefaultAndActivatedList(nVRAM, nVRAM2, hscProviderSocket, vectorArray);
                    if (nVRAM._releaseVersion != 0) {
                        this._mergePhyLocCodeTable(nVRAM, nVRAM2, hscProviderSocket, vectorArray);
                    }
                    this._mergeDrawerProfileInfo(nVRAM, nVRAM2, hscProviderSocket, vectorArray);
                    nVRAM._backupToLocalFile();
                    this._recalculateChecksum(new File("/var/hsc/profiles/" + this._cecName + "/" + "backupFile"));
                    nVRAM.buildNVRAMFromLocalCopy(hscProviderSocket, new File("/var/hsc/profiles/" + this._cecName + "/" + "backupFile"), true, true);
                    if (!DEBUG_ON) break block7;
                    System.out.println("End of mergeData");
                    System.out.println("****************************************");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof HSCCIMException)) {
                        throw new HSCCIMException("002C");
                    }
                    throw new HSCCIMException(throwable);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Trace.trace("apnvhscT", "<- _mergeData");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- _mergeData");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector[] _mergePartitionNames(NVRAM nVRAM, NVRAM nVRAM2, HscProviderSocket hscProviderSocket) throws CIMException {
        Vector[] vectorArray;
        try {
            try {
                Trace.trace("apnvhscT", "-> _mergePartitionNames");
                Trace.trace("apnvhscF", "model= " + nVRAM);
                Trace.trace("apnvhscF", "additionalInfo = " + nVRAM2);
                if (DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println("In _mergePartitionNames");
                }
                try {
                    Vector<Integer> vector;
                    Vector<Integer> vector2;
                    Vector<Integer> vector3;
                    boolean bl;
                    boolean bl2;
                    short s;
                    Vector<Integer> vector4;
                    Vector<Integer> vector5;
                    block81: {
                        block87: {
                            int n;
                            Vector vector6;
                            Vector vector7;
                            block78: {
                                block85: {
                                    block86: {
                                        int n2;
                                        block80: {
                                            block79: {
                                                boolean bl3 = false;
                                                vector5 = new Vector<Integer>();
                                                vector4 = new Vector<Integer>();
                                                String[] stringArray = new String[1];
                                                Hashtable hashtable = null;
                                                s = 1;
                                                bl2 = false;
                                                bl = false;
                                                vector3 = new Vector<Integer>();
                                                vector2 = new Vector<Integer>();
                                                vector = new Vector<Integer>();
                                                int n3 = 1;
                                                while (true) {
                                                    if (n3 > this.NUM_PARTITION_SLOTS) {
                                                        vector7 = nVRAM._getPPARList(hscProviderSocket);
                                                        vector6 = nVRAM2._getPPARList(hscProviderSocket);
                                                        if (!bl3) break block78;
                                                        if (vector7 == null) break block79;
                                                        if (vector7.size() == vector5.size()) break;
                                                        bl2 = true;
                                                        break block80;
                                                    }
                                                    stringArray[0] = Integer.toHexString(n3);
                                                    hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_SLOT_DEFINITION_STATE", stringArray, hscProviderSocket, this._cspVersion);
                                                    byte by = ((Integer)hashtable.get("DEFINITION_STATE")).byteValue();
                                                    if (by != 4) {
                                                        if (this._releaseVersion == 0) {
                                                            vector4.add(new Integer(n3));
                                                        } else {
                                                            hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_TYPE", stringArray, hscProviderSocket, this._cspVersion);
                                                            byte by2 = ((Integer)hashtable.get("TYPE_VALUE")).byteValue();
                                                            if (by2 == 1) {
                                                                vector4.add(new Integer(n3));
                                                            } else if (by2 == 2 || by2 == 3) {
                                                                vector5.add(new Integer(n3));
                                                                bl3 = true;
                                                                s = by2;
                                                            }
                                                        }
                                                    }
                                                    ++n3;
                                                }
                                                n = 0;
                                                while (n < vector5.size()) {
                                                    n2 = (Integer)vector5.elementAt(n);
                                                    if (vector7.contains(vector5.elementAt(n))) {
                                                        if (DEBUG_ON) {
                                                            System.out.println("alpar contained in model lparID = " + vector5.elementAt(n));
                                                        }
                                                        if (nVRAM._partitionClusterTypeTable[n2 - 1] != s) {
                                                            if (DEBUG_ON) {
                                                                System.out.println("model cluster type not matching up");
                                                            }
                                                            bl2 = true;
                                                            break block80;
                                                        }
                                                    } else {
                                                        bl2 = true;
                                                        if (DEBUG_ON) {
                                                            System.out.println("cannotMergeFromModel lparID = " + vector5.elementAt(n));
                                                        }
                                                        break block80;
                                                    }
                                                    ++n;
                                                }
                                                break block80;
                                            }
                                            bl2 = true;
                                        }
                                        if (!bl2) break block85;
                                        if (vector6 == null) break block86;
                                        if (vector6.size() != vector5.size()) {
                                            bl = true;
                                            break block81;
                                        } else {
                                            n = 0;
                                            while (n < vector5.size()) {
                                                n2 = (Integer)vector5.elementAt(n);
                                                if (vector6.contains(vector5.elementAt(n))) {
                                                    if (DEBUG_ON) {
                                                        System.out.println("alpar contained in model lparID = " + vector5.elementAt(n));
                                                    }
                                                    if (nVRAM2._partitionClusterTypeTable[n2 - 1] != s) {
                                                        if (DEBUG_ON) {
                                                            System.out.println("addOn cluster type not matching up");
                                                        }
                                                        bl = true;
                                                        break block81;
                                                    }
                                                } else {
                                                    bl = true;
                                                    if (DEBUG_ON) {
                                                        System.out.println("cannotMergeFromModel lparID = " + vector5.elementAt(n));
                                                    }
                                                    break block81;
                                                }
                                                ++n;
                                            }
                                        }
                                        break block81;
                                    }
                                    bl = true;
                                    break block81;
                                }
                                bl = true;
                                break block81;
                            }
                            if (vector7 != null && vector7.size() != 0) {
                                n = 0;
                                while (n < vector7.size()) {
                                    if (vector4.contains(vector7.elementAt(n))) {
                                        bl2 = true;
                                        if (DEBUG_ON) {
                                            System.out.println("alpar contained in model but lpar in csp lparID = " + vector7.elementAt(n));
                                        }
                                        break;
                                    }
                                    if (DEBUG_ON) {
                                        System.out.println("alpar contained in model but non in csp lparID = " + vector7.elementAt(n));
                                    }
                                    ++n;
                                }
                            } else {
                                bl2 = false;
                            }
                            if (!bl2) break block87;
                            if (vector6 != null && vector6.size() != 0) {
                                n = 0;
                                while (n < vector6.size()) {
                                    if (vector4.contains(vector6.elementAt(n))) {
                                        bl = true;
                                        if (DEBUG_ON) {
                                            System.out.println("alpar contained in addon but lpar in csp lparID = " + vector6.elementAt(n));
                                        }
                                        break block81;
                                    }
                                    if (DEBUG_ON) {
                                        System.out.println("alpar contained in addon but non in csp lparID = " + vector6.elementAt(n));
                                    }
                                    ++n;
                                }
                                break block81;
                            } else {
                                bl = false;
                            }
                            break block81;
                        }
                        bl = true;
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    dataOutputStream.write(nVRAM._nvramData, 0, this.PARTITION_NAME_TABLE_OFFSET);
                    int n = 1;
                    while (true) {
                        block90: {
                            block94: {
                                Object object;
                                block93: {
                                    block91: {
                                        short s2;
                                        block92: {
                                            block88: {
                                                block89: {
                                                    if (n > this.NUM_PARTITION_SLOTS) {
                                                        object = new Vector<Comparable<Boolean>>();
                                                        ((Vector)object).add(new Boolean(bl2));
                                                        ((Vector)object).add(new Boolean(bl));
                                                        ((Vector)object).add(new Integer(s));
                                                        Vector[] vectorArray2 = new Vector[]{vector, vector3, vector2, object, vector5};
                                                        this._cannotMergeFromModel = bl2;
                                                        this._cannotMergeFromAddOn = bl;
                                                        if (DEBUG_ON) {
                                                            System.out.println("dout.size() = " + dataOutputStream.size());
                                                            System.out.println("model._nvramData.length = " + nVRAM._nvramData.length);
                                                        }
                                                        dataOutputStream.write(nVRAM._nvramData, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, this.NVRAM_SIZE - this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET);
                                                        dataOutputStream.close();
                                                        nVRAM._nvramData = byteArrayOutputStream.toByteArray();
                                                        if (DEBUG_ON) {
                                                            System.out.println("lparsFromCsp = " + vector);
                                                            System.out.println("lparsFromModel = " + vector3);
                                                            System.out.println("lparsFromAddOn = " + vector2);
                                                            System.out.println("cspAlparList = " + vector5);
                                                            System.out.println("_merge Part _nvram length = " + nVRAM._nvramData.length);
                                                        }
                                                        if (DEBUG_ON) {
                                                            System.out.println("model._nvramData.length = " + nVRAM._nvramData.length);
                                                            System.out.println("NVRAM_SIZE = " + this.NVRAM_SIZE);
                                                        }
                                                        byteArrayOutputStream.close();
                                                        if (DEBUG_ON) {
                                                            System.out.println("End of _mergePartitionName");
                                                            System.out.println("****************************************");
                                                        }
                                                        vectorArray = vectorArray2;
                                                        break;
                                                    }
                                                    if (DEBUG_ON) {
                                                        System.out.println("----- i = " + n + " -----");
                                                    }
                                                    if (nVRAM._partitionNameTable[n - 1] == null || nVRAM._partitionNameTable[n - 1].trim().length() == 0) break block88;
                                                    if (DEBUG_ON) {
                                                        System.out.println("model's lpar name = " + nVRAM._partitionNameTable[n - 1]);
                                                    }
                                                    object = nVRAM._partitionNameTable[n - 1].trim();
                                                    s2 = 1;
                                                    if (this._releaseVersion != 0) {
                                                        s2 = nVRAM._partitionClusterTypeTable[n - 1];
                                                    }
                                                    if (DEBUG_ON) {
                                                        System.out.println("model's cluster type = " + s2);
                                                    }
                                                    if (s2 != true) break block89;
                                                    if (vector5.contains(new Integer(n))) break block88;
                                                    nVRAM._partitionNameTable[n - 1] = object;
                                                    dataOutputStream.writeBytes(this.setLength((String)object, 31));
                                                    if (nVRAM._fastActivation[n - 1]) {
                                                        dataOutputStream.writeByte(1);
                                                    } else {
                                                        dataOutputStream.writeByte(0);
                                                    }
                                                    if (this._releaseVersion != 0) {
                                                        nVRAM._partitionClusterTypeTable[n - 1] = s2;
                                                        dataOutputStream.writeByte(s2);
                                                    }
                                                    vector3.add(new Integer(n));
                                                    break block90;
                                                }
                                                if (s2 != 2 && s2 != 3 || bl2) break block88;
                                                nVRAM._partitionNameTable[n - 1] = object;
                                                dataOutputStream.writeBytes(this.setLength((String)object, 31));
                                                if (nVRAM._fastActivation[n - 1]) {
                                                    dataOutputStream.writeByte(1);
                                                } else {
                                                    dataOutputStream.writeByte(0);
                                                }
                                                if (this._releaseVersion != 0) {
                                                    nVRAM._partitionClusterTypeTable[n - 1] = s2;
                                                    dataOutputStream.writeByte(s2);
                                                }
                                                vector3.add(new Integer(n));
                                                break block90;
                                            }
                                            if (nVRAM2._partitionNameTable[n - 1] == null || nVRAM2._partitionNameTable[n - 1].trim().length() == 0) break block91;
                                            object = nVRAM2._partitionNameTable[n - 1];
                                            if (DEBUG_ON) {
                                                System.out.println("additionalInfo name = " + (String)object);
                                            }
                                            s2 = 1;
                                            if (this._releaseVersion != 0) {
                                                s2 = nVRAM2._partitionClusterTypeTable[n - 1];
                                            }
                                            if (DEBUG_ON) {
                                                System.out.println("additionalInfo cluster type = " + s2);
                                            }
                                            if (s2 != 1) break block92;
                                            if (vector5.contains(new Integer(n))) break block91;
                                            nVRAM._partitionNameTable[n - 1] = object;
                                            dataOutputStream.writeBytes(this.setLength((String)object, 31));
                                            if (nVRAM2._fastActivation[n - 1]) {
                                                dataOutputStream.writeByte(1);
                                            } else {
                                                dataOutputStream.writeByte(0);
                                            }
                                            if (this._releaseVersion != 0) {
                                                nVRAM._partitionClusterTypeTable[n - 1] = s2;
                                                dataOutputStream.writeByte(s2);
                                            }
                                            vector2.add(new Integer(n));
                                            break block90;
                                        }
                                        if (s2 != 2 && s2 != 3 || bl) break block91;
                                        nVRAM._partitionNameTable[n - 1] = object;
                                        dataOutputStream.writeBytes(this.setLength((String)object, 31));
                                        if (nVRAM2._fastActivation[n - 1]) {
                                            dataOutputStream.writeByte(1);
                                        } else {
                                            dataOutputStream.writeByte(0);
                                        }
                                        if (this._releaseVersion != 0) {
                                            nVRAM._partitionClusterTypeTable[n - 1] = s2;
                                            dataOutputStream.writeByte(s2);
                                        }
                                        vector2.add(new Integer(n));
                                        break block90;
                                    }
                                    if (!vector4.contains(new Integer(n))) break block93;
                                    object = this._usingCspLparInfo(n, hscProviderSocket);
                                    if (object != null && ((String)object).trim().length() != 0) {
                                        vector.add(new Integer(n));
                                        nVRAM._partitionNameTable[n - 1] = object;
                                        nVRAM._fastActivation[n - 1] = false;
                                        dataOutputStream.writeBytes(this.setLength((String)object, 32));
                                        if (this._releaseVersion != 0) {
                                            nVRAM._partitionClusterTypeTable[n - 1] = 1;
                                            dataOutputStream.writeByte(1);
                                        }
                                        break block90;
                                    } else {
                                        nVRAM._partitionNameTable[n - 1] = null;
                                        dataOutputStream.write(new byte[32]);
                                        nVRAM._fastActivation[n - 1] = false;
                                        if (this._releaseVersion != 0) {
                                            nVRAM._partitionClusterTypeTable[n - 1] = 1;
                                            dataOutputStream.writeByte(1);
                                        }
                                    }
                                    break block90;
                                }
                                if (!vector5.contains(new Integer(n))) break block94;
                                object = this._usingCspLparInfo(n, hscProviderSocket);
                                if (object != null && ((String)object).trim().length() != 0) {
                                    vector.add(new Integer(n));
                                    nVRAM._partitionNameTable[n - 1] = object;
                                    dataOutputStream.writeBytes(this.setLength((String)object, 32));
                                    nVRAM._fastActivation[n - 1] = false;
                                    if (this._releaseVersion != 0) {
                                        nVRAM._partitionClusterTypeTable[n - 1] = s;
                                        dataOutputStream.writeByte(s);
                                    }
                                    break block90;
                                } else {
                                    nVRAM._partitionNameTable[n - 1] = null;
                                    dataOutputStream.write(new byte[32]);
                                    nVRAM._fastActivation[n - 1] = false;
                                    if (this._releaseVersion != 0) {
                                        nVRAM._partitionClusterTypeTable[n - 1] = 1;
                                        dataOutputStream.writeByte(1);
                                    }
                                }
                                break block90;
                            }
                            nVRAM._partitionNameTable[n - 1] = null;
                            dataOutputStream.write(new byte[32]);
                            nVRAM._fastActivation[n - 1] = false;
                            if (this._releaseVersion != 0) {
                                nVRAM._partitionClusterTypeTable[n - 1] = 1;
                                dataOutputStream.writeByte(1);
                            }
                        }
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    throw new HSCCIMException("0007");
                }
                Object var25_31 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("002D");
            }
        }
        catch (Throwable throwable) {
            Object var25_32 = null;
            Trace.trace("apnvhscT", "-> _mergePartitionNames");
            throw throwable;
        }
        Trace.trace("apnvhscT", "-> _mergePartitionNames");
        return vectorArray;
    }

    private void _mergeDefaultAndActivatedList(NVRAM nVRAM, NVRAM nVRAM2, HscProviderSocket hscProviderSocket, Vector[] vectorArray) throws CIMException {
        try {
            try {
                Trace.trace("apnvhscT", "-> _mergeDefaultAndActivatedList");
                Trace.trace("apnvhscF", "model = " + nVRAM);
                Trace.trace("apnvhscF", "additionalInfo = " + nVRAM2);
                Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                if (DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println("In _mergeDefaultAndActivatedList");
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    dataOutputStream.write(nVRAM._nvramData, 0, this.DEFAULT_LIST_OFFSET);
                    String[] stringArray = new String[1];
                    Object var8_10 = null;
                    Vector vector = vectorArray[0];
                    Vector vector2 = vectorArray[1];
                    Vector vector3 = vectorArray[2];
                    int n = 0;
                    while (n <= this.NUM_PARTITION_SLOTS) {
                        if (DEBUG_ON) {
                            System.out.println("----- i = " + n + " -----");
                        }
                        if (nVRAM._defaultList[n] != null && nVRAM._defaultList[n].trim().length() != 0 && n != 0 && vector2.contains(new Integer(n))) {
                            dataOutputStream.writeBytes(NVRAM.cryptedTimestamp(nVRAM._defaultList[n]));
                        } else if (nVRAM2._defaultList[n] != null && nVRAM2._defaultList[n].trim().length() != 0 && n != 0 && vector3.contains(new Integer(n))) {
                            nVRAM._defaultList[n] = nVRAM2._defaultList[n];
                            dataOutputStream.writeBytes(NVRAM.cryptedTimestamp(nVRAM2._defaultList[n]));
                        } else {
                            nVRAM._defaultList[n] = null;
                            dataOutputStream.write(new byte[7]);
                        }
                        ++n;
                    }
                    dataOutputStream.write(nVRAM._nvramData, this.ACTIVATED_LIST_CHECKSUM_OFFSET, 8);
                    if (DEBUG_ON) {
                        System.out.println("dout.size() = " + dataOutputStream.size());
                    }
                    int n2 = 0;
                    while (n2 <= this.NUM_PARTITION_SLOTS) {
                        if (DEBUG_ON) {
                            System.out.println("----- i = " + n2 + " -----");
                        }
                        if (nVRAM._activatedList[n2] != null && nVRAM._activatedList[n2].trim().length() != 0 && n2 != 0 && vector2.contains(new Integer(n2))) {
                            dataOutputStream.writeBytes(NVRAM.cryptedTimestamp(nVRAM._activatedList[n2]));
                        } else if (nVRAM2._activatedList[n2] != null && nVRAM2._activatedList[n2].trim().length() != 0 && n2 != 0 && vector3.contains(new Integer(n2))) {
                            nVRAM._activatedList[n2] = nVRAM2._activatedList[n2];
                            dataOutputStream.writeBytes(NVRAM.cryptedTimestamp(nVRAM2._activatedList[n2]));
                        } else {
                            nVRAM._activatedList[n2] = null;
                            dataOutputStream.write(new byte[7]);
                        }
                        ++n2;
                    }
                    if (DEBUG_ON) {
                        System.out.println("dout.size() = " + dataOutputStream.size());
                        System.out.println("model._nvramData.length = " + nVRAM._nvramData.length);
                    }
                    if (this._releaseVersion == 0) {
                        dataOutputStream.write(nVRAM._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, this.NVRAM_SIZE - this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET);
                    } else {
                        if (DEBUG_ON) {
                            System.out.println("model._nvramData.size() = " + nVRAM._nvramData.length);
                            System.out.println("PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET = " + this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET);
                            System.out.println("diff = " + (this.NVRAM_SIZE - this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET));
                        }
                        dataOutputStream.write(nVRAM._nvramData, this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET, this.NVRAM_SIZE - this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET);
                    }
                    dataOutputStream.close();
                    nVRAM._nvramData = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.close();
                    if (DEBUG_ON) {
                        System.out.println("End of _mergeDefaultAndActivatedList");
                        System.out.println("****************************************");
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    throw new HSCCIMException("0007");
                }
                Object var15_16 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (!(throwable instanceof HSCCIMException)) {
                    throw new HSCCIMException("002E");
                }
                throw new HSCCIMException(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            Trace.trace("apnvhscT", "<- _mergeDefaultAndActivatedList");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- _mergeDefaultAndActivatedList");
    }

    private void _mergePhyLocCodeTable(NVRAM nVRAM, NVRAM nVRAM2, HscProviderSocket hscProviderSocket, Vector[] vectorArray) throws CIMException {
        try {
            Vector vector = vectorArray[0];
            Vector vector2 = vectorArray[1];
            Vector vector3 = vectorArray[2];
            Vector vector4 = vectorArray[3];
            Vector vector5 = vectorArray[4];
            boolean bl = (Boolean)vector4.elementAt(0);
            boolean bl2 = (Boolean)vector4.elementAt(1);
            int n = (Integer)vector4.elementAt(2);
            Vector vector6 = new Vector();
            Vector vector7 = new Vector();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (DEBUG_ON) {
                System.out.println("PHY_LOC_CODE_TABLE_OFFSET = " + this.PHY_LOC_CODE_TABLE_OFFSET);
                System.out.println("phy loc code table model._nvramData.length = " + nVRAM._nvramData.length);
            }
            dataOutputStream.write(nVRAM._nvramData, 0, this.PHY_LOC_CODE_TABLE_OFFSET);
            if (!bl) {
                dataOutputStream.close();
                byteArrayOutputStream.close();
                return;
            }
            if (!bl2) {
                Vector[] vectorArray2 = nVRAM2._partitionPhyLocCodeTable;
                int n2 = this.PHY_LOC_CODE_TABLE_OFFSET;
                int n3 = 0;
                while (n3 < vectorArray2.length) {
                    Vector vector8 = vectorArray2[n3];
                    if (vector8 != null) {
                        String string = (String)vector8.elementAt(this.ALPAR_PHY_LOC_INDEX);
                        if (string != null && string.trim().length() != 0) {
                            dataOutputStream.writeByte((byte)(n3 + 1));
                            dataOutputStream.writeBytes(this.setLength(string, 32));
                            Vector<Object> vector9 = new Vector<Object>();
                            vector9.setSize(this.ALPAR_PHY_LOC_INDEX + 1);
                            vector9.setElementAt(new Short((short)n2), this.ALPAR_OFFSET_INDEX);
                            vector9.setElementAt(string, this.ALPAR_PHY_LOC_INDEX);
                            nVRAM._partitionPhyLocCodeTable[n3] = vector9;
                            n2 += this.SIZE_OF_ALPAR_INFO;
                        } else {
                            nVRAM._partitionPhyLocCodeTable[n3] = null;
                        }
                    } else {
                        nVRAM._partitionPhyLocCodeTable[n3] = null;
                    }
                    ++n3;
                }
                int n4 = n2;
                while (n4 < this.PHY_LOC_CODE_TABLE_OFFSET + this._numPhyLocCodeSlots * this.SIZE_OF_ALPAR_INFO) {
                    dataOutputStream.writeByte(0);
                    ++n4;
                }
            } else {
                Vector<String> vector10 = new Vector<String>();
                if (vector5 != null && vector5.size() != 0) {
                    Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_PROCESSOR_AFFINITY", null, hscProviderSocket, this._cspVersion);
                    int n5 = (Integer)hashtable.get("AFFINITY_TYPE");
                    boolean bl3 = (n5 & 4) == 4;
                    int n6 = (Integer)hashtable.get("NUM_GROUPS");
                    Vector vector11 = (Vector)hashtable.get("GROUP_LIST");
                    int n7 = 0;
                    while (n7 < n6) {
                        Hashtable hashtable2 = (Hashtable)vector11.elementAt(n7);
                        String string = (String)hashtable2.get("PROC_GROUP_LOCATION");
                        vector10.add(string.trim());
                        ++n7;
                    }
                    int n8 = this.PHY_LOC_CODE_TABLE_OFFSET;
                    boolean bl4 = false;
                    int n9 = 0;
                    while (n9 < nVRAM._partitionPhyLocCodeTable.length) {
                        if (vector5.contains(new Integer(n9 + 1))) {
                            String string = (String)vector10.elementAt(0);
                            if (DEBUG_ON) {
                                System.out.println("phyLocCode = " + string);
                            }
                            if (bl3) {
                                if (n == 2) {
                                    if (!bl4) {
                                        string = string + "0";
                                        bl4 = true;
                                    } else {
                                        string = string + "1";
                                        bl4 = false;
                                        vector10.removeElementAt(0);
                                    }
                                } else if (n == 3) {
                                    string = string + "0";
                                    vector10.removeElementAt(0);
                                }
                            } else {
                                string = string + "0";
                                vector10.removeElementAt(0);
                            }
                            Vector<Object> vector12 = new Vector<Object>();
                            vector12.setSize(this.ALPAR_PHY_LOC_INDEX + 1);
                            vector12.setElementAt(new Short((short)n8), this.ALPAR_OFFSET_INDEX);
                            vector12.setElementAt(string, this.ALPAR_PHY_LOC_INDEX);
                            nVRAM._partitionPhyLocCodeTable[n9] = vector12;
                            dataOutputStream.writeByte((byte)(n9 + 1));
                            dataOutputStream.writeBytes(this.setLength(string, 32));
                            n8 += this.SIZE_OF_ALPAR_INFO;
                        } else {
                            nVRAM._partitionPhyLocCodeTable[n9] = null;
                        }
                        ++n9;
                    }
                    int n10 = n8;
                    while (n10 < this.PHY_LOC_CODE_TABLE_OFFSET + this._numPhyLocCodeSlots * this.SIZE_OF_ALPAR_INFO) {
                        dataOutputStream.writeByte(0);
                        ++n10;
                    }
                } else {
                    int n11 = 0;
                    while (n11 < nVRAM._partitionPhyLocCodeTable.length) {
                        nVRAM._partitionPhyLocCodeTable[n11] = null;
                        dataOutputStream.write(new byte[this.SIZE_OF_ALPAR_INFO]);
                        ++n11;
                    }
                }
            }
            dataOutputStream.write(nVRAM._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, this.NVRAM_SIZE - this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET);
            dataOutputStream.close();
            nVRAM._nvramData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void _mergeDrawerProfileInfo(NVRAM var1_1, NVRAM var2_2, HscProviderSocket var3_3, Vector[] var4_4) throws CIMException {
        try {
            try {
                var5_5 = var4_4[0];
                var6_7 = var4_4[1];
                var7_8 = var4_4[2];
                var8_9 = var4_4[3];
                var9_10 = var4_4[4];
                var10_11 = (Boolean)var8_9.elementAt(0);
                var11_12 = (Boolean)var8_9.elementAt(1);
                var12_13 = (Integer)var8_9.elementAt(2);
                Trace.trace("apnvhscT", "-> _mergeDrawerProfileInfo");
                Trace.trace("apnvhscF", "model = " + var1_1);
                Trace.trace("apnvhscF", "additionalInfo = " + var2_2);
                Trace.trace("apnvhscF", "socket = " + var3_3);
                if (NVRAM.DEBUG_ON) {
                    System.out.println("****************************************");
                    System.out.println("In _mergeDrawerProfileInfo");
                }
                try {
                    var13_14 = new ByteArrayOutputStream(this.NVRAM_SIZE);
                    var14_16 = new DataOutputStream(var13_14);
                    var14_16.write(var1_1._nvramData, 0, this.PROFILE_NAME_TABLE_OFFSET);
                    var15_17 = new String[1];
                    var16_18 = null;
                    var17_19 = new Vector<String>();
                    var18_20 = 0;
                    var19_21 = new Vector<String>();
                    var20_22 = 0;
                    var21_23 = 0;
                    while (var21_23 <= this.NUM_PARTITION_SLOTS) {
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("----- i = " + var21_23 + " -----");
                        }
                        if (var1_1._profilesAtPartitionTable[var21_23] == null || var1_1._profilesAtPartitionTable[var21_23].isEmpty()) ** GOTO lbl87
                        if (var6_7.contains(new Integer(var21_23)) || var21_23 == 0 && !var10_11) {
                            var22_24 = var1_1._profilesAtPartitionTable[var21_23].elements();
                            var23_25 = null;
                            var24_27 = null;
                            while (var22_24.hasMoreElements()) {
                                var25_28 = (String)var22_24.nextElement();
                                Trace.trace("apnvhscF", "profID = " + var25_28);
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("model's profID = " + var25_28);
                                }
                                var26_30 = (Object[])var1_1._profileTable.get(var25_28);
                                var27_34 = (Vector)var26_30[2];
                                Trace.trace("apnvhscF", "properties = " + var27_34);
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("model's profProperties = " + var27_34);
                                }
                                if (var21_23 == 0) {
                                    var23_25 = (String)((CIMProperty)var27_34.elementAt(1)).getValue().getValue();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("userDefName = " + var23_25);
                                    }
                                } else {
                                    if (var1_1._releaseVersion < 2) {
                                        var23_25 = (String)((CIMProperty)var27_34.elementAt(1)).getValue().getValue();
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("userDefName = " + var23_25);
                                        }
                                        var24_27 = (Vector)((CIMProperty)var27_34.elementAt(8)).getValue().getValue();
                                    } else {
                                        var23_25 = (String)((CIMProperty)var27_34.elementAt(1)).getValue().getValue();
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("userDefName = " + var23_25);
                                        }
                                        var24_27 = (Vector)((CIMProperty)var27_34.elementAt(12)).getValue().getValue();
                                    }
                                    Trace.trace("apnvhscF", "drawerProp = " + var24_27);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("drawerProp = " + var24_27);
                                    }
                                }
                                if (!var17_19.contains(var23_25)) {
                                    var17_19.add(var23_25);
                                    ++var18_20;
                                }
                                if (var24_27 == null || var24_27.isEmpty()) continue;
                                var28_35 = var24_27.elements();
                                while (var28_35.hasMoreElements()) {
                                    var29_38 = (String)var28_35.nextElement();
                                    if (var19_21.contains(var29_38)) continue;
                                    var19_21.add(var29_38);
                                    ++var20_22;
                                }
                            }
                        } else {
                            var22_24 = var1_1._profilesAtPartitionTable[var21_23].elements();
                            while (var22_24.hasMoreElements()) {
                                var23_25 = (String)var22_24.nextElement();
                                var1_1._profileTable.remove(var23_25);
                            }
                            var1_1._profilesAtPartitionTable[var21_23] = new Vector<E>();
lbl87:
                            // 2 sources

                            if (var2_2._profilesAtPartitionTable[var21_23] != null && !var2_2._profilesAtPartitionTable[var21_23].isEmpty() && var7_8.contains(new Integer(var21_23))) {
                                var22_24 = var2_2._profilesAtPartitionTable[var21_23].elements();
                                var23_25 = null;
                                var24_27 = null;
                                var1_1._profilesAtPartitionTable[var21_23] = new Vector<E>();
                                while (var22_24.hasMoreElements()) {
                                    var25_28 = (String)var22_24.nextElement();
                                    Trace.trace("apnvhscF", "profID = " + var25_28);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("addOn's profID = " + var25_28);
                                    }
                                    var1_1._profilesAtPartitionTable[var21_23].add(var25_28);
                                    var26_30 = (Object[])var2_2._profileTable.get(var25_28);
                                    var1_1._profileTable.put(var25_28, var26_30);
                                    var27_34 = (Vector)var26_30[2];
                                    Trace.trace("apnvhscF", "properties = " + var27_34);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("model's profProperties = " + var27_34);
                                    }
                                    if (var1_1._releaseVersion < 2) {
                                        var23_25 = (String)((CIMProperty)var27_34.elementAt(1)).getValue().getValue();
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("userDefName = " + var23_25);
                                        }
                                        var24_27 = (Vector)((CIMProperty)var27_34.elementAt(8)).getValue().getValue();
                                    } else {
                                        var23_25 = (String)((CIMProperty)var27_34.elementAt(1)).getValue().getValue();
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("userDefName = " + var23_25);
                                        }
                                        var24_27 = (Vector)((CIMProperty)var27_34.elementAt(12)).getValue().getValue();
                                    }
                                    Trace.trace("apnvhscF", "drawerProp = " + var24_27);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("drawerProp = " + var24_27);
                                    }
                                    if (!var17_19.contains(var23_25)) {
                                        var17_19.add(var23_25);
                                        ++var18_20;
                                    }
                                    if (var24_27 == null || var24_27.isEmpty()) continue;
                                    var28_35 = var24_27.elements();
                                    while (var28_35.hasMoreElements()) {
                                        var29_38 = (String)var28_35.nextElement();
                                        if (var19_21.contains(var29_38)) continue;
                                        var19_21.add(var29_38);
                                        ++var20_22;
                                    }
                                }
                            } else {
                                var1_1._profilesAtPartitionTable[var21_23] = new Vector<E>();
                            }
                        }
                        ++var21_23;
                    }
                    var22_24 = var17_19.elements();
                    while (var22_24.hasMoreElements()) {
                        var23_25 = (String)var22_24.nextElement();
                        var14_16.writeBytes(this.setLength(var23_25, 32));
                    }
                    var23_26 = (this.MAX_PROFILE - var18_20) * 32;
                    var14_16.write(new byte[var23_26]);
                    var14_16.write(var1_1._nvramData, this.DEFAULT_LIST_CHECKSUM_OFFSET, this.NUM_DRAWERS_OFFSET - this.DEFAULT_LIST_CHECKSUM_OFFSET);
                    if (NVRAM.DEBUG_ON) {
                        System.out.println("dout.size() = " + var14_16.size());
                    }
                    var14_16.writeShort((short)var20_22);
                    var24_27 = var19_21.elements();
                    while (var24_27.hasMoreElements()) {
                        var25_28 = (String)var24_27.nextElement();
                        var14_16.writeBytes(this.setLength(var25_28, 24));
                        var26_32 = var19_21.indexOf(var25_28);
                        var14_16.writeShort((short)var26_32);
                    }
                    var25_29 = var14_16.size();
                    var26_33 = 0;
                    while (var26_33 <= this.NUM_PARTITION_SLOTS) {
                        if (NVRAM.DEBUG_ON) {
                            System.out.println("----- i = " + var26_33 + " -----");
                        }
                        if (var1_1._profilesAtPartitionTable[var26_33] != null && !var1_1._profilesAtPartitionTable[var26_33].isEmpty()) {
                            var27_34 = var1_1._profilesAtPartitionTable[var26_33].elements();
                            while (var27_34.hasMoreElements()) {
                                var28_37 = 0;
                                var29_38 = (String)var27_34.nextElement();
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("profID = " + var29_38);
                                }
                                var30_39 = (Object[])var1_1._profileTable.get(var29_38);
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("offset = " + var25_29);
                                }
                                var30_39[0] = new Integer(var25_29);
                                var31_40 = (Short)var30_39[1];
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("len = " + var31_40);
                                }
                                var25_29 += var31_40;
                                var32_41 = (Vector)var30_39[2];
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("properties = " + var32_41);
                                }
                                if (var26_33 == 0) {
                                    var33_42 = (String)((CIMProperty)var32_41.elementAt(1)).getValue().getValue();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("userDefName = " + var33_42);
                                    }
                                    var28_37 = var17_19.indexOf(var33_42);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("index = " + var28_37);
                                    }
                                    var34_43 = (Vector)((CIMProperty)var32_41.elementAt(2)).getValue().getValue();
                                    Trace.trace("apnvhscF", "profList = " + var34_43);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("profList = " + var34_43);
                                    }
                                    var35_46 = (Vector)((CIMProperty)var32_41.elementAt(3)).getValue().getValue();
                                    Trace.trace("apnvhscF", "partIDList = " + var35_46);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("partIDList = " + var35_46);
                                    }
                                    var36_49 = 0;
                                    if (var34_43 != null && !var34_43.isEmpty()) {
                                        var36_49 = var34_43.size();
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("numParts = " + var36_49);
                                        }
                                    }
                                    if (this._releaseVersion < 3) {
                                        var14_16.writeByte((byte)var31_40);
                                    } else {
                                        var14_16.writeShort(var31_40);
                                    }
                                    var14_16.writeByte((byte)this._hscTemplateVersion);
                                    var14_16.writeBytes(NVRAM.cryptedTimestamp(var29_38));
                                    var14_16.writeByte(1);
                                    if (this._releaseVersion < 3) {
                                        var14_16.writeShort((short)(this.PROFILE_NAME_TABLE_OFFSET + var28_37 * 32));
                                    } else {
                                        var14_16.writeInt(this.PROFILE_NAME_TABLE_OFFSET + var28_37 * 32);
                                    }
                                    var14_16.writeByte((byte)var36_49);
                                    var37_50 = 0;
                                    while (var37_50 < var36_49) {
                                        var38_51 = (UnsignedInt8)var35_46.elementAt(var37_50);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("pid = " + var38_51);
                                        }
                                        var39_54 = (String)var34_43.elementAt(var37_50);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("profTime = " + var39_54);
                                        }
                                        var40_56 = NVRAM.encodeTime(NVRAM.cryptedTimestamp(var39_54));
                                        var14_16.writeByte(var38_51.byteValue());
                                        var14_16.writeBytes(new String(var40_56));
                                        ++var37_50;
                                    }
                                    continue;
                                }
                                if (var1_1._releaseVersion < 2) {
                                    var33_42 = (String)((CIMProperty)var32_41.elementAt(1)).getValue().getValue();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("userDefName = " + var33_42);
                                    }
                                    var28_37 = var17_19.indexOf(var33_42);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("index = " + var28_37);
                                    }
                                    var34_44 = ((UnsignedInt8)((CIMProperty)var32_41.elementAt(2)).getValue().getValue()).shortValue();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("bootMode = " + var34_44);
                                    }
                                    Trace.trace("apnvhscD", "bootMode = " + String.valueOf(var34_44));
                                    var35_47 = ((UnsignedInt8)((CIMProperty)var32_41.elementAt(3)).getValue().getValue()).shortValue();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("serviceAuthority = " + var35_47);
                                    }
                                    Trace.trace("apnvhscD", "serviceAuthority = " + String.valueOf(var35_47));
                                    var36_49 = ((UnsignedInt8)((CIMProperty)var32_41.elementAt(4)).getValue().getValue()).shortValue();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("desiredCPUNum = " + var36_49);
                                    }
                                    Trace.trace("apnvhscD", "desiredCPUNum = " + String.valueOf(var36_49));
                                    var37_50 = ((UnsignedInt8)((CIMProperty)var32_41.elementAt(5)).getValue().getValue()).shortValue();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("reqiredCPUNum = " + var37_50);
                                    }
                                    Trace.trace("apnvhscD", "requiredCPUNum = " + String.valueOf(var37_50));
                                    var38_52 = ((UnsignedInt32)((CIMProperty)var32_41.elementAt(6)).getValue().getValue()).longValue();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("desiredMemSize = " + var38_52);
                                    }
                                    Trace.trace("apnvhscD", "desiredMemSize = " + String.valueOf(var38_52));
                                    var40_57 = ((UnsignedInt32)((CIMProperty)var32_41.elementAt(7)).getValue().getValue()).longValue();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("requiredMemSize = " + var40_57);
                                    }
                                    Trace.trace("apnvhscD", "requiredMemSize = " + String.valueOf(var40_57));
                                    var42_60 = null;
                                    var43_61 = null;
                                    var44_63 = null;
                                    if (((CIMProperty)var32_41.elementAt(8)).getValue() != null) {
                                        var42_60 = (Vector)((CIMProperty)var32_41.elementAt(8)).getValue().getValue();
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("drawerIDs = " + var42_60);
                                        }
                                        var43_61 = (Vector)((CIMProperty)var32_41.elementAt(9)).getValue().getValue();
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("slots = " + var43_61);
                                        }
                                        var44_63 = (Vector)((CIMProperty)var32_41.elementAt(10)).getValue().getValue();
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("require = " + var44_63);
                                        }
                                    }
                                    var45_64 = new Hashtable<Object[], Object[]>();
                                    var46_66 = null;
                                    var47_67 = new char[32];
                                    var48_68 = new char[32];
                                    var49_69 = 0;
                                    while (var49_69 < 32) {
                                        var47_67[var49_69] = 48;
                                        var48_68[var49_69] = 48;
                                        ++var49_69;
                                    }
                                    if (var42_60 != null && !var42_60.isEmpty()) {
                                        var50_71 = 0;
                                        while (var50_71 < var42_60.size()) {
                                            var51_74 = (Object[])var42_60.get(var50_71);
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("drawerID = " + (String)var51_74);
                                            }
                                            var46_66 = var45_64.containsKey(var51_74) != false ? (Object[])var45_64.get(var51_74) : new Object[]{new Short((short)var19_21.indexOf(var51_74)), new Integer(0), new Integer(0)};
                                            var52_75 = ((UnsignedInt8)var43_61.get(var50_71)).shortValue();
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("slotNum = " + var52_75);
                                            }
                                            Trace.trace("apnvhscD", "slotNum = " + String.valueOf(var52_75));
                                            if (((String)var44_63.get(var50_71)).equals("R")) {
                                                if (NVRAM.DEBUG_ON) {
                                                    System.out.println("required");
                                                }
                                                var48_68[32 - var52_75 - 1] = 49;
                                                var53_77 = new String((char[])var48_68);
                                                var48_68[32 - var52_75 - 1] = 48;
                                                var54_80 = Integer.parseInt(var53_77, 2);
                                                var46_66[2] = new Integer((Integer)var46_66[2] | var54_80);
                                            } else {
                                                if (NVRAM.DEBUG_ON) {
                                                    System.out.println("desired");
                                                }
                                                var47_67[32 - var52_75 - 1] = 49;
                                                var53_77 = new String((char[])var47_67);
                                                var47_67[32 - var52_75 - 1] = 48;
                                                var54_80 = Integer.parseInt(var53_77, 2);
                                                var46_66[1] = new Integer((Integer)var46_66[1] | var54_80);
                                            }
                                            var45_64.put(var51_74, var46_66);
                                            ++var50_71;
                                        }
                                    }
                                    var14_16.writeByte((byte)var31_40);
                                    var14_16.writeByte((byte)this._hscTemplateVersion);
                                    var14_16.writeBytes(NVRAM.cryptedTimestamp(var29_38));
                                    var14_16.writeByte(0);
                                    var14_16.writeShort((short)(this.PROFILE_NAME_TABLE_OFFSET + var28_37 * 32));
                                    var14_16.writeByte((byte)var26_33);
                                    var14_16.writeByte((byte)var34_44);
                                    var14_16.writeByte((byte)var35_47);
                                    var14_16.writeByte((byte)var36_49);
                                    var14_16.writeByte((byte)var37_50);
                                    var14_16.writeInt((int)var38_52);
                                    var14_16.writeInt((int)var40_57);
                                    var14_16.writeByte((byte)var45_64.size());
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In _mergeDrawerProfileInfo: num drawers = " + var19_21.size());
                                    }
                                    if (var45_64.size() == 0) continue;
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("has drawers!!!");
                                    }
                                    var50_72 = var45_64.keys();
                                    while (var50_72.hasMoreElements()) {
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("has elements");
                                        }
                                        var51_74 = (String)var50_72.nextElement();
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("id = " + (String)var51_74);
                                        }
                                        var52_75 = (short)var19_21.indexOf(var51_74);
                                        var53_78 = (Integer)((Object[])var45_64.get(var51_74))[1];
                                        var54_80 = (Integer)((Object[])var45_64.get(var51_74))[2];
                                        var14_16.writeShort(var52_75);
                                        var14_16.writeInt(var53_78);
                                        var14_16.writeInt(var54_80);
                                        if (!NVRAM.DEBUG_ON) continue;
                                        System.out.println("In createLPARProfile: drawerID = " + var52_75);
                                        System.out.println("In createLPARProfile: ioSlots = " + var53_78);
                                        System.out.println("In createLPARProfile: require = " + var54_80);
                                    }
                                    continue;
                                }
                                var33_42 = (String)((CIMProperty)var32_41.elementAt(1)).getValue().getValue();
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("userDefName = " + var33_42);
                                }
                                var28_37 = var17_19.indexOf(var33_42);
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("index = " + var28_37);
                                }
                                var34_45 = ((UnsignedInt8)((CIMProperty)var32_41.elementAt(2)).getValue().getValue()).shortValue();
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("bootMode = " + var34_45);
                                }
                                Trace.trace("apnvhscD", "bootMode = " + String.valueOf(var34_45));
                                var35_48 = ((UnsignedInt8)((CIMProperty)var32_41.elementAt(3)).getValue().getValue()).shortValue();
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("serviceAuthority = " + var35_48);
                                }
                                Trace.trace("apnvhscD", "serviceAuthority = " + String.valueOf(var35_48));
                                var36_49 = ((UnsignedInt8)((CIMProperty)var32_41.elementAt(4)).getValue().getValue()).shortValue();
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("rmoSize = " + var36_49);
                                }
                                Trace.trace("apnvhscD", "rmoSize = " + String.valueOf(var36_49));
                                var37_50 = ((UnsignedInt8)((CIMProperty)var32_41.elementAt(5)).getValue().getValue()).shortValue();
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("sfpSurveil = " + var37_50);
                                }
                                Trace.trace("apnvhscD", "sfpSurveil = " + String.valueOf(var37_50));
                                var38_53 = ((UnsignedInt8)((CIMProperty)var32_41.elementAt(6)).getValue().getValue()).shortValue();
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("desiredCPUNum = " + var38_53);
                                }
                                Trace.trace("apnvhscD", "desiredCPUNum = " + String.valueOf(var38_53));
                                var39_55 = ((UnsignedInt8)((CIMProperty)var32_41.elementAt(7)).getValue().getValue()).shortValue();
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("reqiredCPUNum = " + var39_55);
                                }
                                Trace.trace("apnvhscD", "requiredCPUNum = " + String.valueOf(var39_55));
                                var40_58 = ((UnsignedInt8)((CIMProperty)var32_41.elementAt(8)).getValue().getValue()).shortValue();
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("maxCPUNum = " + var40_58);
                                }
                                Trace.trace("apnvhscD", "maxCPUNum = " + String.valueOf(var40_58));
                                var41_59 = ((UnsignedInt32)((CIMProperty)var32_41.elementAt(9)).getValue().getValue()).longValue();
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("desiredMemSize = " + var41_59);
                                }
                                Trace.trace("apnvhscD", "desiredMemSize = " + String.valueOf(var41_59));
                                var43_62 = ((UnsignedInt32)((CIMProperty)var32_41.elementAt(10)).getValue().getValue()).longValue();
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("requiredMemSize = " + var43_62);
                                }
                                Trace.trace("apnvhscD", "requiredMemSize = " + String.valueOf(var43_62));
                                var45_65 = ((UnsignedInt32)((CIMProperty)var32_41.elementAt(11)).getValue().getValue()).longValue();
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("maxMemSize = " + var45_65);
                                }
                                Trace.trace("apnvhscD", "maxMemSize = " + String.valueOf(var45_65));
                                var47_67 = null;
                                var48_68 = null;
                                var49_70 = null;
                                if (((CIMProperty)var32_41.elementAt(12)).getValue() != null) {
                                    var47_67 = (Vector)((CIMProperty)var32_41.elementAt(12)).getValue().getValue();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("drawerIDs = " + var47_67);
                                    }
                                    var48_68 = (Vector)((CIMProperty)var32_41.elementAt(13)).getValue().getValue();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("slots = " + var48_68);
                                    }
                                    var49_70 = (Vector)((CIMProperty)var32_41.elementAt(14)).getValue().getValue();
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("require = " + var49_70);
                                    }
                                }
                                var50_73 = new Hashtable<Object, Object[]>();
                                var51_74 = null;
                                var52_76 = new char[32];
                                var53_79 = new char[32];
                                var54_80 = 0;
                                while (var54_80 < 32) {
                                    var52_76[var54_80] = 48;
                                    var53_79[var54_80] = 48;
                                    ++var54_80;
                                }
                                if (var47_67 != null && !var47_67.isEmpty()) {
                                    var55_81 = 0;
                                    while (var55_81 < var47_67.size()) {
                                        var56_82 = (String)var47_67.get(var55_81);
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("drawerID = " + (String)var56_82);
                                        }
                                        var51_74 = var50_73.containsKey(var56_82) != false ? (Object[])var50_73.get(var56_82) : new Object[]{new Short((short)var19_21.indexOf(var56_82)), new Integer(0), new Integer(0)};
                                        var57_84 = ((UnsignedInt8)var48_68.get(var55_81)).shortValue();
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("slotNum = " + var57_84);
                                        }
                                        Trace.trace("apnvhscD", "slotNum = " + String.valueOf(var57_84));
                                        if (((String)var49_70.get(var55_81)).equals("R")) {
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("required");
                                            }
                                            var53_79[32 - var57_84 - 1] = 49;
                                            var58_86 = new String(var53_79);
                                            var53_79[32 - var57_84 - 1] = 48;
                                            var59_87 = Integer.parseInt(var58_86, 2);
                                            var51_74[2] = new Integer((Integer)var51_74[2] | var59_87);
                                        } else {
                                            if (NVRAM.DEBUG_ON) {
                                                System.out.println("desired");
                                            }
                                            var52_76[32 - var57_84 - 1] = 49;
                                            var58_86 = new String(var52_76);
                                            var52_76[32 - var57_84 - 1] = 48;
                                            var59_87 = Integer.parseInt(var58_86, 2);
                                            var51_74[1] = new Integer((Integer)var51_74[1] | var59_87);
                                        }
                                        var50_73.put(var56_82, var51_74);
                                        ++var55_81;
                                    }
                                }
                                var55_81 = 0;
                                var56_82 = null;
                                var57_83 = null;
                                var58_85 = 0;
                                if (this._releaseVersion >= 3 && ((CIMProperty)var32_41.elementAt(15)).getValue() != null) {
                                    var55_81 = ((UnsignedInt8)((CIMProperty)var32_41.elementAt(15)).getValue().getValue()).shortValue();
                                    var56_82 = (Vector)((CIMProperty)var32_41.elementAt(16)).getValue().getValue();
                                    var57_83 = (Vector)((CIMProperty)var32_41.elementAt(17)).getValue().getValue();
                                }
                                var58_85 = var56_82 == null ? 0 : (int)var56_82.size();
                                if (this._releaseVersion < 3) {
                                    var14_16.writeByte((byte)var31_40);
                                } else {
                                    var14_16.writeShort(var31_40);
                                }
                                var14_16.writeByte((byte)this._hscTemplateVersion);
                                var14_16.writeBytes(NVRAM.cryptedTimestamp(var29_38));
                                var14_16.writeByte(0);
                                if (this._releaseVersion < 3) {
                                    var14_16.writeShort((short)(this.PROFILE_NAME_TABLE_OFFSET + var28_37 * 32));
                                } else {
                                    var14_16.writeInt(this.PROFILE_NAME_TABLE_OFFSET + var28_37 * 32);
                                }
                                var14_16.writeByte((byte)var26_33);
                                var14_16.writeByte((byte)var34_45);
                                var14_16.writeByte((byte)var35_48);
                                var14_16.writeByte((byte)var36_49);
                                var14_16.writeByte((byte)var37_50);
                                var14_16.writeByte((byte)var38_53);
                                var14_16.writeByte((byte)var39_55);
                                var14_16.writeByte((byte)var40_58);
                                var14_16.writeInt((int)var41_59);
                                var14_16.writeInt((int)var43_62);
                                var14_16.writeInt((int)var45_65);
                                var14_16.writeByte((byte)var50_73.size());
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In _mergeDrawerProfileInfo: num drawers = " + var19_21.size());
                                }
                                if (var50_73.size() != 0) {
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("has drawers!!!");
                                    }
                                    var59_88 = var50_73.keys();
                                    while (var59_88.hasMoreElements()) {
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("has elements");
                                        }
                                        var60_90 = (String)var59_88.nextElement();
                                        if (NVRAM.DEBUG_ON) {
                                            System.out.println("id = " + var60_90);
                                        }
                                        var61_93 = (short)var19_21.indexOf(var60_90);
                                        var62_94 = (Integer)((Object[])var50_73.get(var60_90))[1];
                                        var63_95 = (Integer)((Object[])var50_73.get(var60_90))[2];
                                        var14_16.writeShort(var61_93);
                                        var14_16.writeInt(var62_94);
                                        var14_16.writeInt(var63_95);
                                        if (!NVRAM.DEBUG_ON) continue;
                                        System.out.println("In createLPARProfile: drawerID = " + var61_93);
                                        System.out.println("In createLPARProfile: ioSlots = " + var62_94);
                                        System.out.println("In createLPARProfile: require = " + var63_95);
                                    }
                                }
                                if (this._releaseVersion < 3) continue;
                                var14_16.writeByte((byte)var58_85);
                                if (NVRAM.DEBUG_ON) {
                                    System.out.println("In _mergeDrawerProfileInfo: Number SMA Adapters = " + var58_85);
                                }
                                if (var58_85 <= 0) continue;
                                var14_16.writeByte((byte)var55_81);
                                var59_89 = 0;
                                while (var59_89 < var58_85) {
                                    var60_91 = Long.parseLong((String)var56_82.elementAt(var59_89));
                                    var14_16.writeInt((int)var60_91);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In _mergeDrawerProfileInfo: SMA Adapter ID = " + var60_91);
                                    }
                                    ++var59_89;
                                }
                                var60_92 = 0;
                                while (var60_92 < var58_85) {
                                    var61_93 = ((UnsignedInt16)var57_83.elementAt(var60_92)).shortValue();
                                    var14_16.writeShort(var61_93);
                                    if (NVRAM.DEBUG_ON) {
                                        System.out.println("In _mergeDrawerProfileInfo: SMA Adapter Number of Windows = " + var61_93);
                                    }
                                    ++var60_92;
                                }
                            }
                        }
                        ++var26_33;
                    }
                    var14_16.write(new byte[this.NVRAM_SIZE - var25_29]);
                    var14_16.close();
                    var1_1._nvramData = var13_14.toByteArray();
                    var13_14.close();
                }
                catch (Throwable var13_15) {
                    var13_15.printStackTrace();
                    HSCLogUtils.serverLog(var13_15, HSCLogUtils._NVRAMClassLogInfo);
                    throw new HSCCIMException("0007");
                }
                var65_96 = null;
            }
            catch (Throwable var5_6) {
                var5_6.printStackTrace();
                HSCLogUtils.serverLog(var5_6, HSCLogUtils._NVRAMClassLogInfo);
                if (!(var5_6 instanceof HSCCIMException)) {
                    throw new HSCCIMException("002F");
                }
                throw new HSCCIMException(var5_6);
            }
        }
        catch (Throwable var64_98) {
            var65_97 = null;
            Trace.trace("apnvhscT", "<- _mergeDrawerProfileInfo");
            throw var64_98;
        }
        Trace.trace("apnvhscT", "<- _mergeDrawerProfileInfo");
    }

    private void _recalculateChecksum(File file) throws CIMException {
        try {
            try {
                Trace.trace("apnvhscT", "-> _recalculateChecksum");
                Trace.trace("apnvhscF", "file = " + file);
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                Adler32 adler32 = new Adler32();
                byte[] byArray = null;
                byte by = (byte)((randomAccessFile.read() & this._versionMask) >>> 1);
                if (this._releaseVersion == 0) {
                    this.SIZE_OF_LPAR_INFO = (short)32;
                    this.NUM_ALPAR_SLOTS_OFFSET = -1;
                    this.TIME_STAMPS_CHECKSUM_OFFSET = (short)(this.CORRUPTED_BYTE_OFFSET + 1);
                    this._numPhyLocCodeSlots = 0;
                } else {
                    this.SIZE_OF_LPAR_INFO = (short)33;
                    this.NUM_ALPAR_SLOTS_OFFSET = this.CORRUPTED_BYTE_OFFSET + 1;
                    if (this._releaseVersion >= 3) {
                        this.NUM_PARTITION_SLOTS_OFFSET = this.NUM_ALPAR_SLOTS_OFFSET + 1;
                        this.VALIDATION_CHECKSUM_OFFSET = this.NUM_PARTITION_SLOTS_OFFSET + 1;
                        this.TIME_STAMPS_CHECKSUM_OFFSET = this.VALIDATION_CHECKSUM_OFFSET + 8;
                        if (DEBUG_ON) {
                            System.out.println("NUM_PARTITION_SLOTS_OFFSET = " + this.NUM_PARTITION_SLOTS_OFFSET);
                            System.out.println("VALIDATION_CHECKSUM_OFFSET = " + this.VALIDATION_CHECKSUM_OFFSET);
                        }
                    } else {
                        this.TIME_STAMPS_CHECKSUM_OFFSET = this.NUM_ALPAR_SLOTS_OFFSET + 1;
                    }
                    this._numPhyLocCodeSlots = (short)randomAccessFile.read();
                }
                if (DEBUG_ON) {
                    System.out.println("TIME_STAMPS_CHECKSUM_OFFSET = " + this.TIME_STAMPS_CHECKSUM_OFFSET);
                }
                Trace.trace("apnvhscF", "TIME_STAMPS_CHECKSUM_OFFSET = " + this.TIME_STAMPS_CHECKSUM_OFFSET);
                this.NVRAM_TIME_STAMP_OFFSET = this.TIME_STAMPS_CHECKSUM_OFFSET + 8;
                this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET = this.NVRAM_TIME_STAMP_OFFSET + 7;
                this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET = this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET + 7;
                this.DEFAULT_LIST_TIME_STAMP_OFFSET = this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + 7;
                this.ACTIVATED_LIST_TIME_STAMP_OFFSET = this.DEFAULT_LIST_TIME_STAMP_OFFSET + 7;
                if (this._releaseVersion == 0) {
                    this.PHY_LOC_CODE_TIME_STAMP_OFFSET = -1;
                    this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET = this.ACTIVATED_LIST_TIME_STAMP_OFFSET + 7;
                } else {
                    this.PHY_LOC_CODE_TIME_STAMP_OFFSET = (short)(this.ACTIVATED_LIST_TIME_STAMP_OFFSET + 7);
                    this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET = this.PHY_LOC_CODE_TIME_STAMP_OFFSET + 7;
                }
                if (DEBUG_ON) {
                    System.out.println("DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET = " + this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET);
                }
                Trace.trace("apnvhscF", "DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET = " + this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET);
                this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET = this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + 7;
                this.PARTITION_NAME_TABLE_OFFSET = this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET + 8;
                this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET = this.PARTITION_NAME_TABLE_OFFSET + this.NUM_PARTITION_SLOTS * this.SIZE_OF_LPAR_INFO;
                if (DEBUG_ON) {
                    System.out.println("PROFILE_NAME_TABLE_CHECKSUM_OFFSET = " + this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET);
                }
                Trace.trace("apnvhscF", "PROFILE_NAME_TABLE_CHECKSUM_OFFSET = " + String.valueOf(this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET));
                this.PROFILE_NAME_TABLE_OFFSET = this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET + 8;
                this.DEFAULT_LIST_CHECKSUM_OFFSET = this.PROFILE_NAME_TABLE_OFFSET + this.MAX_PROFILE * 32;
                this.DEFAULT_LIST_OFFSET = this.DEFAULT_LIST_CHECKSUM_OFFSET + 8;
                this.ACTIVATED_LIST_CHECKSUM_OFFSET = this.DEFAULT_LIST_OFFSET + 7 * (this.NUM_PARTITION_SLOTS + 1);
                this.ACTIVATED_LIST_OFFSET = this.ACTIVATED_LIST_CHECKSUM_OFFSET + 8;
                if (this._releaseVersion == 0) {
                    this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET = -1;
                    this.PHY_LOC_CODE_TABLE_OFFSET = -1;
                    this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET = this.ACTIVATED_LIST_OFFSET + 7 * (this.NUM_PARTITION_SLOTS + 1);
                    this.NUM_DRAWERS_OFFSET = this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET + 8;
                } else {
                    this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET = this.ACTIVATED_LIST_OFFSET + 7 * (this.NUM_PARTITION_SLOTS + 1);
                    this.PHY_LOC_CODE_TABLE_OFFSET = this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET + 8;
                    this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET = this.PHY_LOC_CODE_TABLE_OFFSET + this.SIZE_OF_ALPAR_INFO * this._numPhyLocCodeSlots;
                    this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET = this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET + 8;
                    this.NUM_DRAWERS_OFFSET = this._releaseVersion < 3 ? this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 2 : this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 4;
                }
                Trace.trace("apnvhscF", "DRAWER_PROFILE_INFO_CHECKSUM_OFFSET = " + String.valueOf(this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET));
                this.DRAWERS_OFFSET = this.NUM_DRAWERS_OFFSET + 2;
                randomAccessFile.seek(0L);
                randomAccessFile.writeByte((byte)(this._releaseVersion << 1 | CORRUPTED_ON[0]));
                randomAccessFile.seek(this.NVRAM_TIME_STAMP_OFFSET);
                byArray = new byte[this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET];
                randomAccessFile.read(byArray);
                adler32.reset();
                adler32.update(byArray);
                randomAccessFile.seek(this.TIME_STAMPS_CHECKSUM_OFFSET);
                randomAccessFile.write(NVRAM.longToByteArray(adler32.getValue()));
                randomAccessFile.seek(this.PARTITION_NAME_TABLE_OFFSET);
                byArray = new byte[this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET - this.PARTITION_NAME_TABLE_OFFSET];
                randomAccessFile.read(byArray);
                adler32.reset();
                adler32.update(byArray);
                randomAccessFile.seek(this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET);
                randomAccessFile.write(NVRAM.longToByteArray(adler32.getValue()));
                randomAccessFile.seek(this.PROFILE_NAME_TABLE_OFFSET);
                byArray = new byte[this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET];
                randomAccessFile.read(byArray);
                adler32.reset();
                adler32.update(byArray);
                randomAccessFile.seek(this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET);
                randomAccessFile.write(NVRAM.longToByteArray(adler32.getValue()));
                randomAccessFile.seek(this.DEFAULT_LIST_OFFSET);
                byArray = new byte[this.ACTIVATED_LIST_CHECKSUM_OFFSET - this.DEFAULT_LIST_OFFSET];
                randomAccessFile.read(byArray);
                adler32.reset();
                adler32.update(byArray);
                randomAccessFile.seek(this.DEFAULT_LIST_CHECKSUM_OFFSET);
                randomAccessFile.write(NVRAM.longToByteArray(adler32.getValue()));
                randomAccessFile.seek(this.ACTIVATED_LIST_OFFSET);
                byArray = this._releaseVersion == 0 ? new byte[this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET - this.ACTIVATED_LIST_OFFSET] : new byte[this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET - this.ACTIVATED_LIST_OFFSET];
                randomAccessFile.read(byArray);
                adler32.reset();
                adler32.update(byArray);
                randomAccessFile.seek(this.ACTIVATED_LIST_CHECKSUM_OFFSET);
                randomAccessFile.write(NVRAM.longToByteArray(adler32.getValue()));
                if (this._releaseVersion != 0) {
                    randomAccessFile.seek(this.PHY_LOC_CODE_TABLE_OFFSET);
                    byArray = new byte[this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET - this.PHY_LOC_CODE_TABLE_OFFSET];
                    randomAccessFile.read(byArray);
                    adler32.reset();
                    adler32.update(byArray);
                    randomAccessFile.seek(this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET);
                    randomAccessFile.write(NVRAM.longToByteArray(adler32.getValue()));
                }
                randomAccessFile.seek(this.NUM_DRAWERS_OFFSET);
                byArray = new byte[this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET];
                randomAccessFile.read(byArray);
                adler32.reset();
                adler32.update(byArray);
                randomAccessFile.seek(this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET);
                randomAccessFile.write(NVRAM.longToByteArray(adler32.getValue()));
                if (this._releaseVersion != 0) {
                    this._drawerProfInfoDataSize = this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET;
                    if (this._releaseVersion < 3) {
                        randomAccessFile.writeShort((short)this._drawerProfInfoDataSize);
                    } else {
                        randomAccessFile.writeInt(this._drawerProfInfoDataSize);
                    }
                }
                randomAccessFile.seek(0L);
                randomAccessFile.writeByte((byte)(this._releaseVersion << 1 | CORRUPTED_OFF[0]));
                randomAccessFile.close();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (!(throwable instanceof HSCCIMException)) {
                    throw new HSCCIMException("0007");
                }
                throw new HSCCIMException(throwable);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Trace.trace("apnvhscT", "<- _recalculateChecksum");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- _recalculateChecksum");
    }

    public static byte[] longToByteArray(long l) {
        Trace.trace("apnvhscT", "-> longToByteArray");
        Trace.trace("apnvhscF", "num = " + l);
        if (DEBUG_ON) {
            System.out.println("num = " + l);
        }
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)(l >>> (8 - n - 1) * 8);
            if (DEBUG_ON) {
                System.out.println("ret[" + n + "] = " + byArray[n]);
            }
            ++n;
        }
        Trace.trace("apnvhscF", "ret = " + byArray);
        Trace.trace("apnvhscT", "<- longToByteArray");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void createLPARProfiles(Hashtable hashtable, HscProviderSocket hscProviderSocket, boolean bl) throws CIMException {
        try {
            try {
                block122: {
                    Trace.trace("apnvhscT", "-> createLPARrofiles");
                    Trace.trace("apnvhscF", "profsProperties = " + hashtable);
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("********************************************");
                        System.out.println("In createLPARProfiles");
                    }
                    try {
                        int n;
                        Object object;
                        Object object2;
                        this.buildNVRAM(hscProviderSocket, false, null, true, false);
                        short s = 0;
                        short s2 = 0;
                        boolean bl2 = false;
                        int n2 = 0;
                        boolean bl3 = false;
                        short s3 = 0;
                        short s4 = 0;
                        short s5 = 0;
                        short s6 = 0;
                        short s7 = 0;
                        short s8 = 0;
                        short s9 = 0;
                        long l = 0L;
                        long l2 = 0L;
                        long l3 = 0L;
                        Object[] objectArray = new Object[3];
                        short s10 = 0;
                        String string = new String();
                        boolean bl4 = false;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        int n3 = 0;
                        int n4 = 0;
                        short s11 = 0;
                        Vector vector = null;
                        Vector vector2 = null;
                        int n5 = 0;
                        byte[] byArray = (byte[])this._nvramData.clone();
                        int n6 = this._nvramDataSize;
                        short s12 = this._numDrawers;
                        Hashtable hashtable2 = (Hashtable)this._drawerIDTable.clone();
                        Hashtable hashtable3 = (Hashtable)this._drawerIndexTable.clone();
                        Hashtable hashtable4 = (Hashtable)this._profileNameTable.clone();
                        Hashtable hashtable5 = (Hashtable)this._profileNameOffsetTable.clone();
                        Hashtable hashtable6 = (Hashtable)this._profileTable.clone();
                        Vector vector3 = (Vector)this._pnameFreeList.clone();
                        Vector vector4 = (Vector)this._dIDFreeList.clone();
                        int n7 = this._drawerOffsetTail;
                        short s13 = this._dIDFreeListTail;
                        String[] stringArray = (String[])this._defaultList.clone();
                        byte[] byArray2 = (byte[])this._nvramData.clone();
                        int n8 = this._nvramDataSize;
                        short s14 = this._numDrawers;
                        Hashtable hashtable7 = (Hashtable)this._drawerIDTable.clone();
                        Hashtable hashtable8 = (Hashtable)this._drawerIndexTable.clone();
                        Hashtable hashtable9 = (Hashtable)this._profileNameTable.clone();
                        Hashtable hashtable10 = (Hashtable)this._profileNameOffsetTable.clone();
                        Hashtable hashtable11 = (Hashtable)this._profileTable.clone();
                        Vector vector5 = (Vector)this._pnameFreeList.clone();
                        Vector vector6 = (Vector)this._dIDFreeList.clone();
                        int n9 = this._drawerOffsetTail;
                        short s15 = this._dIDFreeListTail;
                        String[] stringArray2 = (String[])this._defaultList.clone();
                        Vector[] vectorArray = (Vector[])this._profilesAtPartitionTable.clone();
                        s2 = this._hscTemplateVersion;
                        bl2 = false;
                        Hashtable<String, Object[]> hashtable12 = new Hashtable<String, Object[]>();
                        char[] cArray = new char[32];
                        char[] cArray2 = new char[32];
                        int n10 = this._nvramDataSize;
                        int n11 = -1;
                        int n12 = -1;
                        int n13 = 0;
                        int n14 = 0;
                        int n15 = 0;
                        int n16 = -1;
                        int n17 = -1;
                        boolean bl8 = false;
                        if (hashtable != null && hashtable.size() != 0) {
                            n15 = hashtable.size();
                            try {
                                object2 = hashtable.keys();
                                while (object2.hasMoreElements()) {
                                    block120: {
                                        int n18;
                                        String string2;
                                        int n19;
                                        Object object3;
                                        int[] nArray;
                                        String string3;
                                        Vector vector7;
                                        block119: {
                                            hashtable12 = new Hashtable();
                                            object = (Integer)object2.nextElement();
                                            n = (Integer)object;
                                            Trace.trace("apnvhscF", "partitionID = " + n);
                                            if (DEBUG_ON) {
                                                System.out.println("partitionID = " + n);
                                            }
                                            vector7 = (Vector)hashtable.get(object);
                                            Trace.trace("apnvhscF", "properties = " + vector7);
                                            if (DEBUG_ON) {
                                                System.out.println("properties = " + vector7);
                                            }
                                            String string4 = (String)((CIMProperty)vector7.elementAt(1)).getValue().getValue();
                                            string3 = (String)((CIMProperty)vector7.elementAt(0)).getValue().getValue();
                                            int n20 = 0;
                                            while (true) {
                                                if (n20 >= 32) {
                                                    int n21 = string4.length();
                                                    Trace.trace("apnvhscF", "name = " + string4);
                                                    if (!hashtable4.containsKey(string4)) break;
                                                    Trace.trace("apnvhscF", "profileNameTable already contain the name - Just increment the reference count");
                                                    nArray = (int[])hashtable4.get(string4);
                                                    nArray[1] = nArray[1] + 1;
                                                    n2 = nArray[0];
                                                    if (DEBUG_ON) {
                                                        System.out.println("In createLPARProfile: nameIndex = " + n2);
                                                    }
                                                    break block119;
                                                }
                                                cArray[n20] = 48;
                                                cArray2[n20] = 48;
                                                ++n20;
                                            }
                                            bl4 = true;
                                            nArray = new int[2];
                                            if (vector3.isEmpty()) {
                                                if (!DEBUG_ON) throw new HSCCIMException("0001");
                                                System.out.println("no more space for name");
                                                throw new HSCCIMException("0001");
                                            }
                                            nArray[0] = (Integer)vector3.elementAt(0);
                                            vector3.removeElementAt(0);
                                            nArray[1] = 1;
                                            n3 = n2 = nArray[0];
                                            if (n11 == -1) {
                                                n11 = n3;
                                            } else if (n11 > n3) {
                                                n11 = n3;
                                            }
                                            if (n12 == -1) {
                                                n12 = n3 + 32;
                                            } else if (n12 < n3 + 32) {
                                                n12 = n3 + 32;
                                            }
                                            Trace.trace("apnvhscF", "nameIndex and newNameOffset = " + n2);
                                            if (DEBUG_ON) {
                                                System.out.println("In createLPARProfile: nameIndex = " + n2);
                                            }
                                            hashtable4.put(string4, nArray);
                                            hashtable5.put(new Integer(n2), string4);
                                            object3 = this.setLength(string4, 32).getBytes();
                                            int n22 = 0;
                                            while (n22 < 32) {
                                                byArray[n3 + n22] = object3[n22];
                                                ++n22;
                                            }
                                        }
                                        object3 = null;
                                        Vector vector8 = null;
                                        Vector vector9 = null;
                                        if (this._releaseVersion < 2) {
                                            s3 = ((UnsignedInt8)((CIMProperty)vector7.elementAt(2)).getValue().getValue()).shortValue();
                                            s4 = ((UnsignedInt8)((CIMProperty)vector7.elementAt(3)).getValue().getValue()).shortValue();
                                            s7 = ((UnsignedInt8)((CIMProperty)vector7.elementAt(4)).getValue().getValue()).shortValue();
                                            s8 = ((UnsignedInt8)((CIMProperty)vector7.elementAt(5)).getValue().getValue()).shortValue();
                                            l = ((UnsignedInt32)((CIMProperty)vector7.elementAt(6)).getValue().getValue()).longValue();
                                            l2 = ((UnsignedInt32)((CIMProperty)vector7.elementAt(7)).getValue().getValue()).longValue();
                                            if (((CIMProperty)vector7.elementAt(8)).getValue() != null) {
                                                object3 = (Vector)((CIMProperty)vector7.elementAt(8)).getValue().getValue();
                                                vector8 = (Vector)((CIMProperty)vector7.elementAt(9)).getValue().getValue();
                                                vector9 = (Vector)((CIMProperty)vector7.elementAt(10)).getValue().getValue();
                                            }
                                        } else {
                                            s3 = ((UnsignedInt8)((CIMProperty)vector7.elementAt(2)).getValue().getValue()).shortValue();
                                            s4 = ((UnsignedInt8)((CIMProperty)vector7.elementAt(3)).getValue().getValue()).shortValue();
                                            s5 = ((UnsignedInt8)((CIMProperty)vector7.elementAt(4)).getValue().getValue()).shortValue();
                                            s6 = ((UnsignedInt8)((CIMProperty)vector7.elementAt(5)).getValue().getValue()).shortValue();
                                            s7 = ((UnsignedInt8)((CIMProperty)vector7.elementAt(6)).getValue().getValue()).shortValue();
                                            s8 = ((UnsignedInt8)((CIMProperty)vector7.elementAt(7)).getValue().getValue()).shortValue();
                                            s9 = ((UnsignedInt8)((CIMProperty)vector7.elementAt(8)).getValue().getValue()).shortValue();
                                            l = ((UnsignedInt32)((CIMProperty)vector7.elementAt(9)).getValue().getValue()).longValue();
                                            l2 = ((UnsignedInt32)((CIMProperty)vector7.elementAt(10)).getValue().getValue()).longValue();
                                            l3 = ((UnsignedInt32)((CIMProperty)vector7.elementAt(11)).getValue().getValue()).longValue();
                                            if (((CIMProperty)vector7.elementAt(12)).getValue() != null) {
                                                object3 = (Vector)((CIMProperty)vector7.elementAt(12)).getValue().getValue();
                                                vector8 = (Vector)((CIMProperty)vector7.elementAt(13)).getValue().getValue();
                                                vector9 = (Vector)((CIMProperty)vector7.elementAt(14)).getValue().getValue();
                                            }
                                            if (this._releaseVersion >= 3) {
                                                if (((CIMProperty)vector7.elementAt(15)).getValue() != null) {
                                                    s11 = ((UnsignedInt8)((CIMProperty)vector7.elementAt(15)).getValue().getValue()).shortValue();
                                                    vector = (Vector)((CIMProperty)vector7.elementAt(16)).getValue().getValue();
                                                    vector2 = (Vector)((CIMProperty)vector7.elementAt(17)).getValue().getValue();
                                                }
                                                n5 = vector == null ? 0 : (int)((short)vector.size());
                                            }
                                        }
                                        int n23 = n7;
                                        if (object3 != null && ((Vector)object3).size() != 0) {
                                            Trace.trace("apnvhscF", "num of drawres = " + String.valueOf(((Vector)object3).size()));
                                            int n24 = 0;
                                            while (n24 < ((Vector)object3).size()) {
                                                string = (String)((Vector)object3).get(n24);
                                                if (DEBUG_ON) {
                                                    System.out.println("In createLPARProfiles: slots = " + string);
                                                }
                                                if (hashtable2.containsKey(string)) {
                                                    nArray = (int[])hashtable2.get(string);
                                                    if (DEBUG_ON) {
                                                        System.out.println("In createLPARProfiles: already contain this drawerID");
                                                        System.out.println("In createLPARProfiles: drawerID = " + string.trim() + " drawerIndex = " + nArray[1]);
                                                    }
                                                    nArray[2] = nArray[2] + 1;
                                                } else {
                                                    nArray = new int[3];
                                                    long l4 = this.NVRAM_SIZE;
                                                    if (this._releaseVersion != 0) {
                                                        l4 = this._bufferedNVRAMSize;
                                                    }
                                                    if ((long)n7 >= l4 || (long)(n6 + 24 + 2) > l4) {
                                                        if (DEBUG_ON) {
                                                            System.out.println("not enough space for drawers - need to clean up");
                                                        }
                                                        this._nvramData = (byte[])byArray.clone();
                                                        this._nvramDataSize = n6;
                                                        this._numDrawers = s12;
                                                        this._drawerIDTable = (Hashtable)hashtable2.clone();
                                                        this._drawerIndexTable = (Hashtable)hashtable3.clone();
                                                        this._profileNameTable = (Hashtable)hashtable4.clone();
                                                        this._profileNameOffsetTable = (Hashtable)hashtable5.clone();
                                                        this._profileTable = (Hashtable)hashtable6.clone();
                                                        this._pnameFreeList = (Vector)vector3.clone();
                                                        this._dIDFreeList = (Vector)vector4.clone();
                                                        this._drawerOffsetTail = n7;
                                                        this._dIDFreeListTail = s13;
                                                        this._defaultList = stringArray;
                                                        this.cleanUp(null);
                                                        bl6 = true;
                                                        bl7 = true;
                                                        if ((long)this._drawerOffsetTail >= l4) throw new HSCCIMException("0003");
                                                        if ((long)(this._nvramDataSize + 24 + 2) > l4) {
                                                            throw new HSCCIMException("0003");
                                                        }
                                                        byArray = (byte[])this._nvramData.clone();
                                                        n6 = this._nvramDataSize;
                                                        s12 = this._numDrawers;
                                                        hashtable2 = (Hashtable)this._drawerIDTable.clone();
                                                        hashtable3 = (Hashtable)this._drawerIndexTable.clone();
                                                        hashtable4 = (Hashtable)this._profileNameTable.clone();
                                                        hashtable5 = (Hashtable)this._profileNameOffsetTable.clone();
                                                        hashtable6 = (Hashtable)this._profileTable.clone();
                                                        vector3 = (Vector)this._pnameFreeList.clone();
                                                        vector4 = (Vector)this._dIDFreeList.clone();
                                                        n7 = this._drawerOffsetTail;
                                                        s13 = this._dIDFreeListTail;
                                                        n23 = this._drawerOffsetTail;
                                                        stringArray = this._defaultList;
                                                    }
                                                    bl5 = true;
                                                    nArray[0] = n7;
                                                    if (!vector4.isEmpty()) {
                                                        if (DEBUG_ON) {
                                                            System.out.println("In createLPARProfiles: newDIDFreeList = " + vector4);
                                                        }
                                                        s10 = (Short)vector4.elementAt(0);
                                                        vector4.removeElementAt(0);
                                                        nArray[1] = s10;
                                                        if (DEBUG_ON) {
                                                            System.out.println("In createLPARProfiles: (notempty) drawerIndex = " + s10);
                                                        }
                                                    } else {
                                                        if (s13 > 255) {
                                                            if (!DEBUG_ON) throw new HSCCIMException("0002");
                                                            System.out.println("no more index for drawer");
                                                            throw new HSCCIMException("0002");
                                                        }
                                                        nArray[1] = s13;
                                                        if (DEBUG_ON) {
                                                            System.out.println("In createLPARProfiles: tail drawerIndex = " + s13);
                                                        }
                                                        s13 = (short)(s13 + 1);
                                                    }
                                                    byte[] byArray3 = (byte[])byArray.clone();
                                                    byte[] byArray4 = this.setLength(string, 24).getBytes();
                                                    n19 = 0;
                                                    while (true) {
                                                        if (n19 >= 24) {
                                                            byArray[n7 + 24 + 0] = (byte)(nArray[1] >>> 8);
                                                            byArray[n7 + 24 + 1] = (byte)nArray[1];
                                                            if (DEBUG_ON) {
                                                                System.out.println("newDrawerOffsetTail = " + n7);
                                                            }
                                                            break;
                                                        }
                                                        byArray[n7 + n19] = byArray4[n19];
                                                        ++n19;
                                                    }
                                                    int n25 = n7;
                                                    while (true) {
                                                        if (n25 >= n6) {
                                                            s12 = (short)(s12 + 1);
                                                            byArray[this.NUM_DRAWERS_OFFSET + 0] = (byte)(s12 >> 8);
                                                            byArray[this.NUM_DRAWERS_OFFSET + 1] = (byte)s12;
                                                            if (DEBUG_ON) {
                                                                System.out.println("In createLPARProfiles: newNumDrawer's first byte = " + byArray[this.NUM_DRAWERS_OFFSET]);
                                                                System.out.println("In createLPARProfiles: newNumDrawer's snd byte = " + byArray[this.NUM_DRAWERS_OFFSET + 1]);
                                                                System.out.println("In createLPARProfiles: num of drawers = " + s12);
                                                                System.out.println("In createLPARProfiles: drawerID = " + string.trim());
                                                                System.out.println("In createLPARProfiles: drawerIndex = " + nArray[1]);
                                                            }
                                                            break;
                                                        }
                                                        byArray[n25 + 24 + 2] = byArray3[n25];
                                                        ++n25;
                                                    }
                                                    Enumeration enumeration = hashtable6.elements();
                                                    while (true) {
                                                        if (!enumeration.hasMoreElements()) {
                                                            bl6 = false;
                                                            n6 += 26;
                                                            n7 += 26;
                                                            nArray[2] = 1;
                                                            hashtable2.put(string, nArray);
                                                            hashtable3.put(new Short((short)nArray[1]), string);
                                                            break;
                                                        }
                                                        Object[] objectArray2 = (Object[])enumeration.nextElement();
                                                        objectArray2[0] = new Integer((Integer)objectArray2[0] + 24 + 2);
                                                    }
                                                }
                                                if (DEBUG_ON) {
                                                    System.out.println("before drawersInfo.containsKey");
                                                }
                                                Object[] objectArray3 = hashtable12.containsKey(string) ? (Object[])hashtable12.get(string) : new Object[]{new Short((short)nArray[1]), new Integer(0), new Integer(0)};
                                                short s16 = ((UnsignedInt8)vector8.get(n24)).shortValue();
                                                Trace.trace("apnvhscF", "slotNum = " + String.valueOf(s16));
                                                if (((String)vector9.get(n24)).equalsIgnoreCase("r")) {
                                                    if (DEBUG_ON) {
                                                        System.out.println("required");
                                                    }
                                                    cArray2[32 - s16 - 1] = 49;
                                                    string2 = new String(cArray2);
                                                    cArray2[32 - s16 - 1] = 48;
                                                    n18 = Integer.parseInt(string2, 2);
                                                    objectArray3[2] = new Integer((Integer)objectArray3[2] | n18);
                                                } else {
                                                    if (DEBUG_ON) {
                                                        System.out.println("desired");
                                                    }
                                                    cArray[32 - s16 - 1] = 49;
                                                    string2 = new String(cArray);
                                                    cArray[32 - s16 - 1] = 48;
                                                    n18 = Integer.parseInt(string2, 2);
                                                    objectArray3[1] = new Integer((Integer)objectArray3[1] | n18);
                                                }
                                                hashtable12.put(string, objectArray3);
                                                ++n24;
                                            }
                                        }
                                        if (this._releaseVersion < 2) {
                                            s = (short)(26 + hashtable12.size() * 10);
                                        } else if (this._releaseVersion < 3) {
                                            s = (short)(33 + hashtable12.size() * 10);
                                        } else {
                                            s = (short)(36 + hashtable12.size() * 10);
                                            s = n5 == 0 ? (short)(s + 1) : (short)(s + 2 + n5 * 4 * 1 + n5 * 2 * 1);
                                        }
                                        n14 += s;
                                        if (DEBUG_ON) {
                                            System.out.println("In createLPARProfiles: profile len = " + s);
                                        }
                                        long l5 = this.NVRAM_SIZE;
                                        if (this._releaseVersion != 0) {
                                            l5 = this._bufferedNVRAMSize;
                                        }
                                        if ((long)(n6 + s) > l5) {
                                            this._nvramData = (byte[])byArray.clone();
                                            this._nvramDataSize = n6;
                                            this._numDrawers = s12;
                                            this._drawerIDTable = (Hashtable)hashtable2.clone();
                                            this._drawerIndexTable = (Hashtable)hashtable3.clone();
                                            this._profileNameTable = (Hashtable)hashtable4.clone();
                                            this._profileNameOffsetTable = (Hashtable)hashtable5.clone();
                                            this._profileTable = (Hashtable)hashtable6.clone();
                                            this._pnameFreeList = (Vector)vector3.clone();
                                            this._dIDFreeList = (Vector)vector4.clone();
                                            this._drawerOffsetTail = n7;
                                            this._dIDFreeListTail = s13;
                                            this._defaultList = stringArray;
                                            this.cleanUp(null);
                                            bl6 = true;
                                            bl7 = true;
                                            if ((long)(this._nvramDataSize + s) > l5) {
                                                throw new HSCCIMException("0003");
                                            }
                                            byArray = (byte[])this._nvramData.clone();
                                            n6 = this._nvramDataSize;
                                            s12 = this._numDrawers;
                                            hashtable2 = (Hashtable)this._drawerIDTable.clone();
                                            hashtable3 = (Hashtable)this._drawerIndexTable.clone();
                                            hashtable4 = (Hashtable)this._profileNameTable.clone();
                                            hashtable5 = (Hashtable)this._profileNameOffsetTable.clone();
                                            hashtable6 = (Hashtable)this._profileTable.clone();
                                            vector3 = (Vector)this._pnameFreeList.clone();
                                            vector4 = (Vector)this._dIDFreeList.clone();
                                            if (n7 != this._drawerOffsetTail) {
                                                bl5 = true;
                                            }
                                            n7 = this._drawerOffsetTail;
                                            s13 = this._dIDFreeListTail;
                                            n23 = this._drawerOffsetTail;
                                            stringArray = this._defaultList;
                                        }
                                        try {
                                            if (n13 == 0) {
                                                n13 = n6;
                                                if (DEBUG_ON) {
                                                    System.out.println("firstProfOffset = " + n13);
                                                }
                                            }
                                            bl8 = true;
                                            objectArray = new Object[3];
                                            objectArray[0] = new Integer(n6);
                                            n4 = n6;
                                            objectArray[1] = new Short(s);
                                            objectArray[2] = vector7;
                                            hashtable6.put(string3, objectArray);
                                            this._profilesAtPartitionTable[n].add(string3);
                                            this._nvramBAOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
                                            this._nvramDOutputStream = new DataOutputStream(this._nvramBAOutputStream);
                                            this._nvramDOutputStream.write(byArray, 0, n6);
                                            if (this._releaseVersion < 3) {
                                                this._nvramDOutputStream.writeByte((byte)s);
                                            } else {
                                                this._nvramDOutputStream.writeShort(s);
                                            }
                                            this._nvramDOutputStream.writeByte((byte)s2);
                                            this._nvramDOutputStream.writeBytes(NVRAM.cryptedTimestamp(string3));
                                            this._nvramDOutputStream.writeByte((byte)(bl2 ? 1 : 0));
                                            if (this._releaseVersion < 3) {
                                                this._nvramDOutputStream.writeShort((short)n2);
                                            } else {
                                                this._nvramDOutputStream.writeInt(n2);
                                            }
                                            this._nvramDOutputStream.writeByte((byte)n);
                                            this._nvramDOutputStream.writeByte((byte)s3);
                                            this._nvramDOutputStream.writeByte((byte)s4);
                                            if (this._releaseVersion >= 2) {
                                                this._nvramDOutputStream.writeByte((byte)s5);
                                                this._nvramDOutputStream.writeByte((byte)s6);
                                            }
                                            this._nvramDOutputStream.writeByte((byte)s7);
                                            this._nvramDOutputStream.writeByte((byte)s8);
                                            if (this._releaseVersion >= 2) {
                                                this._nvramDOutputStream.writeByte((byte)s9);
                                            }
                                            this._nvramDOutputStream.writeInt((int)l);
                                            this._nvramDOutputStream.writeInt((int)l2);
                                            if (this._releaseVersion >= 2) {
                                                this._nvramDOutputStream.writeInt((int)l3);
                                            }
                                            this._nvramDOutputStream.writeByte((byte)hashtable12.size());
                                            if (DEBUG_ON) {
                                                System.out.println("In createLPARProfiles: num drawers = " + hashtable12.size());
                                            }
                                            if (hashtable12.size() != 0) {
                                                if (DEBUG_ON) {
                                                    System.out.println("has drawers!!!");
                                                }
                                                Enumeration enumeration = hashtable12.keys();
                                                while (enumeration.hasMoreElements()) {
                                                    if (DEBUG_ON) {
                                                        System.out.println("has elements");
                                                    }
                                                    string2 = (String)enumeration.nextElement();
                                                    n18 = ((Short)((Object[])hashtable12.get(string2))[0]).shortValue();
                                                    int n26 = (Integer)((Object[])hashtable12.get(string2))[1];
                                                    n19 = (Integer)((Object[])hashtable12.get(string2))[2];
                                                    this._nvramDOutputStream.writeShort(n18);
                                                    this._nvramDOutputStream.writeInt(n26);
                                                    this._nvramDOutputStream.writeInt(n19);
                                                    if (!DEBUG_ON) continue;
                                                    System.out.println("In createLPARProfiles: drawerID = " + n18);
                                                    System.out.println("In createLPARProfiles: ioSlots = " + n26);
                                                    System.out.println("In createLPARProfiles: require = " + n19);
                                                }
                                            }
                                            if (this._releaseVersion > 2) {
                                                this._nvramDOutputStream.writeByte((byte)n5);
                                                if (DEBUG_ON) {
                                                    System.out.println("In createLPARProfiles: Number SMA Adapters = " + n5);
                                                }
                                                if (n5 > 0) {
                                                    int n27;
                                                    this._nvramDOutputStream.writeByte((byte)s11);
                                                    System.out.println("In createLPARProfiles: SMA Mode = " + s11);
                                                    int n28 = 0;
                                                    while (true) {
                                                        if (n28 >= n5) {
                                                            n27 = 0;
                                                            break;
                                                        }
                                                        long l6 = Long.parseLong((String)vector.elementAt(n28));
                                                        this._nvramDOutputStream.writeInt((int)l6);
                                                        if (DEBUG_ON) {
                                                            System.out.println("In createLPARProfiles: SMA Adapter ID = " + l6);
                                                        }
                                                        ++n28;
                                                    }
                                                    while (n27 < n5) {
                                                        n18 = ((UnsignedInt16)vector2.elementAt(n27)).shortValue();
                                                        this._nvramDOutputStream.writeShort(n18);
                                                        if (DEBUG_ON) {
                                                            System.out.println("In createLPARProfiles: SMA Adapter Number of Windows = " + n18);
                                                        }
                                                        ++n27;
                                                    }
                                                }
                                            }
                                            this._nvramDOutputStream.write(byArray, n6, this.NVRAM_SIZE - (n6 + s));
                                            n6 += s;
                                            this._nvramDOutputStream.flush();
                                            byArray = this._nvramBAOutputStream.toByteArray();
                                            if (DEBUG_ON) {
                                                System.out.println("In createLPARProfiles: _nvramData's length = " + byArray.length);
                                            }
                                            this._nvramDOutputStream.close();
                                            this._nvramBAOutputStream.close();
                                        }
                                        catch (Throwable throwable) {
                                            throwable.printStackTrace();
                                            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                                            throw new HSCCIMException("0007");
                                        }
                                        if (!bl) continue;
                                        byte[] byArray5 = null;
                                        byArray5 = NVRAM.cryptedTimestamp(string3).getBytes();
                                        int n29 = 0;
                                        while (true) {
                                            if (n29 >= 7) {
                                                stringArray[n] = string3;
                                                if (n16 != -1) break;
                                                n16 = this.DEFAULT_LIST_OFFSET + n * 7;
                                                break block120;
                                            }
                                            byArray[this.DEFAULT_LIST_OFFSET + n * 7 + n29] = byArray5[n29];
                                            ++n29;
                                        }
                                        if (n16 > this.DEFAULT_LIST_OFFSET + n * 7) {
                                            n16 = this.DEFAULT_LIST_OFFSET + n * 7;
                                        }
                                    }
                                    if (n17 == -1) {
                                        n17 = this.DEFAULT_LIST_OFFSET + (n + 1) * 7;
                                        continue;
                                    }
                                    if (n17 >= this.DEFAULT_LIST_OFFSET + (n + 1) * 7) continue;
                                    n17 = this.DEFAULT_LIST_OFFSET + (n + 1) * 7;
                                }
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                this._nvramData = (byte[])byArray2.clone();
                                this._nvramDataSize = n8;
                                this._numDrawers = s14;
                                this._drawerIDTable = (Hashtable)hashtable7.clone();
                                this._drawerIndexTable = (Hashtable)hashtable8.clone();
                                this._profileNameTable = (Hashtable)hashtable9.clone();
                                this._profileNameOffsetTable = (Hashtable)hashtable10.clone();
                                this._profileTable = (Hashtable)hashtable11.clone();
                                this._pnameFreeList = (Vector)vector5.clone();
                                this._dIDFreeList = (Vector)vector6.clone();
                                this._drawerOffsetTail = n9;
                                this._defaultList = (String[])stringArray2.clone();
                                this._profilesAtPartitionTable = (Vector[])vectorArray.clone();
                                bl8 = false;
                                throw throwable;
                            }
                        }
                        this._nvramData = (byte[])byArray.clone();
                        this._nvramDataSize = n6;
                        this._numDrawers = s12;
                        this._drawerIDTable = (Hashtable)hashtable2.clone();
                        this._drawerIndexTable = (Hashtable)hashtable3.clone();
                        this._profileNameTable = (Hashtable)hashtable4.clone();
                        this._profileNameOffsetTable = (Hashtable)hashtable5.clone();
                        this._profileTable = (Hashtable)hashtable6.clone();
                        this._pnameFreeList = (Vector)vector3.clone();
                        this._dIDFreeList = (Vector)vector4.clone();
                        this._drawerOffsetTail = n7;
                        this._dIDFreeListTail = s13;
                        this._defaultList = (String[])stringArray.clone();
                        if (bl8) {
                            block121: {
                                int n30;
                                object2 = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", null, hscProviderSocket, this._cspVersion);
                                object = this.getTime((Hashtable)object2);
                                n = 0;
                                while (true) {
                                    if (n >= 7) {
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                                        this._nvramTimeStamp = (byte[])object.clone();
                                        if (bl4) {
                                            this._checksumCalc.reset();
                                            this._checksumCalc.update(this._nvramData, this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
                                            this._checksum = this._checksumCalc.getValue();
                                            this.writeIntegralToNvramData(this._checksum, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                                            this._profileNameTableTimeStamp = (byte[])object.clone();
                                        }
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, (short)8);
                                        if (this._releaseVersion != 0) {
                                            n30 = this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET;
                                            if (this._releaseVersion >= 3) break;
                                            this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = (byte)(n30 >>> 8);
                                            this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = (byte)(n30 & 0xFF);
                                        }
                                        break block121;
                                    }
                                    this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + n] = (byte)object[n];
                                    if (bl4) {
                                        this._nvramData[this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + n] = (byte)object[n];
                                    }
                                    this._nvramData[this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + n] = (byte)object[n];
                                    if (bl) {
                                        this._nvramData[this.DEFAULT_LIST_TIME_STAMP_OFFSET + n] = (byte)object[n];
                                    }
                                    ++n;
                                }
                                this.writeIntToNvramData(n30, this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET);
                            }
                            this._drawerProfileInfoTimeStamp = (byte[])object.clone();
                            if (bl) {
                                this._checksumCalc.reset();
                                this._checksumCalc.update(this._nvramData, this.DEFAULT_LIST_OFFSET, this.ACTIVATED_LIST_CHECKSUM_OFFSET - this.DEFAULT_LIST_OFFSET);
                                this._checksum = this._checksumCalc.getValue();
                                this.writeIntegralToNvramData(this._checksum, this.DEFAULT_LIST_CHECKSUM_OFFSET, (short)8);
                                this._defaultListTimeStamp = (byte[])object.clone();
                            }
                            this._backupToLocalFile();
                            byte by = (byte)(this._releaseVersion << 1 | CORRUPTED_ON[0]);
                            this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                            this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, hscProviderSocket);
                            if (bl4) {
                                this._writeDataToCSP(new String(this._nvramData, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                if (DEBUG_ON) {
                                    System.out.println("In createLPARProfile: writing to csp at ProfileNameTable portion");
                                }
                                this._writeDataToCSP(new String(this._nvramData, n11, n12 - n11).getBytes(), n11, n12 - n11, hscProviderSocket);
                            }
                            if (this._releaseVersion == 0) {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8, hscProviderSocket);
                            } else if (this._releaseVersion < 3) {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10, hscProviderSocket);
                            } else {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12, hscProviderSocket);
                            }
                            if (bl5) {
                                this._writeDataToCSP(new String(this._nvramData, this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET).getBytes(), this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET, hscProviderSocket);
                            }
                            if (!(bl5 || bl6 || bl7)) {
                                if (DEBUG_ON) {
                                    System.out.println("totalProfLen = " + n14);
                                }
                                this._writeDataToCSP(new String(this._nvramData, n13, n14).getBytes(), n13, n14, hscProviderSocket);
                            } else {
                                if (DEBUG_ON) {
                                    System.out.println("firstProfOffset = " + n13);
                                    System.out.println("totalProfLen = " + n14);
                                }
                                int n31 = bl6 || bl7 ? this.NVRAM_SIZE - this._drawerOffsetTail : this._nvramDataSize - this._drawerOffsetTail;
                                this._writeDataToCSP(new String(this._nvramData, this._drawerOffsetTail, n31).getBytes(), this._drawerOffsetTail, n31, hscProviderSocket);
                            }
                            if (bl) {
                                this._writeDataToCSP(new String(this._nvramData, this.DEFAULT_LIST_CHECKSUM_OFFSET, 8).getBytes(), this.DEFAULT_LIST_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                this._writeDataToCSP(new String(this._nvramData, n16, n17 - n16).getBytes(), n16, n17 - n16, hscProviderSocket);
                            }
                            by = (byte)(this._releaseVersion << 1 | CORRUPTED_OFF[0]);
                            this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                        }
                    }
                    finally {
                        if (!DEBUG_ON) break block122;
                        System.out.println("End of createLPARProfile");
                        System.out.print("********************");
                        System.out.println("********************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var99_111 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throwable.printStackTrace();
                throw new HSCCIMException("0038");
            }
        }
        catch (Throwable throwable) {
            Object var99_112 = null;
            Trace.trace("apnvhscT", "<- createLPARProfiles");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- createLPARProfiles");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void deletePartitions(Vector vector, HscProviderSocket hscProviderSocket) throws CIMException {
        try {
            try {
                block126: {
                    Trace.trace("apnvhscT", "-> deletePartitions");
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("*********************************************");
                        System.out.println("In deletePartitions");
                    }
                    try {
                        byte by;
                        this.buildNVRAM(hscProviderSocket, false, null, true, false);
                        boolean bl = false;
                        boolean bl2 = false;
                        Vector<Integer> vector2 = new Vector<Integer>();
                        int n = -1;
                        int n2 = -1;
                        int n3 = -1;
                        int n4 = -1;
                        int n5 = -1;
                        int n6 = -1;
                        int n7 = -1;
                        int n8 = -1;
                        int n9 = -1;
                        int n10 = -1;
                        int n11 = -1;
                        int n12 = -1;
                        int n13 = -1;
                        int n14 = -1;
                        boolean bl3 = false;
                        byte[] byArray = (byte[])this._nvramData.clone();
                        short s = this._numDrawers;
                        Vector[] vectorArray = (Vector[])this._profilesAtPartitionTable.clone();
                        Hashtable hashtable = (Hashtable)this._drawerIDTable.clone();
                        Hashtable hashtable2 = (Hashtable)this._drawerIndexTable.clone();
                        Hashtable hashtable3 = (Hashtable)this._profileNameTable.clone();
                        Hashtable hashtable4 = (Hashtable)this._profileNameOffsetTable.clone();
                        Hashtable hashtable5 = (Hashtable)this._profileTable.clone();
                        Vector vector3 = (Vector)this._pnameFreeList.clone();
                        Vector vector4 = (Vector)this._dIDFreeList.clone();
                        int n15 = this._drawerOffsetTail;
                        short s2 = this._dIDFreeListTail;
                        String[] stringArray = (String[])this._defaultList.clone();
                        String[] stringArray2 = (String[])this._activatedList.clone();
                        String[] stringArray3 = (String[])this._partitionNameTable.clone();
                        boolean[] blArray = (boolean[])this._fastActivation.clone();
                        Vector[] vectorArray2 = (Vector[])this._partitionPhyLocCodeTable.clone();
                        short[] sArray = (short[])this._partitionClusterTypeTable.clone();
                        Vector vector5 = (Vector)this._phyLocFreeList.clone();
                        int n16 = 0;
                        n16 = this._releaseVersion < 3 ? this.TEMPLATE_VERSION_OFFSET : this.DLPAR_TEMPLATE_VERSION_OFFSET_R4;
                        if (vector != null && vector.size() != 0) {
                            try {
                                int n17 = 0;
                                while (n17 < vector.size()) {
                                    int n18;
                                    block124: {
                                        block123: {
                                            block119: {
                                                int n19;
                                                block122: {
                                                    int n20;
                                                    Object object;
                                                    n18 = (Integer)vector.elementAt(n17);
                                                    Trace.trace("apnvhscF", "partitionID  = " + n18);
                                                    if (DEBUG_ON) {
                                                        System.out.println("In deletePartitions: partitionID = " + n18);
                                                    }
                                                    Enumeration enumeration = ((Vector)this._profilesAtPartitionTable[n18].clone()).elements();
                                                    while (true) {
                                                        int[] nArray;
                                                        int n21;
                                                        int n22;
                                                        Object[] objectArray;
                                                        if (!enumeration.hasMoreElements()) {
                                                            this._partitionNameTable[n18 - 1] = null;
                                                            if (this._releaseVersion != 0) {
                                                                this._partitionClusterTypeTable[n18 - 1] = 1;
                                                                if (this._partitionPhyLocCodeTable[n18 - 1] != null && this._partitionPhyLocCodeTable[n18 - 1].size() >= this.ALPAR_PHY_LOC_INDEX + 1) {
                                                                    break;
                                                                }
                                                            }
                                                            break block119;
                                                        }
                                                        object = (String)enumeration.nextElement();
                                                        Trace.trace("apnvhscF", "profileTimeStamp  = " + (String)object);
                                                        if (DEBUG_ON) {
                                                            System.out.println("In deletePartitions: profileTimeStamp = " + (String)object);
                                                        }
                                                        if ((objectArray = (Object[])this._profileTable.get(object)) == null) continue;
                                                        n20 = (Integer)objectArray[0];
                                                        short s3 = (Short)objectArray[1];
                                                        Trace.trace("apnvhscF", "profileOffset  = " + String.valueOf(n20));
                                                        if (DEBUG_ON) {
                                                            System.out.println("In deletePartitions: profileOffset = " + n20);
                                                            System.out.println("In deletePartitions: templateVersion = " + this._nvramData[n20 + n16]);
                                                        }
                                                        this._nvramData[n20 + n16] = -1;
                                                        vector2.add(new Integer(n20 + n16));
                                                        if (n5 == -1) {
                                                            n5 = n20;
                                                        } else if (n5 > n20) {
                                                            n5 = n20;
                                                        }
                                                        if (n6 == -1) {
                                                            n6 = n20 + s3;
                                                        } else if (n6 < n20 + s3) {
                                                            n6 = n20 + s3;
                                                        }
                                                        String string = (String)((CIMProperty)((Vector)objectArray[2]).elementAt(1)).getValue().getValue();
                                                        Trace.trace("apnvhscF", "name = " + string);
                                                        int n23 = 0;
                                                        short s4 = 0;
                                                        Trace.trace("apnvhscF", "len = " + String.valueOf(s3));
                                                        Vector vector6 = null;
                                                        Vector vector7 = null;
                                                        Vector vector8 = null;
                                                        CIMValue cIMValue = null;
                                                        CIMValue cIMValue2 = null;
                                                        CIMValue cIMValue3 = null;
                                                        if (this._releaseVersion < 2) {
                                                            cIMValue = ((CIMProperty)((Vector)objectArray[2]).elementAt(8)).getValue();
                                                            if (cIMValue != null) {
                                                                Trace.trace("apnvhscF", "drawersValue = " + cIMValue.getValue());
                                                            }
                                                            if ((cIMValue2 = ((CIMProperty)((Vector)objectArray[2]).elementAt(9)).getValue()) != null) {
                                                                Trace.trace("apnvhscF", "slotsValue = " + cIMValue2.getValue());
                                                            }
                                                            if ((cIMValue3 = ((CIMProperty)((Vector)objectArray[2]).elementAt(10)).getValue()) != null) {
                                                                Trace.trace("apnvhscF", "reqValue = " + cIMValue3.getValue());
                                                            }
                                                        } else {
                                                            cIMValue = ((CIMProperty)((Vector)objectArray[2]).elementAt(12)).getValue();
                                                            if (cIMValue != null) {
                                                                Trace.trace("apnvhscF", "drawersValue = " + cIMValue.getValue());
                                                            }
                                                            if ((cIMValue2 = ((CIMProperty)((Vector)objectArray[2]).elementAt(13)).getValue()) != null) {
                                                                Trace.trace("apnvhscF", "slotsValue = " + cIMValue2.getValue());
                                                            }
                                                            if ((cIMValue3 = ((CIMProperty)((Vector)objectArray[2]).elementAt(14)).getValue()) != null) {
                                                                Trace.trace("apnvhscF", "reqValue = " + cIMValue3.getValue());
                                                            }
                                                        }
                                                        if (cIMValue == null && cIMValue2 == null && cIMValue3 == null) {
                                                            vector6 = null;
                                                            vector7 = null;
                                                            vector8 = null;
                                                        } else {
                                                            if (cIMValue == null) throw new HSCCIMException("03EF");
                                                            if (cIMValue2 == null) throw new HSCCIMException("03EF");
                                                            if (cIMValue3 == null) {
                                                                throw new HSCCIMException("03EF");
                                                            }
                                                            vector6 = (Vector)cIMValue.getValue();
                                                            vector7 = (Vector)cIMValue2.getValue();
                                                            vector8 = (Vector)cIMValue3.getValue();
                                                        }
                                                        if (vector6 != null) {
                                                            if (vector6.size() != vector7.size()) throw new HSCCIMException("03EF");
                                                            if (vector6.size() != vector8.size()) {
                                                                throw new HSCCIMException("03EF");
                                                            }
                                                        }
                                                        if (vector6 != null && vector6.size() != 0) {
                                                            n22 = vector6.size();
                                                            Trace.trace("apnvhscF", "numSlots = " + String.valueOf(n22));
                                                            if (DEBUG_ON) {
                                                                System.out.println("In deletePartitions: numSlots = " + n22);
                                                            }
                                                            n21 = 0;
                                                            while (n21 < n22) {
                                                                block120: {
                                                                    String string2 = (String)vector6.get(n21);
                                                                    Trace.trace("apnvhscF", "drawerID = " + string2);
                                                                    if (DEBUG_ON) {
                                                                        System.out.println("In deletePartitions: drawerID = " + string2.trim());
                                                                    }
                                                                    if ((nArray = (int[])this._drawerIDTable.get(string2))[2] == 1) {
                                                                        bl2 = true;
                                                                        n23 = nArray[0];
                                                                        if (n3 == -1) {
                                                                            n3 = n23;
                                                                        } else if (n3 > n23) {
                                                                            n3 = n23;
                                                                        }
                                                                        if (n4 == -1) {
                                                                            n4 = n23 + 24 + 2;
                                                                        } else if (n4 < n23 + 24 + 2) {
                                                                            n4 = n23 + 24 + 2;
                                                                        }
                                                                        if (DEBUG_ON) {
                                                                            System.out.println("In deletePartitions: drawerOffset = " + n23);
                                                                        }
                                                                        int n24 = 0;
                                                                        while (true) {
                                                                            if (n24 >= 26) {
                                                                                this._numDrawers = (short)(this._numDrawers - 1);
                                                                                this._nvramData[this.NUM_DRAWERS_OFFSET] = (byte)(this._numDrawers >>> 8);
                                                                                this._nvramData[this.NUM_DRAWERS_OFFSET + 1] = (byte)this._numDrawers;
                                                                                s4 = (short)nArray[1];
                                                                                if (DEBUG_ON) {
                                                                                    System.out.println("In removeLPARProfile: drawerIndex = " + s4);
                                                                                }
                                                                                this._drawerIDTable.remove(string2);
                                                                                this._drawerIndexTable.remove(new Short(s4));
                                                                                if (s4 != this._dIDFreeListTail - 1) break;
                                                                                this._dIDFreeListTail = (short)(this._dIDFreeListTail - 1);
                                                                                break block120;
                                                                            }
                                                                            this._nvramData[n23 + n24] = 0;
                                                                            ++n24;
                                                                        }
                                                                        this._dIDFreeList.add(new Short(s4));
                                                                    } else {
                                                                        nArray[2] = nArray[2] - 1;
                                                                    }
                                                                }
                                                                ++n21;
                                                            }
                                                        }
                                                        this._profileTable.remove(object);
                                                        this._profilesAtPartitionTable[n18].remove(object);
                                                        nArray = (int[])this._profileNameTable.get(string);
                                                        n22 = (short)nArray[1];
                                                        n23 = nArray[0];
                                                        if (DEBUG_ON) {
                                                            System.out.println("In removeLPARProfile: nameoffset = " + n23);
                                                        }
                                                        if (n22 == 1) {
                                                            block121: {
                                                                bl = true;
                                                                n21 = 0;
                                                                while (true) {
                                                                    if (n21 >= 32) {
                                                                        this._pnameFreeList.add(new Integer(n23));
                                                                        this._profileNameTable.remove(string);
                                                                        this._profileNameOffsetTable.remove(new Integer(n23));
                                                                        if (n != -1) break;
                                                                        n = n23;
                                                                        break block121;
                                                                    }
                                                                    this._nvramData[n23 + n21] = 0;
                                                                    ++n21;
                                                                }
                                                                if (n > n23) {
                                                                    n = n23;
                                                                }
                                                            }
                                                            if (n2 == -1) {
                                                                n2 = n23 + 32;
                                                                continue;
                                                            }
                                                            if (n2 >= n23 + 32) continue;
                                                            n2 = n23 + 32;
                                                            continue;
                                                        }
                                                        nArray[1] = nArray[1] - 1;
                                                    }
                                                    object = (Integer)this._partitionPhyLocCodeTable[n18 - 1].elementAt(this.ALPAR_OFFSET_INDEX);
                                                    n19 = (Integer)object;
                                                    this._phyLocFreeList.add(object);
                                                    this._partitionPhyLocCodeTable[n18 - 1] = null;
                                                    n20 = 0;
                                                    while (true) {
                                                        if (n20 >= this.SIZE_OF_ALPAR_INFO) {
                                                            if (n13 != -1) break;
                                                            n13 = n19;
                                                            break block122;
                                                        }
                                                        this._nvramData[n19 + n20] = 0;
                                                        ++n20;
                                                    }
                                                    if (n13 > n19) {
                                                        n13 = n19;
                                                    }
                                                }
                                                if (n14 == -1) {
                                                    n14 = n19 + this.SIZE_OF_ALPAR_INFO;
                                                } else if (n14 < n19 + this.SIZE_OF_ALPAR_INFO) {
                                                    n14 = n19 + this.SIZE_OF_ALPAR_INFO;
                                                }
                                            }
                                            by = 0;
                                            while (true) {
                                                if (by >= this.SIZE_OF_LPAR_INFO) {
                                                    this._fastActivation[n18 - 1] = false;
                                                    if (n7 != -1) break;
                                                    n7 = this.PARTITION_NAME_TABLE_OFFSET + (n18 - 1) * this.SIZE_OF_LPAR_INFO;
                                                    break block123;
                                                }
                                                this._nvramData[by + (n18 - 1) * this.SIZE_OF_LPAR_INFO + this.PARTITION_NAME_TABLE_OFFSET] = 0;
                                                ++by;
                                            }
                                            if (n7 > this.PARTITION_NAME_TABLE_OFFSET + (n18 - 1) * this.SIZE_OF_LPAR_INFO) {
                                                n7 = this.PARTITION_NAME_TABLE_OFFSET + (n18 - 1) * this.SIZE_OF_LPAR_INFO;
                                            }
                                        }
                                        if (n8 == -1) {
                                            n8 = this.PARTITION_NAME_TABLE_OFFSET + n18 * this.SIZE_OF_LPAR_INFO;
                                        } else if (n8 < this.PARTITION_NAME_TABLE_OFFSET + n18 * this.SIZE_OF_LPAR_INFO) {
                                            n8 = this.PARTITION_NAME_TABLE_OFFSET + n18 * this.SIZE_OF_LPAR_INFO;
                                        }
                                        this._defaultList[n18] = null;
                                        this._activatedList[n18] = null;
                                        int n25 = 0;
                                        while (true) {
                                            if (n25 >= 7) {
                                                if (n9 != -1) break;
                                                n9 = this.DEFAULT_LIST_OFFSET + n18 * 7;
                                                break block124;
                                            }
                                            this._nvramData[this.DEFAULT_LIST_OFFSET + n18 * 7 + n25] = 0;
                                            this._nvramData[this.ACTIVATED_LIST_OFFSET + n18 * 7 + n25] = 0;
                                            ++n25;
                                        }
                                        if (n9 > this.DEFAULT_LIST_OFFSET + n18 * 7) {
                                            n9 = this.DEFAULT_LIST_OFFSET + n18 * 7;
                                        }
                                    }
                                    if (n10 == -1) {
                                        n10 = this.DEFAULT_LIST_OFFSET + (n18 + 1) * 7;
                                    } else if (n10 < this.DEFAULT_LIST_OFFSET + (n18 + 1) * 7) {
                                        n10 = this.DEFAULT_LIST_OFFSET + (n18 + 1) * 7;
                                    }
                                    if (n11 == -1) {
                                        n11 = this.ACTIVATED_LIST_OFFSET + n18 * 7;
                                    } else if (n11 > this.ACTIVATED_LIST_OFFSET + n18 * 7) {
                                        n11 = this.ACTIVATED_LIST_OFFSET + n18 * 7;
                                    }
                                    if (n12 == -1) {
                                        n12 = this.ACTIVATED_LIST_OFFSET + (n18 + 1) * 7;
                                    } else if (n12 < this.ACTIVATED_LIST_OFFSET + (n18 + 1) * 7) {
                                        n12 = this.ACTIVATED_LIST_OFFSET + (n18 + 1) * 7;
                                    }
                                    bl3 = true;
                                    int[] nArray = this.modifySysProfilesUsingLparID(n18, hscProviderSocket, false, false);
                                    if (nArray != null) {
                                        if (n == -1) {
                                            n = nArray[0];
                                        } else if (nArray[0] != -1 && n > nArray[0]) {
                                            n = nArray[0];
                                        }
                                        if (n2 == -1) {
                                            n2 = nArray[1];
                                        } else if (nArray[1] != -1 && n2 < nArray[1]) {
                                            n2 = nArray[1];
                                        }
                                        if (n5 == -1) {
                                            n5 = nArray[2];
                                        } else if (nArray[2] != -1 && n5 > nArray[2]) {
                                            n5 = nArray[2];
                                        }
                                        if (n6 == -1) {
                                            n6 = nArray[3];
                                        } else if (nArray[3] != -1 && n6 < nArray[3]) {
                                            n6 = nArray[3];
                                        }
                                    }
                                    ++n17;
                                }
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                this._nvramData = (byte[])byArray.clone();
                                this._numDrawers = s;
                                this._profilesAtPartitionTable = (Vector[])vectorArray.clone();
                                this._drawerIDTable = (Hashtable)hashtable.clone();
                                this._drawerIndexTable = (Hashtable)hashtable2.clone();
                                this._profileNameTable = (Hashtable)hashtable3.clone();
                                this._profileNameOffsetTable = (Hashtable)hashtable4.clone();
                                this._profileTable = (Hashtable)hashtable5.clone();
                                this._pnameFreeList = (Vector)vector3.clone();
                                this._dIDFreeList = (Vector)vector4.clone();
                                this._drawerOffsetTail = n15;
                                this._dIDFreeListTail = s2;
                                this._defaultList = (String[])stringArray.clone();
                                this._activatedList = (String[])stringArray2.clone();
                                this._partitionNameTable = (String[])stringArray3.clone();
                                this._fastActivation = (boolean[])blArray.clone();
                                this._partitionPhyLocCodeTable = (Vector[])vectorArray2.clone();
                                this._partitionClusterTypeTable = (short[])sArray.clone();
                                this._phyLocFreeList = (Vector)vector5.clone();
                                throw throwable;
                            }
                        }
                        if (bl3) {
                            byte[] byArray2;
                            block125: {
                                Hashtable hashtable6 = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", null, hscProviderSocket, this._cspVersion);
                                byArray2 = this.getTime(hashtable6);
                                int n26 = 0;
                                while (true) {
                                    if (n26 >= 7) {
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                                        this._partitionNameTableTimeStamp = (byte[])byArray2.clone();
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.PARTITION_NAME_TABLE_OFFSET, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET - this.PARTITION_NAME_TABLE_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                                        this._defaultListTimeStamp = (byte[])byArray2.clone();
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.DEFAULT_LIST_OFFSET, this.ACTIVATED_LIST_CHECKSUM_OFFSET - this.DEFAULT_LIST_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.DEFAULT_LIST_CHECKSUM_OFFSET, (short)8);
                                        this._activatedListTimeStamp = (byte[])byArray2.clone();
                                        this._checksumCalc.reset();
                                        if (this._releaseVersion != 0) break;
                                        this._checksumCalc.update(this._nvramData, this.ACTIVATED_LIST_OFFSET, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET - this.ACTIVATED_LIST_OFFSET);
                                        break block125;
                                    }
                                    this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + n26] = byArray2[n26];
                                    this._nvramData[this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET + n26] = byArray2[n26];
                                    if (bl) {
                                        this._nvramData[this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + n26] = byArray2[n26];
                                    }
                                    this._nvramData[this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + n26] = byArray2[n26];
                                    this._nvramData[this.DEFAULT_LIST_TIME_STAMP_OFFSET + n26] = byArray2[n26];
                                    this._nvramData[this.ACTIVATED_LIST_TIME_STAMP_OFFSET + n26] = byArray2[n26];
                                    if (this._releaseVersion != 0) {
                                        this._nvramData[this.PHY_LOC_CODE_TIME_STAMP_OFFSET + n26] = byArray2[n26];
                                    }
                                    ++n26;
                                }
                                this._checksumCalc.update(this._nvramData, this.ACTIVATED_LIST_OFFSET, this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET - this.ACTIVATED_LIST_OFFSET);
                            }
                            this._checksum = this._checksumCalc.getValue();
                            this.writeIntegralToNvramData(this._checksum, this.ACTIVATED_LIST_CHECKSUM_OFFSET, (short)8);
                            if (this._releaseVersion != 0) {
                                this._phyLocCodeTableTimeStamp = (byte[])byArray2.clone();
                                this._checksumCalc.reset();
                                this._checksumCalc.update(this._nvramData, this.PHY_LOC_CODE_TABLE_OFFSET, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET - this.PHY_LOC_CODE_TABLE_OFFSET);
                                this._checksum = this._checksumCalc.getValue();
                                this.writeIntegralToNvramData(this._checksum, this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET, (short)8);
                            }
                            if (bl) {
                                this._profileNameTableTimeStamp = (byte[])byArray2.clone();
                                this._checksumCalc.reset();
                                this._checksumCalc.update(this._nvramData, this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
                                this._checksum = this._checksumCalc.getValue();
                                this.writeIntegralToNvramData(this._checksum, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                            }
                            this._drawerProfileInfoTimeStamp = (byte[])byArray2.clone();
                            this._nvramTimeStamp = (byte[])byArray2.clone();
                            this._checksumCalc.reset();
                            this._checksumCalc.update(this._nvramData, this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET);
                            this._checksum = this._checksumCalc.getValue();
                            this.writeIntegralToNvramData(this._checksum, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, (short)8);
                            if (this._releaseVersion != 0) {
                                by = this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET;
                                if (this._releaseVersion < 3) {
                                    this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = (byte)(by >>> 8);
                                    this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = (byte)(by & 0xFF);
                                } else {
                                    this.writeIntToNvramData(by, this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET);
                                }
                            }
                            this._backupToLocalFile();
                            by = (byte)(this._releaseVersion << 1 | CORRUPTED_ON[0]);
                            this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                            this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, hscProviderSocket);
                            this._writeDataToCSP(new String(this._nvramData, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                            if (DEBUG_ON) {
                                System.out.println("partNameModeStart = " + n7);
                                System.out.println("partNameModEnd = " + n8);
                            }
                            this._writeDataToCSP(new String(this._nvramData, n7, n8 - n7).getBytes(), n7, n8 - n7, hscProviderSocket);
                            this._writeDataToCSP(new String(this._nvramData, this.DEFAULT_LIST_CHECKSUM_OFFSET, 8).getBytes(), this.DEFAULT_LIST_CHECKSUM_OFFSET, 8, hscProviderSocket);
                            this._writeDataToCSP(new String(this._nvramData, n9, n10 - n9).getBytes(), n9, n10 - n9, hscProviderSocket);
                            this._writeDataToCSP(new String(this._nvramData, this.ACTIVATED_LIST_CHECKSUM_OFFSET, 8).getBytes(), this.ACTIVATED_LIST_CHECKSUM_OFFSET, 8, hscProviderSocket);
                            this._writeDataToCSP(new String(this._nvramData, n11, n12 - n11).getBytes(), n11, n12 - n11, hscProviderSocket);
                            if (this._releaseVersion != 0) {
                                this._writeDataToCSP(new String(this._nvramData, this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                this._writeDataToCSP(new String(this._nvramData, n13, n14 - n13).getBytes(), n13, n14 - n13, hscProviderSocket);
                            }
                            if (bl) {
                                if (DEBUG_ON) {
                                    System.out.println("In removeLPARProfile: changeProfileNameTable");
                                }
                                this._writeDataToCSP(new String(this._nvramData, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                this._writeDataToCSP(new String(this._nvramData, n, n2 - n).getBytes(), n, n2 - n, hscProviderSocket);
                            }
                            if (this._releaseVersion == 0) {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8, hscProviderSocket);
                            } else if (this._releaseVersion < 3) {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10, hscProviderSocket);
                            } else {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12, hscProviderSocket);
                            }
                            if (bl2) {
                                if (DEBUG_ON) {
                                    System.out.println("In removeLPARProfile: changeDrawer");
                                }
                                this._writeDataToCSP(new String(this._nvramData, this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET).getBytes(), this.NUM_DRAWERS_OFFSET, this._drawerOffsetTail - this.NUM_DRAWERS_OFFSET, hscProviderSocket);
                            }
                            if (n6 >= 0 && n6 - n5 > 0) {
                                this._writeDataToCSP(new String(this._nvramData, n5, n6 - n5).getBytes(), n5, n6 - n5, hscProviderSocket);
                            }
                            by = (byte)(this._releaseVersion << 1 | CORRUPTED_OFF[0]);
                            this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                        }
                        if (DEBUG_ON) {
                            System.out.println("Successful");
                        }
                    }
                    finally {
                        if (!DEBUG_ON) break block126;
                        System.out.println("End of deletePartitions");
                        System.out.println("********************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var64_71 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("0039");
            }
        }
        catch (Throwable throwable) {
            Object var64_72 = null;
            Trace.trace("apnvhscT", "<- deletePartitions");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- deletePartitions");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void removeSysProfiles(Vector vector, HscProviderSocket hscProviderSocket) throws CIMException {
        try {
            try {
                block40: {
                    Trace.trace("apnvhscT", "-> removeSysProfiles");
                    Trace.trace("apnvhscF", "sysProfList = " + vector);
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("************************************************");
                        System.out.println("In removeSysProfiles");
                    }
                    try {
                        byte by;
                        Object object;
                        Object object2;
                        this.buildNVRAM(hscProviderSocket, false, null, true, false);
                        int n = -1;
                        int n2 = -1;
                        byte by2 = -1;
                        int n3 = -1;
                        Vector<Integer> vector2 = new Vector<Integer>();
                        boolean bl = false;
                        boolean bl2 = false;
                        int n4 = 0;
                        n4 = this._releaseVersion < 3 ? this.TEMPLATE_VERSION_OFFSET : this.DLPAR_TEMPLATE_VERSION_OFFSET_R4;
                        if (vector != null && vector.size() != 0) {
                            object2 = vector.elements();
                            while (object2.hasMoreElements()) {
                                Object[] objectArray;
                                object = (String)object2.nextElement();
                                Trace.trace("apnvhscF", "profileTimeStamp = " + (String)object);
                                if (DEBUG_ON) {
                                    System.out.println("In removeSysProfiles: profileTimeStamp = " + (String)object);
                                }
                                if ((objectArray = (Object[])this._profileTable.get(object)) == null) continue;
                                by = ((Integer)objectArray[0]).intValue();
                                short s = (Short)objectArray[1];
                                Trace.trace("apnvhscF", "len = " + String.valueOf(s));
                                Trace.trace("apnvhscF", "profileOffset  = " + String.valueOf(by));
                                if (by2 == -1) {
                                    by2 = by;
                                } else if (by2 > by) {
                                    by2 = by;
                                }
                                if (n3 == -1) {
                                    n3 = by + s;
                                } else if (n3 < by + s) {
                                    n3 = by + s;
                                }
                                vector2.add(new Integer(by + n4));
                                if (DEBUG_ON) {
                                    System.out.println("In removeSysProfiles: profileOffset = " + by);
                                    System.out.println("In removeSysProfiles: templateVersion = " + this._nvramData[by + n4]);
                                }
                                this._nvramData[by + n4] = -1;
                                String string = (String)((CIMProperty)((Vector)objectArray[2]).elementAt(1)).getValue().getValue();
                                Trace.trace("apnvhscF", "name = " + string);
                                int n5 = 0;
                                this._profileTable.remove(object);
                                this._profilesAtPartitionTable[0].remove(object);
                                bl2 = true;
                                int[] nArray = (int[])this._profileNameTable.get(string);
                                short s2 = (short)nArray[1];
                                n5 = nArray[0];
                                if (DEBUG_ON) {
                                    System.out.println("In removeSysProfile: nameoffset = " + n5);
                                }
                                if (s2 == 1) {
                                    block38: {
                                        bl = true;
                                        int n6 = 0;
                                        while (true) {
                                            if (n6 >= 32) {
                                                this._pnameFreeList.add(new Integer(n5));
                                                this._profileNameTable.remove(string);
                                                this._profileNameOffsetTable.remove(new Integer(n5));
                                                if (n != -1) break;
                                                n = n5;
                                                break block38;
                                            }
                                            this._nvramData[n5 + n6] = 0;
                                            ++n6;
                                        }
                                        if (n > n5) {
                                            n = n5;
                                        }
                                    }
                                    if (n2 == -1) {
                                        n2 = n5 + 32;
                                        continue;
                                    }
                                    if (n2 >= n5 + 32) continue;
                                    n2 = n5 + 32;
                                    continue;
                                }
                                nArray[1] = nArray[1] - 1;
                            }
                        }
                        if (bl2) {
                            block39: {
                                object2 = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", null, hscProviderSocket, this._cspVersion);
                                object = this.getTime((Hashtable)object2);
                                int n7 = 0;
                                while (true) {
                                    if (n7 >= 7) {
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                                        if (bl) {
                                            this._profileNameTableTimeStamp = (byte[])object.clone();
                                            this._checksumCalc.reset();
                                            this._checksumCalc.update(this._nvramData, this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
                                            this._checksum = this._checksumCalc.getValue();
                                            this.writeIntegralToNvramData(this._checksum, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                                        }
                                        this._nvramTimeStamp = (byte[])object.clone();
                                        this._drawerProfileInfoTimeStamp = (byte[])object.clone();
                                        this._checksumCalc.reset();
                                        this._checksumCalc.update(this._nvramData, this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET);
                                        this._checksum = this._checksumCalc.getValue();
                                        this.writeIntegralToNvramData(this._checksum, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, (short)8);
                                        if (this._releaseVersion != 0) {
                                            by = this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET;
                                            if (this._releaseVersion >= 3) break;
                                            this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = (byte)(by >>> 8);
                                            this._nvramData[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = (byte)(by & 0xFF);
                                        }
                                        break block39;
                                    }
                                    this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + n7] = object[n7];
                                    if (bl) {
                                        this._nvramData[this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + n7] = object[n7];
                                    }
                                    this._nvramData[this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + n7] = object[n7];
                                    ++n7;
                                }
                                this.writeIntToNvramData(by, this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET);
                            }
                            this._backupToLocalFile();
                            by = (byte)(this._releaseVersion << 1 | CORRUPTED_ON[0]);
                            this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                            this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, hscProviderSocket);
                            if (bl) {
                                this._writeDataToCSP(new String(this._nvramData, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                if (DEBUG_ON) {
                                    System.out.println("In removeLPARProfile: changeProfileNameTable");
                                }
                                this._writeDataToCSP(new String(this._nvramData, n, n2 - n).getBytes(), n, n2 - n, hscProviderSocket);
                            }
                            if (this._releaseVersion == 0) {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 8, hscProviderSocket);
                            } else if (this._releaseVersion < 3) {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 10, hscProviderSocket);
                            } else {
                                this._writeDataToCSP(new String(this._nvramData, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12).getBytes(), this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET, 12, hscProviderSocket);
                            }
                            if (DEBUG_ON) {
                                System.out.println("profDataModStart = " + by2);
                                System.out.println("profDataModEnd = " + n3);
                            }
                            this._writeDataToCSP(new String(this._nvramData, (int)by2, n3 - by2).getBytes(), by2, n3 - by2, hscProviderSocket);
                            by = (byte)(this._releaseVersion << 1 | CORRUPTED_OFF[0]);
                            this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                        }
                        if (DEBUG_ON) {
                            System.out.println("Successful");
                        }
                    }
                    finally {
                        if (!DEBUG_ON) break block40;
                        System.out.println("End of removeSysProfiles");
                        System.out.println("********************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var23_23 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("003a");
            }
        }
        catch (Throwable throwable) {
            Object var23_24 = null;
            Trace.trace("apnvhscT", "<- removeSysProfiles");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- removeSysProfiles");
    }

    public synchronized void setLPARInfos(Hashtable hashtable, HscProviderSocket hscProviderSocket) throws CIMException {
        try {
            block45: {
                try {
                    Trace.trace("apnvhscT", "-> setLPARInfos");
                    Trace.trace("apnvhscF", "lparInfos = " + hashtable);
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("****************************************");
                        System.out.println("In setLPARInfos");
                    }
                    Object var3_3 = null;
                    Object var4_5 = null;
                    boolean bl = false;
                    this.buildNVRAM(hscProviderSocket, false, null, true, false);
                    if (hashtable != null && hashtable.size() != 0) {
                        Serializable serializable;
                        int n = -1;
                        int n2 = -1;
                        int n3 = -1;
                        int n4 = -1;
                        Enumeration enumeration = hashtable.keys();
                        while (enumeration.hasMoreElements()) {
                            Object object;
                            Object object2;
                            serializable = (Integer)enumeration.nextElement();
                            int n5 = serializable;
                            Trace.trace("apnvhscF", "lparID = " + n5);
                            if (DEBUG_ON) {
                                System.out.println("In setLPARInfos: lparID = " + n5);
                            }
                            Vector vector = (Vector)hashtable.get(serializable);
                            Trace.trace("apnvhscF", "lparInfo = " + vector);
                            if (DEBUG_ON) {
                                System.out.println("In setLPARInfos: lparInfo = " + vector);
                            }
                            if (vector == null || vector.size() != 3) continue;
                            String string = (String)vector.elementAt(0);
                            String string2 = "";
                            short s = 1;
                            if (this._releaseVersion != 0) {
                                string2 = (String)vector.elementAt(1);
                                s = (Short)vector.elementAt(2);
                            }
                            this._partitionNameTable[n5 - 1] = string;
                            int n6 = -1;
                            if (this._releaseVersion != 0) {
                                if (string2 != null && string2.trim().length() != 0) {
                                    object2 = this._partitionPhyLocCodeTable[n5 - 1];
                                    Integer n7 = null;
                                    if (object2 == null || ((Vector)object2).size() == 0) {
                                        if (this._phyLocFreeList == null || this._phyLocFreeList.size() == 0) {
                                            throw new HSCCIMException("0040");
                                        }
                                        n7 = (Integer)this._phyLocFreeList.elementAt(0);
                                        this._phyLocFreeList.removeElementAt(0);
                                        n6 = n7;
                                    } else {
                                        n7 = (Integer)this._partitionPhyLocCodeTable[n5 - 1].elementAt(this.ALPAR_OFFSET_INDEX);
                                        n6 = n7;
                                    }
                                    object = new Vector();
                                    ((Vector)object).setSize(this.ALPAR_PHY_LOC_INDEX + 1);
                                    ((Vector)object).setElementAt(n7, this.ALPAR_OFFSET_INDEX);
                                    ((Vector)object).setElementAt(string2.trim(), this.ALPAR_PHY_LOC_INDEX);
                                    this._partitionPhyLocCodeTable[n5 - 1] = object;
                                } else {
                                    object2 = this._partitionPhyLocCodeTable[n5 - 1];
                                    if (object2 != null && ((Vector)object2).size() != 0) {
                                        Integer n8 = (Integer)this._partitionPhyLocCodeTable[n5 - 1].elementAt(this.ALPAR_OFFSET_INDEX);
                                        n6 = n8;
                                        this._partitionPhyLocCodeTable[n5 - 1] = new Vector();
                                        if (!this._phyLocFreeList.contains(n8)) {
                                            this._phyLocFreeList.add(n8);
                                        }
                                    }
                                }
                                this._partitionClusterTypeTable[n5 - 1] = s;
                            }
                            object2 = null;
                            if (string == null) {
                                object2 = new byte[32];
                            } else {
                                int n9 = string.length();
                                if (n9 != 31) {
                                    string = this.setLength(string, 31);
                                }
                                object2 = string.getBytes();
                            }
                            int n10 = 0;
                            while (n10 < 31) {
                                this._nvramData[n10 + (n5 - 1) * this.SIZE_OF_LPAR_INFO + this.PARTITION_NAME_TABLE_OFFSET] = (byte)object2[n10];
                                ++n10;
                            }
                            object = null;
                            if (this._releaseVersion != 0) {
                                int n11;
                                if (string2 == null || string2.trim().length() == 0) {
                                    object = new byte[32];
                                } else {
                                    n11 = string2.length();
                                    if (n11 != 32) {
                                        string2 = this.setLength(string2, 32);
                                    }
                                    object = string2.getBytes();
                                }
                                if (n6 != -1) {
                                    this._nvramData[n6] = string2 == null || string2.trim().length() == 0 ? (byte)0 : (byte)n5;
                                    n11 = 0;
                                    while (n11 < 32) {
                                        this._nvramData[n6 + 1 + n11] = (byte)object[n11];
                                        ++n11;
                                    }
                                }
                                this._nvramData[(n5 - 1) * this.SIZE_OF_LPAR_INFO + 32 + this.PARTITION_NAME_TABLE_OFFSET] = (byte)s;
                            }
                            bl = true;
                            if (n6 != -1) {
                                if (n3 == -1) {
                                    n3 = n6;
                                } else if (n3 > n6) {
                                    n3 = n6;
                                }
                                if (n4 == -1) {
                                    n4 = n6 + this.SIZE_OF_ALPAR_INFO;
                                } else if (n4 < n6 + this.SIZE_OF_ALPAR_INFO) {
                                    n4 = n6 + this.SIZE_OF_ALPAR_INFO;
                                }
                            }
                            if (n == -1) {
                                n = (n5 - 1) * this.SIZE_OF_LPAR_INFO + this.PARTITION_NAME_TABLE_OFFSET;
                            } else if (n > (n5 - 1) * this.SIZE_OF_LPAR_INFO + this.PARTITION_NAME_TABLE_OFFSET) {
                                n = (n5 - 1) * this.SIZE_OF_LPAR_INFO + this.PARTITION_NAME_TABLE_OFFSET;
                            }
                            if (n2 == -1) {
                                n2 = n5 * this.SIZE_OF_LPAR_INFO + this.PARTITION_NAME_TABLE_OFFSET;
                                continue;
                            }
                            if (n2 >= n5 * this.SIZE_OF_LPAR_INFO + this.PARTITION_NAME_TABLE_OFFSET) continue;
                            n2 = n5 * this.SIZE_OF_LPAR_INFO + this.PARTITION_NAME_TABLE_OFFSET;
                        }
                        if (bl) {
                            serializable = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", null, hscProviderSocket, this._cspVersion);
                            byte[] byArray = this.getTime((Hashtable)serializable);
                            this._nvramTimeStamp = (byte[])byArray.clone();
                            this._partitionNameTableTimeStamp = (byte[])byArray.clone();
                            this._phyLocCodeTableTimeStamp = (byte[])byArray.clone();
                            int n12 = 0;
                            while (n12 < 7) {
                                this._nvramData[this.NVRAM_TIME_STAMP_OFFSET + n12] = byArray[n12];
                                this._nvramData[this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET + n12] = byArray[n12];
                                if (this._releaseVersion != 0) {
                                    this._nvramData[this.PHY_LOC_CODE_TIME_STAMP_OFFSET + n12] = byArray[n12];
                                }
                                ++n12;
                            }
                            this._checksumCalc.reset();
                            this._checksumCalc.update(this._nvramData, this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                            this._checksum = this._checksumCalc.getValue();
                            this.writeIntegralToNvramData(this._checksum, this.TIME_STAMPS_CHECKSUM_OFFSET, (short)8);
                            this._checksumCalc.reset();
                            this._checksumCalc.update(this._nvramData, this.PARTITION_NAME_TABLE_OFFSET, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET - this.PARTITION_NAME_TABLE_OFFSET);
                            this._checksum = this._checksumCalc.getValue();
                            this.writeIntegralToNvramData(this._checksum, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, (short)8);
                            if (n3 != -1) {
                                this._checksumCalc.reset();
                                this._checksumCalc.update(this._nvramData, this.PHY_LOC_CODE_TABLE_OFFSET, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET - this.PHY_LOC_CODE_TABLE_OFFSET);
                                this._checksum = this._checksumCalc.getValue();
                                this.writeIntegralToNvramData(this._checksum, this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET, (short)8);
                            }
                            this._backupToLocalFile();
                            byte by = (byte)(this._releaseVersion << 1 | CORRUPTED_ON[0]);
                            this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                            this._writeDataToCSP(new String(this._nvramData, this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET).getBytes(), this.TIME_STAMPS_CHECKSUM_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.TIME_STAMPS_CHECKSUM_OFFSET, hscProviderSocket);
                            this._writeDataToCSP(new String(this._nvramData, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                            this._writeDataToCSP(new String(this._nvramData, n, n2 - n).getBytes(), n, n2 - n, hscProviderSocket);
                            if (n3 != -1) {
                                this._writeDataToCSP(new String(this._nvramData, this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET, 8).getBytes(), this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET, 8, hscProviderSocket);
                                this._writeDataToCSP(new String(this._nvramData, n3, n4 - n3).getBytes(), n3, n4 - n3, hscProviderSocket);
                            }
                            by = (byte)(this._releaseVersion << 1 | CORRUPTED_OFF[0]);
                            this._writeDataToCSP(new byte[]{by}, this.CORRUPTED_BYTE_OFFSET, 1, hscProviderSocket);
                        }
                    }
                    if (!DEBUG_ON) break block45;
                    System.out.println("End of setLPARInfos");
                    System.out.println("****************************************");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                    if (!(throwable instanceof HSCCIMException)) {
                        throw new HSCCIMException("003b");
                    }
                    throw new HSCCIMException(throwable);
                }
            }
            Object var23_29 = null;
        }
        catch (Throwable throwable) {
            Object var23_30 = null;
            Trace.trace("apnvhscT", "<- setLPARInfos");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- setLPARInfos");
    }

    public synchronized Hashtable getAllPPARInfo(HscProviderSocket hscProviderSocket) throws CIMException {
        Cloneable cloneable;
        Hashtable<Integer, Cloneable> hashtable;
        block11: {
            Trace.trace("apnvhscT", "-> getAllPPARInfo");
            Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println("In getAllPPARInfo");
            }
            Object var2_2 = null;
            Object var3_4 = null;
            hashtable = new Hashtable<Integer, Cloneable>();
            this.buildNVRAM(hscProviderSocket, false, null, true, true);
            if (this._partitionPhyLocCodeTable != null && this._partitionPhyLocCodeTable.length != 0) {
                cloneable = null;
                int n = 0;
                while (n < this._partitionPhyLocCodeTable.length) {
                    String string;
                    String string2;
                    Vector vector = this._partitionPhyLocCodeTable[n];
                    if (vector != null && vector.size() > 1 && (string2 = (String)vector.elementAt(this.ALPAR_PHY_LOC_INDEX)) != null && string2.trim().length() != 0 && (string = this._partitionNameTable[n]) != null && string.trim().length() != 0) {
                        cloneable = new Vector();
                        ((Vector)cloneable).setSize(3);
                        ((Vector)cloneable).setElementAt(this._partitionNameTable[n].trim(), 0);
                        ((Vector)cloneable).setElementAt(string2.trim(), 1);
                        ((Vector)cloneable).setElementAt(new Short(this._partitionClusterTypeTable[n]), 2);
                        hashtable.put(new Integer(n + 1), cloneable);
                    }
                    ++n;
                }
                break block11;
            }
            Hashtable hashtable2 = null;
            Object var11_12 = null;
            Trace.trace("apnvhscT", "<- getAllPPARInfo");
            return hashtable2;
        }
        try {
            if (DEBUG_ON) {
                System.out.println("End of getAllPPARInfo");
                System.out.println("****************************************");
            }
            cloneable = hashtable;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (!(throwable instanceof HSCCIMException)) {
                    throw new HSCCIMException("003c");
                }
                throw new HSCCIMException(throwable);
            }
            catch (Throwable throwable2) {
                Object var11_14 = null;
                Trace.trace("apnvhscT", "<- getAllPPARInfo");
                throw throwable2;
            }
        }
        Trace.trace("apnvhscT", "<- getAllPPARInfo");
        return cloneable;
    }

    public synchronized Vector getLPARInfo(HscProviderSocket hscProviderSocket, int n) throws CIMException {
        Vector vector;
        block13: {
            Trace.trace("apnvhscT", "-> getLPARInfo");
            Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
            Trace.trace("apnvhscF", "lparID = " + n);
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println("In getLPARInfo");
            }
            Object var3_3 = null;
            Object var4_5 = null;
            Vector<Object> vector2 = null;
            this.buildNVRAM(hscProviderSocket, false, null, true, true, true);
            if (this._partitionNameTable[n - 1] == null || this._partitionNameTable[n - 1].trim().length() == 0) break block13;
            vector2 = new Vector<Object>();
            if (this._releaseVersion == 0) {
                vector2.setSize(1);
            } else {
                vector2.setSize(3);
            }
            vector2.setElementAt(this._partitionNameTable[n - 1].trim(), 0);
            if (this._releaseVersion != 0) {
                if (this._partitionPhyLocCodeTable[n - 1] != null && this._partitionPhyLocCodeTable[n - 1].size() >= this.ALPAR_PHY_LOC_INDEX + 1) {
                    vector2.setElementAt((String)this._partitionPhyLocCodeTable[n - 1].elementAt(this.ALPAR_PHY_LOC_INDEX), 1);
                } else {
                    vector2.setElementAt(null, 1);
                }
                vector2.setElementAt(new Short(this._partitionClusterTypeTable[n - 1]), 2);
            }
            if (DEBUG_ON) {
                System.out.println("content = " + vector2);
            }
            Vector<Object> vector3 = vector2;
            Object var8_9 = null;
            Trace.trace("apnvhscT", "<- getLPARInfo");
            return vector3;
        }
        try {
            vector = null;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (!(throwable instanceof HSCCIMException)) {
                    throw new HSCCIMException("003d");
                }
                throw new HSCCIMException(throwable);
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                Trace.trace("apnvhscT", "<- getLPARInfo");
                throw throwable2;
            }
        }
        Trace.trace("apnvhscT", "<- getLPARInfo");
        return vector;
    }

    public synchronized void migration(HscProviderSocket hscProviderSocket, boolean bl, boolean bl2) throws CIMException {
        try {
            Trace.trace("apnvhscT", "-> migration");
            Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
            if (DEBUG_ON) {
                System.out.println("****************************************");
                System.out.println("In migration");
            }
            String[] stringArray = null;
            Hashtable hashtable = null;
            Object var6_7 = null;
            String string = "";
            if (hscProviderSocket != null) {
                hashtable = HscProviderUtils.doCSPCommand("GET_CSP_INTERFACE_VERSION_NUMBER", null, hscProviderSocket);
                string = (String)hashtable.get("VERSION");
            } else if (this._cspVersion == null || this._cspVersion.trim().length() == 0) {
                hashtable = HscProviderUtils.doCSPCommand("GET_CSP_INTERFACE_VERSION_NUMBER", null, hscProviderSocket);
                this._cspVersion = string = (String)hashtable.get("VERSION");
                if (DEBUG_ON) {
                    System.out.println("cspVersion = " + this._cspVersion);
                }
            } else {
                string = this._cspVersion;
                if (DEBUG_ON) {
                    System.out.println("cspVersion = " + string);
                }
            }
            int n = CSP_VERSIONS.indexOf(string);
            byte by = 0;
            if (n == -1) {
                throw new HSCCIMException("0033", new String[]{string});
            }
            by = (Byte)NVRAM_VERSIONS.elementAt(n);
            if (by == this._releaseVersion && by < 3) {
                return;
            }
            if (by == 1) {
                if (this._releaseVersion == 0) {
                    byte[] byArray = new byte[this.NVRAM_SIZE];
                    int n2 = 33;
                    this._migratePartitionInfo(byArray, by, this.PARTITION_NAME_TABLE_OFFSET + 7 + 1);
                    int n3 = this.NUM_PARTITION_SLOTS * n2 - this.NUM_PARTITION_SLOTS * this.SIZE_OF_LPAR_INFO + 7 + 1;
                    this._migrateProfileNameInfo(byArray, by, this.PROFILE_NAME_TABLE_OFFSET + n3);
                    this._migrateDefaultList(byArray, by, this.DEFAULT_LIST_OFFSET + n3);
                    this._migrateActivatedList(byArray, by, this.ACTIVATED_LIST_OFFSET + n3);
                    this._migratePhyLocCodeTable(byArray, by, this.ACTIVATED_LIST_OFFSET + (this.NUM_PARTITION_SLOTS + 1) * 7 + 8 + n3);
                    int n4 = n3 + 8 * this.SIZE_OF_ALPAR_INFO + 8;
                    this._numPhyLocCodeSlots = (short)8;
                    this._migrateDrawerProfileInfo(byArray, by, this.NUM_DRAWERS_OFFSET + n4 + 2, n3);
                    byte[] byArray2 = new byte[7];
                    if (hscProviderSocket != null) {
                        hashtable = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", stringArray, hscProviderSocket, this._cspVersion);
                        byArray2 = this.getTime(hashtable);
                    } else {
                        byArray2 = this._timestamp;
                    }
                    this.SIZE_OF_LPAR_INFO = (short)33;
                    this.NUM_ALPAR_SLOTS_OFFSET = this.CORRUPTED_BYTE_OFFSET + 1;
                    this.TIME_STAMPS_CHECKSUM_OFFSET = this.NUM_ALPAR_SLOTS_OFFSET + 1;
                    this.NVRAM_TIME_STAMP_OFFSET = this.TIME_STAMPS_CHECKSUM_OFFSET + 8;
                    this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET = this.NVRAM_TIME_STAMP_OFFSET + 7;
                    this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET = this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET + 7;
                    this.DEFAULT_LIST_TIME_STAMP_OFFSET = this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + 7;
                    this.ACTIVATED_LIST_TIME_STAMP_OFFSET = this.DEFAULT_LIST_TIME_STAMP_OFFSET + 7;
                    this.PHY_LOC_CODE_TIME_STAMP_OFFSET = this.ACTIVATED_LIST_TIME_STAMP_OFFSET + 7;
                    this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET = this.PHY_LOC_CODE_TIME_STAMP_OFFSET + 7;
                    this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET = this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + 7;
                    this.PARTITION_NAME_TABLE_OFFSET = this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET + 8;
                    this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET = this.PARTITION_NAME_TABLE_OFFSET + this.NUM_PARTITION_SLOTS * this.SIZE_OF_LPAR_INFO;
                    this.PROFILE_NAME_TABLE_OFFSET = this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET + 8;
                    this.DEFAULT_LIST_CHECKSUM_OFFSET = this.PROFILE_NAME_TABLE_OFFSET + this.MAX_PROFILE * 32;
                    this.DEFAULT_LIST_OFFSET = this.DEFAULT_LIST_CHECKSUM_OFFSET + 8;
                    this.ACTIVATED_LIST_CHECKSUM_OFFSET = this.DEFAULT_LIST_OFFSET + 7 * (this.NUM_PARTITION_SLOTS + 1);
                    this.ACTIVATED_LIST_OFFSET = this.ACTIVATED_LIST_CHECKSUM_OFFSET + 8;
                    this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET = this.ACTIVATED_LIST_OFFSET + 7 * (this.NUM_PARTITION_SLOTS + 1);
                    this.PHY_LOC_CODE_TABLE_OFFSET = this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET + 8;
                    this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET = this.PHY_LOC_CODE_TABLE_OFFSET + this.SIZE_OF_ALPAR_INFO * this._numPhyLocCodeSlots;
                    this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET = this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET + 8;
                    this.NUM_DRAWERS_OFFSET = this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 2;
                    this.DRAWERS_OFFSET = this.NUM_DRAWERS_OFFSET + 2;
                    this._migrateTimestamps(byArray, by, byArray2);
                    this._migrateChecksums(byArray, by, n3);
                    String string2 = "/var/hsc/profiles/";
                    string2 = string2.concat(this._cecName) + "/tmp/";
                    File file = new File(string2);
                    file.mkdirs();
                    System.out.println("create dir");
                    string2 = string2.concat("tmpProfileData");
                    RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "rw");
                    randomAccessFile.write(byArray);
                    randomAccessFile.seek(this.NUM_ALPAR_SLOTS_OFFSET);
                    randomAccessFile.writeByte(this._numPhyLocCodeSlots);
                    randomAccessFile.close();
                    this.buildNVRAMFromLocalCopy(hscProviderSocket, new File(string2), bl, bl2);
                    File[] fileArray = file.listFiles();
                    int n5 = 0;
                    while (n5 < fileArray.length) {
                        fileArray[n5].delete();
                        ++n5;
                    }
                    file.delete();
                    System.out.println("delete file");
                }
            } else if (by >= 2) {
                if (this._releaseVersion == 0) {
                    byte[] byArray = new byte[this.NVRAM_SIZE];
                    int n6 = 33;
                    this._migratePartitionInfo(byArray, by, this.PARTITION_NAME_TABLE_OFFSET + 7 + 1);
                    int n7 = this._releaseNumPartitionSlots * n6 - this._releaseNumPartitionSlots * this.SIZE_OF_LPAR_INFO + 7 + 1;
                    this._migrateProfileNameInfo(byArray, by, this.PROFILE_NAME_TABLE_OFFSET + n7);
                    this._migrateDefaultList(byArray, by, this.DEFAULT_LIST_OFFSET + n7);
                    this._migrateActivatedList(byArray, by, this.ACTIVATED_LIST_OFFSET + n7);
                    this._migratePhyLocCodeTable(byArray, by, this.ACTIVATED_LIST_OFFSET + (this._releaseNumPartitionSlots + 1) * 7 + 8 + n7);
                    int n8 = n7 + 8 * this.SIZE_OF_ALPAR_INFO + 8;
                    this._numPhyLocCodeSlots = (short)8;
                    this._migrateDrawerProfileInfo(byArray, by, this.NUM_DRAWERS_OFFSET + n8 + 2, n7);
                    byte[] byArray3 = new byte[7];
                    if (hscProviderSocket != null) {
                        hashtable = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", stringArray, hscProviderSocket, this._cspVersion);
                        byArray3 = this.getTime(hashtable);
                    } else {
                        byArray3 = this._timestamp;
                    }
                    this.SIZE_OF_LPAR_INFO = (short)33;
                    this.NUM_ALPAR_SLOTS_OFFSET = this.CORRUPTED_BYTE_OFFSET + 1;
                    if (by >= 3) {
                        this.NUM_PARTITION_SLOTS_OFFSET = this.NUM_ALPAR_SLOTS_OFFSET + 1;
                        this.VALIDATION_CHECKSUM_OFFSET = this.NUM_PARTITION_SLOTS_OFFSET + 1;
                        this.TIME_STAMPS_CHECKSUM_OFFSET = this.VALIDATION_CHECKSUM_OFFSET + 8;
                        if (DEBUG_ON) {
                            System.out.println("in migration: NUM_PARTITION_SLOTS_OFFSET = " + this.NUM_PARTITION_SLOTS_OFFSET);
                            System.out.println("in migration: VALIDATION_CHECKSUM_OFFSET = " + this.VALIDATION_CHECKSUM_OFFSET);
                        }
                    } else {
                        this.TIME_STAMPS_CHECKSUM_OFFSET = this.NUM_ALPAR_SLOTS_OFFSET + 1;
                    }
                    if (DEBUG_ON) {
                        System.out.println("in migration: TIME_STAMPS_CHECKSUM_OFFSET = " + this.TIME_STAMPS_CHECKSUM_OFFSET);
                    }
                    this.NVRAM_TIME_STAMP_OFFSET = this.TIME_STAMPS_CHECKSUM_OFFSET + 8;
                    this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET = this.NVRAM_TIME_STAMP_OFFSET + 7;
                    this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET = this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET + 7;
                    this.DEFAULT_LIST_TIME_STAMP_OFFSET = this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + 7;
                    this.ACTIVATED_LIST_TIME_STAMP_OFFSET = this.DEFAULT_LIST_TIME_STAMP_OFFSET + 7;
                    this.PHY_LOC_CODE_TIME_STAMP_OFFSET = this.ACTIVATED_LIST_TIME_STAMP_OFFSET + 7;
                    this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET = this.PHY_LOC_CODE_TIME_STAMP_OFFSET + 7;
                    this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET = this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + 7;
                    this.PARTITION_NAME_TABLE_OFFSET = this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET + 8;
                    this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET = this.PARTITION_NAME_TABLE_OFFSET + this.NUM_PARTITION_SLOTS * this.SIZE_OF_LPAR_INFO;
                    this.PROFILE_NAME_TABLE_OFFSET = this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET + 8;
                    this.DEFAULT_LIST_CHECKSUM_OFFSET = this.PROFILE_NAME_TABLE_OFFSET + this.MAX_PROFILE * 32;
                    this.DEFAULT_LIST_OFFSET = this.DEFAULT_LIST_CHECKSUM_OFFSET + 8;
                    this.ACTIVATED_LIST_CHECKSUM_OFFSET = this.DEFAULT_LIST_OFFSET + 7 * (this._releaseNumPartitionSlots + 1);
                    this.ACTIVATED_LIST_OFFSET = this.ACTIVATED_LIST_CHECKSUM_OFFSET + 8;
                    this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET = this.ACTIVATED_LIST_OFFSET + 7 * (this._releaseNumPartitionSlots + 1);
                    this.PHY_LOC_CODE_TABLE_OFFSET = this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET + 8;
                    this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET = this.PHY_LOC_CODE_TABLE_OFFSET + this.SIZE_OF_ALPAR_INFO * this._numPhyLocCodeSlots;
                    this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET = this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET + 8;
                    this.NUM_DRAWERS_OFFSET = by < 3 ? this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 2 : this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 4;
                    this.DRAWERS_OFFSET = this.NUM_DRAWERS_OFFSET + 2;
                    this._migrateTimestamps(byArray, by, byArray3);
                    this._migrateChecksums(byArray, by, n7);
                    String string3 = "/var/hsc/profiles/";
                    string3 = string3.concat(this._cecName) + "/tmp/";
                    File file = new File(string3);
                    file.mkdirs();
                    string3 = string3.concat("tmpProfileData");
                    System.out.println("create dir");
                    RandomAccessFile randomAccessFile = new RandomAccessFile(string3, "rw");
                    randomAccessFile.write(byArray);
                    randomAccessFile.seek(this.NUM_ALPAR_SLOTS_OFFSET);
                    randomAccessFile.writeByte(this._numPhyLocCodeSlots);
                    randomAccessFile.close();
                    this.buildNVRAMFromLocalCopy(hscProviderSocket, new File(string3), bl, bl2);
                    File[] fileArray = file.listFiles();
                    int n9 = 0;
                    while (n9 < fileArray.length) {
                        fileArray[n9].delete();
                        ++n9;
                    }
                    file.delete();
                    System.out.println("delete file");
                } else if (this._releaseVersion >= 1) {
                    byte[] byArray = new byte[this.NVRAM_SIZE];
                    this._migratePartitionInfo(byArray, by, this.PARTITION_NAME_TABLE_OFFSET);
                    this._migrateProfileNameInfo(byArray, by, this.PROFILE_NAME_TABLE_OFFSET);
                    this._migrateDefaultList(byArray, by, this.DEFAULT_LIST_OFFSET);
                    this._migrateActivatedList(byArray, by, this.ACTIVATED_LIST_OFFSET);
                    this._migratePhyLocCodeTable(byArray, by, this.PHY_LOC_CODE_TABLE_OFFSET);
                    this._migrateDrawerProfileInfo(byArray, by, this.NUM_DRAWERS_OFFSET, 0);
                    byte[] byArray4 = new byte[7];
                    if (hscProviderSocket != null) {
                        hashtable = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", stringArray, hscProviderSocket, this._cspVersion);
                        byArray4 = this.getTime(hashtable);
                    } else {
                        byArray4 = this._timestamp;
                    }
                    if (by >= 3) {
                        this.NUM_PARTITION_SLOTS_OFFSET = this.NUM_ALPAR_SLOTS_OFFSET + 1;
                        this.VALIDATION_CHECKSUM_OFFSET = this.NUM_PARTITION_SLOTS_OFFSET + 1;
                        this.TIME_STAMPS_CHECKSUM_OFFSET = this.VALIDATION_CHECKSUM_OFFSET + 8;
                        if (DEBUG_ON) {
                            System.out.println("in migration: NUM_PARTITION_SLOTS_OFFSET = " + this.NUM_PARTITION_SLOTS_OFFSET);
                            System.out.println("in migration: VALIDATION_CHECKSUM_OFFSET = " + this.VALIDATION_CHECKSUM_OFFSET);
                        }
                        if (DEBUG_ON) {
                            System.out.println("in migration: TIME_STAMPS_CHECKSUM_OFFSET = " + this.TIME_STAMPS_CHECKSUM_OFFSET);
                        }
                        this.NVRAM_TIME_STAMP_OFFSET = this.TIME_STAMPS_CHECKSUM_OFFSET + 8;
                        this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET = this.NVRAM_TIME_STAMP_OFFSET + 7;
                        this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET = this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET + 7;
                        this.DEFAULT_LIST_TIME_STAMP_OFFSET = this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + 7;
                        this.ACTIVATED_LIST_TIME_STAMP_OFFSET = this.DEFAULT_LIST_TIME_STAMP_OFFSET + 7;
                        this.PHY_LOC_CODE_TIME_STAMP_OFFSET = this.ACTIVATED_LIST_TIME_STAMP_OFFSET + 7;
                        this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET = this.PHY_LOC_CODE_TIME_STAMP_OFFSET + 7;
                        this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET = this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + 7;
                        this.PARTITION_NAME_TABLE_OFFSET = this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET + 8;
                        this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET = this.PARTITION_NAME_TABLE_OFFSET + this.NUM_PARTITION_SLOTS * this.SIZE_OF_LPAR_INFO;
                        this.PROFILE_NAME_TABLE_OFFSET = this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET + 8;
                        this.DEFAULT_LIST_CHECKSUM_OFFSET = this.PROFILE_NAME_TABLE_OFFSET + this.MAX_PROFILE * 32;
                        this.DEFAULT_LIST_OFFSET = this.DEFAULT_LIST_CHECKSUM_OFFSET + 8;
                        this.ACTIVATED_LIST_CHECKSUM_OFFSET = this.DEFAULT_LIST_OFFSET + 7 * (this.NUM_PARTITION_SLOTS + 1);
                        this.ACTIVATED_LIST_OFFSET = this.ACTIVATED_LIST_CHECKSUM_OFFSET + 8;
                        this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET = this.ACTIVATED_LIST_OFFSET + 7 * (this.NUM_PARTITION_SLOTS + 1);
                        this.PHY_LOC_CODE_TABLE_OFFSET = this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET + 8;
                        this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET = this.PHY_LOC_CODE_TABLE_OFFSET + this.SIZE_OF_ALPAR_INFO * this._numPhyLocCodeSlots;
                        this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET = this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET + 8;
                        if (DEBUG_ON) {
                            System.out.println("PROFILE_NAME_TABLE_OFFSET = " + this.PROFILE_NAME_TABLE_OFFSET);
                            System.out.println("DEFAULT_LIST_CHECKSUM_OFFSET = " + this.DEFAULT_LIST_CHECKSUM_OFFSET);
                            System.out.println("DEFAULT_LIST_OFFSET = " + this.DEFAULT_LIST_OFFSET);
                            System.out.println("ACTIVATED_LIST_CHECKSUM_OFFSET = " + this.ACTIVATED_LIST_CHECKSUM_OFFSET);
                            System.out.println("ACTIVATED_LIST_OFFSET = " + this.ACTIVATED_LIST_OFFSET);
                            System.out.println("PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET = " + this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET);
                            System.out.println("PHY_LOC_CODE_TABLE_OFFSET = " + this.PHY_LOC_CODE_TABLE_OFFSET);
                            System.out.println("DRAWER_PROFILE_INFO_CHECKSUM_OFFSET = " + this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET);
                            System.out.println("DRAWER_PROF_INFO_DATA_SIZE_OFFSET = " + this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET);
                        }
                        this.NUM_DRAWERS_OFFSET = by < 3 ? this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 2 : this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 4;
                        System.out.println("NUM_DRAWERS_OFFSET = " + this.NUM_DRAWERS_OFFSET);
                        this.DRAWERS_OFFSET = this.NUM_DRAWERS_OFFSET + 2;
                    }
                    this._migrateTimestamps(byArray, by, byArray4);
                    this._migrateChecksums(byArray, by, 0);
                    String string4 = "/var/hsc/profiles/";
                    string4 = string4.concat(this._cecName) + "/tmp/";
                    File file = new File(string4);
                    file.mkdirs();
                    System.out.println("create dir");
                    string4 = string4.concat("tmpProfileData");
                    RandomAccessFile randomAccessFile = new RandomAccessFile(string4, "rw");
                    randomAccessFile.write(byArray);
                    randomAccessFile.seek(this.NUM_ALPAR_SLOTS_OFFSET);
                    randomAccessFile.writeByte(this._numPhyLocCodeSlots);
                    randomAccessFile.close();
                    this.buildNVRAMFromLocalCopy(hscProviderSocket, new File(string4), bl, bl2);
                    File[] fileArray = file.listFiles();
                    int n10 = 0;
                    while (n10 < fileArray.length) {
                        fileArray[n10].delete();
                        ++n10;
                    }
                    file.delete();
                    System.out.println("delete file");
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("0036");
            }
            throw new HSCCIMException(throwable);
        }
    }

    private void _migratePartitionInfo(byte[] byArray, byte by, int n) throws CIMException {
        try {
            int n2 = n;
            if (this._releaseVersion < 3 && by >= 3) {
                n2 += 9;
            }
            System.out.println("in _migratePartitionInfo(): startingOffset = " + n);
            System.out.println("in _migratePartitionInfo(): migratedStartingOffset = " + n2);
            if (this._releaseVersion == 0) {
                if (by >= 1) {
                    int n3 = 33;
                    int n4 = 0;
                    while (n4 < this._releaseNumPartitionSlots) {
                        int n5 = 0;
                        while (n5 < 32) {
                            byArray[n2 + n3 * n4 + n5] = this._nvramData[this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * n4 + n5];
                            ++n5;
                        }
                        if (DEBUG_ON) {
                            System.out.println("startingOffset = " + n);
                            System.out.println("PARTITION_NAME_TABLE_OFFSET + SIZE_OF_LPAR_INFO*i = " + (this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * n4));
                            System.out.println("partition name[" + n4 + "] = " + new String(this._nvramData, this.PARTITION_NAME_TABLE_OFFSET + this.SIZE_OF_LPAR_INFO * n4, 32));
                        }
                        ++n4;
                    }
                }
            } else {
                int n6 = 0;
                while (n6 < this._releaseNumPartitionSlots * this.SIZE_OF_LPAR_INFO) {
                    byArray[n2 + n6] = this._nvramData[n + n6];
                    ++n6;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("0041");
            }
            throw new HSCCIMException(throwable);
        }
    }

    private void _migrateProfileNameInfo(byte[] byArray, byte by, int n) throws CIMException {
        try {
            int n2;
            int n3 = n;
            if (this._releaseVersion < 3 && by >= 3) {
                n3 += 9;
            }
            if (this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                n2 = this.NUM_PARTITION_SLOTS - this._releaseNumPartitionSlots;
                n3 += n2 * 33;
                if (DEBUG_ON) {
                    System.out.println("in _migrateProfileNameInfo: adding slots = " + n2);
                    System.out.println("in _migrateProfileNameInfo: migratedStartingOffset = " + n3);
                }
            }
            if (this._releaseVersion == 0) {
                if (by >= 1) {
                    if (DEBUG_ON) {
                        System.out.println("startingOffset = " + n);
                        System.out.println("migratedStartingOffset = " + n3);
                        System.out.println("PROFILE_NAME_TABLE_OFFSET = " + this.PROFILE_NAME_TABLE_OFFSET);
                    }
                    n2 = 0;
                    while (n2 < this.MAX_PROFILE * 32) {
                        byArray[n3 + n2] = this._nvramData[this.PROFILE_NAME_TABLE_OFFSET + n2];
                        ++n2;
                    }
                    if (DEBUG_ON) {
                        int n4 = 0;
                        while (n4 < this.MAX_PROFILE) {
                            System.out.println("migration name = " + new String(this._nvramData, this.PROFILE_NAME_TABLE_OFFSET + n4 * 32, 32));
                            ++n4;
                        }
                    }
                }
            } else {
                n2 = 0;
                while (n2 < this.MAX_PROFILE * 32) {
                    byArray[n3 + n2] = this._nvramData[n + n2];
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("0042");
            }
            throw new HSCCIMException(throwable);
        }
    }

    private void _migrateDefaultList(byte[] byArray, byte by, int n) throws CIMException {
        try {
            int n2;
            int n3 = n;
            int n4 = 0;
            if (this._releaseVersion < 3 && by >= 3) {
                n3 += 9;
            }
            if (this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                n4 = this.NUM_PARTITION_SLOTS - this._releaseNumPartitionSlots;
                n3 += n4 * 33;
                if (DEBUG_ON) {
                    System.out.println("in _migrateDefaultList: adding slots = " + n4);
                    System.out.println("in _migrateDefaultList: migratedStartingOffset = " + n3);
                }
            }
            if (this._releaseVersion == 0) {
                if (by >= 1) {
                    n2 = 0;
                    while (n2 < 7 * (this._releaseNumPartitionSlots + 1)) {
                        byArray[n3 + n2] = this._nvramData[this.DEFAULT_LIST_OFFSET + n2];
                        ++n2;
                    }
                }
            } else {
                n2 = 0;
                while (n2 < 7 * (this._releaseNumPartitionSlots + 1)) {
                    byArray[n3 + n2] = this._nvramData[n + n2];
                    ++n2;
                }
            }
            if (n4 > 0) {
                n2 = n3 + 7 * (this._releaseNumPartitionSlots + 1);
                if (DEBUG_ON) {
                    System.out.println("default list extra timestamps writing at offset " + n2);
                }
                int n5 = 0;
                while (n5 < 7 * n4) {
                    byArray[n2 + n5] = 0;
                    ++n5;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("0043");
            }
            throw new HSCCIMException(throwable);
        }
    }

    private void _migrateActivatedList(byte[] byArray, byte by, int n) throws CIMException {
        try {
            int n2;
            int n3 = n;
            if (this._releaseVersion < 3 && by >= 3) {
                n3 += 9;
            }
            if (this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                n2 = this.NUM_PARTITION_SLOTS - this._releaseNumPartitionSlots;
                n3 += n2 * 33;
                n3 += 7 * n2;
                if (DEBUG_ON) {
                    System.out.println("in _migrateActivatedList: adding slots = " + n2);
                    System.out.println("in _migrateActivatedList: migratedStartingOffset = " + n3);
                }
            }
            if (this._releaseVersion == 0) {
                if (by >= 1) {
                    n2 = 0;
                    while (n2 < 7 * (this._releaseNumPartitionSlots + 1)) {
                        byArray[n3 + n2] = this._nvramData[this.ACTIVATED_LIST_OFFSET + n2];
                        ++n2;
                    }
                }
            } else {
                n2 = 0;
                while (n2 < 7 * (this._releaseNumPartitionSlots + 1)) {
                    byArray[n3 + n2] = this._nvramData[n + n2];
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("0044");
            }
            throw new HSCCIMException(throwable);
        }
    }

    private void _migratePhyLocCodeTable(byte[] byArray, byte by, int n) throws CIMException {
        try {
            int n2;
            int n3 = n;
            if (this._releaseVersion < 3 && by >= 3) {
                n3 += 9;
            }
            if (this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                n2 = this.NUM_PARTITION_SLOTS - this._releaseNumPartitionSlots;
                n3 += n2 * 33;
                n3 += 2 * (7 * n2);
                if (DEBUG_ON) {
                    System.out.println("in _migratePhyLocCodeTable: adding slots = " + n2);
                    System.out.println("in _migratePhyLocCodeTable: migratedStartingOffset = " + n3);
                }
            }
            if (this._releaseVersion == 0) {
                if (by >= 1) {
                    n2 = 0;
                    while (n2 < 8 * this.SIZE_OF_ALPAR_INFO) {
                        byArray[n3 + n2] = 0;
                        ++n2;
                    }
                }
            } else {
                n2 = 0;
                while (n2 < 8 * this.SIZE_OF_ALPAR_INFO) {
                    byArray[n3 + n2] = this._nvramData[n + n2];
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("0045");
            }
            throw new HSCCIMException(throwable);
        }
    }

    private void _migrateDrawerProfileInfo(byte[] byArray, byte by, int n, int n2) throws CIMException {
        try {
            int n3 = n;
            if (this._releaseVersion < 3 && by >= 3) {
                n3 += 9;
                n2 = 9;
                n3 += 2;
            }
            if (this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                int n4 = this.NUM_PARTITION_SLOTS - this._releaseNumPartitionSlots;
                n3 += n4 * 33;
                n3 += 2 * (7 * n4);
                n2 += n4 * 33;
                if (DEBUG_ON) {
                    System.out.println("in _migrateDrawerProfileInfo: adding slots = " + n4);
                    System.out.println("in _migrateDrawerProfileInfo: startingOffset = " + n);
                    System.out.println("in _migrateDrawerProfileInfo: migratedStartingOffset = " + n3);
                    System.out.println("in _migrateDrawerProfileInfo: profNameOffsetIncr = " + n2);
                }
            }
            if (this._releaseVersion == 0) {
                if (by == 1) {
                    short s;
                    if (DEBUG_ON) {
                        System.out.println("NVRAM size = " + this.NVRAM_SIZE);
                        System.out.println("startOffset = " + n);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE - n);
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._nvramData);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    dataInputStream.skipBytes(this.NUM_DRAWERS_OFFSET);
                    int n5 = dataInputStream.readShort();
                    if (DEBUG_ON) {
                        System.out.println("numDrawers = " + n5);
                    }
                    dataOutputStream.writeShort(n5);
                    boolean bl = false;
                    int n6 = 0;
                    int n7 = 0;
                    while (n7 < n5) {
                        byte[] byArray2 = new byte[24];
                        dataInputStream.readFully(byArray2);
                        String string = new String(byArray2);
                        if (string == null || string.trim().length() <= 0) {
                            ++n6;
                            dataInputStream.skipBytes(2);
                            continue;
                        }
                        ++n6;
                        s = dataInputStream.readShort();
                        dataOutputStream.writeBytes(string);
                        dataOutputStream.writeShort(s);
                        ++n7;
                        if (!DEBUG_ON) continue;
                        System.out.println("migrate dID = " + string);
                    }
                    int n8 = this.DRAWERS_OFFSET + n6 * 26;
                    if (n8 < this._nvramData.length) {
                        while (!bl) {
                            int n9 = dataInputStream.readUnsignedByte();
                            if (n9 == 0) {
                                if (n8 + 24 + 2 >= this._nvramData.length) {
                                    dataInputStream.close();
                                    byteArrayInputStream.close();
                                    dataOutputStream.close();
                                    byteArrayOutputStream.close();
                                    return;
                                }
                                dataInputStream.skipBytes(25);
                                n8 = n8 + 24 + 2;
                                continue;
                            }
                            bl = true;
                        }
                    } else {
                        dataInputStream.close();
                        byteArrayInputStream.close();
                        dataOutputStream.close();
                        byteArrayOutputStream.close();
                        return;
                    }
                    dataInputStream.close();
                    byteArrayInputStream.close();
                    byteArrayInputStream = new ByteArrayInputStream(this._nvramData);
                    dataInputStream = new DataInputStream(byteArrayInputStream);
                    dataInputStream.skipBytes(n8);
                    int n10 = dataInputStream.readUnsignedByte();
                    while (n10 != 0) {
                        if (DEBUG_ON) {
                            System.out.println("profLen = " + n10);
                        }
                        if ((s = (short)dataInputStream.readByte()) == 255) {
                            dataInputStream.skipBytes(n10 - 2);
                        } else {
                            byte[] byArray3 = new byte[7];
                            dataInputStream.readFully(byArray3);
                            byte by2 = dataInputStream.readByte();
                            short s2 = dataInputStream.readShort();
                            if (DEBUG_ON) {
                                System.out.println("old nameIndex = " + s2);
                                System.out.println("profNameOffsetIncr = " + n2);
                                System.out.println("name = " + new String(this._nvramData, (int)s2, 32));
                            }
                            s2 = (short)(s2 + n2);
                            if (DEBUG_ON) {
                                System.out.println("nameIndex = " + s2);
                            }
                            byte[] byArray4 = new byte[n10 - 12];
                            dataInputStream.readFully(byArray4);
                            dataOutputStream.writeByte((byte)n10);
                            dataOutputStream.writeByte(s);
                            dataOutputStream.write(byArray3);
                            dataOutputStream.writeByte(by2);
                            dataOutputStream.writeShort(s2);
                            dataOutputStream.write(byArray4);
                        }
                        n10 = dataInputStream.readUnsignedByte();
                    }
                    dataOutputStream.flush();
                    byte[] byArray5 = byteArrayOutputStream.toByteArray();
                    dataOutputStream.close();
                    byteArrayOutputStream.close();
                    dataInputStream.close();
                    byteArrayInputStream.close();
                    if (DEBUG_ON) {
                        System.out.println("drawerProfileData.length = " + byArray5.length);
                    }
                    int n11 = 0;
                    while (n11 < byArray5.length) {
                        byArray[n + n11] = byArray5[n11];
                        ++n11;
                    }
                } else if (by >= 2) {
                    short s;
                    if (DEBUG_ON) {
                        System.out.println("NVRAM size = " + this.NVRAM_SIZE);
                        System.out.println("startOffset = " + n);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE - n);
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._nvramData);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    dataInputStream.skipBytes(this.NUM_DRAWERS_OFFSET);
                    int n12 = dataInputStream.readShort();
                    if (DEBUG_ON) {
                        System.out.println("numDrawers = " + n12);
                    }
                    dataOutputStream.writeShort(n12);
                    boolean bl = false;
                    int n13 = 0;
                    int n14 = 0;
                    while (n14 < n12) {
                        byte[] byArray6 = new byte[24];
                        dataInputStream.readFully(byArray6);
                        String string = new String(byArray6);
                        if (string == null || string.trim().length() <= 0) {
                            ++n13;
                            dataInputStream.skipBytes(2);
                            continue;
                        }
                        ++n13;
                        s = dataInputStream.readShort();
                        dataOutputStream.writeBytes(string);
                        dataOutputStream.writeShort(s);
                        ++n14;
                        if (!DEBUG_ON) continue;
                        System.out.println("migrate dID = " + string);
                    }
                    int n15 = this.DRAWERS_OFFSET + n13 * 26;
                    if (n15 < this._nvramData.length) {
                        while (!bl) {
                            int n16 = dataInputStream.readUnsignedByte();
                            if (n16 == 0) {
                                if (n15 + 24 + 2 >= this._nvramData.length) {
                                    dataInputStream.close();
                                    byteArrayInputStream.close();
                                    dataOutputStream.close();
                                    byteArrayOutputStream.close();
                                    return;
                                }
                                dataInputStream.skipBytes(25);
                                n15 = n15 + 24 + 2;
                                continue;
                            }
                            bl = true;
                        }
                    } else {
                        dataInputStream.close();
                        byteArrayInputStream.close();
                        dataOutputStream.close();
                        byteArrayOutputStream.close();
                        return;
                    }
                    dataInputStream.close();
                    byteArrayInputStream.close();
                    byteArrayInputStream = new ByteArrayInputStream(this._nvramData);
                    dataInputStream = new DataInputStream(byteArrayInputStream);
                    dataInputStream.skipBytes(n15);
                    int n17 = dataInputStream.readUnsignedByte();
                    while (n17 != 0) {
                        if (DEBUG_ON) {
                            System.out.println("profLen = " + n17);
                        }
                        if ((s = (short)dataInputStream.readByte()) == 255) {
                            dataInputStream.skipBytes(n17 - 2);
                        } else {
                            short s3;
                            byte[] byArray7 = new byte[7];
                            dataInputStream.readFully(byArray7);
                            byte by3 = dataInputStream.readByte();
                            if (by3 == 1) {
                                s3 = dataInputStream.readShort();
                                if (DEBUG_ON) {
                                    System.out.println("old nameIndex = " + s3);
                                    System.out.println("profNameOffsetIncr = " + n2);
                                    System.out.println("name = " + new String(this._nvramData, (int)s3, 32));
                                }
                                s3 = (short)(s3 + n2);
                                if (DEBUG_ON) {
                                    System.out.println("nameIndex = " + s3);
                                }
                                byte[] byArray8 = new byte[n17 - 12];
                                dataInputStream.readFully(byArray8);
                                if (by < 3) {
                                    dataOutputStream.writeByte((byte)n17);
                                } else {
                                    dataOutputStream.writeShort((short)(n17 += 3));
                                }
                                if (DEBUG_ON) {
                                    System.out.println("profile length = " + n17);
                                }
                                dataOutputStream.writeByte(s);
                                dataOutputStream.write(byArray7);
                                dataOutputStream.writeByte(by3);
                                if (by < 3) {
                                    dataOutputStream.writeShort(s3);
                                } else {
                                    dataOutputStream.writeInt(s3);
                                }
                                dataOutputStream.write(byArray8);
                            } else {
                                s3 = dataInputStream.readShort();
                                if (DEBUG_ON) {
                                    System.out.println("old nameIndex = " + s3);
                                    System.out.println("profNameOffsetIncr = " + n2);
                                    System.out.println("name = " + new String(this._nvramData, (int)s3, 32));
                                }
                                s3 = (short)(s3 + n2);
                                if (DEBUG_ON) {
                                    System.out.println("nameIndex = " + s3);
                                }
                                byte by4 = (byte)dataInputStream.readUnsignedByte();
                                byte by5 = (byte)dataInputStream.readUnsignedByte();
                                byte by6 = (byte)dataInputStream.readUnsignedByte();
                                int n18 = 1;
                                int n19 = 1;
                                int n20 = 0;
                                byte by7 = (byte)dataInputStream.readUnsignedByte();
                                byte by8 = (byte)dataInputStream.readUnsignedByte();
                                int n21 = dataInputStream.readInt();
                                int n22 = dataInputStream.readInt();
                                byte[] byArray9 = new byte[n17 - 25];
                                dataInputStream.readFully(byArray9);
                                if (by == 2) {
                                    dataOutputStream.writeByte((byte)(n17 + 1 + 4 + 1 + 1));
                                } else {
                                    dataOutputStream.writeShort((short)((n17 += 3) + 1 + 4 + 1 + 1 + 1));
                                }
                                if (DEBUG_ON) {
                                    System.out.println("profile length = " + n17);
                                }
                                dataOutputStream.writeByte(s);
                                dataOutputStream.write(byArray7);
                                dataOutputStream.writeByte(by3);
                                if (by == 2) {
                                    dataOutputStream.writeShort(s3);
                                } else {
                                    dataOutputStream.writeInt(s3);
                                }
                                dataOutputStream.writeByte(by4);
                                dataOutputStream.writeByte(by5);
                                dataOutputStream.writeByte(by6);
                                dataOutputStream.writeByte(n18);
                                dataOutputStream.writeByte(n19);
                                dataOutputStream.writeByte(by7);
                                dataOutputStream.writeByte(by8);
                                dataOutputStream.writeByte(by7);
                                dataOutputStream.writeInt(n21);
                                dataOutputStream.writeInt(n22);
                                dataOutputStream.writeInt(n21);
                                dataOutputStream.write(byArray9);
                                if (by > 2) {
                                    dataOutputStream.writeByte(n20);
                                }
                            }
                        }
                        n17 = dataInputStream.readUnsignedByte();
                    }
                    dataOutputStream.flush();
                    byte[] byArray10 = byteArrayOutputStream.toByteArray();
                    dataOutputStream.close();
                    byteArrayOutputStream.close();
                    dataInputStream.close();
                    byteArrayInputStream.close();
                    if (DEBUG_ON) {
                        System.out.println("drawerProfileData.length = " + byArray10.length);
                    }
                    int n23 = 0;
                    while (n23 < byArray10.length) {
                        byArray[n3 + n23] = byArray10[n23];
                        ++n23;
                    }
                }
            } else if (this._releaseVersion == 1) {
                if (by >= 2) {
                    short s;
                    if (DEBUG_ON) {
                        System.out.println("NVRAM size = " + this.NVRAM_SIZE);
                        System.out.println("startOffset = " + n);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE - n);
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._nvramData);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    dataInputStream.skipBytes(this.NUM_DRAWERS_OFFSET);
                    int n24 = dataInputStream.readShort();
                    if (DEBUG_ON) {
                        System.out.println("numDrawers = " + n24);
                    }
                    dataOutputStream.writeShort(n24);
                    boolean bl = false;
                    int n25 = 0;
                    int n26 = 0;
                    while (n26 < n24) {
                        byte[] byArray11 = new byte[24];
                        dataInputStream.readFully(byArray11);
                        String string = new String(byArray11);
                        if (string == null || string.trim().length() <= 0) {
                            ++n25;
                            dataInputStream.skipBytes(2);
                            continue;
                        }
                        ++n25;
                        s = dataInputStream.readShort();
                        dataOutputStream.writeBytes(string);
                        dataOutputStream.writeShort(s);
                        ++n26;
                        if (!DEBUG_ON) continue;
                        System.out.println("migrate dID = " + string);
                    }
                    int n27 = this.DRAWERS_OFFSET + n25 * 26;
                    if (n27 < this._nvramData.length) {
                        while (!bl) {
                            int n28 = dataInputStream.readUnsignedByte();
                            if (n28 == 0) {
                                if (n27 + 24 + 2 >= this._nvramData.length) {
                                    dataInputStream.close();
                                    byteArrayInputStream.close();
                                    dataOutputStream.close();
                                    byteArrayOutputStream.close();
                                    return;
                                }
                                dataInputStream.skipBytes(25);
                                n27 = n27 + 24 + 2;
                                continue;
                            }
                            bl = true;
                        }
                    } else {
                        dataInputStream.close();
                        byteArrayInputStream.close();
                        dataOutputStream.close();
                        byteArrayOutputStream.close();
                        return;
                    }
                    dataInputStream.close();
                    byteArrayInputStream.close();
                    byteArrayInputStream = new ByteArrayInputStream(this._nvramData);
                    dataInputStream = new DataInputStream(byteArrayInputStream);
                    dataInputStream.skipBytes(n27);
                    int n29 = dataInputStream.readUnsignedByte();
                    while (n29 != 0) {
                        if (DEBUG_ON) {
                            System.out.println("profLen = " + n29);
                        }
                        if ((s = (short)dataInputStream.readByte()) == 255) {
                            dataInputStream.skipBytes(n29 - 2);
                        } else {
                            short s4;
                            byte[] byArray12 = new byte[7];
                            dataInputStream.readFully(byArray12);
                            byte by9 = dataInputStream.readByte();
                            if (by9 == 1) {
                                s4 = dataInputStream.readShort();
                                if (DEBUG_ON) {
                                    System.out.println("old nameIndex = " + s4);
                                    System.out.println("profNameOffsetIncr = " + n2);
                                    System.out.println("name = " + new String(this._nvramData, (int)s4, 32));
                                }
                                s4 = (short)(s4 + n2);
                                if (DEBUG_ON) {
                                    System.out.println("nameIndex = " + s4);
                                }
                                byte[] byArray13 = new byte[n29 - 12];
                                dataInputStream.readFully(byArray13);
                                if (by == 2) {
                                    dataOutputStream.writeByte((byte)n29);
                                } else {
                                    dataOutputStream.writeShort((short)(n29 += 3));
                                }
                                if (DEBUG_ON) {
                                    System.out.println("profile length = " + n29);
                                }
                                dataOutputStream.writeByte(s);
                                dataOutputStream.write(byArray12);
                                dataOutputStream.writeByte(by9);
                                if (by == 2) {
                                    dataOutputStream.writeShort(s4);
                                } else {
                                    dataOutputStream.writeInt(s4);
                                }
                                dataOutputStream.write(byArray13);
                            } else {
                                s4 = dataInputStream.readShort();
                                if (DEBUG_ON) {
                                    System.out.println("old nameIndex = " + s4);
                                    System.out.println("profNameOffsetIncr = " + n2);
                                    System.out.println("name = " + new String(this._nvramData, (int)s4, 32));
                                }
                                s4 = (short)(s4 + n2);
                                if (DEBUG_ON) {
                                    System.out.println("nameIndex = " + s4);
                                }
                                byte by10 = (byte)dataInputStream.readUnsignedByte();
                                byte by11 = (byte)dataInputStream.readUnsignedByte();
                                byte by12 = (byte)dataInputStream.readUnsignedByte();
                                int n30 = 1;
                                int n31 = 1;
                                int n32 = 0;
                                byte by13 = (byte)dataInputStream.readUnsignedByte();
                                byte by14 = (byte)dataInputStream.readUnsignedByte();
                                int n33 = dataInputStream.readInt();
                                int n34 = dataInputStream.readInt();
                                byte[] byArray14 = new byte[n29 - 25];
                                dataInputStream.readFully(byArray14);
                                if (by == 2) {
                                    dataOutputStream.writeByte((byte)(n29 + 1 + 4 + 1 + 1));
                                } else {
                                    dataOutputStream.writeShort((short)((n29 += 3) + 1 + 4 + 1 + 1 + 1));
                                }
                                if (DEBUG_ON) {
                                    System.out.println("profile length = " + n29);
                                }
                                dataOutputStream.writeByte(s);
                                dataOutputStream.write(byArray12);
                                dataOutputStream.writeByte(by9);
                                if (by == 2) {
                                    dataOutputStream.writeShort(s4);
                                } else {
                                    dataOutputStream.writeInt(s4);
                                }
                                dataOutputStream.writeByte(by10);
                                dataOutputStream.writeByte(by11);
                                dataOutputStream.writeByte(by12);
                                dataOutputStream.writeByte(n30);
                                dataOutputStream.writeByte(n31);
                                dataOutputStream.writeByte(by13);
                                dataOutputStream.writeByte(by14);
                                dataOutputStream.writeByte(by13);
                                dataOutputStream.writeInt(n33);
                                dataOutputStream.writeInt(n34);
                                dataOutputStream.writeInt(n33);
                                dataOutputStream.write(byArray14);
                                if (by > 2) {
                                    dataOutputStream.writeByte(n32);
                                }
                            }
                        }
                        n29 = dataInputStream.readUnsignedByte();
                    }
                    dataOutputStream.flush();
                    byte[] byArray15 = byteArrayOutputStream.toByteArray();
                    dataOutputStream.close();
                    byteArrayOutputStream.close();
                    dataInputStream.close();
                    byteArrayInputStream.close();
                    if (DEBUG_ON) {
                        System.out.println("drawerProfileData.length = " + byArray15.length);
                    }
                    int n35 = 0;
                    while (n35 < byArray15.length) {
                        byArray[n3 + n35] = byArray15[n35];
                        ++n35;
                    }
                }
            } else if (this._releaseVersion == 2) {
                if (by >= 3) {
                    short s;
                    if (DEBUG_ON) {
                        System.out.println("NVRAM size = " + this.NVRAM_SIZE);
                        System.out.println("startOffset = " + n);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE - n);
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._nvramData);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    dataInputStream.skipBytes(this.NUM_DRAWERS_OFFSET);
                    int n36 = dataInputStream.readShort();
                    if (DEBUG_ON) {
                        System.out.println("numDrawers = " + n36);
                    }
                    dataOutputStream.writeShort(n36);
                    boolean bl = false;
                    int n37 = 0;
                    int n38 = 0;
                    while (n38 < n36) {
                        byte[] byArray16 = new byte[24];
                        dataInputStream.readFully(byArray16);
                        String string = new String(byArray16);
                        if (string == null || string.trim().length() <= 0) {
                            ++n37;
                            dataInputStream.skipBytes(2);
                            continue;
                        }
                        ++n37;
                        s = dataInputStream.readShort();
                        dataOutputStream.writeBytes(string);
                        dataOutputStream.writeShort(s);
                        ++n38;
                        if (!DEBUG_ON) continue;
                        System.out.println("migrate dID = " + string);
                    }
                    int n39 = this.DRAWERS_OFFSET + n37 * 26;
                    if (n39 < this._nvramData.length) {
                        while (!bl) {
                            int n40 = dataInputStream.readUnsignedByte();
                            if (n40 == 0) {
                                if (n39 + 24 + 2 >= this._nvramData.length) {
                                    dataInputStream.close();
                                    byteArrayInputStream.close();
                                    dataOutputStream.close();
                                    byteArrayOutputStream.close();
                                    return;
                                }
                                dataInputStream.skipBytes(25);
                                n39 = n39 + 24 + 2;
                                continue;
                            }
                            bl = true;
                        }
                    } else {
                        dataInputStream.close();
                        byteArrayInputStream.close();
                        dataOutputStream.close();
                        byteArrayOutputStream.close();
                        return;
                    }
                    dataInputStream.close();
                    byteArrayInputStream.close();
                    byteArrayInputStream = new ByteArrayInputStream(this._nvramData);
                    dataInputStream = new DataInputStream(byteArrayInputStream);
                    dataInputStream.skipBytes(n39);
                    int n41 = dataInputStream.readUnsignedByte();
                    while (n41 != 0) {
                        if (DEBUG_ON) {
                            System.out.println("profLen = " + n41);
                        }
                        if ((s = (short)dataInputStream.readByte()) == 255) {
                            dataInputStream.skipBytes(n41 - 2);
                        } else {
                            short s5;
                            byte[] byArray17 = new byte[7];
                            dataInputStream.readFully(byArray17);
                            byte by15 = dataInputStream.readByte();
                            if (by15 == 1) {
                                s5 = dataInputStream.readShort();
                                if (DEBUG_ON) {
                                    System.out.println("old nameIndex = " + s5);
                                    System.out.println("profNameOffsetIncr = " + n2);
                                    System.out.println("name = " + new String(this._nvramData, (int)s5, 32));
                                }
                                s5 = (short)(s5 + n2);
                                if (DEBUG_ON) {
                                    System.out.println("nameIndex = " + s5);
                                }
                                byte[] byArray18 = new byte[n41 - 12];
                                dataInputStream.readFully(byArray18);
                                dataOutputStream.writeShort((short)(n41 += 3));
                                if (DEBUG_ON) {
                                    System.out.println("profile length = " + n41);
                                }
                                dataOutputStream.writeByte(s);
                                dataOutputStream.write(byArray17);
                                dataOutputStream.writeByte(by15);
                                dataOutputStream.writeInt(s5);
                                dataOutputStream.write(byArray18);
                            } else {
                                s5 = dataInputStream.readShort();
                                if (DEBUG_ON) {
                                    System.out.println("old nameIndex = " + s5);
                                    System.out.println("profNameOffsetIncr = " + n2);
                                    System.out.println("name = " + new String(this._nvramData, (int)s5, 32));
                                }
                                s5 = (short)(s5 + n2);
                                if (DEBUG_ON) {
                                    System.out.println("nameIndex = " + s5);
                                }
                                byte by16 = (byte)dataInputStream.readUnsignedByte();
                                byte by17 = (byte)dataInputStream.readUnsignedByte();
                                byte by18 = (byte)dataInputStream.readUnsignedByte();
                                byte by19 = (byte)dataInputStream.readUnsignedByte();
                                byte by20 = (byte)dataInputStream.readUnsignedByte();
                                int n42 = 0;
                                byte by21 = (byte)dataInputStream.readUnsignedByte();
                                byte by22 = (byte)dataInputStream.readUnsignedByte();
                                byte by23 = (byte)dataInputStream.readUnsignedByte();
                                int n43 = dataInputStream.readInt();
                                int n44 = dataInputStream.readInt();
                                int n45 = dataInputStream.readInt();
                                byte[] byArray19 = new byte[n41 - 32];
                                dataInputStream.readFully(byArray19);
                                dataOutputStream.writeShort((short)(n41 + 4));
                                dataOutputStream.writeByte(s);
                                dataOutputStream.write(byArray17);
                                dataOutputStream.writeByte(by15);
                                dataOutputStream.writeInt(s5);
                                dataOutputStream.writeByte(by16);
                                dataOutputStream.writeByte(by17);
                                dataOutputStream.writeByte(by18);
                                dataOutputStream.writeByte(by19);
                                dataOutputStream.writeByte(by20);
                                dataOutputStream.writeByte(by21);
                                dataOutputStream.writeByte(by22);
                                dataOutputStream.writeByte(by23);
                                dataOutputStream.writeInt(n43);
                                dataOutputStream.writeInt(n44);
                                dataOutputStream.writeInt(n45);
                                dataOutputStream.write(byArray19);
                                dataOutputStream.writeByte(n42);
                            }
                        }
                        n41 = dataInputStream.readUnsignedByte();
                    }
                    dataOutputStream.flush();
                    byte[] byArray20 = byteArrayOutputStream.toByteArray();
                    dataOutputStream.close();
                    byteArrayOutputStream.close();
                    dataInputStream.close();
                    byteArrayInputStream.close();
                    if (DEBUG_ON) {
                        System.out.println("drawerProfileData.length = " + byArray20.length);
                    }
                    int n46 = 0;
                    while (n46 < byArray20.length) {
                        byArray[n3 + n46] = byArray20[n46];
                        ++n46;
                    }
                }
            } else if (this._releaseVersion == 3 && by >= 3) {
                short s;
                if (DEBUG_ON) {
                    System.out.println("NVRAM size = " + this.NVRAM_SIZE);
                    System.out.println("startOffset = " + n);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE - n);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._nvramData);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                dataInputStream.skipBytes(this.NUM_DRAWERS_OFFSET);
                int n47 = dataInputStream.readShort();
                if (DEBUG_ON) {
                    System.out.println("numDrawers = " + n47);
                }
                dataOutputStream.writeShort(n47);
                boolean bl = false;
                int n48 = 0;
                int n49 = 0;
                while (n49 < n47) {
                    byte[] byArray21 = new byte[24];
                    dataInputStream.readFully(byArray21);
                    String string = new String(byArray21);
                    if (string == null || string.trim().length() <= 0) {
                        ++n48;
                        dataInputStream.skipBytes(2);
                        continue;
                    }
                    ++n48;
                    s = dataInputStream.readShort();
                    dataOutputStream.writeBytes(string);
                    dataOutputStream.writeShort(s);
                    ++n49;
                    if (!DEBUG_ON) continue;
                    System.out.println("migrate dID = " + string);
                }
                int n50 = this.DRAWERS_OFFSET + n48 * 26;
                if (n50 < this._nvramData.length) {
                    while (!bl) {
                        int n51 = dataInputStream.readUnsignedShort();
                        if (n51 == 0) {
                            if (n50 + 24 + 2 >= this._nvramData.length) {
                                dataInputStream.close();
                                byteArrayInputStream.close();
                                dataOutputStream.close();
                                byteArrayOutputStream.close();
                                return;
                            }
                            dataInputStream.skipBytes(24);
                            n50 = n50 + 24 + 2;
                            continue;
                        }
                        bl = true;
                    }
                } else {
                    dataInputStream.close();
                    byteArrayInputStream.close();
                    dataOutputStream.close();
                    byteArrayOutputStream.close();
                    return;
                }
                dataInputStream.close();
                byteArrayInputStream.close();
                byteArrayInputStream = new ByteArrayInputStream(this._nvramData);
                dataInputStream = new DataInputStream(byteArrayInputStream);
                dataInputStream.skipBytes(n50);
                int n52 = dataInputStream.readUnsignedShort();
                while (n52 != 0) {
                    if (DEBUG_ON) {
                        System.out.println("profLen = " + n52);
                    }
                    if ((s = (short)dataInputStream.readByte()) == 255) {
                        dataInputStream.skipBytes(n52 - 3);
                    } else {
                        byte[] byArray22 = new byte[7];
                        dataInputStream.readFully(byArray22);
                        byte by24 = dataInputStream.readByte();
                        int n53 = dataInputStream.readInt();
                        if (DEBUG_ON) {
                            System.out.println("old nameIndex = " + n53);
                            System.out.println("profNameOffsetIncr = " + n2);
                            System.out.println("name = " + new String(this._nvramData, n53, 32));
                        }
                        n53 = (short)(n53 + n2);
                        if (DEBUG_ON) {
                            System.out.println("nameIndex = " + n53);
                        }
                        byte[] byArray23 = new byte[n52 - 15];
                        dataInputStream.readFully(byArray23);
                        dataOutputStream.writeShort((short)n52);
                        if (DEBUG_ON) {
                            System.out.println("profile length = " + n52);
                        }
                        dataOutputStream.writeByte(s);
                        dataOutputStream.write(byArray22);
                        dataOutputStream.writeByte(by24);
                        dataOutputStream.writeInt(n53);
                        dataOutputStream.write(byArray23);
                    }
                    n52 = dataInputStream.readUnsignedShort();
                }
                dataOutputStream.flush();
                byte[] byArray24 = byteArrayOutputStream.toByteArray();
                dataOutputStream.close();
                byteArrayOutputStream.close();
                dataInputStream.close();
                byteArrayInputStream.close();
                if (DEBUG_ON) {
                    System.out.println("drawerProfileData.length = " + byArray24.length);
                }
                int n54 = 0;
                while (n54 < byArray24.length) {
                    byArray[n3 + n54] = byArray24[n54];
                    ++n54;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("0046");
            }
            throw new HSCCIMException(throwable);
        }
    }

    private void _migrateTimestamps(byte[] byArray, byte by, byte[] byArray2) throws CIMException {
        try {
            int n = 0;
            if (DEBUG_ON) {
                System.out.println("in _migrateTimestamps: migratedStartingOffset = " + n);
            }
            if (by >= 1) {
                int n2 = 0;
                while (n2 < 7) {
                    byArray[n + this.NVRAM_TIME_STAMP_OFFSET + n2] = byArray2[n2];
                    byArray[n + this.PARTITION_NAME_TABLE_TIME_STAMP_OFFSET + n2] = byArray2[n2];
                    byArray[n + this.PROFILE_NAME_TABLE_TIME_STAMP_OFFSET + n2] = byArray2[n2];
                    byArray[n + this.DEFAULT_LIST_TIME_STAMP_OFFSET + n2] = byArray2[n2];
                    byArray[n + this.ACTIVATED_LIST_TIME_STAMP_OFFSET + n2] = byArray2[n2];
                    byArray[n + this.PHY_LOC_CODE_TIME_STAMP_OFFSET + n2] = byArray2[n2];
                    byArray[n + this.DRAWER_PROFILE_INFO_TIME_STAMP_OFFSET + n2] = byArray2[n2];
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("0047");
            }
            throw new HSCCIMException(throwable);
        }
    }

    private void _migrateChecksums(byte[] byArray, byte by, int n) throws CIMException {
        try {
            int n2 = 0;
            if (DEBUG_ON) {
                System.out.println("in _migrateChecksums: migratedStartingOffset = " + n2);
            }
            if (by >= 1) {
                int n3;
                int n4;
                int n5;
                if (DEBUG_ON) {
                    System.out.println("incr = " + n);
                }
                Adler32 adler32 = new Adler32();
                long l = 0L;
                byte[] byArray2 = null;
                adler32.reset();
                if (DEBUG_ON) {
                    System.out.println("checksum NVRAM_TIME_STAMP_OFFSET = " + (n2 + this.NVRAM_TIME_STAMP_OFFSET));
                }
                adler32.update(byArray, n2 + this.NVRAM_TIME_STAMP_OFFSET, this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET - this.NVRAM_TIME_STAMP_OFFSET);
                l = adler32.getValue();
                byArray2 = NVRAM.longToByteArray(l);
                System.out.println("writing timeStampChecksum " + l + " at offset " + (n2 + this.TIME_STAMPS_CHECKSUM_OFFSET));
                int n6 = 0;
                while (n6 < 8) {
                    byArray[n2 + this.TIME_STAMPS_CHECKSUM_OFFSET + n6] = byArray2[n6];
                    ++n6;
                }
                adler32.reset();
                if (DEBUG_ON) {
                    System.out.println("newData.length  " + byArray.length);
                    System.out.println("checksum PARTITION_NAME_TABLE_OFFSET = " + (n2 + this.PARTITION_NAME_TABLE_OFFSET));
                }
                if (this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                    adler32.update(byArray, n2 + this.PARTITION_NAME_TABLE_OFFSET, this.NUM_PARTITION_SLOTS * 33);
                } else {
                    adler32.update(byArray, n2 + this.PARTITION_NAME_TABLE_OFFSET, this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET - this.PARTITION_NAME_TABLE_OFFSET);
                }
                l = adler32.getValue();
                byArray2 = NVRAM.longToByteArray(l);
                System.out.println("writing partitionNameTableChecksum " + l + " at offset " + (n2 + this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET));
                int n7 = 0;
                while (n7 < 8) {
                    byArray[n2 + this.PARTITION_NAME_TABLE_CHECKSUM_OFFSET + n7] = byArray2[n7];
                    ++n7;
                }
                if (this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                    n5 = this.NUM_PARTITION_SLOTS - this._releaseNumPartitionSlots;
                    if (DEBUG_ON) {
                        System.out.println("migrating checksums: adding slots = " + n5);
                    }
                }
                if (DEBUG_ON) {
                    System.out.println("checksum  PROFILE_NAME_TABLE_OFFSET = " + (n2 + this.PROFILE_NAME_TABLE_OFFSET));
                }
                adler32.reset();
                adler32.update(byArray, n2 + this.PROFILE_NAME_TABLE_OFFSET, this.DEFAULT_LIST_CHECKSUM_OFFSET - this.PROFILE_NAME_TABLE_OFFSET);
                l = adler32.getValue();
                byArray2 = NVRAM.longToByteArray(l);
                System.out.println("writing profileNameTableChecksum " + l + " at offset " + (n2 + this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET));
                n5 = 0;
                while (n5 < 8) {
                    byArray[n2 + this.PROFILE_NAME_TABLE_CHECKSUM_OFFSET + n5] = byArray2[n5];
                    ++n5;
                }
                adler32.reset();
                if (DEBUG_ON) {
                    System.out.println("checksum DEFAULT_LIST_OFFSET = " + (n2 + this.DEFAULT_LIST_OFFSET));
                }
                if (this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                    adler32.update(byArray, n2 + this.DEFAULT_LIST_OFFSET, (this.NUM_PARTITION_SLOTS + 1) * 7);
                } else {
                    adler32.update(byArray, n2 + this.DEFAULT_LIST_OFFSET, this.ACTIVATED_LIST_CHECKSUM_OFFSET - this.DEFAULT_LIST_OFFSET);
                }
                l = adler32.getValue();
                byArray2 = NVRAM.longToByteArray(l);
                System.out.println("writing defaultListChecksum " + l + " at offset " + (n2 + this.DEFAULT_LIST_CHECKSUM_OFFSET));
                int n8 = 0;
                while (n8 < 8) {
                    byArray[n2 + this.DEFAULT_LIST_CHECKSUM_OFFSET + n8] = byArray2[n8];
                    ++n8;
                }
                if (this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                    n4 = this.NUM_PARTITION_SLOTS - this._releaseNumPartitionSlots;
                    if (DEBUG_ON) {
                        System.out.println("migrating checksums: adding slots = " + n4);
                    }
                }
                if (DEBUG_ON) {
                    System.out.println("checksum ACTIVATED_LIST_OFFSET = " + (n2 + this.ACTIVATED_LIST_OFFSET));
                }
                adler32.reset();
                if (this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                    adler32.update(byArray, n2 + this.ACTIVATED_LIST_OFFSET, (this.NUM_PARTITION_SLOTS + 1) * 7);
                } else {
                    adler32.update(byArray, n2 + this.ACTIVATED_LIST_OFFSET, this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET - this.ACTIVATED_LIST_OFFSET);
                }
                l = adler32.getValue();
                byArray2 = NVRAM.longToByteArray(l);
                System.out.println("writing activatedListChecksum " + l + " at offset " + (n2 + this.ACTIVATED_LIST_CHECKSUM_OFFSET));
                n4 = 0;
                while (n4 < 8) {
                    byArray[n2 + this.ACTIVATED_LIST_CHECKSUM_OFFSET + n4] = byArray2[n4];
                    ++n4;
                }
                if (this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                    n3 = this.NUM_PARTITION_SLOTS - this._releaseNumPartitionSlots;
                    if (DEBUG_ON) {
                        System.out.println("migrating checksums: adding slots = " + n3);
                    }
                }
                if (DEBUG_ON) {
                    System.out.println("checksum  PHY_LOC_CODE_TABLE_OFFSET = " + (n2 + this.PHY_LOC_CODE_TABLE_OFFSET));
                }
                adler32.reset();
                adler32.update(byArray, n2 + this.PHY_LOC_CODE_TABLE_OFFSET, this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET - this.PHY_LOC_CODE_TABLE_OFFSET);
                l = adler32.getValue();
                byArray2 = NVRAM.longToByteArray(l);
                System.out.println("writing phyLocCodeTableChecksum " + l + " at offset " + (n2 + this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET));
                n3 = 0;
                while (n3 < 8) {
                    byArray[n2 + this.PHY_LOC_CODE_TABLE_CHECKSUM_OFFSET + n3] = byArray2[n3];
                    ++n3;
                }
                adler32.reset();
                if (DEBUG_ON) {
                    System.out.println("checksum  NUM_DRAWERS_OFFSET = " + (n2 + this.NUM_DRAWERS_OFFSET));
                }
                if (by < 3) {
                    adler32.update(byArray, n2 + this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - (n2 + this.NUM_DRAWERS_OFFSET));
                } else {
                    adler32.update(byArray, n2 + this.NUM_DRAWERS_OFFSET, this.NVRAM_SIZE - (n2 + this.NUM_DRAWERS_OFFSET));
                }
                l = adler32.getValue();
                byArray2 = NVRAM.longToByteArray(l);
                int n9 = 0;
                while (n9 < 8) {
                    byArray[n2 + this.DRAWER_PROFILE_INFO_CHECKSUM_OFFSET + n9] = byArray2[n9];
                    ++n9;
                }
                if (by < 3) {
                    byArray[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = (byte)(this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET >>> 8);
                    byArray[this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = (byte)(this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET & 0xFF);
                } else {
                    int n10 = this.NVRAM_SIZE - (n2 + this.NUM_DRAWERS_OFFSET);
                    byArray[n2 + this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET] = (byte)(n10 >>> 24);
                    byArray[n2 + this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 1] = (byte)(n10 >>> 16);
                    byArray[n2 + this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 2] = (byte)(n10 >>> 8);
                    byArray[n2 + this.DRAWER_PROF_INFO_DATA_SIZE_OFFSET + 3] = (byte)(n10 & 0xFF);
                    if (DEBUG_ON) {
                        System.out.println("In _migrateChecksums nvramSize = " + n10);
                        System.out.println("In _migrateChecksums - NUM_DRAWERS_OFFSET " + this.NUM_DRAWERS_OFFSET);
                        System.out.println("In _migrateChecksums - migratedStartingOffset " + n2);
                        System.out.println("In _migrateChecksums  ---NVRAM_SIZE - NUM_DRAWERS_OFFSET = " + (this.NVRAM_SIZE - this.NUM_DRAWERS_OFFSET));
                        System.out.println("In _migrateChecksums  ---NVRAM_SIZE - new NUM_DRAWERS_OFFSET = " + (this.NVRAM_SIZE - (n2 + this.NUM_DRAWERS_OFFSET)));
                    }
                }
                byArray[this.CORRUPTED_BYTE_OFFSET] = (byte)(by << 1);
                if (by >= 3) {
                    System.out.println(" In _migrateChecksums ----------- setting _releaseNumPartitionSlots");
                    byArray[this.NUM_PARTITION_SLOTS_OFFSET] = (byte)this.NUM_PARTITION_SLOTS;
                    if (this.NUM_PARTITION_SLOTS > this._releaseNumPartitionSlots) {
                        this._releaseNumPartitionSlots = this.NUM_PARTITION_SLOTS;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("0048");
            }
            throw new HSCCIMException(throwable);
        }
    }

    public synchronized int[] modifySysProfilesUsingLparID(int n, HscProviderSocket hscProviderSocket, boolean bl, boolean bl2) throws CIMException {
        try {
            Object object;
            Trace.trace("apnvhscT", " -> modifySysProfilesUsingLparID");
            Trace.trace("apnvhscF", "lparID = " + String.valueOf(n));
            Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
            if (DEBUG_ON) {
                System.out.print("********************");
                System.out.println("********************");
                System.out.println("In _modifySysProfilesUsingLparID");
            }
            if (bl) {
                this.buildNVRAM(hscProviderSocket, false, null, true, true, false);
            }
            Vector vector = this.getLPARProfilesAtPartition((short)0, hscProviderSocket, false, false);
            Enumeration enumeration = vector.elements();
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            while (enumeration.hasMoreElements()) {
                Object object2;
                object = (Vector)enumeration.nextElement();
                String string = (String)((CIMProperty)((Vector)object).elementAt(0)).getValue().getValue();
                if (DEBUG_ON) {
                    System.out.println("sysProfTimestamp = " + string);
                }
                Trace.trace("apnvhscF", "sysProfTimestamp = " + string);
                Trace.trace("apnvhscF", "properties = " + object);
                CIMProperty cIMProperty = (CIMProperty)((Vector)object).get(3);
                CIMProperty cIMProperty2 = (CIMProperty)((Vector)object).get(2);
                if (cIMProperty == null) continue;
                CIMValue cIMValue = cIMProperty.getValue();
                CIMValue cIMValue2 = cIMProperty2.getValue();
                if (cIMValue == null) continue;
                Vector vector2 = (Vector)cIMValue.getValue();
                Trace.trace("apnvhscF", "lparIDs = " + vector2);
                Vector vector3 = (Vector)cIMValue2.getValue();
                Trace.trace("apnvhscF", "lparProfs = " + vector3);
                if (vector2 == null) break;
                int n6 = vector2.indexOf(new UnsignedInt8((short)n));
                if (n6 == -1) continue;
                vector2.removeElementAt(n6);
                vector3.removeElementAt(n6);
                ((Vector)object).setSize(4);
                if (vector2.size() == 0) {
                    if (DEBUG_ON) {
                        System.out.println("modifySysUsing --> size = 0");
                    }
                    if ((object2 = this.removeSysProfile(string, hscProviderSocket, false, false)) == null) continue;
                    if (n2 == -1) {
                        n2 = object2[0];
                    } else if (n2 > object2[0] && object2[0] != -1) {
                        n2 = object2[0];
                    }
                    if (n3 == -1) {
                        n3 = object2[1];
                    } else if (n3 < object2[1] && object2[1] != -1) {
                        n3 = object2[1];
                    }
                    if (n4 == -1) {
                        n4 = object2[2];
                    } else if (n4 > object2[2] && object2[2] != -1) {
                        n4 = object2[2];
                    }
                    if (n5 == -1) {
                        n5 = object2[3];
                        continue;
                    }
                    if (n5 >= object2[3] || object2[3] == -1) continue;
                    n5 = object2[3];
                    continue;
                }
                ((Vector)object).setElementAt(new CIMProperty("ProfileList", new CIMValue(vector3, new CIMDataType(29))), 2);
                ((Vector)object).setElementAt(new CIMProperty("PartitionIDList", new CIMValue(vector2, new CIMDataType(21))), 3);
                object2 = (String)((CIMProperty)((Vector)object).elementAt(1)).getValue().getValue();
                int[] nArray = this.saveSysProfile((String)object2, string, (Vector)object, null, hscProviderSocket, false, bl2);
                if (nArray == null) continue;
                if (n2 == -1) {
                    n2 = nArray[0];
                } else if (n2 > nArray[0] && nArray[0] != -1) {
                    n2 = nArray[0];
                }
                if (n3 == -1) {
                    n3 = nArray[1];
                } else if (n3 < nArray[1] && nArray[1] != -1) {
                    n3 = nArray[1];
                }
                if (n4 == -1) {
                    n4 = nArray[2];
                } else if (n4 > nArray[2] && nArray[2] != -1) {
                    n4 = nArray[2];
                }
                if (n5 == -1) {
                    n5 = nArray[3];
                    continue;
                }
                if (n5 >= nArray[3] || nArray[3] == -1) continue;
                n5 = nArray[3];
            }
            object = new int[]{n2, n3, n4, n5};
            return object;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("002A", new String[]{String.valueOf(n)});
            }
            throw new HSCCIMException(throwable);
        }
        finally {
            if (DEBUG_ON) {
                System.out.println("End of modifySysProfilesUsingLparID");
                System.out.print("********************");
                System.out.println("********************");
            }
            Trace.trace("apnvhscT", " <- modifySysProfilesUsingLparID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Vector getLPARProfilesAtPartition(short s, HscProviderSocket hscProviderSocket, boolean bl, boolean bl2) throws CIMException {
        Vector vector;
        try {
            try {
                block13: {
                    Trace.trace("apnvhscT", "<- getLPARProfileAtPartition");
                    Trace.trace("apnvhscF", "partitionID = " + String.valueOf(s));
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("*********************************************");
                        System.out.println("In getLPARProfileAtPartition");
                    }
                    try {
                        Enumeration enumeration;
                        if (bl) {
                            this.buildNVRAM(hscProviderSocket, false, null, true, true, true);
                        }
                        if ((enumeration = this._profilesAtPartitionTable[s].elements()) == null) {
                            Trace.trace("apnvhscF", "ret = null");
                            vector = null;
                            return vector;
                        }
                        Vector<Vector> vector2 = new Vector<Vector>();
                        while (true) {
                            Object object;
                            if (!enumeration.hasMoreElements()) {
                                object = vector2;
                                return object;
                            }
                            object = (String)enumeration.nextElement();
                            Trace.trace("apnvhscF", "profileTimeStamp = " + (String)object);
                            Object[] objectArray = (Object[])this._profileTable.get(object);
                            Vector vector3 = (Vector)((Vector)objectArray[2]).clone();
                            CIMProperty cIMProperty = null;
                            CIMProperty cIMProperty2 = null;
                            if (vector3 == null) continue;
                            vector3.setSize(13);
                            cIMProperty = ((String)object).equals(this._defaultList[s]) ? new CIMProperty("isDefault", new CIMValue((Object)new Boolean(true))) : new CIMProperty("isDefault", new CIMValue((Object)new Boolean(false)));
                            vector3.setElementAt(cIMProperty, 11);
                            cIMProperty2 = ((String)object).equals(this._activatedList[s]) ? new CIMProperty("isActivated", new CIMValue((Object)new Boolean(true))) : new CIMProperty("isActivated", new CIMValue((Object)new Boolean(false)));
                            vector3.setElementAt(cIMProperty2, 12);
                            Trace.trace("apnvhscF", "profileProperties = " + vector3);
                            vector2.add(vector3);
                        }
                    }
                    finally {
                        if (!DEBUG_ON) break block13;
                        System.out.println("End of getLPARProfileAtPartition");
                        System.out.println("********************************************");
                        System.out.println();
                        System.out.println();
                    }
                }
                Object var14_9 = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("0011");
            }
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            Trace.trace("apnvhscT", "<- getLPARProfileAtPartition");
            throw throwable;
        }
        Trace.trace("apnvhscT", "<- getLPARProfileAtPartition");
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Vector getSysProfile(String string, HscProviderSocket hscProviderSocket, boolean bl, boolean bl2) throws CIMException {
        try {
            try {
                Vector vector;
                block12: {
                    Object[] objectArray;
                    block10: {
                        Vector vector2;
                        block11: {
                            Trace.trace("apnvhscT", "-> getSysProfile");
                            Trace.trace("apnvhscF", "profiletTimeStamp = " + string);
                            Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                            if (DEBUG_ON) {
                                System.out.println("***********************************************");
                                System.out.println("In getSysProfile");
                            }
                            try {
                                if (bl) {
                                    this.buildNVRAM(hscProviderSocket, false, null, true, true, true);
                                }
                                if ((objectArray = (Object[])this._profileTable.get(string)) != null) break block10;
                                vector2 = null;
                                Object var10_9 = null;
                                if (!DEBUG_ON) break block11;
                                System.out.println("*********************************************");
                                System.out.println();
                            }
                            catch (Throwable throwable) {
                                Object var10_11 = null;
                                if (!DEBUG_ON) throw throwable;
                                System.out.println("*********************************************");
                                System.out.println();
                                throw throwable;
                            }
                        }
                        Object var12_12 = null;
                        Trace.trace("apnvhscT", "<- getSysProfile");
                        return vector2;
                    }
                    Vector vector3 = (Vector)((Vector)objectArray[2]).clone();
                    Trace.trace("apnvhscF", "ret = " + vector3);
                    if (vector3 != null) {
                        vector = null;
                        CIMProperty cIMProperty = null;
                        vector3.setSize(6);
                        vector = string.equals(this._defaultList[0]) ? new CIMProperty("isDefault", new CIMValue((Object)new Boolean(true))) : new CIMProperty("isDefault", new CIMValue((Object)new Boolean(false)));
                        Trace.trace("apnvhscF", "isDefault = " + vector);
                        vector3.setElementAt(vector, 4);
                        cIMProperty = string.equals(this._activatedList[0]) ? new CIMProperty("isActivated", new CIMValue((Object)new Boolean(true))) : new CIMProperty("isActivated", new CIMValue((Object)new Boolean(false)));
                        Trace.trace("apnvhscF", "isActivated = " + cIMProperty);
                        vector3.setElementAt(cIMProperty, 5);
                    }
                    vector = vector3;
                    Object var10_10 = null;
                    if (!DEBUG_ON) break block12;
                    System.out.println("*********************************************");
                    System.out.println();
                }
                Object var12_13 = null;
                Trace.trace("apnvhscT", "<- getSysProfile");
                return vector;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._NVRAMClassLogInfo);
                if (throwable instanceof HSCCIMException) throw new HSCCIMException(throwable);
                throw new HSCCIMException("0012");
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            Trace.trace("apnvhscT", "<- getSysProfile");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int[] saveSysProfile(String string, String string2, Vector vector, String string3, HscProviderSocket hscProviderSocket, boolean bl, boolean bl2) throws CIMException {
        int[] nArray;
        try {
            try {
                block105: {
                    Trace.trace("apnvhscT", "-> saveSysProfile");
                    Trace.trace("apnvhscF", "oldName = " + string);
                    Trace.trace("apnvhscF", "profileTimeStamp = " + string2);
                    Trace.trace("apnvhscF", "properties = " + vector);
                    Trace.trace("apnvhscF", "newName = " + string3);
                    Trace.trace("apnvhscF", "socket = " + hscProviderSocket);
                    if (DEBUG_ON) {
                        System.out.println("********************************************");
                        System.out.println("In saveSysProfile");
                    }
                    try {
                        int[] nArray2;
                        block109: {
                            byte by;
                            block111: {
                                int n21;
                                int n14;
                                int n9;
                                int n8;
                                block112: {
                                    boolean bl11;
                                    boolean bl10;
                                    boolean bl8;
                                    block110: {
                                        boolean bl12;
                                        String string4;
                                        boolean bl7;
                                        boolean bl5;
                                        boolean bl4;
                                        int n5;
                                        int n4;
                                        short s;
                                        block104: {
                                            int n20;
                                            byte[] byArray;
                                            Object object;
                                            if (bl) {
                                                this.buildNVRAM(hscProviderSocket, false, null, true, true, false);
                                            }
                                            s = 0;
                                            short s2 = 0;
                                            boolean bl3 = false;
                                            int n = 0;
                                            int n2 = 0;
                                            s2 = this._hscTemplateVersion;
                                            bl3 = true;
                                            int n3 = this._drawerOffsetTail;
                                            n4 = 0;
                                            n5 = 0;
                                            bl4 = false;
                                            bl5 = false;
                                            boolean bl6 = false;
                                            byte[] byArray2 = (byte[])this._nvramData.clone();
                                            int n6 = this._nvramDataSize;
                                            short s3 = this._numDrawers;
                                            Hashtable hashtable = (Hashtable)this._drawerIDTable.clone();
                                            Hashtable hashtable2 = (Hashtable)this._drawerIndexTable.clone();
                                            Hashtable hashtable3 = (Hashtable)this._profileNameTable.clone();
                                            Hashtable hashtable4 = (Hashtable)this._profileNameOffsetTable.clone();
                                            Hashtable hashtable5 = (Hashtable)this._profileTable.clone();
                                            Vector vector2 = (Vector)this._pnameFreeList.clone();
                                            Vector vector3 = (Vector)this._dIDFreeList.clone();
                                            int n7 = this._drawerOffsetTail;
                                            short s4 = this._dIDFreeListTail;
                                            n8 = (Integer)((Object[])this._profileTable.get(string2))[0];
                                            bl7 = false;
                                            bl8 = false;
                                            boolean bl9 = true;
                                            bl10 = false;
                                            bl11 = false;
                                            nArray2 = new int[4];
                                            n9 = 0;
                                            n9 = this._releaseVersion < 3 ? this.TEMPLATE_VERSION_OFFSET : this.DLPAR_TEMPLATE_VERSION_OFFSET_R4;
                                            int n10 = string.length();
                                            if (string3 == null) {
                                                Trace.trace("apnvhscF", "No new name - No need to change the profile name table");
                                                string4 = new String(string);
                                                n = ((int[])this._profileNameTable.get(string4))[0];
                                                Trace.trace("apnvhscF", "nameIndex = " + n);
                                                if (DEBUG_ON) {
                                                    System.out.println("In saveSysProfile: name = " + string4.trim());
                                                    System.out.println("In saveSysProfile: nameIndex = " + n);
                                                }
                                                nArray2[0] = -1;
                                                nArray2[1] = -1;
                                            } else {
                                                int[] nArray3;
                                                block100: {
                                                    Trace.trace("apnvhscF", "Has new name - May need to change the name table");
                                                    if (this.isDuplicatedAtPartition(0, string3, hscProviderSocket)) {
                                                        if (DEBUG_ON) {
                                                            System.out.println("In saveSysProfile: name already exist");
                                                        }
                                                        throw new HSCCIMException("0004", new String[]{string3, String.valueOf(0)});
                                                    }
                                                    n10 = string3.length();
                                                    string4 = new String(string3);
                                                    if (DEBUG_ON) {
                                                        System.out.println("In saveSysProfile: name = " + string4.trim());
                                                    }
                                                    nArray3 = (int[])hashtable3.get(string);
                                                    n2 = nArray3[0];
                                                    Trace.trace("apnvhscF", "oldNameOffset = " + String.valueOf(n2));
                                                    if (DEBUG_ON) {
                                                        System.out.println("In saveSysProfile: oldNameOffset = " + n2);
                                                    }
                                                    n4 = n2;
                                                    short s5 = (short)nArray3[1];
                                                    if (s5 == 1) {
                                                        bl7 = true;
                                                        bl4 = true;
                                                        int n11 = 0;
                                                        while (true) {
                                                            if (n11 >= 32) {
                                                                hashtable3.remove(string);
                                                                hashtable4.remove(new Integer(n2));
                                                                vector2.add(new Integer(n2));
                                                                nArray2[0] = n2;
                                                                nArray2[1] = n2 + 32;
                                                                break block100;
                                                            }
                                                            byArray2[n2 + n11] = 0;
                                                            ++n11;
                                                        }
                                                    }
                                                    nArray3[1] = nArray3[1] - 1;
                                                    nArray2[0] = -1;
                                                    nArray2[1] = -1;
                                                }
                                                if (hashtable3.containsKey(string3)) {
                                                    if (DEBUG_ON) {
                                                        System.out.println("In saveSysProfile: contained the new name already");
                                                    }
                                                    Trace.trace("apnvhscF", "profileNameTable already contains the new name - Just increment the reference count");
                                                    nArray3 = (int[])hashtable3.get(string4);
                                                    n = nArray3[0];
                                                    Trace.trace("apnvhscF", "nameIndex = " + String.valueOf(n));
                                                    if (DEBUG_ON) {
                                                        System.out.println("In saveSysProfile: nameIndex = " + n);
                                                    }
                                                    nArray3[1] = nArray3[1] + 1;
                                                } else {
                                                    block101: {
                                                        Trace.trace("apnvhscF", "profileNameTable doesn't contain the new name - Need to create one in the name table");
                                                        bl7 = true;
                                                        if (DEBUG_ON) {
                                                            System.out.println("In saveSysProfile: the new name is not yet exist. Need to create one");
                                                        }
                                                        if (vector2.isEmpty()) {
                                                            if (!DEBUG_ON) throw new HSCCIMException("0001");
                                                            System.out.println("No more space for new name");
                                                            throw new HSCCIMException("0001");
                                                        }
                                                        bl5 = true;
                                                        nArray3 = new int[2];
                                                        nArray3[0] = (Integer)vector2.elementAt(0);
                                                        if (DEBUG_ON) {
                                                            System.out.println("In saveSysProfile: new name offset = " + nArray3[0]);
                                                        }
                                                        vector2.removeElementAt(0);
                                                        nArray3[1] = 1;
                                                        n5 = n = nArray3[0];
                                                        hashtable3.put(string4, nArray3);
                                                        hashtable4.put(new Integer(n), string4);
                                                        byte[] byArray3 = this.setLength(string4, 32).getBytes();
                                                        int n12 = 0;
                                                        while (true) {
                                                            if (n12 >= 32) {
                                                                if (nArray2[0] != -1) break;
                                                                nArray2[0] = n;
                                                                break block101;
                                                            }
                                                            byArray2[n + n12] = byArray3[n12];
                                                            ++n12;
                                                        }
                                                        if (nArray2[0] > n) {
                                                            nArray2[0] = n;
                                                        }
                                                    }
                                                    if (nArray2[1] == -1) {
                                                        nArray2[1] = n + 32;
                                                    } else if (nArray2[1] < n + 32) {
                                                        nArray2[1] = n + 32;
                                                    }
                                                }
                                            }
                                            CIMProperty cIMProperty = null;
                                            CIMProperty cIMProperty2 = null;
                                            if (vector.size() == 4) {
                                                cIMProperty = (CIMProperty)vector.elementAt(2);
                                                cIMProperty2 = (CIMProperty)vector.elementAt(3);
                                            }
                                            Vector vector4 = null;
                                            Vector vector5 = null;
                                            int n13 = 0;
                                            if (cIMProperty != null && cIMProperty.getValue() != null) {
                                                vector4 = (Vector)cIMProperty.getValue().getValue();
                                                vector5 = (Vector)cIMProperty2.getValue().getValue();
                                                if (vector4 != null) {
                                                    n13 = vector4.size();
                                                }
                                            }
                                            Object[] objectArray = new Object[3];
                                            objectArray = (Object[])hashtable5.get(string2);
                                            Vector vector6 = (Vector)objectArray[2];
                                            Trace.trace("apnvhscF", "cimproperties = " + vector6);
                                            s = this._releaseVersion < 3 ? (short)(13 + n13 * 6) : (short)(16 + n13 * 6);
                                            Trace.trace("apnvhscF", "len = " + s);
                                            Object[] objectArray2 = new Object[3];
                                            objectArray2[1] = new Short(s);
                                            objectArray2[2] = vector;
                                            if (DEBUG_ON) {
                                                System.out.println("In saveSysProfile: new len = " + s);
                                            }
                                            if (DEBUG_ON) {
                                                System.out.println("In saveSysProfile: old Len = " + (Short)objectArray[1]);
                                            }
                                            Trace.trace("apnvhscF", "oldLen = " + objectArray[1]);
                                            n14 = 0;
                                            bl12 = false;
                                            try {
                                                block108: {
                                                    block103: {
                                                        int n16;
                                                        Object object2;
                                                        Hashtable hashtable6;
                                                        int n17;
                                                        block107: {
                                                            block102: {
                                                                if (s != (Short)objectArray[1]) break block107;
                                                                Trace.trace("apnvhscF", "old and new profiles have the same length - No need to move the profile");
                                                                objectArray2[0] = objectArray[0];
                                                                n14 = (Integer)objectArray2[0];
                                                                bl12 = !bl6;
                                                                hashtable5.put(string2, objectArray2);
                                                                this._nvramBAOutputStream = new ByteArrayOutputStream(this.NVRAM_SIZE);
                                                                this._nvramDOutputStream = new DataOutputStream(this._nvramBAOutputStream);
                                                                this._nvramDOutputStream.write(byArray2, 0, ((Short)objectArray2[0]).shortValue());
                                                                if (this._releaseVersion < 3) {
                                                                    this._nvramDOutputStream.writeByte((byte)s);
                                                                } else {
                                                                    this._nvramDOutputStream.writeShort(s);
                                                                }
                                                                this._nvramDOutputStream.writeByte((byte)s2);
                                                                this._nvramDOutputStream.writeBytes(NVRAM.cryptedTimestamp(string2));
                                                                this._nvramDOutputStream.writeByte((byte)(bl3 ? 1 : 0));
                                                                if (this._releaseVersion < 3) {
                                                                    this._nvramDOutputStream.writeShort((short)n);
                                                                } else {
                                                                    this._nvramDOutputStream.writeInt(n);
                                                                }
                                                                this._nvramDOutputStream.writeByte((byte)n13);
                                                                int n15 = 0;
                                                                while (true) {
                                                                    if (n15 >= n13) {
                                                                        n2 = ((Short)objectArray2[0]).shortValue();
                                                                        this._nvramDOutputStream.write(byArray2, n2 + s, this.NVRAM_SIZE - (n2 + s));
                                                                        if (nArray2[2] != -1) break;
                                                                        nArray2[2] = n2;
                                                                        break block102;
                                                                    }
                                                                    object = (String)vector4.elementAt(n15);
                                                                    Trace.trace("apnvhscF", "timeStamp = " + (String)object);
                                                                    byArray = NVRAM.encodeTime(NVRAM.cryptedTimestamp((String)object));
                                                                    UnsignedInt8 unsignedInt8 = (UnsignedInt8)vector5.elementAt(n15);
                                                                    if (DEBUG_ON) {
                                                                        System.out.println("pid = " + unsignedInt8);
                                                                        System.out.println("encoded time stamp len = " + byArray.length);
                                                                    }
                                                                    this._nvramDOutputStream.writeByte(unsignedInt8.byteValue());
                                                                    this._nvramDOutputStream.writeBytes(new String(byArray));
                                                                    ++n15;
                                                                }
                                                                if (nArray2[2] > n2) {
                                                                    nArray2[2] = n2;
                                                                }
                                                            }
                                                            if (nArray2[3] == -1) {
                        